/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.OffsetAndMetadata;
import kafka.coordinator.group.AwaitingSync$;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.Dead$;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupCoordinator$;
import kafka.coordinator.group.GroupMetadata$;
import kafka.coordinator.group.GroupMetadata$$anonfun$completePendingTxnOffsetCommit$1$;
import kafka.coordinator.group.GroupOverview;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.GroupSummary;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.MemberSummary;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$Int$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\rmu!B\u0001\u0003\u0011\u0013I\u0011!D$s_V\u0004X*\u001a;bI\u0006$\u0018M\u0003\u0002\u0004\t\u0005)qM]8va*\u0011QAB\u0001\fG>|'\u000fZ5oCR|'OC\u0001\b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AC\u0006\u000e\u0003\t1Q\u0001\u0004\u0002\t\n5\u0011Qb\u0012:pkBlU\r^1eCR\f7CA\u0006\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\")Qc\u0003C\u0001-\u00051A(\u001b8jiz\"\u0012!\u0003\u0005\b1-\u0011\r\u0011\"\u0003\u001a\u0003M1\u0018\r\\5e!J,g/[8vgN#\u0018\r^3t+\u0005Q\u0002\u0003B\u000e\u001fC\u0011r!a\u0004\u000f\n\u0005u\u0001\u0012A\u0002)sK\u0012,g-\u0003\u0002 A\t\u0019Q*\u00199\u000b\u0005u\u0001\u0002C\u0001\u0006#\u0013\t\u0019#A\u0001\u0006He>,\bo\u0015;bi\u0016\u00042aG\u0013\"\u0013\t1\u0003EA\u0002TKRDa\u0001K\u0006!\u0002\u0013Q\u0012\u0001\u0006<bY&$\u0007K]3wS>,8o\u0015;bi\u0016\u001c\b\u0005C\u0004+\u0017E\u0005I\u0011A\u0016\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005a#FA\u0011.W\u0005q\u0003CA\u00185\u001b\u0005\u0001$BA\u00193\u0003%)hn\u00195fG.,GM\u0003\u00024!\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005U\u0002$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u001a)AB\u0001\u0001\u0003oM\u0019aG\u0004\u001d\u0011\u0005ebT\"\u0001\u001e\u000b\u0005m2\u0011!B;uS2\u001c\u0018BA\u001f;\u0005\u001daunZ4j]\u001eD\u0001b\u0010\u001c\u0003\u0006\u0004%\t\u0001Q\u0001\bOJ|W\u000f]%e+\u0005\t\u0005CA\u000eC\u0013\t\u0019\u0005E\u0001\u0004TiJLgn\u001a\u0005\t\u000bZ\u0012\t\u0011)A\u0005\u0003\u0006AqM]8va&#\u0007\u0005\u0003\u0005Hm\t\u0005\t\u0015!\u0003\"\u00031Ig.\u001b;jC2\u001cF/\u0019;f\u0011\u0015)b\u0007\"\u0001J)\rQ5\n\u0014\t\u0003\u0015YBQa\u0010%A\u0002\u0005Cqa\u0012%\u0011\u0002\u0003\u0007\u0011\u0005C\u0004Om\u0001\u0007I\u0011B(\u0002\u000bM$\u0018\r^3\u0016\u0003\u0005Bq!\u0015\u001cA\u0002\u0013%!+A\u0005ti\u0006$Xm\u0018\u0013fcR\u00111K\u0016\t\u0003\u001fQK!!\u0016\t\u0003\tUs\u0017\u000e\u001e\u0005\b/B\u000b\t\u00111\u0001\"\u0003\rAH%\r\u0005\u00073Z\u0002\u000b\u0015B\u0011\u0002\rM$\u0018\r^3!\u0011!YfG1A\u0005\u0002\ta\u0016\u0001\u00027pG.,\u0012!\u0018\t\u0003=\u001el\u0011a\u0018\u0006\u0003A\u0006\fQ\u0001\\8dWNT!AY2\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002eK\u0006!Q\u000f^5m\u0015\u00051\u0017\u0001\u00026bm\u0006L!\u0001[0\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0011\u0019Qg\u0007)A\u0005;\u0006)An\\2lA!9AN\u000eb\u0001\n\u0013i\u0017aB7f[\n,'o]\u000b\u0002]B!q\u000e^!w\u001b\u0005\u0001(BA9s\u0003\u001diW\u000f^1cY\u0016T!a\u001d\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002va\n9\u0001*Y:i\u001b\u0006\u0004\bC\u0001\u0006x\u0013\tA(A\u0001\bNK6\u0014WM]'fi\u0006$\u0017\r^1\t\ri4\u0004\u0015!\u0003o\u0003!iW-\u001c2feN\u0004\u0003b\u0002?7\u0005\u0004%I!`\u0001\b_\u001a47/\u001a;t+\u0005q\b#B8u\u007f\u0006U\u0001\u0003BA\u0001\u0003#i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0007G>lWn\u001c8\u000b\u0007\u001d\tIA\u0003\u0003\u0002\f\u00055\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u0010\u0005\u0019qN]4\n\t\u0005M\u00111\u0001\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\rQ\u0011qC\u0005\u0004\u00033\u0011!!H\"p[6LGOU3d_J$W*\u001a;bI\u0006$\u0018-\u00118e\u001f\u001a47/\u001a;\t\u000f\u0005ua\u0007)A\u0005}\u0006AqN\u001a4tKR\u001c\b\u0005C\u0005\u0002\"Y\u0012\r\u0011\"\u0003\u0002$\u0005!\u0002/\u001a8eS:<wJ\u001a4tKR\u001cu.\\7jiN,\"!!\n\u0011\u000b=$x0a\n\u0011\t\u0005%\u0012QF\u0007\u0003\u0003WQ1!!\u0002\u0007\u0013\u0011\ty#a\u000b\u0003#=3gm]3u\u0003:$W*\u001a;bI\u0006$\u0018\r\u0003\u0005\u00024Y\u0002\u000b\u0011BA\u0013\u0003U\u0001XM\u001c3j]\u001e|eMZ:fi\u000e{W.\\5ug\u0002B\u0011\"a\u000e7\u0005\u0004%I!!\u000f\u0002CA,g\u000eZ5oOR\u0013\u0018M\\:bGRLwN\\1m\u001f\u001a47/\u001a;D_6l\u0017\u000e^:\u0016\u0005\u0005m\u0002CB8u\u0003{\t\u0019\u0005E\u0002\u0010\u0003\u007fI1!!\u0011\u0011\u0005\u0011auN\\4\u0011\r=\f)e`A\u000b\u0013\ty\u0002\u000f\u0003\u0005\u0002JY\u0002\u000b\u0011BA\u001e\u0003\t\u0002XM\u001c3j]\u001e$&/\u00198tC\u000e$\u0018n\u001c8bY>3gm]3u\u0007>lW.\u001b;tA!I\u0011Q\n\u001cA\u0002\u0013%\u0011qJ\u0001#e\u0016\u001cW-\u001b<fIR\u0013\u0018M\\:bGRLwN\\1m\u001f\u001a47/\u001a;D_6l\u0017\u000e^:\u0016\u0005\u0005E\u0003cA\b\u0002T%\u0019\u0011Q\u000b\t\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011\f\u001cA\u0002\u0013%\u00111L\u0001'e\u0016\u001cW-\u001b<fIR\u0013\u0018M\\:bGRLwN\\1m\u001f\u001a47/\u001a;D_6l\u0017\u000e^:`I\u0015\fHcA*\u0002^!Iq+a\u0016\u0002\u0002\u0003\u0007\u0011\u0011\u000b\u0005\t\u0003C2\u0004\u0015)\u0003\u0002R\u0005\u0019#/Z2fSZ,G\r\u0016:b]N\f7\r^5p]\u0006dwJ\u001a4tKR\u001cu.\\7jiN\u0004\u0003\"CA3m\u0001\u0007I\u0011BA(\u0003u\u0011XmY3jm\u0016$7i\u001c8tk6,'o\u00144gg\u0016$8i\\7nSR\u001c\b\"CA5m\u0001\u0007I\u0011BA6\u0003\u0005\u0012XmY3jm\u0016$7i\u001c8tk6,'o\u00144gg\u0016$8i\\7nSR\u001cx\fJ3r)\r\u0019\u0016Q\u000e\u0005\n/\u0006\u001d\u0014\u0011!a\u0001\u0003#B\u0001\"!\u001d7A\u0003&\u0011\u0011K\u0001\u001fe\u0016\u001cW-\u001b<fI\u000e{gn];nKJ|eMZ:fi\u000e{W.\\5ug\u0002B\u0011\"!\u001e7\u0001\u0004%\t!a\u001e\u0002\u0019A\u0014x\u000e^8d_2$\u0016\u0010]3\u0016\u0005\u0005e\u0004\u0003B\b\u0002|\u0005K1!! \u0011\u0005\u0019y\u0005\u000f^5p]\"I\u0011\u0011\u0011\u001cA\u0002\u0013\u0005\u00111Q\u0001\u0011aJ|Go\\2pYRK\b/Z0%KF$2aUAC\u0011%9\u0016qPA\u0001\u0002\u0004\tI\b\u0003\u0005\u0002\nZ\u0002\u000b\u0015BA=\u00035\u0001(o\u001c;pG>dG+\u001f9fA!I\u0011Q\u0012\u001cA\u0002\u0013\u0005\u0011qR\u0001\rO\u0016tWM]1uS>t\u0017\nZ\u000b\u0003\u0003#\u00032aDAJ\u0013\r\t)\n\u0005\u0002\u0004\u0013:$\b\"CAMm\u0001\u0007I\u0011AAN\u0003A9WM\\3sCRLwN\\%e?\u0012*\u0017\u000fF\u0002T\u0003;C\u0011bVAL\u0003\u0003\u0005\r!!%\t\u0011\u0005\u0005f\u0007)Q\u0005\u0003#\u000bQbZ3oKJ\fG/[8o\u0013\u0012\u0004\u0003\u0002CASm\u0001\u0007I\u0011\u0001!\u0002\u00111,\u0017\rZ3s\u0013\u0012D\u0011\"!+7\u0001\u0004%\t!a+\u0002\u00191,\u0017\rZ3s\u0013\u0012|F%Z9\u0015\u0007M\u000bi\u000b\u0003\u0005X\u0003O\u000b\t\u00111\u0001B\u0011\u001d\t\tL\u000eQ!\n\u0005\u000b\u0011\u0002\\3bI\u0016\u0014\u0018\n\u001a\u0011\t\u0011\u0005Uf\u00071A\u0005\u0002\u0001\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\u0005\n\u0003s3\u0004\u0019!C\u0001\u0003w\u000bA\u0002\u001d:pi>\u001cw\u000e\\0%KF$2aUA_\u0011!9\u0016qWA\u0001\u0002\u0004\t\u0005bBAam\u0001\u0006K!Q\u0001\naJ|Go\\2pY\u0002B\u0011\"!27\u0001\u0004%\t!a\u0014\u0002\u001d9,w/T3nE\u0016\u0014\u0018\t\u001a3fI\"I\u0011\u0011\u001a\u001cA\u0002\u0013\u0005\u00111Z\u0001\u0013]\u0016<X*Z7cKJ\fE\rZ3e?\u0012*\u0017\u000fF\u0002T\u0003\u001bD\u0011bVAd\u0003\u0003\u0005\r!!\u0015\t\u0011\u0005Eg\u0007)Q\u0005\u0003#\nqB\\3x\u001b\u0016l'-\u001a:BI\u0012,G\r\t\u0005\b\u0003+4D\u0011AAl\u0003\u0019Ig\u000eT8dWV!\u0011\u0011\\Ap)\u0011\tY.!=\u0011\t\u0005u\u0017q\u001c\u0007\u0001\t!\t\t/a5C\u0002\u0005\r(!\u0001+\u0012\t\u0005\u0015\u00181\u001e\t\u0004\u001f\u0005\u001d\u0018bAAu!\t9aj\u001c;iS:<\u0007cA\b\u0002n&\u0019\u0011q\u001e\t\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002t\u0006MG\u00111\u0001\u0002v\u0006\u0019a-\u001e8\u0011\u000b=\t90a7\n\u0007\u0005e\bC\u0001\u0005=Eft\u0017-\\3?\u0011\u001d\tiP\u000eC\u0001\u0003\u007f\f!![:\u0015\t\u0005E#\u0011\u0001\u0005\b\u0005\u0007\tY\u00101\u0001\"\u0003)9'o\\;q'R\fG/\u001a\u0005\b\u0005\u000f1D\u0011\u0001B\u0005\u0003\rqw\u000e\u001e\u000b\u0005\u0003#\u0012Y\u0001C\u0004\u0003\u0004\t\u0015\u0001\u0019A\u0011\t\u000f\t=a\u0007\"\u0001\u0003\u0012\u0005\u0019\u0001.Y:\u0015\t\u0005E#1\u0003\u0005\b\u0005+\u0011i\u00011\u0001B\u0003!iW-\u001c2fe&#\u0007b\u0002B\rm\u0011\u0005!1D\u0001\u0004O\u0016$Hc\u0001<\u0003\u001e!9!Q\u0003B\f\u0001\u0004\t\u0005b\u0002B\u0011m\u0011\u0005!1E\u0001\u0004C\u0012$GcA*\u0003&!9!q\u0005B\u0010\u0001\u00041\u0018AB7f[\n,'\u000fC\u0004\u0003,Y\"\tA!\f\u0002\rI,Wn\u001c<f)\r\u0019&q\u0006\u0005\b\u0005+\u0011I\u00031\u0001B\u0011\u0019\u0011\u0019D\u000eC\u0001\u001f\u0006a1-\u001e:sK:$8\u000b^1uK\"9!q\u0007\u001c\u0005\u0002\te\u0012!\u00068pif+GOU3k_&tW\rZ'f[\n,'o]\u000b\u0003\u0005w\u0001RA!\u0010\u0003DYt1a\u0004B \u0013\r\u0011\t\u0005E\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011)Ea\u0012\u0003\t1K7\u000f\u001e\u0006\u0004\u0005\u0003\u0002\u0002b\u0002B&m\u0011\u0005!QJ\u0001\u000bC2dW*Z7cKJ\u001cXC\u0001B(!\u0015\u0011\tFa\u0015B\u001b\u0005\u0011\u0018B\u0001\u0014s\u0011\u001d\u00119F\u000eC\u0001\u0005s\t\u0011#\u00197m\u001b\u0016l'-\u001a:NKR\fG-\u0019;b\u0011\u001d\u0011YF\u000eC\u0001\u0003\u001f\u000b!C]3cC2\fgnY3US6,w.\u001e;Ng\"9!q\f\u001c\u0005\u0002\t\u0005\u0014AF4f]\u0016\u0014\u0018\r^3NK6\u0014WM]%e'V4g-\u001b=\u0016\u0005\t\r\u0004\u0003\u0002B3\u0005Wj!Aa\u001a\u000b\u0007\t%T-\u0001\u0003mC:<\u0017bA\"\u0003h!9!q\u000e\u001c\u0005\u0002\u0005=\u0013\u0001D2b]J+'-\u00197b]\u000e,\u0007b\u0002B:m\u0011\u0005!QO\u0001\riJ\fgn]5uS>tGk\u001c\u000b\u0004'\n]\u0004b\u0002B\u0002\u0005c\u0002\r!\t\u0005\u0007\u0005w2D\u0011\u0001!\u0002\u001dM,G.Z2u!J|Go\\2pY\"9!q\u0010\u001c\u0005\n\t\u0005\u0015AE2b]\u0012LG-\u0019;f!J|Go\\2pYN,\"Aa!\u0011\u000b\t\u0015%1R!\u000e\u0005\t\u001d%b\u0001BEe\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0004M\t\u001d\u0005b\u0002BHm\u0011\u0005!\u0011S\u0001\u0012gV\u0004\bo\u001c:ugB\u0013x\u000e^8d_2\u001cH\u0003BA)\u0005'C\u0001B!&\u0003\u000e\u0002\u0007!qS\u0001\u0010[\u0016l'-\u001a:Qe>$xnY8mgB\u00191$J!\t\u000f\tme\u0007\"\u0001\u0003\u001e\u0006\u0011\u0012N\\5u\u001d\u0016DHoR3oKJ\fG/[8o)\u0005\u0019\u0006b\u0002BQm\u0011\u0005!1U\u0001\u0016GV\u0014(/\u001a8u\u001b\u0016l'-\u001a:NKR\fG-\u0019;b+\t\u0011)\u000bE\u0003\u001c=\u0005\u00139\u000bE\u0003\u0010\u0005S\u0013i+C\u0002\u0003,B\u0011Q!\u0011:sCf\u00042a\u0004BX\u0013\r\u0011\t\f\u0005\u0002\u0005\u0005f$X\rC\u0004\u00036Z\"\tAa.\u0002\u000fM,X.\\1ssV\u0011!\u0011\u0018\t\u0004\u0015\tm\u0016b\u0001B_\u0005\taqI]8vaN+X.\\1ss\"9!\u0011\u0019\u001c\u0005\u0002\t\r\u0017\u0001C8wKJ4\u0018.Z<\u0016\u0005\t\u0015\u0007c\u0001\u0006\u0003H&\u0019!\u0011\u001a\u0002\u0003\u001b\u001d\u0013x.\u001e9Pm\u0016\u0014h/[3x\u0011\u001d\u0011iM\u000eC\u0001\u0005\u001f\f\u0011#\u001b8ji&\fG.\u001b>f\u001f\u001a47/\u001a;t)\u0015\u0019&\u0011\u001bBl\u0011\u001da(1\u001aa\u0001\u0005'\u0004rA!\u0015\u0003V~\f)\"\u0003\u0002 e\"A!\u0011\u001cBf\u0001\u0004\u0011Y.A\tqK:$\u0017N\\4Uq:|eMZ:fiN\u0004ba\u0007\u0010\u0002>\u0005\r\u0003b\u0002Bpm\u0011\u0005!\u0011]\u0001\u0015_:|eMZ:fi\u000e{W.\\5u\u0003B\u0004XM\u001c3\u0015\u000bM\u0013\u0019Oa:\t\u000f\t\u0015(Q\u001ca\u0001\u007f\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0002\u0003Bu\u0005;\u0004\r!!\u0006\u0002==4gm]3u/&$\bnQ8n[&$(+Z2pe\u0012lU\r^1eCR\f\u0007b\u0002Bwm\u0011\u0005!q^\u0001\u0017M\u0006LG\u000eU3oI&twm\u00144gg\u0016$xK]5uKR)1K!=\u0003t\"9!Q\u001dBv\u0001\u0004y\b\u0002\u0003B{\u0005W\u0004\r!a\n\u0002\r=4gm]3u\u0011\u001d\u0011IP\u000eC\u0001\u0005w\f1\u0003\u001d:fa\u0006\u0014Xm\u00144gg\u0016$8i\\7nSR$2a\u0015B\u007f\u0011\u001da(q\u001fa\u0001\u0005\u007f\u0004Ra\u0007\u0010\u0000\u0003OAqaa\u00017\t\u0003\u0019)!\u0001\fqe\u0016\u0004\u0018M]3Uq:|eMZ:fi\u000e{W.\\5u)\u0015\u00196qAB\u0006\u0011!\u0019Ia!\u0001A\u0002\u0005u\u0012A\u00039s_\u0012,8-\u001a:JI\"9Ap!\u0001A\u0002\t}\bbBB\bm\u0011\u0005\u0011qJ\u0001#Q\u0006\u001c(+Z2fSZ,GmQ8og&\u001cH/\u001a8u\u001f\u001a47/\u001a;D_6l\u0017\u000e^:\t\u000f\rMa\u0007\"\u0001\u0004\u0016\u0005Qb-Y5m!\u0016tG-\u001b8h)btwJ\u001a4tKR\u001cu.\\7jiR)1ka\u0006\u0004\u001a!A1\u0011BB\t\u0001\u0004\ti\u0004C\u0004\u0003f\u000eE\u0001\u0019A@\t\u000f\rua\u0007\"\u0001\u0004 \u00059rN\u001c+y]>3gm]3u\u0007>lW.\u001b;BaB,g\u000e\u001a\u000b\b'\u000e\u000521EB\u0013\u0011!\u0019Iaa\u0007A\u0002\u0005u\u0002b\u0002Bs\u00077\u0001\ra \u0005\t\u0007O\u0019Y\u00021\u0001\u0002\u0016\u0005i2m\\7nSR\u0014VmY8sI6+G/\u00193bi\u0006\fe\u000eZ(gMN,G\u000fC\u0004\u0004,Y\"\ta!\f\u0002=\r|W\u000e\u001d7fi\u0016\u0004VM\u001c3j]\u001e$\u0006P\\(gMN,GoQ8n[&$H#B*\u00040\rE\u0002\u0002CB\u0005\u0007S\u0001\r!!\u0010\t\u0011\rM2\u0011\u0006a\u0001\u0003#\n\u0001\"[:D_6l\u0017\u000e\u001e\u0005\b\u0007o1D\u0011AB\u001d\u0003=\t7\r^5wKB\u0013x\u000eZ;dKJ\u001cXCAB\u001e!\u0019\u0011\tFa\u0015\u0002>!91q\b\u001c\u0005\u0002\r\u0005\u0013a\t5bgB+g\u000eZ5oO>3gm]3u\u0007>lW.\u001b;t\rJ|W\u000e\u0015:pIV\u001cWM\u001d\u000b\u0005\u0003#\u001a\u0019\u0005\u0003\u0005\u0004\n\ru\u0002\u0019AA\u001f\u0011\u001d\u00199E\u000eC\u0001\u0007\u0013\nQB]3n_Z,wJ\u001a4tKR\u001cH\u0003BB&\u0007\u001f\u0002rA!\"\u0004N}\f9#C\u0002 \u0005\u000fC\u0001b!\u0015\u0004F\u0001\u000711K\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB)!\u0011KB+\u007f&\u00191q\u000b:\u0003\u0007M+\u0017\u000fC\u0004\u0004\\Y\"\ta!\u0018\u0002)I,Wn\u001c<f\u000bb\u0004\u0018N]3e\u001f\u001a47/\u001a;t)\u0011\u0011ypa\u0018\t\u0011\r\u00054\u0011\fa\u0001\u0003{\tqa\u001d;beRl5\u000fC\u0004\u0004fY\"\taa\u001a\u0002\u0015\u0005dGn\u00144gg\u0016$8/\u0006\u0002\u0004L!9!Q\u001f\u001c\u0005\u0002\r-D\u0003BB7\u0007_\u0002RaDA>\u0003OAqA!:\u0004j\u0001\u0007q\u0010\u0003\u0005\u0004tY\"\tAAB;\u0003aygMZ:fi^KG\u000f\u001b*fG>\u0014H-T3uC\u0012\fG/\u0019\u000b\u0005\u0007o\u001aI\bE\u0003\u0010\u0003w\n)\u0002C\u0004\u0003f\u000eE\u0004\u0019A@\t\u000f\rud\u0007\"\u0001\u0002\u0010\u0006Qa.^7PM\u001a\u001cX\r^:\t\u000f\r\u0005e\u0007\"\u0001\u0002P\u0005Q\u0001.Y:PM\u001a\u001cX\r^:\t\u000f\r\u0015e\u0007\"\u0003\u0004\b\u0006)\u0012m]:feR4\u0016\r\\5e)J\fgn]5uS>tGcA*\u0004\n\"911RBB\u0001\u0004\t\u0013a\u0003;be\u001e,Go\u0015;bi\u0016Dqaa$7\t\u0003\u001a\t*\u0001\u0005u_N#(/\u001b8h)\u0005\t\u0005f\u0001\u001c\u0004\u0016B\u0019\u0011ha&\n\u0007\re%HA\u0007o_:$\bN]3bIN\fg-\u001a")
public class GroupMetadata
implements Logging {
    private final String groupId;
    private GroupState state;
    private final ReentrantLock lock;
    private final HashMap<String, MemberMetadata> members;
    private final HashMap<TopicPartition, CommitRecordMetadataAndOffset> kafka$coordinator$group$GroupMetadata$$offsets;
    private final HashMap<TopicPartition, OffsetAndMetadata> kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits;
    private final HashMap<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits;
    private boolean receivedTransactionalOffsetCommits;
    private boolean receivedConsumerOffsetCommits;
    private Option<String> protocolType;
    private int generationId;
    private String leaderId;
    private String protocol;
    private boolean newMemberAdded;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static GroupState $lessinit$greater$default$2() {
        return GroupMetadata$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        GroupMetadata groupMetadata = this;
        synchronized (groupMetadata) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String groupId() {
        return this.groupId;
    }

    private GroupState state() {
        return this.state;
    }

    private void state_$eq(GroupState x$1) {
        this.state = x$1;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    private HashMap<String, MemberMetadata> members() {
        return this.members;
    }

    public HashMap<TopicPartition, CommitRecordMetadataAndOffset> kafka$coordinator$group$GroupMetadata$$offsets() {
        return this.kafka$coordinator$group$GroupMetadata$$offsets;
    }

    public HashMap<TopicPartition, OffsetAndMetadata> kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits() {
        return this.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits;
    }

    public HashMap<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits() {
        return this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits;
    }

    private boolean receivedTransactionalOffsetCommits() {
        return this.receivedTransactionalOffsetCommits;
    }

    private void receivedTransactionalOffsetCommits_$eq(boolean x$1) {
        this.receivedTransactionalOffsetCommits = x$1;
    }

    private boolean receivedConsumerOffsetCommits() {
        return this.receivedConsumerOffsetCommits;
    }

    private void receivedConsumerOffsetCommits_$eq(boolean x$1) {
        this.receivedConsumerOffsetCommits = x$1;
    }

    public Option<String> protocolType() {
        return this.protocolType;
    }

    public void protocolType_$eq(Option<String> x$1) {
        this.protocolType = x$1;
    }

    public int generationId() {
        return this.generationId;
    }

    public void generationId_$eq(int x$1) {
        this.generationId = x$1;
    }

    public String leaderId() {
        return this.leaderId;
    }

    public void leaderId_$eq(String x$1) {
        this.leaderId = x$1;
    }

    public String protocol() {
        return this.protocol;
    }

    public void protocol_$eq(String x$1) {
        this.protocol = x$1;
    }

    public boolean newMemberAdded() {
        return this.newMemberAdded;
    }

    public void newMemberAdded_$eq(boolean x$1) {
        this.newMemberAdded = x$1;
    }

    public <T> T inLock(Function0<T> fun) {
        return CoreUtils$.MODULE$.inLock(this.lock(), fun);
    }

    public boolean is(GroupState groupState) {
        GroupState groupState2 = this.state();
        GroupState groupState3 = groupState;
        return !(groupState2 != null ? !groupState2.equals(groupState3) : groupState3 != null);
    }

    public boolean not(GroupState groupState) {
        GroupState groupState2 = this.state();
        GroupState groupState3 = groupState;
        return groupState2 != null ? !groupState2.equals(groupState3) : groupState3 != null;
    }

    public boolean has(String memberId) {
        return this.members().contains(memberId);
    }

    public MemberMetadata get(String memberId) {
        return this.members().apply(memberId);
    }

    public void add(MemberMetadata member) {
        if (this.members().isEmpty()) {
            this.protocolType_$eq(new Some<String>(member.protocolType()));
        }
        String string2 = this.groupId();
        String string3 = member.groupId();
        Predef$.MODULE$.assert(!(string2 != null ? !string2.equals(string3) : string3 != null));
        Object a = this.protocolType().orNull(Predef$.MODULE$.$conforms());
        String string4 = member.protocolType();
        Predef$.MODULE$.assert(!(a != null ? !a.equals(string4) : string4 != null));
        Predef$.MODULE$.assert(this.supportsProtocols(member.protocols()));
        if (this.leaderId() == null) {
            this.leaderId_$eq(member.memberId());
        }
        this.members().put(member.memberId(), member);
    }

    public void remove(String memberId) {
        this.members().remove(memberId);
        String string2 = memberId;
        String string3 = this.leaderId();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.leaderId_$eq(this.members().isEmpty() ? null : (String)this.members().keys().head());
        }
    }

    public GroupState currentState() {
        return this.state();
    }

    public List<MemberMetadata> notYetRejoinedMembers() {
        return ((TraversableOnce)this.members().values().filter(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MemberMetadata x$1) {
                return x$1.awaitingJoinCallback() == null;
            }
        })).toList();
    }

    public Set<String> allMembers() {
        return this.members().keySet();
    }

    public List<MemberMetadata> allMemberMetadata() {
        return this.members().values().toList();
    }

    public int rebalanceTimeoutMs() {
        return BoxesRunTime.unboxToInt(this.members().values().foldLeft(BoxesRunTime.boxToInteger(0), new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int timeout, MemberMetadata member) {
                return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(timeout), member.rebalanceTimeoutMs());
            }
        }));
    }

    public String generateMemberIdSuffix() {
        return UUID.randomUUID().toString();
    }

    public boolean canRebalance() {
        return ((SetLike)GroupMetadata$.MODULE$.kafka$coordinator$group$GroupMetadata$$validPreviousStates().apply(PreparingRebalance$.MODULE$)).contains(this.state());
    }

    public void transitionTo(GroupState groupState) {
        this.assertValidTransition(groupState);
        this.state_$eq(groupState);
    }

    public String selectProtocol() {
        if (this.members().isEmpty()) {
            throw new IllegalStateException("Cannot select protocol for empty group");
        }
        scala.collection.immutable.Set<String> candidates = this.candidateProtocols();
        List<Tuple2<String, Object>> votes = ((TraversableLike)this.allMemberMetadata().map(new scala.Serializable(this, candidates){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set candidates$1;

            public final String apply(MemberMetadata x$2) {
                return x$2.vote(this.candidates$1);
            }
            {
                this.candidates$1 = candidates$1;
            }
        }, List$.MODULE$.canBuildFrom())).groupBy(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return Predef$.MODULE$.identity(x);
            }
        }).mapValues(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(List<String> x$3) {
                return x$3.size();
            }
        }).toList();
        return votes.maxBy(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<String, Object> x$4) {
                return x$4._2$mcI$sp();
            }
        }, Ordering$Int$.MODULE$)._1();
    }

    private scala.collection.immutable.Set<String> candidateProtocols() {
        return ((LinearSeqOptimized)this.allMemberMetadata().map(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Set<String> apply(MemberMetadata x$5) {
                return x$5.protocols();
            }
        }, List$.MODULE$.canBuildFrom())).reduceLeft(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Set<String> apply(scala.collection.immutable.Set<String> commonProtocols, scala.collection.immutable.Set<String> protocols2) {
                return (scala.collection.immutable.Set)commonProtocols.$amp(protocols2);
            }
        });
    }

    public boolean supportsProtocols(scala.collection.immutable.Set<String> memberProtocols) {
        return this.members().isEmpty() || ((TraversableOnce)memberProtocols.$amp(this.candidateProtocols())).nonEmpty();
    }

    public void initNextGeneration() {
        List<MemberMetadata> list = this.notYetRejoinedMembers();
        GenTraversable genTraversable = List$.MODULE$.empty();
        Predef$.MODULE$.assert(!(list != null ? !((Object)list).equals(genTraversable) : genTraversable != null));
        if (this.members().nonEmpty()) {
            this.generationId_$eq(this.generationId() + 1);
            this.protocol_$eq(this.selectProtocol());
            this.transitionTo(AwaitingSync$.MODULE$);
        } else {
            this.generationId_$eq(this.generationId() + 1);
            this.protocol_$eq(null);
            this.transitionTo(Empty$.MODULE$);
        }
        this.receivedConsumerOffsetCommits_$eq(false);
        this.receivedTransactionalOffsetCommits_$eq(false);
    }

    public scala.collection.immutable.Map<String, byte[]> currentMemberMetadata() {
        if (this.is(Dead$.MODULE$) || this.is(PreparingRebalance$.MODULE$)) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Cannot obtain member metadata for group in state %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.state()})));
        }
        return ((TraversableOnce)this.members().map((Function1<String, MemberMetadata>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadata $outer;

            public final Tuple2<String, byte[]> apply(Tuple2<String, MemberMetadata> x0$1) {
                Tuple2<String, MemberMetadata> tuple2 = x0$1;
                if (tuple2 != null) {
                    String memberId = tuple2._1();
                    MemberMetadata memberMetadata = tuple2._2();
                    Tuple2<String, byte[]> tuple22 = new Tuple2<String, byte[]>(memberId, memberMetadata.metadata(this.$outer.protocol()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public GroupSummary summary() {
        GroupSummary groupSummary;
        if (this.is(Stable$.MODULE$)) {
            List<MemberSummary> members = ((TraversableOnce)this.members().values().map(new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GroupMetadata $outer;

                public final MemberSummary apply(MemberMetadata member) {
                    return member.summary(this.$outer.protocol());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Iterable$.MODULE$.canBuildFrom())).toList();
            groupSummary = new GroupSummary(this.state().toString(), this.protocolType().getOrElse(new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            }), this.protocol(), members);
        } else {
            List<MemberSummary> members = ((TraversableOnce)this.members().values().map(new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final MemberSummary apply(MemberMetadata member) {
                    return member.summaryNoMetadata();
                }
            }, Iterable$.MODULE$.canBuildFrom())).toList();
            groupSummary = new GroupSummary(this.state().toString(), this.protocolType().getOrElse(new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            }), GroupCoordinator$.MODULE$.NoProtocol(), members);
        }
        return groupSummary;
    }

    public GroupOverview overview() {
        return new GroupOverview(this.groupId(), this.protocolType().getOrElse(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }));
    }

    public void initializeOffsets(Map<TopicPartition, CommitRecordMetadataAndOffset> offsets, scala.collection.immutable.Map<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> pendingTxnOffsets) {
        this.kafka$coordinator$group$GroupMetadata$$offsets().$plus$plus$eq((TraversableOnce<Tuple2<TopicPartition, CommitRecordMetadataAndOffset>>)offsets);
        this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits().$plus$plus$eq((TraversableOnce<Tuple2<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>>>)pendingTxnOffsets);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onOffsetCommitAppend(TopicPartition topicPartition, CommitRecordMetadataAndOffset offsetWithCommitRecordMetadata) {
        Serializable serializable;
        if (this.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits().contains(topicPartition)) {
            if (offsetWithCommitRecordMetadata.appendedBatchOffset().isEmpty()) {
                throw new IllegalStateException("Cannot complete offset commit write without providing the metadata of the record in the log.");
            }
            serializable = this.kafka$coordinator$group$GroupMetadata$$offsets().contains(topicPartition) && !this.kafka$coordinator$group$GroupMetadata$$offsets().apply(topicPartition).olderThan(offsetWithCommitRecordMetadata) ? BoxedUnit.UNIT : this.kafka$coordinator$group$GroupMetadata$$offsets().put(topicPartition, offsetWithCommitRecordMetadata);
        } else {
            serializable = BoxedUnit.UNIT;
        }
        Option<OffsetAndMetadata> option = this.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits().get(topicPartition);
        if (option instanceof Some) {
            Some some = (Some)option;
            OffsetAndMetadata stagedOffset = (OffsetAndMetadata)some.x();
            OffsetAndMetadata offsetAndMetadata = offsetWithCommitRecordMetadata.offsetAndMetadata();
            OffsetAndMetadata offsetAndMetadata2 = stagedOffset;
            if (!(offsetAndMetadata != null ? !((Object)offsetAndMetadata).equals(offsetAndMetadata2) : offsetAndMetadata2 != null)) {
                this.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits().remove(topicPartition);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void failPendingOffsetWrite(TopicPartition topicPartition, OffsetAndMetadata offset2) {
        Option<OffsetAndMetadata> option = this.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits().get(topicPartition);
        if (option instanceof Some) {
            Some some = (Some)option;
            OffsetAndMetadata pendingOffset = (OffsetAndMetadata)some.x();
            OffsetAndMetadata offsetAndMetadata = offset2;
            OffsetAndMetadata offsetAndMetadata2 = pendingOffset;
            if (!(offsetAndMetadata != null ? !((Object)offsetAndMetadata).equals(offsetAndMetadata2) : offsetAndMetadata2 != null)) {
                this.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits().remove(topicPartition);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void prepareOffsetCommit(scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.receivedConsumerOffsetCommits_$eq(true);
        this.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits().$plus$plus$eq((TraversableOnce<Tuple2<TopicPartition, OffsetAndMetadata>>)offsets);
    }

    public void prepareTxnOffsetCommit(long producerId, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.trace((Function0<String>)((Object)new scala.Serializable(this, producerId, offsets){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadata $outer;
            private final long producerId$1;
            private final scala.collection.immutable.Map offsets$1;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offsets ", " is pending"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.producerId$1), this.$outer.groupId(), this.offsets$1}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producerId$1 = producerId$1;
                this.offsets$1 = offsets$1;
            }
        }));
        this.receivedTransactionalOffsetCommits_$eq(true);
        scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset> producerOffsets = this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits().getOrElseUpdate(BoxesRunTime.boxToLong(producerId), (Function0<scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset> apply() {
                return Map$.MODULE$.empty();
            }
        }));
        offsets.foreach(new scala.Serializable(this, producerOffsets){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map producerOffsets$1;

            public final Option<CommitRecordMetadataAndOffset> apply(Tuple2<TopicPartition, OffsetAndMetadata> x0$2) {
                Tuple2<TopicPartition, OffsetAndMetadata> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition topicPartition = tuple2._1();
                    OffsetAndMetadata offsetAndMetadata = tuple2._2();
                    Option<CommitRecordMetadataAndOffset> option = this.producerOffsets$1.put(topicPartition, new CommitRecordMetadataAndOffset(None$.MODULE$, offsetAndMetadata));
                    return option;
                }
                throw new MatchError(tuple2);
            }
            {
                this.producerOffsets$1 = producerOffsets$1;
            }
        });
    }

    public boolean hasReceivedConsistentOffsetCommits() {
        return !this.receivedConsumerOffsetCommits() || !this.receivedTransactionalOffsetCommits();
    }

    public void failPendingTxnOffsetCommit(long producerId, TopicPartition topicPartition) {
        Option<scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> option = this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits().get(BoxesRunTime.boxToLong(producerId));
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            scala.collection.mutable.Map pendingOffsets = (scala.collection.mutable.Map)some.x();
            Option pendingOffsetCommit = pendingOffsets.remove(topicPartition);
            this.trace((Function0<String>)((Object)new scala.Serializable(this, producerId, pendingOffsetCommit){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GroupMetadata $outer;
                private final long producerId$2;
                private final Option pendingOffsetCommit$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offsets ", " failed "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.producerId$2), this.$outer.groupId(), this.pendingOffsetCommit$1}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to be appended to the log"})).s(Nil$.MODULE$)).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producerId$2 = producerId$2;
                    this.pendingOffsetCommit$1 = pendingOffsetCommit$1;
                }
            }));
            if (pendingOffsets.isEmpty()) {
                this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits().remove(BoxesRunTime.boxToLong(producerId));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void onTxnOffsetCommitAppend(long producerId, TopicPartition topicPartition, CommitRecordMetadataAndOffset commitRecordMetadataAndOffset) {
        block3: {
            block2: {
                var5_4 = this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits().get(BoxesRunTime.boxToLong(producerId));
                if (!(var5_4 instanceof Some)) break block2;
                var6_5 = (Some)var5_4;
                pendingOffset = (scala.collection.mutable.Map)var6_5.x();
                if (!pendingOffset.contains(topicPartition)) ** GOTO lbl-1000
                v0 = ((CommitRecordMetadataAndOffset)pendingOffset.apply(topicPartition)).offsetAndMetadata();
                var9_7 = commitRecordMetadataAndOffset.offsetAndMetadata();
                if (!(v0 != null ? v0.equals(var9_7) == false : var9_7 != null)) {
                    pendingOffset.update(topicPartition, commitRecordMetadataAndOffset);
                    v1 = BoxedUnit.UNIT;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = BoxedUnit.UNIT;
                }
                var8_8 = v1;
                break block3;
            }
            var8_9 = BoxedUnit.UNIT;
        }
    }

    public void completePendingTxnOffsetCommit(long producerId, boolean isCommit) {
        Option<scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> pendingOffsetsOpt = this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits().remove(BoxesRunTime.boxToLong(producerId));
        if (isCommit) {
            pendingOffsetsOpt.foreach(new scala.Serializable(this, producerId){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GroupMetadata $outer;
                public final long producerId$3;

                public final void apply(scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset> pendingOffsets) {
                    pendingOffsets.foreach(new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$completePendingTxnOffsetCommit$1 $outer;

                        public final Object apply(Tuple2<TopicPartition, CommitRecordMetadataAndOffset> x0$3) {
                            Tuple2<TopicPartition, CommitRecordMetadataAndOffset> tuple2 = x0$3;
                            if (tuple2 != null) {
                                Serializable serializable;
                                TopicPartition topicPartition = tuple2._1();
                                CommitRecordMetadataAndOffset commitRecordMetadataAndOffset = tuple2._2();
                                if (commitRecordMetadataAndOffset.appendedBatchOffset().isEmpty()) {
                                    throw new IllegalStateException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to complete a transactional offset commit for producerId ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.$outer.producerId$3)}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and groupId ", " even though the the offset commit record itself hasn't been appended to the log."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.kafka$coordinator$group$GroupMetadata$$anonfun$$$outer().groupId()}))).toString());
                                }
                                Option<CommitRecordMetadataAndOffset> currentOffsetOpt = this.$outer.kafka$coordinator$group$GroupMetadata$$anonfun$$$outer().kafka$coordinator$group$GroupMetadata$$offsets().get(topicPartition);
                                if (currentOffsetOpt.forall((Function1<CommitRecordMetadataAndOffset, Object>)((Object)new scala.Serializable(this, commitRecordMetadataAndOffset){
                                    public static final long serialVersionUID = 0L;
                                    private final CommitRecordMetadataAndOffset commitRecordMetadataAndOffset$1;

                                    public final boolean apply(CommitRecordMetadataAndOffset x$6) {
                                        return x$6.olderThan(this.commitRecordMetadataAndOffset$1);
                                    }
                                    {
                                        this.commitRecordMetadataAndOffset$1 = commitRecordMetadataAndOffset$1;
                                    }
                                }))) {
                                    this.$outer.kafka$coordinator$group$GroupMetadata$$anonfun$$$outer().trace((Function0<String>)((Object)new scala.Serializable(this, commitRecordMetadataAndOffset){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$completePendingTxnOffsetCommit$1$$anonfun$apply$1 $outer;
                                        private final CommitRecordMetadataAndOffset commitRecordMetadataAndOffset$1;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offset ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.$outer.kafka$coordinator$group$GroupMetadata$$anonfun$$anonfun$$$outer().producerId$3), this.$outer.kafka$coordinator$group$GroupMetadata$$anonfun$$anonfun$$$outer().kafka$coordinator$group$GroupMetadata$$anonfun$$$outer().groupId(), this.commitRecordMetadataAndOffset$1}))).append((Object)"committed and loaded into the cache.").toString();
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.commitRecordMetadataAndOffset$1 = commitRecordMetadataAndOffset$1;
                                        }
                                    }));
                                    serializable = this.$outer.kafka$coordinator$group$GroupMetadata$$anonfun$$$outer().kafka$coordinator$group$GroupMetadata$$offsets().put(topicPartition, commitRecordMetadataAndOffset);
                                } else {
                                    this.$outer.kafka$coordinator$group$GroupMetadata$$anonfun$$$outer().trace((Function0<String>)((Object)new scala.Serializable(this, commitRecordMetadataAndOffset, currentOffsetOpt){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$completePendingTxnOffsetCommit$1$$anonfun$apply$1 $outer;
                                        private final CommitRecordMetadataAndOffset commitRecordMetadataAndOffset$1;
                                        private final Option currentOffsetOpt$1;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offset ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.$outer.kafka$coordinator$group$GroupMetadata$$anonfun$$anonfun$$$outer().producerId$3), this.$outer.kafka$coordinator$group$GroupMetadata$$anonfun$$anonfun$$$outer().kafka$coordinator$group$GroupMetadata$$anonfun$$$outer().groupId(), this.commitRecordMetadataAndOffset$1}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"committed, but not loaded since its offset is older than current offset ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.currentOffsetOpt$1}))).toString();
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.commitRecordMetadataAndOffset$1 = commitRecordMetadataAndOffset$1;
                                            this.currentOffsetOpt$1 = currentOffsetOpt$1;
                                        }
                                    }));
                                    serializable = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit = serializable;
                                return boxedUnit;
                            }
                            throw new MatchError(tuple2);
                        }

                        public /* synthetic */ $anonfun$completePendingTxnOffsetCommit$1 kafka$coordinator$group$GroupMetadata$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ GroupMetadata kafka$coordinator$group$GroupMetadata$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producerId$3 = producerId$3;
                }
            });
        } else {
            this.trace((Function0<String>)((Object)new scala.Serializable(this, producerId, pendingOffsetsOpt){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GroupMetadata $outer;
                private final long producerId$3;
                private final Option pendingOffsetsOpt$1;

                public final String apply() {
                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offsets ", " aborted"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.producerId$3), this.$outer.groupId(), this.pendingOffsetsOpt$1}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producerId$3 = producerId$3;
                    this.pendingOffsetsOpt$1 = pendingOffsetsOpt$1;
                }
            }));
        }
    }

    public Set<Object> activeProducers() {
        return this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits().keySet();
    }

    public boolean hasPendingOffsetCommitsFromProducer(long producerId) {
        return this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits().contains(BoxesRunTime.boxToLong(producerId));
    }

    public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> removeOffsets(Seq<TopicPartition> topicPartitions) {
        return ((TraversableOnce)topicPartitions.flatMap(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadata $outer;

            public final Iterable<Tuple2<TopicPartition, OffsetAndMetadata>> apply(TopicPartition topicPartition) {
                this.$outer.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits().remove(topicPartition);
                this.$outer.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits().foreach(new scala.Serializable(this, topicPartition){
                    public static final long serialVersionUID = 0L;
                    private final TopicPartition topicPartition$1;

                    public final Option<CommitRecordMetadataAndOffset> apply(Tuple2<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> x0$4) {
                        Tuple2<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> tuple2 = x0$4;
                        if (tuple2 != null) {
                            scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset> pendingOffsets = tuple2._2();
                            Option<CommitRecordMetadataAndOffset> option = pendingOffsets.remove(this.topicPartition$1);
                            return option;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.topicPartition$1 = topicPartition$1;
                    }
                });
                Option<CommitRecordMetadataAndOffset> removedOffset = this.$outer.kafka$coordinator$group$GroupMetadata$$offsets().remove(topicPartition);
                return Option$.MODULE$.option2Iterable(removedOffset.map(new scala.Serializable(this, topicPartition){
                    public static final long serialVersionUID = 0L;
                    private final TopicPartition topicPartition$1;

                    public final Tuple2<TopicPartition, OffsetAndMetadata> apply(CommitRecordMetadataAndOffset x$7) {
                        return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.topicPartition$1), x$7.offsetAndMetadata());
                    }
                    {
                        this.topicPartition$1 = topicPartition$1;
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> removeExpiredOffsets(long startMs) {
        HashMap expiredOffsets = ((TraversableLike)this.kafka$coordinator$group$GroupMetadata$$offsets().filter((Function1)((Object)new scala.Serializable(this, startMs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadata $outer;
            private final long startMs$1;

            public final boolean apply(Tuple2<TopicPartition, CommitRecordMetadataAndOffset> x0$5) {
                Tuple2<TopicPartition, CommitRecordMetadataAndOffset> tuple2 = x0$5;
                if (tuple2 != null) {
                    TopicPartition topicPartition = tuple2._1();
                    CommitRecordMetadataAndOffset commitRecordMetadataAndOffset = tuple2._2();
                    boolean bl = commitRecordMetadataAndOffset.offsetAndMetadata().expireTimestamp() < this.startMs$1 && !this.$outer.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits().contains(topicPartition);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.startMs$1 = startMs$1;
            }
        }))).map(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, OffsetAndMetadata> apply(Tuple2<TopicPartition, CommitRecordMetadataAndOffset> x0$6) {
                Tuple2<TopicPartition, CommitRecordMetadataAndOffset> tuple2 = x0$6;
                if (tuple2 != null) {
                    TopicPartition topicPartition = tuple2._1();
                    CommitRecordMetadataAndOffset commitRecordOffsetAndMetadata = tuple2._2();
                    Tuple2<TopicPartition, OffsetAndMetadata> tuple22 = new Tuple2<TopicPartition, OffsetAndMetadata>(topicPartition, commitRecordOffsetAndMetadata.offsetAndMetadata());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, HashMap$.MODULE$.canBuildFrom());
        this.kafka$coordinator$group$GroupMetadata$$offsets().$minus$minus$eq((TraversableOnce<TopicPartition>)((Object)expiredOffsets.keySet()));
        return expiredOffsets.toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> allOffsets() {
        return ((TraversableOnce)this.kafka$coordinator$group$GroupMetadata$$offsets().map((Function1<TopicPartition, CommitRecordMetadataAndOffset>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, OffsetAndMetadata> apply(Tuple2<TopicPartition, CommitRecordMetadataAndOffset> x0$7) {
                Tuple2<TopicPartition, CommitRecordMetadataAndOffset> tuple2 = x0$7;
                if (tuple2 != null) {
                    TopicPartition topicPartition = tuple2._1();
                    CommitRecordMetadataAndOffset commitRecordMetadataAndOffset = tuple2._2();
                    Tuple2<TopicPartition, OffsetAndMetadata> tuple22 = new Tuple2<TopicPartition, OffsetAndMetadata>(topicPartition, commitRecordMetadataAndOffset.offsetAndMetadata());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }), HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Option<OffsetAndMetadata> offset(TopicPartition topicPartition) {
        return this.kafka$coordinator$group$GroupMetadata$$offsets().get(topicPartition).map(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final OffsetAndMetadata apply(CommitRecordMetadataAndOffset x$8) {
                return x$8.offsetAndMetadata();
            }
        });
    }

    public Option<CommitRecordMetadataAndOffset> offsetWithRecordMetadata(TopicPartition topicPartition) {
        return this.kafka$coordinator$group$GroupMetadata$$offsets().get(topicPartition);
    }

    public int numOffsets() {
        return this.kafka$coordinator$group$GroupMetadata$$offsets().size();
    }

    public boolean hasOffsets() {
        return this.kafka$coordinator$group$GroupMetadata$$offsets().nonEmpty() || this.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits().nonEmpty() || this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits().nonEmpty();
    }

    private void assertValidTransition(GroupState targetState) {
        if (((SetLike)GroupMetadata$.MODULE$.kafka$coordinator$group$GroupMetadata$$validPreviousStates().apply(targetState)).contains(this.state())) {
            return;
        }
        throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Group %s should be in the %s states before moving to %s state. Instead it is in %s state")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.groupId(), ((TraversableOnce)GroupMetadata$.MODULE$.kafka$coordinator$group$GroupMetadata$$validPreviousStates().apply(targetState)).mkString(","), targetState, this.state()})));
    }

    public String toString() {
        return new StringBuilder().append((Object)"GroupMetadata(").append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"groupId=", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.groupId()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"generation=", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.generationId())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"protocolType=", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.protocolType()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currentState=", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.currentState()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"members=", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.members()}))).toString();
    }

    public GroupMetadata(String groupId, GroupState initialState) {
        this.groupId = groupId;
        Logging$class.$init$(this);
        this.state = initialState;
        this.lock = new ReentrantLock();
        this.members = new HashMap();
        this.kafka$coordinator$group$GroupMetadata$$offsets = new HashMap();
        this.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits = new HashMap();
        this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits = new HashMap();
        this.receivedTransactionalOffsetCommits = false;
        this.receivedConsumerOffsetCommits = false;
        this.protocolType = None$.MODULE$;
        this.generationId = 0;
        this.leaderId = null;
        this.protocol = null;
        this.newMemberAdded = false;
    }
}

