/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused$;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.collection.GenMap;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\ted!B\u0001\u0003\u0001\t1!!\u0005'pO\u000ecW-\u00198fe6\u000bg.Y4fe*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0014\t\u00019Qb\u0005\t\u0003\u0011-i\u0011!\u0003\u0006\u0002\u0015\u0005)1oY1mC&\u0011A\"\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u00059\tR\"A\b\u000b\u0005A!\u0011!B;uS2\u001c\u0018B\u0001\n\u0010\u0005\u001daunZ4j]\u001e\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0003\u0002\u000f5,GO]5dg&\u0011\u0001$\u0006\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\b\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\u000f1|w\rR5sg\u000e\u0001Q#A\u000f\u0011\u0007y1\u0013F\u0004\u0002 I9\u0011\u0001eI\u0007\u0002C)\u0011!eG\u0001\u0007yI|w\u000e\u001e \n\u0003)I!!J\u0005\u0002\u000fA\f7m[1hK&\u0011q\u0005\u000b\u0002\u0004'\u0016\f(BA\u0013\n!\tQs&D\u0001,\u0015\taS&\u0001\u0002j_*\ta&\u0001\u0003kCZ\f\u0017B\u0001\u0019,\u0005\u00111\u0015\u000e\\3\t\u0011I\u0002!\u0011!Q\u0001\nu\t\u0001\u0002\\8h\t&\u00148\u000f\t\u0005\ti\u0001\u0011)\u0019!C\u0001k\u0005!An\\4t+\u00051\u0004\u0003\u0002\b8s\u0011K!\u0001O\b\u0003\tA{w\u000e\u001c\t\u0003u\tk\u0011a\u000f\u0006\u0003yu\naaY8n[>t'BA\u0003?\u0015\ty\u0004)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0003\u0006\u0019qN]4\n\u0005\r[$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003\u000b\u001ak\u0011AA\u0005\u0003\u000f\n\u00111\u0001T8h\u0011!I\u0005A!A!\u0002\u00131\u0014!\u00027pON\u0004\u0003\u0002C&\u0001\u0005\u000b\u0007I\u0011\u0001'\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m+\u0005i\u0005C\u0001(R\u001b\u0005y%B\u0001)\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011!k\u0014\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\t\u0011Q\u0003!\u0011!Q\u0001\n5\u000bQ\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007\u0005C\u0003W\u0001\u0011\u0005q+\u0001\u0004=S:LGO\u0010\u000b\u00051fS6\f\u0005\u0002F\u0001!)!$\u0016a\u0001;!)A'\u0016a\u0001m!)1*\u0016a\u0001\u001b\"9Q\f\u0001b\u0001\n\u0003r\u0016A\u00037pO\u001e,'OT1nKV\tq\f\u0005\u0002aG6\t\u0011M\u0003\u0002c[\u0005!A.\u00198h\u0013\t!\u0017M\u0001\u0004TiJLgn\u001a\u0005\u0007M\u0002\u0001\u000b\u0011B0\u0002\u00171|wmZ3s\u001d\u0006lW\r\t\u0005\tQ\u0002\u0011\r\u0011\"\u0001\u0003=\u0006!rN\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016DaA\u001b\u0001!\u0002\u0013y\u0016!F8gMN,Go\u00115fG.\u0004x.\u001b8u\r&dW\r\t\u0005\bY\u0002\u0001\r\u0011\"\u0003n\u0003-\u0019\u0007.Z2la>Lg\u000e^:\u0016\u00039\u0004Ba\u001c;*m6\t\u0001O\u0003\u0002re\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003g&\t!bY8mY\u0016\u001cG/[8o\u0013\t)\bOA\u0002NCB\u0004\"a^=\u000e\u0003aT!\u0001\\(\n\u0005iD(\u0001F(gMN,Go\u00115fG.\u0004x.\u001b8u\r&dW\rC\u0004}\u0001\u0001\u0007I\u0011B?\u0002\u001f\rDWmY6q_&tGo]0%KF$2A`A\u0002!\tAq0C\u0002\u0002\u0002%\u0011A!\u00168ji\"A\u0011QA>\u0002\u0002\u0003\u0007a.A\u0002yIEBq!!\u0003\u0001A\u0003&a.\u0001\u0007dQ\u0016\u001c7\u000e]8j]R\u001c\b\u0005\u000b\u0003\u0002\b\u00055\u0001c\u0001\u0005\u0002\u0010%\u0019\u0011\u0011C\u0005\u0003\u0011Y|G.\u0019;jY\u0016D\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0006\u0002\u0015%t\u0007K]8he\u0016\u001c8/\u0006\u0002\u0002\u001aA9\u00111DA\u0011s\u0005\u0015RBAA\u000f\u0015\r\tyB]\u0001\b[V$\u0018M\u00197f\u0013\u0011\t\u0019#!\b\u0003\u000f!\u000b7\u000f['baB\u0019Q)a\n\n\u0007\u0005%\"A\u0001\tM_\u001e\u001cE.Z1oS:<7\u000b^1uK\"A\u0011Q\u0006\u0001!\u0002\u0013\tI\"A\u0006j]B\u0013xn\u001a:fgN\u0004\u0003\"CA\u0019\u0001\t\u0007I\u0011BA\u001a\u0003\u0011awnY6\u0016\u0005\u0005U\u0002\u0003BA\u001c\u0003\u000bj!!!\u000f\u000b\t\u0005m\u0012QH\u0001\u0006Y>\u001c7n\u001d\u0006\u0005\u0003\u007f\t\t%\u0001\u0006d_:\u001cWO\u001d:f]RT1!a\u0011.\u0003\u0011)H/\u001b7\n\t\u0005\u001d\u0013\u0011\b\u0002\u000e%\u0016,g\u000e\u001e:b]RdunY6\t\u0011\u0005-\u0003\u0001)A\u0005\u0003k\tQ\u0001\\8dW\u0002B\u0011\"a\u0014\u0001\u0005\u0004%I!!\u0015\u0002%A\fWo]3e\u00072,\u0017M\\5oO\u000e{g\u000eZ\u000b\u0003\u0003'\u0002B!a\u000e\u0002V%!\u0011qKA\u001d\u0005%\u0019uN\u001c3ji&|g\u000e\u0003\u0005\u0002\\\u0001\u0001\u000b\u0011BA*\u0003M\u0001\u0018-^:fI\u000ecW-\u00198j]\u001e\u001cuN\u001c3!\u0011%\ty\u0006\u0001a\u0001\n\u0013\t\t'A\reSJ$\u0018.Z:u\u0019><7\t\\3b]\u0006\u0014G.\u001a*bi&|WCAA2!\rA\u0011QM\u0005\u0004\u0003OJ!A\u0002#pk\ndW\rC\u0005\u0002l\u0001\u0001\r\u0011\"\u0003\u0002n\u0005iB-\u001b:uS\u0016\u001cH\u000fT8h\u00072,\u0017M\\1cY\u0016\u0014\u0016\r^5p?\u0012*\u0017\u000fF\u0002\u007f\u0003_B!\"!\u0002\u0002j\u0005\u0005\t\u0019AA2\u0011!\t\u0019\b\u0001Q!\n\u0005\r\u0014A\u00073jeRLWm\u001d;M_\u001e\u001cE.Z1oC\ndWMU1uS>\u0004\u0003\u0006BA9\u0003\u001bA\u0011\"!\u001f\u0001\u0001\u0004%I!a\u001f\u0002\u001bQLW.Z(g\u0019\u0006\u001cHOU;o+\t\ti\bE\u0002\t\u0003\u007fJ1!!!\n\u0005\u0011auN\\4\t\u0013\u0005\u0015\u0005\u00011A\u0005\n\u0005\u001d\u0015!\u0005;j[\u0016|e\rT1tiJ+hn\u0018\u0013fcR\u0019a0!#\t\u0015\u0005\u0015\u00111QA\u0001\u0002\u0004\ti\b\u0003\u0005\u0002\u000e\u0002\u0001\u000b\u0015BA?\u00039!\u0018.\\3PM2\u000b7\u000f\u001e*v]\u0002BC!a#\u0002\u000e!9\u00111\u0013\u0001\u0005\u0002\u0005U\u0015!F1mY\u000ecW-\u00198fe\u000eCWmY6q_&tGo]\u000b\u0003\u0003/\u0003r!!'\u0002 f\niHD\u0002\t\u00037K1!!(\n\u0003\u0019\u0001&/\u001a3fM&\u0019Q/!)\u000b\u0007\u0005u\u0015\u0002C\u0004\u0002&\u0002!\t!a*\u00023\u001d\u0014\u0018M\u0019$jYRD\u0017.Z:u\u0007>l\u0007/Y2uK\u0012dun\u001a\u000b\u0005\u0003S\u000b)\fE\u0003\t\u0003W\u000by+C\u0002\u0002.&\u0011aa\u00149uS>t\u0007cA#\u00022&\u0019\u00111\u0017\u0002\u0003\u00151{w\rV8DY\u0016\fg\u000e\u0003\u0005\u00028\u0006\r\u0006\u0019AA]\u0003\u0011!\u0018.\\3\u0011\t\u0005m\u0016qX\u0007\u0003\u0003{S!\u0001E\u001e\n\t\u0005\u0005\u0017Q\u0018\u0002\u0005)&lW\rC\u0004\u0002F\u0002!\t!a2\u0002\u001b\u0011,G.\u001a;bE2,Gj\\4t)\t\tI\rE\u0003\u001f\u0003\u0017\fy-C\u0002\u0002N\"\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\t\u0006\u0011\u0005E\u0017\bR\u0005\u0004\u0003'L!A\u0002+va2,'\u0007C\u0004\u0002X\u0002!\t!!7\u0002\u001b\u0005\u0014wN\u001d;DY\u0016\fg.\u001b8h)\rq\u00181\u001c\u0005\b\u0003;\f)\u000e1\u0001:\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!!9\u0001\t\u0003\t\u0019/A\u000bbE>\u0014H/\u00118e!\u0006,8/Z\"mK\u0006t\u0017N\\4\u0015\u0007y\f)\u000fC\u0004\u0002^\u0006}\u0007\u0019A\u001d\t\u000f\u0005%\b\u0001\"\u0001\u0002l\u0006q!/Z:v[\u0016\u001cE.Z1oS:<Gc\u0001@\u0002n\"9\u0011Q\\At\u0001\u0004I\u0004bBAy\u0001\u0011%\u00111_\u0001\u0012SN\u001cE.Z1oS:<\u0017J\\*uCR,GCBA{\u0003w\fi\u0010E\u0002\t\u0003oL1!!?\n\u0005\u001d\u0011un\u001c7fC:Dq!!8\u0002p\u0002\u0007\u0011\b\u0003\u0005\u0002\u0000\u0006=\b\u0019AA\u0013\u00035)\u0007\u0010]3di\u0016$7\u000b^1uK\"9!1\u0001\u0001\u0005\u0002\t\u0015\u0011\u0001F2iK\u000e\\7\t\\3b]&tw-\u00112peR,G\rF\u0002\u007f\u0005\u000fAq!!8\u0003\u0002\u0001\u0007\u0011\bC\u0004\u0003\f\u0001!\tA!\u0004\u0002#U\u0004H-\u0019;f\u0007\",7m\u001b9pS:$8\u000fF\u0003\u007f\u0005\u001f\u0011\u0019\u0002C\u0004\u0003\u0012\t%\u0001\u0019A\u0015\u0002\u000f\u0011\fG/\u0019#je\"A!Q\u0003B\u0005\u0001\u0004\u00119\"\u0001\u0004va\u0012\fG/\u001a\t\u0006\u0011\u0005-&\u0011\u0004\t\u0007\u0011\u0005E\u0017(! \t\u000f\tu\u0001\u0001\"\u0001\u0003 \u0005\u0019\u0002.\u00198eY\u0016dun\u001a#je\u001a\u000b\u0017\u000e\\;sKR\u0019aP!\t\t\u0011\t\r\"1\u0004a\u0001\u0005K\t1\u0001Z5s!\u0011\tIJa\n\n\u0007\u0011\f\t\u000bC\u0004\u0003,\u0001!\tA!\f\u0002/5\f\u0017PY3UeVt7-\u0019;f\u0007\",7m\u001b9pS:$Hc\u0002@\u00030\tE\"1\u0007\u0005\b\u0005#\u0011I\u00031\u0001*\u0011\u001d\tiN!\u000bA\u0002eB\u0001B!\u000e\u0003*\u0001\u0007\u0011QP\u0001\u0007_\u001a47/\u001a;\t\u000f\te\u0002\u0001\"\u0001\u0003<\u0005aAm\u001c8f\u00072,\u0017M\\5oOR9aP!\u0010\u0003@\t\u0005\u0003bBAo\u0005o\u0001\r!\u000f\u0005\b\u0005#\u00119\u00041\u0001*\u0011!\u0011\u0019Ea\u000eA\u0002\u0005u\u0014!C3oI>3gm]3u\u0011\u001d\u00119\u0005\u0001C\u0001\u0005\u0013\nA\u0002Z8oK\u0012+G.\u001a;j]\u001e$2A B&\u0011\u001d\tiN!\u0012A\u0002e:\u0001Ba\u0014\u0003\u0011\u0003\u0011!\u0011K\u0001\u0012\u0019><7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014\bcA#\u0003T\u00199\u0011A\u0001E\u0001\u0005\tU3\u0003\u0002B*\u000f5AqA\u0016B*\t\u0003\u0011I\u0006\u0006\u0002\u0003R!A!Q\fB*\t\u0003\u0011y&\u0001\njg\u000e{W\u000e]1di\u0006sG\rR3mKR,G\u0003BA{\u0005CBaa\u0001B.\u0001\u0004!\u0005\u0002\u0003B3\u0005'\"\tAa\u001a\u0002!\rdW-\u00198bE2,wJ\u001a4tKR\u001cHC\u0003B5\u0005W\u0012iGa\u001c\u0003vA9\u0001\"!5\u0002~\u0005u\u0004BB\u0002\u0003d\u0001\u0007A\tC\u0004\u0002^\n\r\u0004\u0019A\u001d\t\u0011\tE$1\ra\u0001\u0005g\n\u0011\u0002\\1ti\u000ecW-\u00198\u0011\u000b=$\u0018(! \t\u0011\t]$1\ra\u0001\u0003{\n1A\\8x\u0001")
public class LogCleanerManager
implements KafkaMetricsGroup {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    private final String loggerName;
    private final String offsetCheckpointFile;
    private volatile scala.collection.immutable.Map<File, OffsetCheckpointFile> kafka$log$LogCleanerManager$$checkpoints;
    private final HashMap<TopicPartition, LogCleaningState> kafka$log$LogCleanerManager$$inProgress;
    private final ReentrantLock lock;
    private final Condition kafka$log$LogCleanerManager$$pausedCleaningCond;
    private volatile double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    private volatile long kafka$log$LogCleanerManager$$timeOfLastRun;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Tuple2<Object, Object> cleanableOffsets(Log log, TopicPartition topicPartition, scala.collection.immutable.Map<TopicPartition, Object> map2, long l) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, map2, l);
    }

    public static boolean isCompactAndDelete(Log log) {
        return LogCleanerManager$.MODULE$.isCompactAndDelete(log);
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.metricName(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.explicitMetricName(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    private Logger logger$lzycompute() {
        LogCleanerManager logCleanerManager = this;
        synchronized (logCleanerManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    public scala.collection.immutable.Map<File, OffsetCheckpointFile> kafka$log$LogCleanerManager$$checkpoints() {
        return this.kafka$log$LogCleanerManager$$checkpoints;
    }

    public void kafka$log$LogCleanerManager$$checkpoints_$eq(scala.collection.immutable.Map<File, OffsetCheckpointFile> x$1) {
        this.kafka$log$LogCleanerManager$$checkpoints = x$1;
    }

    public HashMap<TopicPartition, LogCleaningState> kafka$log$LogCleanerManager$$inProgress() {
        return this.kafka$log$LogCleanerManager$$inProgress;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    public Condition kafka$log$LogCleanerManager$$pausedCleaningCond() {
        return this.kafka$log$LogCleanerManager$$pausedCleaningCond;
    }

    public double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio() {
        return this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    }

    public void kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(double x$1) {
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = x$1;
    }

    public long kafka$log$LogCleanerManager$$timeOfLastRun() {
        return this.kafka$log$LogCleanerManager$$timeOfLastRun;
    }

    public void kafka$log$LogCleanerManager$$timeOfLastRun_$eq(long x$1) {
        this.kafka$log$LogCleanerManager$$timeOfLastRun = x$1;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
        return CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;

            public final scala.collection.immutable.Map<TopicPartition, Object> apply() {
                return ((TraversableOnce)this.$outer.kafka$log$LogCleanerManager$$checkpoints().values().flatMap(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$allCleanerCheckpoints$1 $outer;

                    public final Map<TopicPartition, Object> apply(OffsetCheckpointFile checkpoint) {
                        GenMap<TopicPartition, Object> genMap;
                        try {
                            genMap = checkpoint.read();
                        }
                        catch (KafkaStorageException kafkaStorageException) {
                            this.$outer.kafka$log$LogCleanerManager$$anonfun$$$outer().error((Function0<String>)((Object)new scala.Serializable(this, checkpoint){
                                public static final long serialVersionUID = 0L;
                                private final OffsetCheckpointFile checkpoint$2;

                                public final String apply() {
                                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to access checkpoint file ", " in dir ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.checkpoint$2.file().getName(), this.checkpoint$2.file().getParentFile().getAbsolutePath()}));
                                }
                                {
                                    this.checkpoint$2 = checkpoint$2;
                                }
                            }), (Function0<Throwable>)((Object)new scala.Serializable(this, kafkaStorageException){
                                public static final long serialVersionUID = 0L;
                                private final KafkaStorageException e$1;

                                public final KafkaStorageException apply() {
                                    return this.e$1;
                                }
                                {
                                    this.e$1 = e$1;
                                }
                            }));
                            genMap = Predef$.MODULE$.Map().empty();
                        }
                        return genMap;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }

            public /* synthetic */ LogCleanerManager kafka$log$LogCleanerManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<LogToClean> grabFilthiestCompactedLog(Time time) {
        return CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final Time time$1;

            public final Option<LogToClean> apply() {
                Option option;
                long now = this.time$1.milliseconds();
                this.$outer.kafka$log$LogCleanerManager$$timeOfLastRun_$eq(now);
                scala.collection.immutable.Map<TopicPartition, Object> lastClean = this.$outer.allCleanerCheckpoints();
                Iterable dirtyLogs = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)this.$outer.logs().filter((Function1)((Object)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<TopicPartition, Log> x0$1) {
                        Tuple2<TopicPartition, Log> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Log log = tuple2._2();
                            boolean bl = log.config().compact();
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                }))).filterNot(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$grabFilthiestCompactedLog$1 $outer;

                    public final boolean apply(Tuple2<TopicPartition, Log> x0$2) {
                        Tuple2<TopicPartition, Log> tuple2 = x0$2;
                        if (tuple2 != null) {
                            TopicPartition topicPartition = tuple2._1();
                            boolean bl = this.$outer.kafka$log$LogCleanerManager$$anonfun$$$outer().kafka$log$LogCleanerManager$$inProgress().contains(topicPartition);
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).map(new scala.Serializable(this, now, lastClean){
                    public static final long serialVersionUID = 0L;
                    private final long now$1;
                    private final scala.collection.immutable.Map lastClean$1;

                    public final LogToClean apply(Tuple2<TopicPartition, Log> x0$3) {
                        Tuple2<TopicPartition, Log> tuple2 = x0$3;
                        if (tuple2 != null) {
                            TopicPartition topicPartition = tuple2._1();
                            Log log = tuple2._2();
                            Tuple2<Object, Object> tuple22 = LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, this.lastClean$1, this.now$1);
                            if (tuple22 != null) {
                                Tuple2$mcJJ$sp tuple2$mcJJ$sp;
                                long firstDirtyOffset = tuple22._1$mcJ$sp();
                                long firstUncleanableDirtyOffset = tuple22._2$mcJ$sp();
                                Tuple2$mcJJ$sp tuple2$mcJJ$sp2 = tuple2$mcJJ$sp = new Tuple2$mcJJ$sp(firstDirtyOffset, firstUncleanableDirtyOffset);
                                long firstDirtyOffset2 = ((Tuple2)tuple2$mcJJ$sp2)._1$mcJ$sp();
                                long firstUncleanableDirtyOffset2 = ((Tuple2)tuple2$mcJJ$sp2)._2$mcJ$sp();
                                LogToClean logToClean = new LogToClean(topicPartition, log, firstDirtyOffset2, firstUncleanableDirtyOffset2);
                                return logToClean;
                            }
                            throw new MatchError(tuple22);
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.now$1 = now$1;
                        this.lastClean$1 = lastClean$1;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).filter(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(LogToClean ltc) {
                        return ltc.totalBytes() > 0L;
                    }
                });
                this.$outer.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
                Iterable cleanableLogs = (Iterable)dirtyLogs.filter(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(LogToClean ltc) {
                        return ltc.cleanableRatio() > Predef$.MODULE$.Double2double(ltc.log().config().minCleanableRatio());
                    }
                });
                if (cleanableLogs.isEmpty()) {
                    option = None$.MODULE$;
                } else {
                    LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
                    this.$outer.kafka$log$LogCleanerManager$$inProgress().put(filthiest.topicPartition(), LogCleaningInProgress$.MODULE$);
                    option = new Some<LogToClean>(filthiest);
                }
                return option;
            }

            public /* synthetic */ LogCleanerManager kafka$log$LogCleanerManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.time$1 = time$1;
            }
        });
    }

    public Iterable<Tuple2<TopicPartition, Log>> deletableLogs() {
        return CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;

            /*
             * WARNING - void declaration
             */
            public final Iterable<Tuple2<TopicPartition, Log>> apply() {
                void var1_1;
                Iterable toClean = (Iterable)this.$outer.logs().filter((Function1)((Object)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deletableLogs$1 $outer;

                    public final boolean apply(Tuple2<TopicPartition, Log> x0$4) {
                        Tuple2<TopicPartition, Log> tuple2 = x0$4;
                        if (tuple2 != null) {
                            TopicPartition topicPartition = tuple2._1();
                            Log log = tuple2._2();
                            boolean bl = !this.$outer.kafka$log$LogCleanerManager$$anonfun$$$outer().kafka$log$LogCleanerManager$$inProgress().contains(topicPartition) && LogCleanerManager$.MODULE$.isCompactAndDelete(log);
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                toClean.foreach(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deletableLogs$1 $outer;

                    public final Option<LogCleaningState> apply(Tuple2<TopicPartition, Log> x0$5) {
                        Tuple2<TopicPartition, Log> tuple2 = x0$5;
                        if (tuple2 != null) {
                            TopicPartition tp = tuple2._1();
                            Option<LogCleaningState> option = this.$outer.kafka$log$LogCleanerManager$$anonfun$$$outer().kafka$log$LogCleanerManager$$inProgress().put(tp, LogCleaningInProgress$.MODULE$);
                            return option;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return var1_1;
            }

            public /* synthetic */ LogCleanerManager kafka$log$LogCleanerManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void abortCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.abortAndPauseCleaning(this.topicPartition$1);
                this.$outer.resumeCleaning(this.topicPartition$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$1 = topicPartition$1;
            }
        });
        this.info((Function0<String>)((Object)new scala.Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$1;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cleaning for partition ", " is aborted"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$1}));
            }
            {
                this.topicPartition$1 = topicPartition$1;
            }
        }));
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option<LogCleaningState> option;
                block7: {
                    LogCleaningState logCleaningState;
                    block8: {
                        block6: {
                            Option<LogCleaningState> option2;
                            block5: {
                                option = this.$outer.kafka$log$LogCleanerManager$$inProgress().get(this.topicPartition$3);
                                if (!None$.MODULE$.equals(option)) break block5;
                                option2 = this.$outer.kafka$log$LogCleanerManager$$inProgress().put(this.topicPartition$3, LogCleaningPaused$.MODULE$);
                                break block6;
                            }
                            if (!(option instanceof Some)) break block7;
                            Some some = (Some)option;
                            LogCleaningState state = (LogCleaningState)some.x();
                            logCleaningState = state;
                            if (!LogCleaningInProgress$.MODULE$.equals(logCleaningState)) break block8;
                            Option<LogCleaningState> option3 = this.$outer.kafka$log$LogCleanerManager$$inProgress().put(this.topicPartition$3, LogCleaningAborted$.MODULE$);
                            option2 = option3;
                        }
                        while (true) {
                            if (this.$outer.kafka$log$LogCleanerManager$$isCleaningInState(this.topicPartition$3, LogCleaningPaused$.MODULE$)) {
                                return;
                            }
                            this.$outer.kafka$log$LogCleanerManager$$pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
                        }
                    }
                    throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be aborted and paused since it is in ", " state."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$3, logCleaningState})));
                }
                throw new MatchError(option);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$3 = topicPartition$3;
            }
        });
        this.info((Function0<String>)((Object)new scala.Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$3;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cleaning for partition ", " is aborted and paused"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$3}));
            }
            {
                this.topicPartition$3 = topicPartition$3;
            }
        }));
    }

    public void resumeCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$4;

            public final Option<LogCleaningState> apply() {
                Option<LogCleaningState> option = this.$outer.kafka$log$LogCleanerManager$$inProgress().get(this.topicPartition$4);
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be resumed since it is not paused."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$4})));
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    LogCleaningState state = (LogCleaningState)some.x();
                    LogCleaningState logCleaningState = state;
                    if (LogCleaningPaused$.MODULE$.equals(logCleaningState)) {
                        Option<LogCleaningState> option2;
                        Option<LogCleaningState> option3 = option2 = this.$outer.kafka$log$LogCleanerManager$$inProgress().remove(this.topicPartition$4);
                        return option3;
                    }
                    throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be resumed since it is in ", " state."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$4, logCleaningState})));
                }
                throw new MatchError(option);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$4 = topicPartition$4;
            }
        });
        this.info((Function0<String>)((Object)new scala.Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$4;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " is resumed"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$4}));
            }
            {
                this.topicPartition$4 = topicPartition$4;
            }
        }));
    }

    public boolean kafka$log$LogCleanerManager$$isCleaningInState(TopicPartition topicPartition, LogCleaningState expectedState) {
        Option<LogCleaningState> option;
        block4: {
            boolean bl;
            block3: {
                LogCleaningState state;
                block2: {
                    option = this.kafka$log$LogCleanerManager$$inProgress().get(topicPartition);
                    if (!None$.MODULE$.equals(option)) break block2;
                    bl = false;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                LogCleaningState logCleaningState = state = (LogCleaningState)some.x();
                LogCleaningState logCleaningState2 = expectedState;
                bl = !(logCleaningState != null ? !logCleaningState.equals(logCleaningState2) : logCleaningState2 != null);
            }
            return bl;
        }
        throw new MatchError(option);
    }

    public void checkCleaningAborted(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$5;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (this.$outer.kafka$log$LogCleanerManager$$isCleaningInState(this.topicPartition$5, LogCleaningAborted$.MODULE$)) {
                    throw new LogCleaningAbortedException();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$5 = topicPartition$5;
            }
        });
    }

    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> update2) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, dataDir, update2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dataDir$1;
            private final Option update$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)this.$outer.kafka$log$LogCleanerManager$$checkpoints().apply(this.dataDir$1);
                if (checkpoint != null) {
                    try {
                        Map<TopicPartition, Object> existing = checkpoint.read().filterKeys(this.$outer.logs().keys()).$plus$plus(Option$.MODULE$.option2Iterable(this.update$1));
                        checkpoint.write(existing);
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                        this.$outer.error((Function0<String>)((Object)new scala.Serializable(this, checkpoint){
                            public static final long serialVersionUID = 0L;
                            private final OffsetCheckpointFile checkpoint$1;

                            public final String apply() {
                                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to access checkpoint file ", " in dir ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.checkpoint$1.file().getName(), this.checkpoint$1.file().getParentFile().getAbsolutePath()}));
                            }
                            {
                                this.checkpoint$1 = checkpoint$1;
                            }
                        }), (Function0<Throwable>)((Object)new scala.Serializable(this, kafkaStorageException){
                            public static final long serialVersionUID = 0L;
                            private final KafkaStorageException e$2;

                            public final KafkaStorageException apply() {
                                return this.e$2;
                            }
                            {
                                this.e$2 = e$2;
                            }
                        }));
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataDir$1 = dataDir$1;
                this.update$1 = update$1;
            }
        });
    }

    public void handleLogDirFailure(String dir) {
        this.info((Function0<String>)((Object)new scala.Serializable(this, dir){
            public static final long serialVersionUID = 0L;
            private final String dir$1;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping cleaning logs in dir ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.dir$1}));
            }
            {
                this.dir$1 = dir$1;
            }
        }));
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, dir){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            public final String dir$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$LogCleanerManager$$checkpoints_$eq(this.$outer.kafka$log$LogCleanerManager$$checkpoints().filterKeys((Function1<File, Object>)((Object)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$handleLogDirFailure$1 $outer;

                    public final boolean apply(File x$2) {
                        String string2 = x$2.getAbsolutePath();
                        String string3 = this.$outer.dir$1;
                        return string2 != null ? !string2.equals(string3) : string3 != null;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$1 = dir$1;
            }
        });
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset2) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, dataDir, topicPartition, offset2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dataDir$2;
            private final TopicPartition topicPartition$2;
            private final long offset$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map<TopicPartition, Object> existing;
                OffsetCheckpointFile checkpoint;
                if (this.$outer.logs().get(this.topicPartition$2).config().compact() && (checkpoint = (OffsetCheckpointFile)this.$outer.kafka$log$LogCleanerManager$$checkpoints().apply(this.dataDir$2)) != null && BoxesRunTime.unboxToLong((existing = checkpoint.read()).getOrElse(this.topicPartition$2, new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })) > this.offset$1) {
                    checkpoint.write(existing.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.topicPartition$2), BoxesRunTime.boxToLong(this.offset$1))));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataDir$2 = dataDir$2;
                this.topicPartition$2 = topicPartition$2;
                this.offset$1 = offset$1;
            }
        });
    }

    public void doneCleaning(TopicPartition topicPartition, File dataDir, long endOffset) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, topicPartition, dataDir, endOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$6;
            private final File dataDir$3;
            private final long endOffset$1;

            public final Object apply() {
                LogCleaningState logCleaningState;
                block4: {
                    Serializable serializable;
                    block3: {
                        block2: {
                            logCleaningState = this.$outer.kafka$log$LogCleanerManager$$inProgress().apply(this.topicPartition$6);
                            if (!LogCleaningInProgress$.MODULE$.equals(logCleaningState)) break block2;
                            this.$outer.updateCheckpoints(this.dataDir$3, Option$.MODULE$.apply(new Tuple2<TopicPartition, Long>(this.topicPartition$6, BoxesRunTime.boxToLong(this.endOffset$1))));
                            serializable = this.$outer.kafka$log$LogCleanerManager$$inProgress().remove(this.topicPartition$6);
                            break block3;
                        }
                        if (!LogCleaningAborted$.MODULE$.equals(logCleaningState)) break block4;
                        this.$outer.kafka$log$LogCleanerManager$$inProgress().put(this.topicPartition$6, LogCleaningPaused$.MODULE$);
                        this.$outer.kafka$log$LogCleanerManager$$pausedCleaningCond().signalAll();
                        serializable = BoxedUnit.UNIT;
                    }
                    return serializable;
                }
                throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"In-progress partition ", " cannot be in ", " state."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$6, logCleaningState})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$6 = topicPartition$6;
                this.dataDir$3 = dataDir$3;
                this.endOffset$1 = endOffset$1;
            }
        });
    }

    public void doneDeleting(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$7;

            public final Option<LogCleaningState> apply() {
                return this.$outer.kafka$log$LogCleanerManager$$inProgress().remove(this.topicPartition$7);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$7 = topicPartition$7;
            }
        });
    }

    public LogCleanerManager(Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.kafka$log$LogCleanerManager$$checkpoints = ((TraversableOnce)logDirs.map(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;

            public final Tuple2<File, OffsetCheckpointFile> apply(File dir) {
                return new Tuple2<File, OffsetCheckpointFile>(dir, new OffsetCheckpointFile(new File(dir, this.$outer.offsetCheckpointFile()), this.$outer.logDirFailureChannel()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.kafka$log$LogCleanerManager$$inProgress = (HashMap)HashMap$.MODULE$.apply(Nil$.MODULE$);
        this.lock = new ReentrantLock();
        this.kafka$log$LogCleanerManager$$pausedCleaningCond = this.lock().newCondition();
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = 0.0;
        this.newGauge("max-dirty-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public int value() {
                return (int)((double)100 * this.$outer.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.kafka$log$LogCleanerManager$$timeOfLastRun = Time.SYSTEM.milliseconds();
        this.newGauge("time-since-last-run-ms", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public long value() {
                return Time.SYSTEM.milliseconds() - this.$outer.kafka$log$LogCleanerManager$$timeOfLastRun();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

