/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import kafka.common.MessageFormatter;
import kafka.common.MessageFormatter$class;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.Deserializer;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0001\u0003\u0001\u001d\u0011q\u0003R3gCVdG/T3tg\u0006<WMR8s[\u0006$H/\u001a:\u000b\u0005\r!\u0011!\u0002;p_2\u001c(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!\u0001\u0004d_6lwN\\\u0005\u0003'A\u0011\u0001#T3tg\u0006<WMR8s[\u0006$H/\u001a:\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001b\u0002\u000e\u0001\u0001\u0004%\taG\u0001\taJLg\u000e^&fsV\tA\u0004\u0005\u0002\n;%\u0011aD\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d\u0001\u0003\u00011A\u0005\u0002\u0005\nA\u0002\u001d:j]R\\U-_0%KF$\"AI\u0013\u0011\u0005%\u0019\u0013B\u0001\u0013\u000b\u0005\u0011)f.\u001b;\t\u000f\u0019z\u0012\u0011!a\u00019\u0005\u0019\u0001\u0010J\u0019\t\r!\u0002\u0001\u0015)\u0003\u001d\u0003%\u0001(/\u001b8u\u0017\u0016L\b\u0005C\u0004+\u0001\u0001\u0007I\u0011A\u000e\u0002\u0015A\u0014\u0018N\u001c;WC2,X\rC\u0004-\u0001\u0001\u0007I\u0011A\u0017\u0002\u001dA\u0014\u0018N\u001c;WC2,Xm\u0018\u0013fcR\u0011!E\f\u0005\bM-\n\t\u00111\u0001\u001d\u0011\u0019\u0001\u0004\u0001)Q\u00059\u0005Y\u0001O]5oiZ\u000bG.^3!\u0011\u001d\u0011\u0004\u00011A\u0005\u0002m\ta\u0002\u001d:j]R$\u0016.\\3ti\u0006l\u0007\u000fC\u00045\u0001\u0001\u0007I\u0011A\u001b\u0002%A\u0014\u0018N\u001c;US6,7\u000f^1na~#S-\u001d\u000b\u0003EYBqAJ\u001a\u0002\u0002\u0003\u0007A\u0004\u0003\u00049\u0001\u0001\u0006K\u0001H\u0001\u0010aJLg\u000e\u001e+j[\u0016\u001cH/Y7qA!9!\b\u0001a\u0001\n\u0003Y\u0014\u0001D6fsN+\u0007/\u0019:bi>\u0014X#\u0001\u001f\u0011\u0007%it(\u0003\u0002?\u0015\t)\u0011I\u001d:bsB\u0011\u0011\u0002Q\u0005\u0003\u0003*\u0011AAQ=uK\"91\t\u0001a\u0001\n\u0003!\u0015\u0001E6fsN+\u0007/\u0019:bi>\u0014x\fJ3r)\t\u0011S\tC\u0004'\u0005\u0006\u0005\t\u0019\u0001\u001f\t\r\u001d\u0003\u0001\u0015)\u0003=\u00035YW-_*fa\u0006\u0014\u0018\r^8sA!9\u0011\n\u0001a\u0001\n\u0003Y\u0014!\u00047j]\u0016\u001cV\r]1sCR|'\u000fC\u0004L\u0001\u0001\u0007I\u0011\u0001'\u0002#1Lg.Z*fa\u0006\u0014\u0018\r^8s?\u0012*\u0017\u000f\u0006\u0002#\u001b\"9aESA\u0001\u0002\u0004a\u0004BB(\u0001A\u0003&A(\u0001\bmS:,7+\u001a9be\u0006$xN\u001d\u0011\t\u000fE\u0003\u0001\u0019!C\u0001%\u0006y1.Z=EKN,'/[1mSj,'/F\u0001T!\rIAKV\u0005\u0003+*\u0011aa\u00149uS>t\u0007GA,f!\rA\u0016mY\u0007\u00023*\u0011!lW\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005Ea&BA\u0003^\u0015\tqv,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0006\u0019qN]4\n\u0005\tL&\u0001\u0004#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\bC\u00013f\u0019\u0001!\u0011BZ4\u0002\u0002\u0003\u0005)\u0011\u00018\u0003\u0007}#\u0013\u0007\u0003\u0004i\u0001\u0001\u0006K![\u0001\u0011W\u0016LH)Z:fe&\fG.\u001b>fe\u0002\u00022!\u0003+ka\tYW\u000eE\u0002YC2\u0004\"\u0001Z7\u0005\u0013\u0019<\u0017\u0011!A\u0001\u0006\u0003q\u0017CA8s!\tI\u0001/\u0003\u0002r\u0015\t9aj\u001c;iS:<\u0007CA\u0005t\u0013\t!(BA\u0002B]fDqA\u001e\u0001A\u0002\u0013\u0005q/A\nlKf$Um]3sS\u0006d\u0017N_3s?\u0012*\u0017\u000f\u0006\u0002#q\"9a%^A\u0001\u0002\u0004I\bcA\u0005UuB\u001210 \t\u00041\u0006d\bC\u00013~\t%1w-!A\u0001\u0002\u000b\u0005a\u000e\u0003\u0005\u0000\u0001\u0001\u0007I\u0011AA\u0001\u0003E1\u0018\r\\;f\t\u0016\u001cXM]5bY&TXM]\u000b\u0003\u0003\u0007\u0001B!\u0003+\u0002\u0006A\"\u0011qAA\u0006!\u0011A\u0016-!\u0003\u0011\u0007\u0011\fY\u0001B\u0006\u0002\u000e\u0005=\u0011\u0011!A\u0001\u0006\u0003q'aA0%e!A\u0011\u0011\u0003\u0001!B\u0013\t\u0019\"\u0001\nwC2,X\rR3tKJL\u0017\r\\5{KJ\u0004\u0003\u0003B\u0005U\u0003+\u0001D!a\u0006\u0002\u001cA!\u0001,YA\r!\r!\u00171\u0004\u0003\f\u0003\u001b\ty!!A\u0001\u0002\u000b\u0005a\u000eC\u0005\u0002 \u0001\u0001\r\u0011\"\u0001\u0002\"\u0005)b/\u00197vK\u0012+7/\u001a:jC2L'0\u001a:`I\u0015\fHc\u0001\u0012\u0002$!Ia%!\b\u0002\u0002\u0003\u0007\u0011Q\u0005\t\u0005\u0013Q\u000b9\u0003\r\u0003\u0002*\u00055\u0002\u0003\u0002-b\u0003W\u00012\u0001ZA\u0017\t-\ti!a\u0004\u0002\u0002\u0003\u0005)\u0011\u00018\t\u000f\u0005E\u0002\u0001\"\u0011\u00024\u0005!\u0011N\\5u)\r\u0011\u0013Q\u0007\u0005\t\u0003o\ty\u00031\u0001\u0002:\u0005)\u0001O]8qgB!\u00111HA#\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013\u0001B;uS2T!!a\u0011\u0002\t)\fg/Y\u0005\u0005\u0003\u000f\niD\u0001\u0006Qe>\u0004XM\u001d;jKNDq!a\u0013\u0001\t\u0003\ti%A\u0004xe&$X\rV8\u0015\u000b\t\ny%a\u0019\t\u0011\u0005E\u0013\u0011\na\u0001\u0003'\nabY8ogVlWM\u001d*fG>\u0014H\r\u0005\u0004\u0002V\u0005}C\bP\u0007\u0003\u0003/RA!!\u0017\u0002\\\u0005A1m\u001c8tk6,'OC\u0002\u0002^q\u000bqa\u00197jK:$8/\u0003\u0003\u0002b\u0005]#AD\"p]N,X.\u001a:SK\u000e|'\u000f\u001a\u0005\t\u0003K\nI\u00051\u0001\u0002h\u00051q.\u001e;qkR\u0004B!!\u001b\u0002p5\u0011\u00111\u000e\u0006\u0005\u0003[\n\t%\u0001\u0002j_&!\u0011\u0011OA6\u0005-\u0001&/\u001b8u'R\u0014X-Y7")
public class DefaultMessageFormatter
implements MessageFormatter {
    private boolean printKey;
    private boolean printValue;
    private boolean printTimestamp;
    private byte[] keySeparator;
    private byte[] lineSeparator;
    private Option<Deserializer<?>> keyDeserializer;
    private Option<Deserializer<?>> valueDeserializer;

    @Override
    public void close() {
        MessageFormatter$class.close(this);
    }

    public boolean printKey() {
        return this.printKey;
    }

    public void printKey_$eq(boolean x$1) {
        this.printKey = x$1;
    }

    public boolean printValue() {
        return this.printValue;
    }

    public void printValue_$eq(boolean x$1) {
        this.printValue = x$1;
    }

    public boolean printTimestamp() {
        return this.printTimestamp;
    }

    public void printTimestamp_$eq(boolean x$1) {
        this.printTimestamp = x$1;
    }

    public byte[] keySeparator() {
        return this.keySeparator;
    }

    public void keySeparator_$eq(byte[] x$1) {
        this.keySeparator = x$1;
    }

    public byte[] lineSeparator() {
        return this.lineSeparator;
    }

    public void lineSeparator_$eq(byte[] x$1) {
        this.lineSeparator = x$1;
    }

    public Option<Deserializer<?>> keyDeserializer() {
        return this.keyDeserializer;
    }

    public void keyDeserializer_$eq(Option<Deserializer<?>> x$1) {
        this.keyDeserializer = x$1;
    }

    public Option<Deserializer<?>> valueDeserializer() {
        return this.valueDeserializer;
    }

    public void valueDeserializer_$eq(Option<Deserializer<?>> x$1) {
        this.valueDeserializer = x$1;
    }

    @Override
    public void init(Properties props) {
        if (props.containsKey("print.timestamp")) {
            this.printTimestamp_$eq(props.getProperty("print.timestamp").trim().equalsIgnoreCase("true"));
        }
        if (props.containsKey("print.key")) {
            this.printKey_$eq(props.getProperty("print.key").trim().equalsIgnoreCase("true"));
        }
        if (props.containsKey("print.value")) {
            this.printValue_$eq(props.getProperty("print.value").trim().equalsIgnoreCase("true"));
        }
        if (props.containsKey("key.separator")) {
            this.keySeparator_$eq(props.getProperty("key.separator").getBytes(StandardCharsets.UTF_8));
        }
        if (props.containsKey("line.separator")) {
            this.lineSeparator_$eq(props.getProperty("line.separator").getBytes(StandardCharsets.UTF_8));
        }
        if (props.containsKey("key.deserializer")) {
            this.keyDeserializer_$eq(new Some((Deserializer)Class.forName(props.getProperty("key.deserializer")).newInstance()));
        }
        if (props.containsKey("value.deserializer")) {
            this.valueDeserializer_$eq(new Some((Deserializer)Class.forName(props.getProperty("value.deserializer")).newInstance()));
        }
    }

    @Override
    public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
        if (this.printTimestamp()) {
            TimestampType timestampType = consumerRecord.timestampType();
            TimestampType timestampType2 = TimestampType.NO_TIMESTAMP_TYPE;
            if (!(timestampType != null ? !((Object)((Object)timestampType)).equals((Object)timestampType2) : timestampType2 != null)) {
                output.write(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NO_TIMESTAMP"})).s(Nil$.MODULE$).getBytes(StandardCharsets.UTF_8));
            } else {
                output.write(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{consumerRecord.timestampType(), BoxesRunTime.boxToLong(consumerRecord.timestamp())})).getBytes(StandardCharsets.UTF_8));
            }
            this.writeSeparator$1(this.printKey() || this.printValue(), output);
        }
        if (this.printKey()) {
            this.write$1(this.keyDeserializer(), consumerRecord.key(), output);
            this.writeSeparator$1(this.printValue(), output);
        }
        if (this.printValue()) {
            this.write$1(this.valueDeserializer(), consumerRecord.value(), output);
            output.write(this.lineSeparator());
        }
    }

    private final void writeSeparator$1(boolean columnSeparator, PrintStream output$1) {
        if (columnSeparator) {
            output$1.write(this.keySeparator());
        } else {
            output$1.write(this.lineSeparator());
        }
    }

    private final void write$1(Option deserializer, byte[] sourceBytes, PrintStream output$1) {
        byte[] nonNullBytes = Option$.MODULE$.apply(sourceBytes).getOrElse(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte[] apply() {
                return "null".getBytes(StandardCharsets.UTF_8);
            }
        });
        byte[] convertedBytes = deserializer.map(new Serializable(this, nonNullBytes){
            public static final long serialVersionUID = 0L;
            private final byte[] nonNullBytes$1;

            public final byte[] apply(Deserializer<?> x$2) {
                return x$2.deserialize(null, this.nonNullBytes$1).toString().getBytes(StandardCharsets.UTF_8);
            }
            {
                this.nonNullBytes$1 = nonNullBytes$1;
            }
        }).getOrElse(new Serializable(this, nonNullBytes){
            public static final long serialVersionUID = 0L;
            private final byte[] nonNullBytes$1;

            public final byte[] apply() {
                return this.nonNullBytes$1;
            }
            {
                this.nonNullBytes$1 = nonNullBytes$1;
            }
        });
        output$1.write(convertedBytes);
    }

    public DefaultMessageFormatter() {
        MessageFormatter$class.$init$(this);
        this.printKey = false;
        this.printValue = true;
        this.printTimestamp = false;
        this.keySeparator = "\t".getBytes(StandardCharsets.UTF_8);
        this.lineSeparator = "\n".getBytes(StandardCharsets.UTF_8);
        this.keyDeserializer = None$.MODULE$;
        this.valueDeserializer = None$.MODULE$;
    }
}

