/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.log.AbortedTxn;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.log.ProducerIdEntry;
import kafka.log.ProducerStateManager$;
import kafka.log.TimeIndex;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.log.TransactionIndex;
import kafka.serializer.Decoder;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$$anonfun$kafka$tools$DumpLogSegments$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.Record;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcV$sp;
import scala.runtime.RichInt$;

public final class DumpLogSegments$ {
    public static final DumpLogSegments$ MODULE$;

    static {
        new DumpLogSegments$();
    }

    public void main(String[] args) {
        DumpLogSegments.MessageParser<String, String> messageParser;
        OptionParser parser = new OptionParser(false);
        OptionSpecBuilder printOpt = parser.accepts("print-data-log", "if set, printing the messages content when dumping data logs. Automatically set if any decoder option is specified.");
        OptionSpecBuilder verifyOpt = parser.accepts("verify-index-only", "if set, just verify the index log without printing its content.");
        OptionSpecBuilder indexSanityOpt = parser.accepts("index-sanity-check", "if set, just checks the index sanity without printing its content. This is the same check that is executed on broker startup to determine if an index needs rebuilding or not.");
        ArgumentAcceptingOptionSpec<String> filesOpt = parser.accepts("files", "REQUIRED: The comma separated list of data and index log files to be dumped.").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
        ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt = parser.accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(0x500000), (Integer[])((Object[])new Integer[0]));
        OptionSpecBuilder deepIterationOpt = parser.accepts("deep-iteration", "if set, uses deep instead of shallow iteration.");
        ArgumentAcceptingOptionSpec<String> valueDecoderOpt = parser.accepts("value-decoder-class", "if set, used to deserialize the messages. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo("kafka.serializer.StringDecoder", (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<String> keyDecoderOpt = parser.accepts("key-decoder-class", "if set, used to deserialize the keys. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo("kafka.serializer.StringDecoder", (String[])((Object[])new String[0]));
        OptionSpecBuilder offsetsOpt = parser.accepts("offsets-decoder", "if set, log data will be parsed as offset data from the __consumer_offsets topic.");
        OptionSpecBuilder transactionLogOpt = parser.accepts("transaction-log-decoder", "if set, log data will be parsed as transaction metadata from the __transaction_state topic.");
        OptionSpecBuilder helpOpt = parser.accepts("help", "Print usage information.");
        OptionSet options = parser.parse(args);
        if (args.length == 0 || options.has(helpOpt)) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Parse a log file and dump its contents to the console, useful for debugging a seemingly corrupt log segment.");
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{filesOpt}));
        boolean printDataLog = options.has(printOpt) || options.has(offsetsOpt) || options.has(transactionLogOpt) || options.has(valueDecoderOpt) || options.has(keyDecoderOpt);
        boolean verifyOnly = options.has(verifyOpt);
        boolean indexSanityOnly = options.has(indexSanityOpt);
        String[] files = options.valueOf(filesOpt).split(",");
        int maxMessageSize = options.valueOf(maxMessageSizeOpt);
        boolean isDeepIteration = options.has(deepIterationOpt);
        if (options.has(offsetsOpt)) {
            messageParser = new DumpLogSegments.OffsetsMessageParser();
        } else if (options.has(transactionLogOpt)) {
            messageParser = new DumpLogSegments.TransactionLogMessageParser();
        } else {
            Decoder valueDecoder = (Decoder)CoreUtils$.MODULE$.createObject(options.valueOf(valueDecoderOpt), Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            Decoder keyDecoder = (Decoder)CoreUtils$.MODULE$.createObject(options.valueOf(keyDecoderOpt), Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            messageParser = new DumpLogSegments.DecoderMessageParser(keyDecoder, valueDecoder);
        }
        DumpLogSegments.OffsetsMessageParser messageParser2 = messageParser;
        HashMap<String, List<Tuple2<Object, Object>>> misMatchesForIndexFilesMap = new HashMap<String, List<Tuple2<Object, Object>>>();
        DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors = new DumpLogSegments.TimeIndexDumpErrors();
        HashMap<String, List<Tuple2<Object, Object>>> nonConsecutivePairsForLogFilesMap = new HashMap<String, List<Tuple2<Object, Object>>>();
        Predef$.MODULE$.refArrayOps((Object[])files).foreach(new scala.Serializable(printDataLog, verifyOnly, indexSanityOnly, maxMessageSize, isDeepIteration, messageParser2, misMatchesForIndexFilesMap, timeIndexDumpErrors, nonConsecutivePairsForLogFilesMap){
            public static final long serialVersionUID = 0L;
            private final boolean printDataLog$1;
            private final boolean verifyOnly$1;
            private final boolean indexSanityOnly$1;
            private final int maxMessageSize$1;
            private final boolean isDeepIteration$1;
            private final DumpLogSegments.MessageParser messageParser$1;
            private final HashMap misMatchesForIndexFilesMap$1;
            private final DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$1;
            private final HashMap nonConsecutivePairsForLogFilesMap$1;

            public final void apply(String arg) {
                String suffix;
                File file = new File(arg);
                Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dumping ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{file})));
                String filename = file.getName();
                String string2 = suffix = filename.substring(filename.lastIndexOf("."));
                String string3 = Log$.MODULE$.LogFileSuffix();
                String string4 = string2;
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpLog(file, this.printDataLog$1, this.nonConsecutivePairsForLogFilesMap$1, this.isDeepIteration$1, this.maxMessageSize$1, this.messageParser$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string5 = Log$.MODULE$.IndexFileSuffix();
                    String string6 = string2;
                    if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                        DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpIndex(file, this.indexSanityOnly$1, this.verifyOnly$1, this.misMatchesForIndexFilesMap$1, this.maxMessageSize$1);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String string7 = Log$.MODULE$.TimeIndexFileSuffix();
                        String string8 = string2;
                        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                            DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpTimeIndex(file, this.indexSanityOnly$1, this.verifyOnly$1, this.timeIndexDumpErrors$1, this.maxMessageSize$1);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            String string9 = Log$.MODULE$.ProducerSnapshotFileSuffix();
                            String string10 = string2;
                            if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                                DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpProducerIdSnapshot(file);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                String string11 = Log$.MODULE$.TxnIndexFileSuffix();
                                String string12 = string2;
                                if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
                                    DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpTxnIndex(file);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    System.err.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignoring unknown file ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{file})));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                            }
                        }
                    }
                }
            }
            {
                this.printDataLog$1 = printDataLog$1;
                this.verifyOnly$1 = verifyOnly$1;
                this.indexSanityOnly$1 = indexSanityOnly$1;
                this.maxMessageSize$1 = maxMessageSize$1;
                this.isDeepIteration$1 = isDeepIteration$1;
                this.messageParser$1 = messageParser$1;
                this.misMatchesForIndexFilesMap$1 = misMatchesForIndexFilesMap$1;
                this.timeIndexDumpErrors$1 = timeIndexDumpErrors$1;
                this.nonConsecutivePairsForLogFilesMap$1 = nonConsecutivePairsForLogFilesMap$1;
            }
        });
        misMatchesForIndexFilesMap.foreach(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, List<Tuple2<Object, Object>>> x0$1) {
                Tuple2<String, List<Tuple2<Object, Object>>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String fileName = tuple2._1();
                    List<Tuple2<Object, Object>> listOfMismatches = tuple2._2();
                    System.err.println(new StringBuilder().append((Object)"Mismatches in :").append((Object)fileName).toString());
                    listOfMismatches.foreach(new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<Object, Object> m) {
                            System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index offset: %d, log offset: %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(m._1$mcJ$sp()), BoxesRunTime.boxToLong(m._2$mcJ$sp())})));
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        timeIndexDumpErrors.printErrors();
        nonConsecutivePairsForLogFilesMap.foreach(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, List<Tuple2<Object, Object>>> x0$2) {
                Tuple2<String, List<Tuple2<Object, Object>>> tuple2 = x0$2;
                if (tuple2 != null) {
                    String fileName = tuple2._1();
                    List<Tuple2<Object, Object>> listOfNonConsecutivePairs = tuple2._2();
                    System.err.println(new StringBuilder().append((Object)"Non-consecutive offsets in :").append((Object)fileName).toString());
                    listOfNonConsecutivePairs.foreach(new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<Object, Object> m) {
                            System.err.println(new StringOps(Predef$.MODULE$.augmentString("  %d is followed by %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(m._1$mcJ$sp()), BoxesRunTime.boxToLong(m._2$mcJ$sp())})));
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public void kafka$tools$DumpLogSegments$$dumpTxnIndex(File file) {
        TransactionIndex index = new TransactionIndex(Log$.MODULE$.offsetFromFile(file), file);
        index.allAbortedTxns().foreach(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(AbortedTxn abortedTxn) {
                Predef$.MODULE$.println(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"version: ", " producerId: ", " firstOffset: ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToShort(abortedTxn.version()), BoxesRunTime.boxToLong(abortedTxn.producerId()), BoxesRunTime.boxToLong(abortedTxn.firstOffset())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lastOffset: ", " lastStableOffset: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(abortedTxn.lastOffset()), BoxesRunTime.boxToLong(abortedTxn.lastStableOffset())}))).toString());
            }
        });
    }

    public void kafka$tools$DumpLogSegments$$dumpProducerIdSnapshot(File file) {
        try {
            ProducerStateManager$.MODULE$.readSnapshot(file).foreach(new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(ProducerIdEntry entry2) {
                    Predef$.MODULE$.println(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerId: ", " producerEpoch: ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(entry2.producerId()), BoxesRunTime.boxToShort(entry2.producerEpoch())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coordinatorEpoch: ", " currentTxnFirstOffset: ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(entry2.coordinatorEpoch()), entry2.currentTxnFirstOffset()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cachedMetadata: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{entry2.batchMetadata()}))).toString());
                }
            });
        }
        catch (CorruptSnapshotException corruptSnapshotException) {
            System.err.println(corruptSnapshotException.getMessage());
        }
    }

    public void kafka$tools$DumpLogSegments$$dumpIndex(File file, boolean indexSanityOnly, boolean verifyOnly, HashMap<String, List<Tuple2<Object, Object>>> misMatchesForIndexFilesMap, int maxMessageSize) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            Object object = new Object();
            try {
                long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
                File logFile = new File(file.getAbsoluteFile().getParent(), new StringBuilder().append((Object)file.getName().split("\\.")[0]).append((Object)Log$.MODULE$.LogFileSuffix()).toString());
                FileRecords fileRecords = FileRecords.open(logFile, false);
                File x$4 = file;
                long x$5 = startOffset;
                boolean x$6 = false;
                int x$7 = OffsetIndex$.MODULE$.$lessinit$greater$default$3();
                OffsetIndex index = new OffsetIndex(x$4, x$5, x$7, x$6);
                if (indexSanityOnly) {
                    index.sanityCheck();
                    Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " passed sanity check."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{file})));
                    return;
                }
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), index.entries()).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new scala.Serializable(file, verifyOnly, misMatchesForIndexFilesMap, maxMessageSize, fileRecords, index, object){
                    public static final long serialVersionUID = 0L;
                    private final File file$2;
                    private final boolean verifyOnly$2;
                    private final HashMap misMatchesForIndexFilesMap$2;
                    private final int maxMessageSize$2;
                    private final FileRecords fileRecords$1;
                    private final OffsetIndex index$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        Serializable serializable;
                        OffsetPosition entry2 = this.index$1.entry(i);
                        FileRecords slice2 = this.fileRecords$1.read(entry2.position(), this.maxMessageSize$2);
                        Record firstRecord = slice2.records().iterator().next();
                        if (firstRecord.offset() != entry2.offset() + this.index$1.baseOffset()) {
                            List<Tuple2<Object, Object>> misMatchesSeq = this.misMatchesForIndexFilesMap$2.getOrElse(this.file$2.getAbsolutePath(), new scala.Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final List<Tuple2<Object, Object>> apply() {
                                    return Nil$.MODULE$;
                                }
                            });
                            misMatchesSeq = misMatchesSeq.$colon$colon(new Tuple2$mcJJ$sp(entry2.offset() + this.index$1.baseOffset(), firstRecord.offset()));
                            serializable = this.misMatchesForIndexFilesMap$2.put(this.file$2.getAbsolutePath(), misMatchesSeq);
                        } else {
                            serializable = BoxedUnit.UNIT;
                        }
                        if (entry2.offset() == 0L && i > 0) {
                            throw new NonLocalReturnControl$mcV$sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                        if (!this.verifyOnly$2) {
                            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("offset: %d position: %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(entry2.offset() + this.index$1.baseOffset()), BoxesRunTime.boxToInteger(entry2.position())})));
                        }
                    }
                    {
                        this.file$2 = file$2;
                        this.verifyOnly$2 = verifyOnly$2;
                        this.misMatchesForIndexFilesMap$2 = misMatchesForIndexFilesMap$2;
                        this.maxMessageSize$2 = maxMessageSize$2;
                        this.fileRecords$1 = fileRecords$1;
                        this.index$1 = index$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                }));
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public void kafka$tools$DumpLogSegments$$dumpTimeIndex(File file, boolean indexSanityOnly, boolean verifyOnly, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors, int maxMessageSize) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            Object object = new Object();
            try {
                File indexFile;
                long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
                File logFile = new File(file.getAbsoluteFile().getParent(), new StringBuilder().append((Object)file.getName().split("\\.")[0]).append((Object)Log$.MODULE$.LogFileSuffix()).toString());
                FileRecords fileRecords = FileRecords.open(logFile, false);
                File x$8 = indexFile = new File(file.getAbsoluteFile().getParent(), new StringBuilder().append((Object)file.getName().split("\\.")[0]).append((Object)Log$.MODULE$.IndexFileSuffix()).toString());
                long x$9 = startOffset;
                boolean x$10 = false;
                int x$11 = OffsetIndex$.MODULE$.$lessinit$greater$default$3();
                OffsetIndex index = new OffsetIndex(x$8, x$9, x$11, x$10);
                File x$12 = file;
                long x$13 = startOffset;
                boolean x$14 = false;
                int x$15 = TimeIndex$.MODULE$.$lessinit$greater$default$3();
                TimeIndex timeIndex = new TimeIndex(x$12, x$13, x$15, x$14);
                if (indexSanityOnly) {
                    timeIndex.sanityCheck();
                    Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " passed sanity check."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{file})));
                    return;
                }
                LongRef prevTimestamp = LongRef.create(-1L);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), timeIndex.entries()).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new scala.Serializable(file, verifyOnly, timeIndexDumpErrors, fileRecords, index, timeIndex, prevTimestamp, object){
                    public static final long serialVersionUID = 0L;
                    private final File file$3;
                    private final boolean verifyOnly$3;
                    private final DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$2;
                    private final FileRecords fileRecords$2;
                    private final OffsetIndex index$2;
                    public final TimeIndex timeIndex$1;
                    private final LongRef prevTimestamp$1;
                    private final Object nonLocalReturnKey2$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        Option<FileLogInputStream.FileChannelRecordBatch> option;
                        block10: {
                            TimestampOffset entry2;
                            block8: {
                                Some some;
                                boolean bl;
                                LongRef maxTimestamp;
                                block9: {
                                    block7: {
                                        entry2 = this.timeIndex$1.entry(i);
                                        int position = this.index$2.lookup(entry2.offset() + this.timeIndex$1.baseOffset()).position();
                                        FileRecords partialFileRecords = this.fileRecords$2.read(position, Integer.MAX_VALUE);
                                        Iterable<FileLogInputStream.FileChannelRecordBatch> batches = JavaConverters$.MODULE$.iterableAsScalaIterableConverter(partialFileRecords.batches()).asScala();
                                        maxTimestamp = LongRef.create(-1L);
                                        bl = false;
                                        some = null;
                                        option = batches.find((Function1<FileLogInputStream.FileChannelRecordBatch, Object>)((Object)new scala.Serializable(this, entry2){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ anonfun$kafka$tools$DumpLogSegments$$dumpTimeIndex$1 $outer;
                                            private final TimestampOffset entry$1;

                                            public final boolean apply(FileLogInputStream.FileChannelRecordBatch x$1) {
                                                return x$1.lastOffset() >= this.entry$1.offset() + this.$outer.timeIndex$1.baseOffset();
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.entry$1 = entry$1;
                                            }
                                        }));
                                        if (!None$.MODULE$.equals(option)) break block7;
                                        this.timeIndexDumpErrors$2.recordShallowOffsetNotFound(this.file$3, entry2.offset() + this.timeIndex$1.baseOffset(), -1);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block8;
                                    }
                                    if (!(option instanceof Some)) break block9;
                                    bl = true;
                                    some = (Some)option;
                                    FileLogInputStream.FileChannelRecordBatch batch = (FileLogInputStream.FileChannelRecordBatch)some.x();
                                    if (batch.lastOffset() == entry2.offset() + this.timeIndex$1.baseOffset()) break block9;
                                    this.timeIndexDumpErrors$2.recordShallowOffsetNotFound(this.file$3, entry2.offset() + this.timeIndex$1.baseOffset(), batch.lastOffset());
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block8;
                                }
                                if (!bl) break block10;
                                FileLogInputStream.FileChannelRecordBatch batch = (FileLogInputStream.FileChannelRecordBatch)some.x();
                                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(batch).asScala()).foreach(new scala.Serializable(this, maxTimestamp){
                                    public static final long serialVersionUID = 0L;
                                    private final LongRef maxTimestamp$1;

                                    public final void apply(Record record2) {
                                        this.maxTimestamp$1.elem = package$.MODULE$.max(this.maxTimestamp$1.elem, record2.timestamp());
                                    }
                                    {
                                        this.maxTimestamp$1 = maxTimestamp$1;
                                    }
                                });
                                if (maxTimestamp.elem != entry2.timestamp()) {
                                    this.timeIndexDumpErrors$2.recordMismatchTimeIndex(this.file$3, entry2.timestamp(), maxTimestamp.elem);
                                }
                                if (this.prevTimestamp$1.elem >= entry2.timestamp()) {
                                    this.timeIndexDumpErrors$2.recordOutOfOrderIndexTimestamp(this.file$3, entry2.timestamp(), this.prevTimestamp$1.elem);
                                }
                                if (entry2.offset() == 0L && i > 0) {
                                    throw new NonLocalReturnControl$mcV$sp(this.nonLocalReturnKey2$1, BoxedUnit.UNIT);
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            if (!this.verifyOnly$3) {
                                Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("timestamp: %s offset: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(entry2.timestamp()), BoxesRunTime.boxToLong(this.timeIndex$1.baseOffset() + entry2.offset())})));
                            }
                            this.prevTimestamp$1.elem = entry2.timestamp();
                            return;
                        }
                        throw new MatchError(option);
                    }
                    {
                        this.file$3 = file$3;
                        this.verifyOnly$3 = verifyOnly$3;
                        this.timeIndexDumpErrors$2 = timeIndexDumpErrors$2;
                        this.fileRecords$2 = fileRecords$2;
                        this.index$2 = index$2;
                        this.timeIndex$1 = timeIndex$1;
                        this.prevTimestamp$1 = prevTimestamp$1;
                        this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                    }
                }));
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public void kafka$tools$DumpLogSegments$$dumpLog(File file, boolean printContents, HashMap<String, List<Tuple2<Object, Object>>> nonConsecutivePairsForLogFilesMap, boolean isDeepIteration, int maxMessageSize, DumpLogSegments.MessageParser<?, ?> parser) {
        long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
        Predef$.MODULE$.println(new StringBuilder().append((Object)"Starting offset: ").append(BoxesRunTime.boxToLong(startOffset)).toString());
        FileRecords messageSet = FileRecords.open(file, false);
        LongRef validBytes = LongRef.create(0L);
        LongRef lastOffset = LongRef.create(-1L);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(messageSet.batches()).asScala()).foreach(new scala.Serializable(file, printContents, nonConsecutivePairsForLogFilesMap, isDeepIteration, parser, validBytes, lastOffset){
            public static final long serialVersionUID = 0L;
            public final File file$1;
            public final boolean printContents$1;
            public final HashMap nonConsecutivePairsForLogFilesMap$2;
            private final boolean isDeepIteration$2;
            public final DumpLogSegments.MessageParser parser$1;
            public final LongRef validBytes$1;
            public final LongRef lastOffset$1;

            public final void apply(FileLogInputStream.FileChannelRecordBatch batch) {
                if (this.isDeepIteration$2) {
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(batch).asScala()).foreach(new scala.Serializable(this, batch){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun$kafka$tools$DumpLogSegments$$dumpLog$1 $outer;
                        private final FileLogInputStream.FileChannelRecordBatch batch$1;

                        public final void apply(Record record2) {
                            Serializable serializable;
                            if (this.$outer.lastOffset$1.elem == -1L) {
                                this.$outer.lastOffset$1.elem = record2.offset();
                                serializable = BoxedUnit.UNIT;
                            } else if (record2.offset() != this.$outer.lastOffset$1.elem + 1L) {
                                List<Tuple2<Object, Object>> nonConsecutivePairsSeq = this.$outer.nonConsecutivePairsForLogFilesMap$2.getOrElse(this.$outer.file$1.getAbsolutePath(), new scala.Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final List<Tuple2<Object, Object>> apply() {
                                        return Nil$.MODULE$;
                                    }
                                });
                                nonConsecutivePairsSeq = nonConsecutivePairsSeq.$colon$colon(new Tuple2$mcJJ$sp(this.$outer.lastOffset$1.elem, record2.offset()));
                                serializable = this.$outer.nonConsecutivePairsForLogFilesMap$2.put(this.$outer.file$1.getAbsolutePath(), nonConsecutivePairsSeq);
                            } else {
                                serializable = BoxedUnit.UNIT;
                            }
                            this.$outer.lastOffset$1.elem = record2.offset();
                            Predef$.MODULE$.print(new StringBuilder().append((Object)"offset: ").append(BoxesRunTime.boxToLong(record2.offset())).append((Object)" position: ").append(BoxesRunTime.boxToLong(this.$outer.validBytes$1.elem)).append((Object)" ").append((Object)((Object)this.batch$1.timestampType())).append((Object)": ").append(BoxesRunTime.boxToLong(record2.timestamp())).append((Object)" isvalid: ").append(BoxesRunTime.boxToBoolean(record2.isValid())).append((Object)" keysize: ").append(BoxesRunTime.boxToInteger(record2.keySize())).append((Object)" valuesize: ").append(BoxesRunTime.boxToInteger(record2.valueSize())).append((Object)" magic: ").append(BoxesRunTime.boxToByte(this.batch$1.magic())).append((Object)" compresscodec: ").append((Object)((Object)this.batch$1.compressionType())).toString());
                            if (this.batch$1.magic() >= 2) {
                                Predef$.MODULE$.print(new StringBuilder().append((Object)" producerId: ").append(BoxesRunTime.boxToLong(this.batch$1.producerId())).append((Object)" producerEpoch: ").append(BoxesRunTime.boxToShort(this.batch$1.producerEpoch())).append((Object)" sequence: ").append(BoxesRunTime.boxToInteger(record2.sequence())).append((Object)" isTransactional: ").append(BoxesRunTime.boxToBoolean(this.batch$1.isTransactional())).append((Object)" headerKeys: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])record2.headers()).map(new scala.Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(Header x$2) {
                                        return x$2.key();
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("[", ",", "]")).toString());
                            } else {
                                Predef$.MODULE$.print(new StringBuilder().append((Object)" crc: ").append(record2.checksumOrNull()).toString());
                            }
                            if (this.batch$1.isControlBatch()) {
                                short controlTypeId = ControlRecordType.parseTypeId(record2.key());
                                ControlRecordType controlRecordType = ControlRecordType.fromTypeId(controlTypeId);
                                boolean bl = ((Object)((Object)ControlRecordType.ABORT)).equals((Object)((Object)controlRecordType)) ? true : ((Object)((Object)ControlRecordType.COMMIT)).equals((Object)((Object)controlRecordType));
                                if (bl) {
                                    EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize(record2);
                                    Predef$.MODULE$.print(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" endTxnMarker: ", " coordinatorEpoch: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{endTxnMarker.controlType(), BoxesRunTime.boxToInteger(endTxnMarker.coordinatorEpoch())})));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    Predef$.MODULE$.print(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" controlType: ", "(", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{controlRecordType, BoxesRunTime.boxToShort(controlTypeId)})));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                            } else if (this.$outer.printContents$1) {
                                Tuple2<Option<K>, Option<V>> tuple2 = this.$outer.parser$1.parse(record2);
                                if (tuple2 != null) {
                                    Tuple2<Option<K>, Option<V>> tuple22;
                                    Option<K> key = tuple2._1();
                                    Option<V> payload = tuple2._2();
                                    Tuple2<Option<K>, Option<V>> tuple23 = tuple22 = new Tuple2<Option<K>, Option<V>>(key, payload);
                                    Option<K> key2 = tuple23._1();
                                    Option<V> payload2 = tuple23._2();
                                    key2.foreach(new scala.Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final void apply(Object key) {
                                            Predef$.MODULE$.print(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" key: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{key})));
                                        }
                                    });
                                    payload2.foreach(new scala.Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final void apply(Object payload) {
                                            Predef$.MODULE$.print(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" payload: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{payload})));
                                        }
                                    });
                                } else {
                                    throw new MatchError(tuple2);
                                }
                            }
                            Predef$.MODULE$.println();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.batch$1 = batch$1;
                        }
                    });
                } else {
                    if (batch.magic() >= 2) {
                        Predef$.MODULE$.print(new StringBuilder().append((Object)"baseOffset: ").append(BoxesRunTime.boxToLong(batch.baseOffset())).append((Object)" lastOffset: ").append(BoxesRunTime.boxToLong(batch.lastOffset())).append((Object)" baseSequence: ").append(BoxesRunTime.boxToInteger(batch.baseSequence())).append((Object)" lastSequence: ").append(BoxesRunTime.boxToInteger(batch.lastSequence())).append((Object)" producerId: ").append(BoxesRunTime.boxToLong(batch.producerId())).append((Object)" producerEpoch: ").append(BoxesRunTime.boxToShort(batch.producerEpoch())).append((Object)" partitionLeaderEpoch: ").append(BoxesRunTime.boxToInteger(batch.partitionLeaderEpoch())).append((Object)" isTransactional: ").append(BoxesRunTime.boxToBoolean(batch.isTransactional())).toString());
                    } else {
                        Predef$.MODULE$.print(new StringBuilder().append((Object)"offset: ").append(BoxesRunTime.boxToLong(batch.lastOffset())).toString());
                    }
                    Predef$.MODULE$.println(new StringBuilder().append((Object)" position: ").append(BoxesRunTime.boxToLong(this.validBytes$1.elem)).append((Object)" ").append((Object)((Object)batch.timestampType())).append((Object)": ").append(BoxesRunTime.boxToLong(batch.maxTimestamp())).append((Object)" isvalid: ").append(BoxesRunTime.boxToBoolean(batch.isValid())).append((Object)" size: ").append(BoxesRunTime.boxToInteger(batch.sizeInBytes())).append((Object)" magic: ").append(BoxesRunTime.boxToByte(batch.magic())).append((Object)" compresscodec: ").append((Object)((Object)batch.compressionType())).append((Object)" crc: ").append(BoxesRunTime.boxToLong(batch.checksum())).toString());
                }
                this.validBytes$1.elem += (long)batch.sizeInBytes();
            }
            {
                this.file$1 = file$1;
                this.printContents$1 = printContents$1;
                this.nonConsecutivePairsForLogFilesMap$2 = nonConsecutivePairsForLogFilesMap$2;
                this.isDeepIteration$2 = isDeepIteration$2;
                this.parser$1 = parser$1;
                this.validBytes$1 = validBytes$1;
                this.lastOffset$1 = lastOffset$1;
            }
        });
        long trailingBytes = (long)messageSet.sizeInBytes() - validBytes.elem;
        if (trailingBytes > 0L) {
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Found %d invalid bytes at the end of %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(trailingBytes), file.getName()})));
        }
    }

    private DumpLogSegments$() {
        MODULE$ = this;
    }
}

