/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import kafka.api.LeaderAndIsr;
import kafka.controller.IsrChangeNotificationListener$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ReplicationUtils$$anonfun$kafka$utils$ReplicationUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.common.TopicPartition;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple2$mcZI$sp;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.TraitSetter;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ReplicationUtils$
implements Logging {
    public static final ReplicationUtils$ MODULE$;
    private final String IsrChangeNotificationPrefix;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ReplicationUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReplicationUtils$ replicationUtils$ = this;
        synchronized (replicationUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    @TraitSetter
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private String IsrChangeNotificationPrefix() {
        return this.IsrChangeNotificationPrefix;
    }

    public Tuple2<Object, Object> updateLeaderAndIsr(ZkUtils zkUtils, String topic, int partitionId, LeaderAndIsr newLeaderAndIsr, int controllerEpoch, int zkVersion) {
        this.debug((Function0<String>)((Object)new Serializable(topic, partitionId, newLeaderAndIsr){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final int partitionId$1;
            private final LeaderAndIsr newLeaderAndIsr$1;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated ISR for ", "-", " to ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$1, BoxesRunTime.boxToInteger(this.partitionId$1), this.newLeaderAndIsr$1.isr().mkString(",")}));
            }
            {
                this.topic$1 = topic$1;
                this.partitionId$1 = partitionId$1;
                this.newLeaderAndIsr$1 = newLeaderAndIsr$1;
            }
        }));
        String path = ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topic, partitionId);
        String newLeaderData = zkUtils.leaderAndIsrZkData(newLeaderAndIsr, controllerEpoch);
        Tuple2<Object, Object> updatePersistentPath2 = zkUtils.conditionalUpdatePersistentPath(path, newLeaderData, zkVersion, new Some<Function3<ZkUtils, String, String, Tuple2<Object, Object>>>((Function3<ZkUtils, String, String, Tuple2<Object, Object>>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(ZkUtils zkUtils, String path, String expectedLeaderAndIsrInfo) {
                return ReplicationUtils$.MODULE$.kafka$utils$ReplicationUtils$$checkLeaderAndIsrZkData(zkUtils, path, expectedLeaderAndIsrInfo);
            }
        })));
        return updatePersistentPath2;
    }

    public void propagateIsrChanges(ZkUtils zkUtils, Set<TopicPartition> isrChangeSet) {
        String isrChangeNotificationPath = zkUtils.createSequentialPersistentPath(new StringBuilder().append((Object)ZkUtils$.MODULE$.IsrChangeNotificationPath()).append((Object)"/").append((Object)this.IsrChangeNotificationPrefix()).toString(), this.generateIsrChangeJson(isrChangeSet), zkUtils.createSequentialPersistentPath$default$3());
        this.debug((Function0<String>)((Object)new Serializable(isrChangeSet, isrChangeNotificationPath){
            public static final long serialVersionUID = 0L;
            private final Set isrChangeSet$1;
            private final String isrChangeNotificationPath$1;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Added ", " for ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.isrChangeNotificationPath$1, this.isrChangeSet$1}));
            }
            {
                this.isrChangeSet$1 = isrChangeSet$1;
                this.isrChangeNotificationPath$1 = isrChangeNotificationPath$1;
            }
        }));
    }

    public Tuple2<Object, Object> kafka$utils$ReplicationUtils$$checkLeaderAndIsrZkData(ZkUtils zkUtils, String path, String expectedLeaderAndIsrInfo) {
        Tuple2 tuple2;
        Object object = new Object();
        try {
            try {
                Tuple2<Option<String>, Stat> writtenLeaderAndIsrInfo = zkUtils.readDataMaybeNull(path);
                Option<String> writtenLeaderOpt = writtenLeaderAndIsrInfo._1();
                Stat writtenStat = writtenLeaderAndIsrInfo._2();
                Option<LeaderIsrAndControllerEpoch> expectedLeader = this.kafka$utils$ReplicationUtils$$parseLeaderAndIsr(expectedLeaderAndIsrInfo, path, writtenStat);
                writtenLeaderOpt.foreach(new Serializable(path, writtenStat, expectedLeader, object){
                    public static final long serialVersionUID = 0L;
                    private final String path$1;
                    private final Stat writtenStat$1;
                    private final Option expectedLeader$1;
                    private final Object nonLocalReturnKey1$1;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final void apply(String writtenData) {
                        Option<LeaderIsrAndControllerEpoch> writtenLeader = ReplicationUtils$.MODULE$.kafka$utils$ReplicationUtils$$parseLeaderAndIsr(writtenData, this.path$1, this.writtenStat$1);
                        Tuple2<Option, Option<LeaderIsrAndControllerEpoch>> tuple2 = new Tuple2<Option, Option<LeaderIsrAndControllerEpoch>>(this.expectedLeader$1, writtenLeader);
                        if (tuple2 != null) {
                            Option option = tuple2._1();
                            Option<LeaderIsrAndControllerEpoch> option2 = tuple2._2();
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                LeaderIsrAndControllerEpoch expectedLeader = (LeaderIsrAndControllerEpoch)some.x();
                                if (option2 instanceof Some) {
                                    Some some2 = (Some)option2;
                                    LeaderIsrAndControllerEpoch writtenLeader2 = (LeaderIsrAndControllerEpoch)some2.x();
                                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = expectedLeader;
                                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch2 = writtenLeader2;
                                    if (leaderIsrAndControllerEpoch == null) {
                                        if (leaderIsrAndControllerEpoch2 == null) throw new NonLocalReturnControl<Tuple2$mcZI$sp>(this.nonLocalReturnKey1$1, new Tuple2$mcZI$sp(true, this.writtenStat$1.getVersion()));
                                    } else if (((Object)leaderIsrAndControllerEpoch).equals(leaderIsrAndControllerEpoch2)) {
                                        throw new NonLocalReturnControl<Tuple2$mcZI$sp>(this.nonLocalReturnKey1$1, new Tuple2$mcZI$sp(true, this.writtenStat$1.getVersion()));
                                    }
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    {
                        this.path$1 = path$1;
                        this.writtenStat$1 = writtenStat$1;
                        this.expectedLeader$1 = expectedLeader$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
            }
            catch (Exception exception) {}
            tuple2 = new Tuple2$mcZI$sp(false, -1);
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                tuple2 = (Tuple2)nonLocalReturnControl.value();
            }
            throw nonLocalReturnControl;
        }
        return tuple2;
    }

    public Option<LeaderIsrAndControllerEpoch> getLeaderIsrAndEpochForPartition(ZkUtils zkUtils, String topic, int partition2) {
        String leaderAndIsrPath = ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topic, partition2);
        Tuple2<Option<String>, Stat> tuple2 = zkUtils.readDataMaybeNull(leaderAndIsrPath);
        if (tuple2 != null) {
            Tuple2<Option<String>, Stat> tuple22;
            Option<String> leaderAndIsrOpt = tuple2._1();
            Stat stat = tuple2._2();
            Tuple2<Option<String>, Stat> tuple23 = tuple22 = new Tuple2<Option<String>, Stat>(leaderAndIsrOpt, stat);
            Option<String> leaderAndIsrOpt2 = tuple23._1();
            Stat stat2 = tuple23._2();
            this.debug((Function0<String>)((Object)new Serializable(topic, partition2, leaderAndIsrOpt2){
                public static final long serialVersionUID = 0L;
                private final String topic$2;
                private final int partition$1;
                private final Option leaderAndIsrOpt$1;

                public final String apply() {
                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read leaderISR ", " for ", "-", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.leaderAndIsrOpt$1, this.topic$2, BoxesRunTime.boxToInteger(this.partition$1)}));
                }
                {
                    this.topic$2 = topic$2;
                    this.partition$1 = partition$1;
                    this.leaderAndIsrOpt$1 = leaderAndIsrOpt$1;
                }
            }));
            return leaderAndIsrOpt2.flatMap(new Serializable(leaderAndIsrPath, stat2){
                public static final long serialVersionUID = 0L;
                private final String leaderAndIsrPath$1;
                private final Stat stat$2;

                public final Option<LeaderIsrAndControllerEpoch> apply(String leaderAndIsrStr) {
                    return ReplicationUtils$.MODULE$.kafka$utils$ReplicationUtils$$parseLeaderAndIsr(leaderAndIsrStr, this.leaderAndIsrPath$1, this.stat$2);
                }
                {
                    this.leaderAndIsrPath$1 = leaderAndIsrPath$1;
                    this.stat$2 = stat$2;
                }
            });
        }
        throw new MatchError(tuple2);
    }

    public Option<LeaderIsrAndControllerEpoch> kafka$utils$ReplicationUtils$$parseLeaderAndIsr(String leaderAndIsrStr, String path, Stat stat) {
        return Json$.MODULE$.parseFull(leaderAndIsrStr).flatMap(new Serializable(path, stat){
            public static final long serialVersionUID = 0L;
            public final String path$2;
            private final Stat stat$1;

            public final Some<LeaderIsrAndControllerEpoch> apply(JsonValue js) {
                JsonObject leaderIsrAndEpochInfo = js.asJsonObject();
                int leader = BoxesRunTime.unboxToInt(leaderIsrAndEpochInfo.apply("leader").to(DecodeJson$DecodeInt$.MODULE$));
                int epoch = BoxesRunTime.unboxToInt(leaderIsrAndEpochInfo.apply("leader_epoch").to(DecodeJson$DecodeInt$.MODULE$));
                List<Object> isr = leaderIsrAndEpochInfo.apply("isr").to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeInt$.MODULE$, List$.MODULE$.canBuildFrom()));
                int controllerEpoch = BoxesRunTime.unboxToInt(leaderIsrAndEpochInfo.apply("controller_epoch").to(DecodeJson$DecodeInt$.MODULE$));
                int zkPathVersion = this.stat$1.getVersion();
                ReplicationUtils$.MODULE$.trace((Function0<String>)((Object)new Serializable(this, leader, epoch, isr, zkPathVersion){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$kafka$utils$ReplicationUtils$$parseLeaderAndIsr$1 $outer;
                    private final int leader$1;
                    private final int epoch$1;
                    private final List isr$1;
                    private final int zkPathVersion$1;

                    public final String apply() {
                        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Leader ", ", Epoch ", ", Isr ", ", Zk path version ", " for leaderAndIsrPath ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.leader$1), BoxesRunTime.boxToInteger(this.epoch$1), this.isr$1, BoxesRunTime.boxToInteger(this.zkPathVersion$1), this.$outer.path$2}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.leader$1 = leader$1;
                        this.epoch$1 = epoch$1;
                        this.isr$1 = isr$1;
                        this.zkPathVersion$1 = zkPathVersion$1;
                    }
                }));
                return new Some<LeaderIsrAndControllerEpoch>(new LeaderIsrAndControllerEpoch(new LeaderAndIsr(leader, epoch, isr, zkPathVersion), controllerEpoch));
            }
            {
                this.path$2 = path$2;
                this.stat$1 = stat$1;
            }
        });
    }

    private String generateIsrChangeJson(Set<TopicPartition> isrChanges) {
        Map[] partitions = (Map[])((TraversableOnce)isrChanges.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<String, Object> apply(TopicPartition tp) {
                return (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("topic"), tp.topic()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("partition"), BoxesRunTime.boxToInteger(tp.partition()))}));
            }
        }, Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Map.class));
        return Json$.MODULE$.encode(Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("version"), BoxesRunTime.boxToLong(IsrChangeNotificationListener$.MODULE$.version())), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("partitions"), partitions)})));
    }

    private ReplicationUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.IsrChangeNotificationPrefix = "isr_change_";
    }
}

