/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractConverter;

public abstract class DateTimeConverter
extends AbstractConverter {
    private String[] patterns;
    private String displayPatterns;
    private Locale locale;
    private TimeZone timeZone;
    private boolean useLocaleFormat;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public DateTimeConverter() {
    }

    public DateTimeConverter(Object defaultValue) {
        super(defaultValue);
    }

    public void setUseLocaleFormat(boolean useLocaleFormat) {
        this.useLocaleFormat = useLocaleFormat;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.setUseLocaleFormat(true);
    }

    public void setPattern(String pattern) {
        this.setPatterns(new String[]{pattern});
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public void setPatterns(String[] patterns) {
        this.patterns = patterns;
        if (patterns != null && patterns.length > 1) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < patterns.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(patterns[i]);
            }
            this.displayPatterns = buffer.toString();
        }
        this.setUseLocaleFormat(true);
    }

    protected String convertToString(Object value2) throws Throwable {
        Date date = null;
        if (value2 instanceof Date) {
            date = (Date)value2;
        } else if (value2 instanceof Calendar) {
            date = ((Calendar)value2).getTime();
        } else if (value2 instanceof Long) {
            date = new Date((Long)value2);
        }
        String result2 = null;
        if (this.useLocaleFormat && date != null) {
            DateFormat format2 = null;
            format2 = this.patterns != null && this.patterns.length > 0 ? this.getFormat(this.patterns[0]) : this.getFormat(this.locale, this.timeZone);
            this.logFormat("Formatting", format2);
            result2 = format2.format(date);
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Converted  to String using format '" + result2 + "'");
            }
        } else {
            result2 = value2.toString();
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Converted  to String using toString() '" + result2 + "'");
            }
        }
        return result2;
    }

    protected Object convertToType(Class targetType, Object value2) throws Exception {
        Class<?> sourceType = value2.getClass();
        if (value2 instanceof Timestamp) {
            Timestamp timestamp2 = (Timestamp)value2;
            long timeInMillis = timestamp2.getTime() / 1000L * 1000L;
            return this.toDate(targetType, timeInMillis += (long)(timestamp2.getNanos() / 1000000));
        }
        if (value2 instanceof Date) {
            Date date = (Date)value2;
            return this.toDate(targetType, date.getTime());
        }
        if (value2 instanceof Calendar) {
            Calendar calendar = (Calendar)value2;
            return this.toDate(targetType, calendar.getTime().getTime());
        }
        if (value2 instanceof Long) {
            Long longObj = (Long)value2;
            return this.toDate(targetType, longObj);
        }
        String stringValue = value2.toString().trim();
        if (stringValue.length() == 0) {
            return this.handleMissing(targetType);
        }
        if (this.useLocaleFormat) {
            Calendar calendar = null;
            if (this.patterns != null && this.patterns.length > 0) {
                calendar = this.parse(sourceType, targetType, stringValue);
            } else {
                DateFormat format2 = this.getFormat(this.locale, this.timeZone);
                calendar = this.parse(sourceType, targetType, stringValue, format2);
            }
            if ((class$java$util$Calendar == null ? (class$java$util$Calendar = DateTimeConverter.class$("java.util.Calendar")) : class$java$util$Calendar).isAssignableFrom(targetType)) {
                return calendar;
            }
            return this.toDate(targetType, calendar.getTime().getTime());
        }
        return this.toDate(targetType, stringValue);
    }

    private Object toDate(Class type, long value2) {
        if (type.equals(class$java$util$Date == null ? (class$java$util$Date = DateTimeConverter.class$("java.util.Date")) : class$java$util$Date)) {
            return new Date(value2);
        }
        if (type.equals(class$java$sql$Date == null ? (class$java$sql$Date = DateTimeConverter.class$("java.sql.Date")) : class$java$sql$Date)) {
            return new java.sql.Date(value2);
        }
        if (type.equals(class$java$sql$Time == null ? (class$java$sql$Time = DateTimeConverter.class$("java.sql.Time")) : class$java$sql$Time)) {
            return new Time(value2);
        }
        if (type.equals(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = DateTimeConverter.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
            return new Timestamp(value2);
        }
        if (type.equals(class$java$util$Calendar == null ? (class$java$util$Calendar = DateTimeConverter.class$("java.util.Calendar")) : class$java$util$Calendar)) {
            Calendar calendar = null;
            calendar = this.locale == null && this.timeZone == null ? Calendar.getInstance() : (this.locale == null ? Calendar.getInstance(this.timeZone) : (this.timeZone == null ? Calendar.getInstance(this.locale) : Calendar.getInstance(this.timeZone, this.locale)));
            calendar.setTime(new Date(value2));
            calendar.setLenient(false);
            return calendar;
        }
        String msg = this.toString(this.getClass()) + " cannot handle conversion to '" + this.toString(type) + "'";
        if (this.log().isWarnEnabled()) {
            this.log().warn("    " + msg);
        }
        throw new ConversionException(msg);
    }

    private Object toDate(Class type, String value2) {
        if (type.equals(class$java$sql$Date == null ? (class$java$sql$Date = DateTimeConverter.class$("java.sql.Date")) : class$java$sql$Date)) {
            try {
                return java.sql.Date.valueOf(value2);
            }
            catch (IllegalArgumentException e) {
                throw new ConversionException("String must be in JDBC format [yyyy-MM-dd] to create a java.sql.Date");
            }
        }
        if (type.equals(class$java$sql$Time == null ? (class$java$sql$Time = DateTimeConverter.class$("java.sql.Time")) : class$java$sql$Time)) {
            try {
                return Time.valueOf(value2);
            }
            catch (IllegalArgumentException e) {
                throw new ConversionException("String must be in JDBC format [HH:mm:ss] to create a java.sql.Time");
            }
        }
        if (type.equals(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = DateTimeConverter.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
            try {
                return Timestamp.valueOf(value2);
            }
            catch (IllegalArgumentException e) {
                throw new ConversionException("String must be in JDBC format [yyyy-MM-dd HH:mm:ss.fffffffff] to create a java.sql.Timestamp");
            }
        }
        String msg = this.toString(this.getClass()) + " does not support default String to '" + this.toString(type) + "' conversion.";
        if (this.log().isWarnEnabled()) {
            this.log().warn("    " + msg);
            this.log().warn("    (N.B. Re-configure Converter or use alternative implementation)");
        }
        throw new ConversionException(msg);
    }

    protected DateFormat getFormat(Locale locale, TimeZone timeZone) {
        DateFormat format2 = null;
        format2 = locale == null ? DateFormat.getDateInstance(3) : DateFormat.getDateInstance(3, locale);
        if (timeZone != null) {
            format2.setTimeZone(timeZone);
        }
        return format2;
    }

    private DateFormat getFormat(String pattern) {
        SimpleDateFormat format2 = new SimpleDateFormat(pattern);
        if (this.timeZone != null) {
            format2.setTimeZone(this.timeZone);
        }
        return format2;
    }

    private Calendar parse(Class sourceType, Class targetType, String value2) throws Exception {
        Exception firstEx = null;
        for (int i = 0; i < this.patterns.length; ++i) {
            try {
                DateFormat format2 = this.getFormat(this.patterns[i]);
                Calendar calendar = this.parse(sourceType, targetType, value2, format2);
                return calendar;
            }
            catch (Exception ex) {
                if (firstEx != null) continue;
                firstEx = ex;
                continue;
            }
        }
        if (this.patterns.length > 1) {
            throw new ConversionException("Error converting '" + this.toString(sourceType) + "' to '" + this.toString(targetType) + "' using  patterns '" + this.displayPatterns + "'");
        }
        throw firstEx;
    }

    private Calendar parse(Class sourceType, Class targetType, String value2, DateFormat format2) {
        this.logFormat("Parsing", format2);
        format2.setLenient(false);
        ParsePosition pos = new ParsePosition(0);
        Date parsedDate = format2.parse(value2, pos);
        if (pos.getErrorIndex() >= 0 || pos.getIndex() != value2.length() || parsedDate == null) {
            String msg = "Error converting '" + this.toString(sourceType) + "' to '" + this.toString(targetType) + "'";
            if (format2 instanceof SimpleDateFormat) {
                msg = msg + " using pattern '" + ((SimpleDateFormat)format2).toPattern() + "'";
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("    " + msg);
            }
            throw new ConversionException(msg);
        }
        Calendar calendar = format2.getCalendar();
        return calendar;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.toString(this.getClass()));
        buffer.append("[UseDefault=");
        buffer.append(this.isUseDefault());
        buffer.append(", UseLocaleFormat=");
        buffer.append(this.useLocaleFormat);
        if (this.displayPatterns != null) {
            buffer.append(", Patterns={");
            buffer.append(this.displayPatterns);
            buffer.append('}');
        }
        if (this.locale != null) {
            buffer.append(", Locale=");
            buffer.append(this.locale);
        }
        if (this.timeZone != null) {
            buffer.append(", TimeZone=");
            buffer.append(this.timeZone);
        }
        buffer.append(']');
        return buffer.toString();
    }

    private void logFormat(String action, DateFormat format2) {
        if (this.log().isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer(45);
            buffer.append("    ");
            buffer.append(action);
            buffer.append(" with Format");
            if (format2 instanceof SimpleDateFormat) {
                buffer.append("[");
                buffer.append(((SimpleDateFormat)format2).toPattern());
                buffer.append("]");
            }
            buffer.append(" for ");
            if (this.locale == null) {
                buffer.append("default locale");
            } else {
                buffer.append("locale[");
                buffer.append(this.locale);
                buffer.append("]");
            }
            if (this.timeZone != null) {
                buffer.append(", TimeZone[");
                buffer.append(this.timeZone);
                buffer.append("]");
            }
            this.log().debug(buffer.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

