/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.KeyValue;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.iterators.EmptyIterator;
import org.apache.commons.collections4.iterators.EmptyMapIterator;

public class AbstractHashedMap<K, V>
extends AbstractMap<K, V>
implements IterableMap<K, V> {
    protected static final String NO_NEXT_ENTRY = "No next() entry in the iteration";
    protected static final String NO_PREVIOUS_ENTRY = "No previous() entry in the iteration";
    protected static final String REMOVE_INVALID = "remove() can only be called once after next()";
    protected static final String GETKEY_INVALID = "getKey() can only be called after next() and before remove()";
    protected static final String GETVALUE_INVALID = "getValue() can only be called after next() and before remove()";
    protected static final String SETVALUE_INVALID = "setValue() can only be called after next() and before remove()";
    protected static final int DEFAULT_CAPACITY = 16;
    protected static final int DEFAULT_THRESHOLD = 12;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int MAXIMUM_CAPACITY = 0x40000000;
    protected static final Object NULL = new Object();
    transient float loadFactor;
    transient int size;
    transient HashEntry<K, V>[] data;
    transient int threshold;
    transient int modCount;
    transient EntrySet<K, V> entrySet;
    transient KeySet<K> keySet;
    transient Values<V> values;

    protected AbstractHashedMap() {
    }

    protected AbstractHashedMap(int initialCapacity, float loadFactor, int threshold) {
        this.loadFactor = loadFactor;
        this.data = new HashEntry[initialCapacity];
        this.threshold = threshold;
        this.init();
    }

    protected AbstractHashedMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    protected AbstractHashedMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity must be a non negative number");
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Load factor must be greater than 0");
        }
        this.loadFactor = loadFactor;
        initialCapacity = this.calculateNewCapacity(initialCapacity);
        this.threshold = this.calculateThreshold(initialCapacity, loadFactor);
        this.data = new HashEntry[initialCapacity];
        this.init();
    }

    protected AbstractHashedMap(Map<? extends K, ? extends V> map2) {
        this(Math.max(2 * map2.size(), 16), 0.75f);
        super._putAll(map2);
    }

    protected void init() {
    }

    @Override
    public V get(Object key) {
        key = this.convertKey(key);
        int hashCode2 = this.hash(key);
        HashEntry<K, V> entry2 = this.data[this.hashIndex(hashCode2, this.data.length)];
        while (entry2 != null) {
            if (entry2.hashCode == hashCode2 && this.isEqualKey(key, entry2.key)) {
                return entry2.getValue();
            }
            entry2 = entry2.next;
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        key = this.convertKey(key);
        int hashCode2 = this.hash(key);
        HashEntry<K, V> entry2 = this.data[this.hashIndex(hashCode2, this.data.length)];
        while (entry2 != null) {
            if (entry2.hashCode == hashCode2 && this.isEqualKey(key, entry2.key)) {
                return true;
            }
            entry2 = entry2.next;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value2) {
        if (value2 == null) {
            HashEntry<K, V>[] hashEntryArray = this.data;
            int n = hashEntryArray.length;
            for (int i = 0; i < n; ++i) {
                HashEntry<K, V> element;
                HashEntry<K, V> entry2 = element = hashEntryArray[i];
                while (entry2 != null) {
                    if (entry2.getValue() == null) {
                        return true;
                    }
                    entry2 = entry2.next;
                }
            }
        } else {
            HashEntry<K, V>[] hashEntryArray = this.data;
            int n = hashEntryArray.length;
            for (int i = 0; i < n; ++i) {
                HashEntry<K, V> element;
                HashEntry<K, V> entry3 = element = hashEntryArray[i];
                while (entry3 != null) {
                    if (this.isEqualValue(value2, entry3.getValue())) {
                        return true;
                    }
                    entry3 = entry3.next;
                }
            }
        }
        return false;
    }

    @Override
    public V put(K key, V value2) {
        Object convertedKey = this.convertKey(key);
        int hashCode2 = this.hash(convertedKey);
        int index = this.hashIndex(hashCode2, this.data.length);
        HashEntry<K, V> entry2 = this.data[index];
        while (entry2 != null) {
            if (entry2.hashCode == hashCode2 && this.isEqualKey(convertedKey, entry2.key)) {
                V oldValue = entry2.getValue();
                this.updateEntry(entry2, value2);
                return oldValue;
            }
            entry2 = entry2.next;
        }
        this.addMapping(index, hashCode2, key, value2);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map2) {
        this._putAll(map2);
    }

    private void _putAll(Map<? extends K, ? extends V> map2) {
        int mapSize = map2.size();
        if (mapSize == 0) {
            return;
        }
        int newSize = (int)((float)(this.size + mapSize) / this.loadFactor + 1.0f);
        this.ensureCapacity(this.calculateNewCapacity(newSize));
        for (Map.Entry<K, V> entry2 : map2.entrySet()) {
            this.put(entry2.getKey(), entry2.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        key = this.convertKey(key);
        int hashCode2 = this.hash(key);
        int index = this.hashIndex(hashCode2, this.data.length);
        HashEntry<K, V> entry2 = this.data[index];
        HashEntry<K, V> previous = null;
        while (entry2 != null) {
            if (entry2.hashCode == hashCode2 && this.isEqualKey(key, entry2.key)) {
                V oldValue = entry2.getValue();
                this.removeMapping(entry2, index, previous);
                return oldValue;
            }
            previous = entry2;
            entry2 = entry2.next;
        }
        return null;
    }

    @Override
    public void clear() {
        ++this.modCount;
        HashEntry<K, V>[] data = this.data;
        for (int i = data.length - 1; i >= 0; --i) {
            data[i] = null;
        }
        this.size = 0;
    }

    protected Object convertKey(Object key) {
        return key == null ? NULL : key;
    }

    protected int hash(Object key) {
        int h = key.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    protected boolean isEqualKey(Object key1, Object key2) {
        return key1 == key2 || key1.equals(key2);
    }

    protected boolean isEqualValue(Object value1, Object value2) {
        return value1 == value2 || value1.equals(value2);
    }

    protected int hashIndex(int hashCode2, int dataSize) {
        return hashCode2 & dataSize - 1;
    }

    protected HashEntry<K, V> getEntry(Object key) {
        key = this.convertKey(key);
        int hashCode2 = this.hash(key);
        HashEntry<K, V> entry2 = this.data[this.hashIndex(hashCode2, this.data.length)];
        while (entry2 != null) {
            if (entry2.hashCode == hashCode2 && this.isEqualKey(key, entry2.key)) {
                return entry2;
            }
            entry2 = entry2.next;
        }
        return null;
    }

    protected void updateEntry(HashEntry<K, V> entry2, V newValue) {
        entry2.setValue(newValue);
    }

    protected void reuseEntry(HashEntry<K, V> entry2, int hashIndex, int hashCode2, K key, V value2) {
        entry2.next = this.data[hashIndex];
        entry2.hashCode = hashCode2;
        entry2.key = key;
        entry2.value = value2;
    }

    protected void addMapping(int hashIndex, int hashCode2, K key, V value2) {
        ++this.modCount;
        HashEntry<K, V> entry2 = this.createEntry(this.data[hashIndex], hashCode2, key, value2);
        this.addEntry(entry2, hashIndex);
        ++this.size;
        this.checkCapacity();
    }

    protected HashEntry<K, V> createEntry(HashEntry<K, V> next2, int hashCode2, K key, V value2) {
        return new HashEntry<K, V>(next2, hashCode2, this.convertKey(key), value2);
    }

    protected void addEntry(HashEntry<K, V> entry2, int hashIndex) {
        this.data[hashIndex] = entry2;
    }

    protected void removeMapping(HashEntry<K, V> entry2, int hashIndex, HashEntry<K, V> previous) {
        ++this.modCount;
        this.removeEntry(entry2, hashIndex, previous);
        --this.size;
        this.destroyEntry(entry2);
    }

    protected void removeEntry(HashEntry<K, V> entry2, int hashIndex, HashEntry<K, V> previous) {
        if (previous == null) {
            this.data[hashIndex] = entry2.next;
        } else {
            previous.next = entry2.next;
        }
    }

    protected void destroyEntry(HashEntry<K, V> entry2) {
        entry2.next = null;
        entry2.key = null;
        entry2.value = null;
    }

    protected void checkCapacity() {
        int newCapacity;
        if (this.size >= this.threshold && (newCapacity = this.data.length * 2) <= 0x40000000) {
            this.ensureCapacity(newCapacity);
        }
    }

    protected void ensureCapacity(int newCapacity) {
        int oldCapacity = this.data.length;
        if (newCapacity <= oldCapacity) {
            return;
        }
        if (this.size == 0) {
            this.threshold = this.calculateThreshold(newCapacity, this.loadFactor);
            this.data = new HashEntry[newCapacity];
        } else {
            HashEntry<K, V>[] oldEntries = this.data;
            HashEntry[] newEntries = new HashEntry[newCapacity];
            ++this.modCount;
            for (int i = oldCapacity - 1; i >= 0; --i) {
                HashEntry next2;
                HashEntry<K, V> entry2 = oldEntries[i];
                if (entry2 == null) continue;
                oldEntries[i] = null;
                do {
                    next2 = entry2.next;
                    int index = this.hashIndex(entry2.hashCode, newCapacity);
                    entry2.next = newEntries[index];
                    newEntries[index] = entry2;
                } while ((entry2 = next2) != null);
            }
            this.threshold = this.calculateThreshold(newCapacity, this.loadFactor);
            this.data = newEntries;
        }
    }

    protected int calculateNewCapacity(int proposedCapacity) {
        int newCapacity;
        if (proposedCapacity > 0x40000000) {
            newCapacity = 0x40000000;
        } else {
            for (newCapacity = 1; newCapacity < proposedCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > 0x40000000) {
                newCapacity = 0x40000000;
            }
        }
        return newCapacity;
    }

    protected int calculateThreshold(int newCapacity, float factor) {
        return (int)((float)newCapacity * factor);
    }

    protected HashEntry<K, V> entryNext(HashEntry<K, V> entry2) {
        return entry2.next;
    }

    protected int entryHashCode(HashEntry<K, V> entry2) {
        return entry2.hashCode;
    }

    protected K entryKey(HashEntry<K, V> entry2) {
        return entry2.getKey();
    }

    protected V entryValue(HashEntry<K, V> entry2) {
        return entry2.getValue();
    }

    @Override
    public MapIterator<K, V> mapIterator() {
        if (this.size == 0) {
            return EmptyMapIterator.emptyMapIterator();
        }
        return new HashMapIterator(this);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this);
        }
        return this.entrySet;
    }

    protected Iterator<Map.Entry<K, V>> createEntrySetIterator() {
        if (this.size() == 0) {
            return EmptyIterator.emptyIterator();
        }
        return new EntrySetIterator(this);
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet(this);
        }
        return this.keySet;
    }

    protected Iterator<K> createKeySetIterator() {
        if (this.size() == 0) {
            return EmptyIterator.emptyIterator();
        }
        return new KeySetIterator(this);
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values(this);
        }
        return this.values;
    }

    protected Iterator<V> createValuesIterator() {
        if (this.size() == 0) {
            return EmptyIterator.emptyIterator();
        }
        return new ValuesIterator(this);
    }

    protected void doWriteObject(ObjectOutputStream out) throws IOException {
        out.writeFloat(this.loadFactor);
        out.writeInt(this.data.length);
        out.writeInt(this.size);
        MapIterator<K, V> it = this.mapIterator();
        while (it.hasNext()) {
            out.writeObject(it.next());
            out.writeObject(it.getValue());
        }
    }

    protected void doReadObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.loadFactor = in.readFloat();
        int capacity = in.readInt();
        int size2 = in.readInt();
        this.init();
        this.threshold = this.calculateThreshold(capacity, this.loadFactor);
        this.data = new HashEntry[capacity];
        for (int i = 0; i < size2; ++i) {
            Object key = in.readObject();
            Object value2 = in.readObject();
            this.put(key, value2);
        }
    }

    @Override
    protected AbstractHashedMap<K, V> clone() {
        try {
            AbstractHashedMap cloned = (AbstractHashedMap)super.clone();
            cloned.data = new HashEntry[this.data.length];
            cloned.entrySet = null;
            cloned.keySet = null;
            cloned.values = null;
            cloned.modCount = 0;
            cloned.size = 0;
            cloned.init();
            cloned.putAll(this);
            return cloned;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map map2 = (Map)obj;
        if (map2.size() != this.size()) {
            return false;
        }
        MapIterator<K, V> it = this.mapIterator();
        try {
            while (it.hasNext()) {
                K key = it.next();
                V value2 = it.getValue();
                if (!(value2 == null ? map2.get(key) != null || !map2.containsKey(key) : !value2.equals(map2.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException ignored) {
            return false;
        }
        catch (NullPointerException ignored) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int total = 0;
        Iterator<Map.Entry<K, V>> it = this.createEntrySetIterator();
        while (it.hasNext()) {
            total += it.next().hashCode();
        }
        return total;
    }

    @Override
    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        StringBuilder buf = new StringBuilder(32 * this.size());
        buf.append('{');
        MapIterator<K, V> it = this.mapIterator();
        boolean hasNext = it.hasNext();
        while (hasNext) {
            K key = it.next();
            V value2 = it.getValue();
            buf.append((Object)(key == this ? "(this Map)" : key)).append('=').append((Object)(value2 == this ? "(this Map)" : value2));
            hasNext = it.hasNext();
            if (!hasNext) continue;
            buf.append(',').append(' ');
        }
        buf.append('}');
        return buf.toString();
    }

    protected static abstract class HashIterator<K, V> {
        private final AbstractHashedMap<K, V> parent;
        private int hashIndex;
        private HashEntry<K, V> last;
        private HashEntry<K, V> next;
        private int expectedModCount;

        protected HashIterator(AbstractHashedMap<K, V> parent) {
            this.parent = parent;
            HashEntry<K, V>[] data = parent.data;
            int i = data.length;
            HashEntry next2 = null;
            while (i > 0 && next2 == null) {
                next2 = data[--i];
            }
            this.next = next2;
            this.hashIndex = i;
            this.expectedModCount = parent.modCount;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        protected HashEntry<K, V> nextEntry() {
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            HashEntry<K, V> newCurrent = this.next;
            if (newCurrent == null) {
                throw new NoSuchElementException(AbstractHashedMap.NO_NEXT_ENTRY);
            }
            HashEntry<K, V>[] data = this.parent.data;
            int i = this.hashIndex;
            HashEntry n = newCurrent.next;
            while (n == null && i > 0) {
                n = data[--i];
            }
            this.next = n;
            this.hashIndex = i;
            this.last = newCurrent;
            return newCurrent;
        }

        protected HashEntry<K, V> currentEntry() {
            return this.last;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException(AbstractHashedMap.REMOVE_INVALID);
            }
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.parent.remove(this.last.getKey());
            this.last = null;
            this.expectedModCount = this.parent.modCount;
        }

        public String toString() {
            if (this.last != null) {
                return "Iterator[" + this.last.getKey() + "=" + this.last.getValue() + "]";
            }
            return "Iterator[]";
        }
    }

    protected static class HashEntry<K, V>
    implements Map.Entry<K, V>,
    KeyValue<K, V> {
        protected HashEntry<K, V> next;
        protected int hashCode;
        protected Object key;
        protected Object value;

        protected HashEntry(HashEntry<K, V> next2, int hashCode2, Object key, V value2) {
            this.next = next2;
            this.hashCode = hashCode2;
            this.key = key;
            this.value = value2;
        }

        @Override
        public K getKey() {
            if (this.key == NULL) {
                return null;
            }
            return (K)this.key;
        }

        @Override
        public V getValue() {
            return (V)this.value;
        }

        @Override
        public V setValue(V value2) {
            Object old = this.value;
            this.value = value2;
            return (V)old;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)obj;
            return (this.getKey() == null ? other.getKey() == null : this.getKey().equals(other.getKey())) && (this.getValue() == null ? other.getValue() == null : this.getValue().equals(other.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public String toString() {
            return "" + this.getKey() + '=' + this.getValue();
        }
    }

    protected static class ValuesIterator<V>
    extends HashIterator<Object, V>
    implements Iterator<V> {
        protected ValuesIterator(AbstractHashedMap<?, V> parent) {
            super(parent);
        }

        @Override
        public V next() {
            return super.nextEntry().getValue();
        }
    }

    protected static class Values<V>
    extends AbstractCollection<V> {
        private final AbstractHashedMap<?, V> parent;

        protected Values(AbstractHashedMap<?, V> parent) {
            this.parent = parent;
        }

        @Override
        public int size() {
            return this.parent.size();
        }

        @Override
        public void clear() {
            this.parent.clear();
        }

        @Override
        public boolean contains(Object value2) {
            return this.parent.containsValue(value2);
        }

        @Override
        public Iterator<V> iterator() {
            return this.parent.createValuesIterator();
        }
    }

    protected static class KeySetIterator<K>
    extends HashIterator<K, Object>
    implements Iterator<K> {
        protected KeySetIterator(AbstractHashedMap<K, ?> parent) {
            super(parent);
        }

        @Override
        public K next() {
            return super.nextEntry().getKey();
        }
    }

    protected static class KeySet<K>
    extends AbstractSet<K> {
        private final AbstractHashedMap<K, ?> parent;

        protected KeySet(AbstractHashedMap<K, ?> parent) {
            this.parent = parent;
        }

        @Override
        public int size() {
            return this.parent.size();
        }

        @Override
        public void clear() {
            this.parent.clear();
        }

        @Override
        public boolean contains(Object key) {
            return this.parent.containsKey(key);
        }

        @Override
        public boolean remove(Object key) {
            boolean result2 = this.parent.containsKey(key);
            this.parent.remove(key);
            return result2;
        }

        @Override
        public Iterator<K> iterator() {
            return this.parent.createKeySetIterator();
        }
    }

    protected static class EntrySetIterator<K, V>
    extends HashIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        protected EntrySetIterator(AbstractHashedMap<K, V> parent) {
            super(parent);
        }

        @Override
        public Map.Entry<K, V> next() {
            return super.nextEntry();
        }
    }

    protected static class EntrySet<K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        private final AbstractHashedMap<K, V> parent;

        protected EntrySet(AbstractHashedMap<K, V> parent) {
            this.parent = parent;
        }

        @Override
        public int size() {
            return this.parent.size();
        }

        @Override
        public void clear() {
            this.parent.clear();
        }

        @Override
        public boolean contains(Object entry2) {
            if (entry2 instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)entry2;
                HashEntry<K, V> match = this.parent.getEntry(e.getKey());
                return match != null && match.equals(e);
            }
            return false;
        }

        @Override
        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            if (!this.contains(obj)) {
                return false;
            }
            Map.Entry entry2 = (Map.Entry)obj;
            this.parent.remove(entry2.getKey());
            return true;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this.parent.createEntrySetIterator();
        }
    }

    protected static class HashMapIterator<K, V>
    extends HashIterator<K, V>
    implements MapIterator<K, V> {
        protected HashMapIterator(AbstractHashedMap<K, V> parent) {
            super(parent);
        }

        @Override
        public K next() {
            return super.nextEntry().getKey();
        }

        @Override
        public K getKey() {
            HashEntry current = this.currentEntry();
            if (current == null) {
                throw new IllegalStateException(AbstractHashedMap.GETKEY_INVALID);
            }
            return current.getKey();
        }

        @Override
        public V getValue() {
            HashEntry current = this.currentEntry();
            if (current == null) {
                throw new IllegalStateException(AbstractHashedMap.GETVALUE_INVALID);
            }
            return current.getValue();
        }

        @Override
        public V setValue(V value2) {
            HashEntry current = this.currentEntry();
            if (current == null) {
                throw new IllegalStateException(AbstractHashedMap.SETVALUE_INVALID);
            }
            return current.setValue(value2);
        }
    }
}

