/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree;

import java.util.Iterator;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.NodeCombiner;
import org.apache.commons.configuration.tree.ViewNode;

public class OverrideCombiner
extends NodeCombiner {
    public ConfigurationNode combine(ConfigurationNode node1, ConfigurationNode node2) {
        ConfigurationNode child;
        ViewNode result2 = this.createViewNode();
        result2.setName(node1.getName());
        Iterator it = node1.getChildren().iterator();
        while (it.hasNext()) {
            child = (ConfigurationNode)it.next();
            ConfigurationNode child2 = this.canCombine(node1, node2, child);
            if (child2 != null) {
                result2.addChild(this.combine(child, child2));
                continue;
            }
            result2.addChild(child);
        }
        it = node2.getChildren().iterator();
        while (it.hasNext()) {
            child = (ConfigurationNode)it.next();
            if (node1.getChildrenCount(child.getName()) >= 1) continue;
            result2.addChild(child);
        }
        this.addAttributes(result2, node1, node2);
        result2.setValue(node1.getValue() != null ? node1.getValue() : node2.getValue());
        return result2;
    }

    protected void addAttributes(ViewNode result2, ConfigurationNode node1, ConfigurationNode node2) {
        result2.appendAttributes(node1);
        Iterator it = node2.getAttributes().iterator();
        while (it.hasNext()) {
            ConfigurationNode attr = (ConfigurationNode)it.next();
            if (node1.getAttributeCount(attr.getName()) != 0) continue;
            result2.addAttribute(attr);
        }
    }

    protected ConfigurationNode canCombine(ConfigurationNode node1, ConfigurationNode node2, ConfigurationNode child) {
        if (node2.getChildrenCount(child.getName()) == 1 && node1.getChildrenCount(child.getName()) == 1 && !this.isListNode(child)) {
            return (ConfigurationNode)node2.getChildren(child.getName()).get(0);
        }
        return null;
    }
}

