/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.atomic;

import java.util.Arrays;
import org.apache.curator.RetryLoop;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.framework.recipes.atomic.AtomicValue;
import org.apache.curator.framework.recipes.atomic.MakeValue;
import org.apache.curator.framework.recipes.atomic.MutableAtomicValue;
import org.apache.curator.framework.recipes.atomic.PromotedToLock;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.utils.EnsurePath;
import org.apache.curator.utils.PathUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class DistributedAtomicValue {
    private final CuratorFramework client;
    private final String path;
    private final RetryPolicy retryPolicy;
    private final PromotedToLock promotedToLock;
    private final InterProcessMutex mutex;
    private final EnsurePath ensurePath;

    public DistributedAtomicValue(CuratorFramework client, String path, RetryPolicy retryPolicy) {
        this(client, path, retryPolicy, null);
    }

    public DistributedAtomicValue(CuratorFramework client, String path, RetryPolicy retryPolicy, PromotedToLock promotedToLock) {
        this.client = client;
        this.path = PathUtils.validatePath(path);
        this.retryPolicy = retryPolicy;
        this.promotedToLock = promotedToLock;
        this.mutex = promotedToLock != null ? new InterProcessMutex(client, promotedToLock.getPath()) : null;
        this.ensurePath = client.newNamespaceAwareEnsurePath(path).excludingLast();
    }

    public AtomicValue<byte[]> get() throws Exception {
        MutableAtomicValue<Object> result2 = new MutableAtomicValue<Object>(null, null, false);
        this.getCurrentValue(result2, new Stat());
        result2.postValue = result2.preValue;
        result2.succeeded = true;
        return result2;
    }

    public void forceSet(byte[] newValue) throws Exception {
        try {
            this.ensurePath.ensure(this.client.getZookeeperClient());
            this.client.setData().forPath(this.path, newValue);
        }
        catch (KeeperException.NoNodeException dummy) {
            try {
                this.client.create().forPath(this.path, newValue);
            }
            catch (KeeperException.NodeExistsException dummy2) {
                this.client.setData().forPath(this.path, newValue);
            }
        }
    }

    public AtomicValue<byte[]> compareAndSet(byte[] expectedValue, byte[] newValue) throws Exception {
        MutableAtomicValue<Object> result2 = new MutableAtomicValue<Object>(null, null, false);
        Stat stat = new Stat();
        boolean createIt = this.getCurrentValue(result2, stat);
        if (!createIt && Arrays.equals(expectedValue, (byte[])result2.preValue)) {
            try {
                ((BackgroundPathAndBytesable)this.client.setData().withVersion(stat.getVersion())).forPath(this.path, newValue);
                result2.succeeded = true;
                result2.postValue = newValue;
            }
            catch (KeeperException.BadVersionException dummy) {
                result2.succeeded = false;
            }
            catch (KeeperException.NoNodeException dummy) {
                result2.succeeded = false;
            }
        } else {
            result2.succeeded = false;
        }
        return result2;
    }

    public AtomicValue<byte[]> trySet(final byte[] newValue) throws Exception {
        MutableAtomicValue<Object> result2 = new MutableAtomicValue<Object>(null, null, false);
        MakeValue makeValue = new MakeValue(){

            @Override
            public byte[] makeFrom(byte[] previous) {
                return newValue;
            }
        };
        this.tryOptimistic(result2, makeValue);
        if (!result2.succeeded() && this.mutex != null) {
            this.tryWithMutex(result2, makeValue);
        }
        return result2;
    }

    public boolean initialize(byte[] value2) throws Exception {
        this.ensurePath.ensure(this.client.getZookeeperClient());
        try {
            this.client.create().forPath(this.path, value2);
        }
        catch (KeeperException.NodeExistsException ignore) {
            return false;
        }
        return true;
    }

    AtomicValue<byte[]> trySet(MakeValue makeValue) throws Exception {
        MutableAtomicValue<Object> result2 = new MutableAtomicValue<Object>(null, null, false);
        this.tryOptimistic(result2, makeValue);
        if (!result2.succeeded() && this.mutex != null) {
            this.tryWithMutex(result2, makeValue);
        }
        return result2;
    }

    RuntimeException createCorruptionException(byte[] bytes) {
        StringBuilder str = new StringBuilder();
        str.append('[');
        boolean first = true;
        for (byte b : bytes) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append("0x").append(Integer.toHexString(b & 0xFF));
        }
        str.append(']');
        return new RuntimeException(String.format("Corrupted data for node \"%s\": %s", this.path, str.toString()));
    }

    private boolean getCurrentValue(MutableAtomicValue<byte[]> result2, Stat stat) throws Exception {
        boolean createIt = false;
        try {
            this.ensurePath.ensure(this.client.getZookeeperClient());
            result2.preValue = ((WatchPathable)this.client.getData().storingStatIn(stat)).forPath(this.path);
        }
        catch (KeeperException.NoNodeException e) {
            result2.preValue = null;
            createIt = true;
        }
        return createIt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryWithMutex(MutableAtomicValue<byte[]> result2, MakeValue makeValue) throws Exception {
        long startMs = System.currentTimeMillis();
        int retryCount = 0;
        if (this.mutex.acquire(this.promotedToLock.getMaxLockTime(), this.promotedToLock.getMaxLockTimeUnit())) {
            try {
                boolean done = false;
                while (!done) {
                    result2.stats.incrementPromotedTries();
                    if (this.tryOnce(result2, makeValue)) {
                        result2.succeeded = true;
                        done = true;
                        continue;
                    }
                    if (this.promotedToLock.getRetryPolicy().allowRetry(retryCount++, System.currentTimeMillis() - startMs, RetryLoop.getDefaultRetrySleeper())) continue;
                    done = true;
                }
            }
            finally {
                this.mutex.release();
            }
        }
        result2.stats.setPromotedTimeMs(System.currentTimeMillis() - startMs);
    }

    private void tryOptimistic(MutableAtomicValue<byte[]> result2, MakeValue makeValue) throws Exception {
        long startMs = System.currentTimeMillis();
        int retryCount = 0;
        boolean done = false;
        while (!done) {
            result2.stats.incrementOptimisticTries();
            if (this.tryOnce(result2, makeValue)) {
                result2.succeeded = true;
                done = true;
                continue;
            }
            if (this.retryPolicy.allowRetry(retryCount++, System.currentTimeMillis() - startMs, RetryLoop.getDefaultRetrySleeper())) continue;
            done = true;
        }
        result2.stats.setOptimisticTimeMs(System.currentTimeMillis() - startMs);
    }

    private boolean tryOnce(MutableAtomicValue<byte[]> result2, MakeValue makeValue) throws Exception {
        Stat stat = new Stat();
        boolean createIt = this.getCurrentValue(result2, stat);
        boolean success = false;
        try {
            byte[] newValue = makeValue.makeFrom((byte[])result2.preValue);
            if (createIt) {
                this.client.create().forPath(this.path, newValue);
            } else {
                ((BackgroundPathAndBytesable)this.client.setData().withVersion(stat.getVersion())).forPath(this.path, newValue);
            }
            result2.postValue = Arrays.copyOf(newValue, newValue.length);
            success = true;
        }
        catch (KeeperException.NodeExistsException e) {
        }
        catch (KeeperException.BadVersionException e) {
        }
        catch (KeeperException.NoNodeException e) {
            // empty catch block
        }
        return success;
    }
}

