/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.shared;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.framework.listen.ListenerContainer;
import org.apache.curator.framework.recipes.shared.SharedValueListener;
import org.apache.curator.framework.recipes.shared.SharedValueReader;
import org.apache.curator.framework.recipes.shared.VersionedValue;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.utils.PathUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedValue
implements Closeable,
SharedValueReader {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ListenerContainer<SharedValueListener> listeners = new ListenerContainer();
    private final CuratorFramework client;
    private final String path;
    private final byte[] seedValue;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final AtomicReference<VersionedValue<byte[]>> currentValue;
    private final CuratorWatcher watcher = new CuratorWatcher(){

        @Override
        public void process(WatchedEvent event) throws Exception {
            if (SharedValue.this.state.get() == State.STARTED) {
                SharedValue.this.readValue();
                SharedValue.this.notifyListeners();
            }
        }
    };
    private final ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        @Override
        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            SharedValue.this.notifyListenerOfStateChanged(newState);
        }
    };

    public SharedValue(CuratorFramework client, String path, byte[] seedValue) {
        this.client = client;
        this.path = PathUtils.validatePath(path);
        this.seedValue = Arrays.copyOf(seedValue, seedValue.length);
        this.currentValue = new AtomicReference<VersionedValue<byte[]>>(new VersionedValue<byte[]>(0, Arrays.copyOf(seedValue, seedValue.length)));
    }

    @Override
    public byte[] getValue() {
        VersionedValue<byte[]> localCopy = this.currentValue.get();
        return Arrays.copyOf(localCopy.getValue(), localCopy.getValue().length);
    }

    @Override
    public VersionedValue<byte[]> getVersionedValue() {
        VersionedValue<byte[]> localCopy = this.currentValue.get();
        return new VersionedValue<byte[]>(localCopy.getVersion(), Arrays.copyOf(localCopy.getValue(), localCopy.getValue().length));
    }

    public void setValue(byte[] newValue) throws Exception {
        Preconditions.checkState(this.state.get() == State.STARTED, "not started");
        Stat result2 = (Stat)this.client.setData().forPath(this.path, newValue);
        this.updateValue(result2.getVersion(), Arrays.copyOf(newValue, newValue.length));
    }

    @Deprecated
    public boolean trySetValue(byte[] newValue) throws Exception {
        return this.trySetValue(this.currentValue.get(), newValue);
    }

    public boolean trySetValue(VersionedValue<byte[]> previous, byte[] newValue) throws Exception {
        Preconditions.checkState(this.state.get() == State.STARTED, "not started");
        VersionedValue<byte[]> current = this.currentValue.get();
        if (previous.getVersion() != current.getVersion() || !Arrays.equals(previous.getValue(), current.getValue())) {
            return false;
        }
        try {
            Stat result2 = (Stat)((BackgroundPathAndBytesable)this.client.setData().withVersion(previous.getVersion())).forPath(this.path, newValue);
            this.updateValue(result2.getVersion(), Arrays.copyOf(newValue, newValue.length));
            return true;
        }
        catch (KeeperException.BadVersionException ignore) {
            this.readValue();
            return false;
        }
    }

    private void updateValue(int version, byte[] bytes) {
        VersionedValue<byte[]> current;
        do {
            if ((current = this.currentValue.get()).getVersion() < version) continue;
            return;
        } while (!this.currentValue.compareAndSet(current, new VersionedValue<byte[]>(version, bytes)));
    }

    @Override
    public ListenerContainer<SharedValueListener> getListenable() {
        return this.listeners;
    }

    public void start() throws Exception {
        Preconditions.checkState(this.state.compareAndSet(State.LATENT, State.STARTED), "Cannot be started more than once");
        this.client.getConnectionStateListenable().addListener(this.connectionStateListener);
        try {
            this.client.create().creatingParentsIfNeeded().forPath(this.path, this.seedValue);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
        this.readValue();
    }

    @Override
    public void close() throws IOException {
        this.client.getConnectionStateListenable().removeListener(this.connectionStateListener);
        this.state.set(State.CLOSED);
        this.listeners.clear();
    }

    private void readValue() throws Exception {
        Stat localStat = new Stat();
        byte[] bytes = (byte[])((Pathable)((WatchPathable)this.client.getData().storingStatIn(localStat)).usingWatcher(this.watcher)).forPath(this.path);
        this.updateValue(localStat.getVersion(), bytes);
    }

    private void notifyListeners() {
        final byte[] localValue = this.getValue();
        this.listeners.forEach(new Function<SharedValueListener, Void>(){

            @Override
            public Void apply(SharedValueListener listener) {
                try {
                    listener.valueHasChanged(SharedValue.this, localValue);
                }
                catch (Exception e) {
                    SharedValue.this.log.error("From SharedValue listener", e);
                }
                return null;
            }
        });
    }

    private void notifyListenerOfStateChanged(final ConnectionState newState) {
        this.listeners.forEach(new Function<SharedValueListener, Void>(){

            @Override
            public Void apply(SharedValueListener listener) {
                listener.stateChanged(SharedValue.this.client, newState);
                return null;
            }
        });
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

