/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.Decryptor;
import org.apache.hadoop.crypto.Encryptor;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderExtension;

@InterfaceAudience.Private
public class KeyProviderCryptoExtension
extends KeyProviderExtension<CryptoExtension> {
    public static final String EEK = "EEK";
    public static final String EK = "EK";

    protected KeyProviderCryptoExtension(KeyProvider keyProvider, CryptoExtension extension2) {
        super(keyProvider, extension2);
    }

    public void warmUpEncryptedKeys(String ... keyNames) throws IOException {
        ((CryptoExtension)this.getExtension()).warmUpEncryptedKeys(keyNames);
    }

    public EncryptedKeyVersion generateEncryptedKey(String encryptionKeyName) throws IOException, GeneralSecurityException {
        return ((CryptoExtension)this.getExtension()).generateEncryptedKey(encryptionKeyName);
    }

    public KeyProvider.KeyVersion decryptEncryptedKey(EncryptedKeyVersion encryptedKey) throws IOException, GeneralSecurityException {
        return ((CryptoExtension)this.getExtension()).decryptEncryptedKey(encryptedKey);
    }

    public static KeyProviderCryptoExtension createKeyProviderCryptoExtension(KeyProvider keyProvider) {
        CryptoExtension cryptoExtension = null;
        if (keyProvider instanceof CryptoExtension) {
            cryptoExtension = (CryptoExtension)((Object)keyProvider);
        } else if (keyProvider instanceof KeyProviderExtension && ((KeyProviderExtension)keyProvider).getKeyProvider() instanceof CryptoExtension) {
            KeyProviderExtension keyProviderExtension = (KeyProviderExtension)keyProvider;
            cryptoExtension = (CryptoExtension)((Object)keyProviderExtension.getKeyProvider());
        } else {
            cryptoExtension = new DefaultCryptoExtension(keyProvider);
        }
        return new KeyProviderCryptoExtension(keyProvider, cryptoExtension);
    }

    @Override
    public void close() throws IOException {
        KeyProvider provider = this.getKeyProvider();
        if (provider != null && provider != this) {
            provider.close();
        }
    }

    private static class DefaultCryptoExtension
    implements CryptoExtension {
        private final KeyProvider keyProvider;
        private static final ThreadLocal<SecureRandom> RANDOM = new ThreadLocal<SecureRandom>(){

            @Override
            protected SecureRandom initialValue() {
                return new SecureRandom();
            }
        };

        private DefaultCryptoExtension(KeyProvider keyProvider) {
            this.keyProvider = keyProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public EncryptedKeyVersion generateEncryptedKey(String encryptionKeyName) throws IOException, GeneralSecurityException {
            KeyProvider.KeyVersion encryptionKey = this.keyProvider.getCurrentKey(encryptionKeyName);
            Preconditions.checkNotNull(encryptionKey, "No KeyVersion exists for key '%s' ", new Object[]{encryptionKeyName});
            try (CryptoCodec cc = CryptoCodec.getInstance(this.keyProvider.getConf());){
                byte[] newKey = new byte[encryptionKey.getMaterial().length];
                cc.generateSecureRandom(newKey);
                byte[] iv = new byte[cc.getCipherSuite().getAlgorithmBlockSize()];
                cc.generateSecureRandom(iv);
                byte[] encryptionIV = EncryptedKeyVersion.deriveIV(iv);
                Encryptor encryptor = cc.createEncryptor();
                encryptor.init(encryptionKey.getMaterial(), encryptionIV);
                int keyLen = newKey.length;
                ByteBuffer bbIn = ByteBuffer.allocateDirect(keyLen);
                ByteBuffer bbOut = ByteBuffer.allocateDirect(keyLen);
                bbIn.put(newKey);
                bbIn.flip();
                encryptor.encrypt(bbIn, bbOut);
                bbOut.flip();
                byte[] encryptedKey = new byte[keyLen];
                bbOut.get(encryptedKey);
                EncryptedKeyVersion encryptedKeyVersion = new EncryptedKeyVersion(encryptionKeyName, encryptionKey.getVersionName(), iv, new KeyProvider.KeyVersion(encryptionKey.getName(), KeyProviderCryptoExtension.EEK, encryptedKey));
                return encryptedKeyVersion;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public KeyProvider.KeyVersion decryptEncryptedKey(EncryptedKeyVersion encryptedKeyVersion) throws IOException, GeneralSecurityException {
            String encryptionKeyVersionName = encryptedKeyVersion.getEncryptionKeyVersionName();
            KeyProvider.KeyVersion encryptionKey = this.keyProvider.getKeyVersion(encryptionKeyVersionName);
            Preconditions.checkNotNull(encryptionKey, "KeyVersion name '%s' does not exist", new Object[]{encryptionKeyVersionName});
            Preconditions.checkArgument(encryptedKeyVersion.getEncryptedKeyVersion().getVersionName().equals(KeyProviderCryptoExtension.EEK), "encryptedKey version name must be '%s', is '%s'", new Object[]{KeyProviderCryptoExtension.EEK, encryptedKeyVersion.getEncryptedKeyVersion().getVersionName()});
            byte[] encryptionIV = EncryptedKeyVersion.deriveIV(encryptedKeyVersion.getEncryptedKeyIv());
            try (CryptoCodec cc = CryptoCodec.getInstance(this.keyProvider.getConf());){
                Decryptor decryptor = cc.createDecryptor();
                decryptor.init(encryptionKey.getMaterial(), encryptionIV);
                KeyProvider.KeyVersion encryptedKV = encryptedKeyVersion.getEncryptedKeyVersion();
                int keyLen = encryptedKV.getMaterial().length;
                ByteBuffer bbIn = ByteBuffer.allocateDirect(keyLen);
                ByteBuffer bbOut = ByteBuffer.allocateDirect(keyLen);
                bbIn.put(encryptedKV.getMaterial());
                bbIn.flip();
                decryptor.decrypt(bbIn, bbOut);
                bbOut.flip();
                byte[] decryptedKey = new byte[keyLen];
                bbOut.get(decryptedKey);
                KeyProvider.KeyVersion keyVersion = new KeyProvider.KeyVersion(encryptionKey.getName(), KeyProviderCryptoExtension.EK, decryptedKey);
                return keyVersion;
            }
        }

        @Override
        public void warmUpEncryptedKeys(String ... keyNames) throws IOException {
        }

        @Override
        public void drain(String keyName) {
        }
    }

    public static interface CryptoExtension
    extends KeyProviderExtension.Extension {
        public void warmUpEncryptedKeys(String ... var1) throws IOException;

        public void drain(String var1);

        public EncryptedKeyVersion generateEncryptedKey(String var1) throws IOException, GeneralSecurityException;

        public KeyProvider.KeyVersion decryptEncryptedKey(EncryptedKeyVersion var1) throws IOException, GeneralSecurityException;
    }

    public static class EncryptedKeyVersion {
        private String encryptionKeyName;
        private String encryptionKeyVersionName;
        private byte[] encryptedKeyIv;
        private KeyProvider.KeyVersion encryptedKeyVersion;

        protected EncryptedKeyVersion(String keyName, String encryptionKeyVersionName, byte[] encryptedKeyIv, KeyProvider.KeyVersion encryptedKeyVersion) {
            this.encryptionKeyName = keyName == null ? null : keyName.intern();
            this.encryptionKeyVersionName = encryptionKeyVersionName == null ? null : encryptionKeyVersionName.intern();
            this.encryptedKeyIv = encryptedKeyIv;
            this.encryptedKeyVersion = encryptedKeyVersion;
        }

        public static EncryptedKeyVersion createForDecryption(String keyName, String encryptionKeyVersionName, byte[] encryptedKeyIv, byte[] encryptedKeyMaterial) {
            KeyProvider.KeyVersion encryptedKeyVersion = new KeyProvider.KeyVersion(null, KeyProviderCryptoExtension.EEK, encryptedKeyMaterial);
            return new EncryptedKeyVersion(keyName, encryptionKeyVersionName, encryptedKeyIv, encryptedKeyVersion);
        }

        public String getEncryptionKeyName() {
            return this.encryptionKeyName;
        }

        public String getEncryptionKeyVersionName() {
            return this.encryptionKeyVersionName;
        }

        public byte[] getEncryptedKeyIv() {
            return this.encryptedKeyIv;
        }

        public KeyProvider.KeyVersion getEncryptedKeyVersion() {
            return this.encryptedKeyVersion;
        }

        protected static byte[] deriveIV(byte[] encryptedKeyIV) {
            byte[] rIv = new byte[encryptedKeyIV.length];
            for (int i = 0; i < encryptedKeyIV.length; ++i) {
                rIv[i] = (byte)(encryptedKeyIV[i] ^ 0xFF);
            }
            return rIv;
        }
    }
}

