/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.util.StringInterner;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class BlockLocation {
    private String[] hosts;
    private String[] cachedHosts;
    private String[] names;
    private String[] topologyPaths;
    private String[] storageIds;
    private StorageType[] storageTypes;
    private long offset;
    private long length;
    private boolean corrupt;
    private static final String[] EMPTY_STR_ARRAY = new String[0];
    private static final StorageType[] EMPTY_STORAGE_TYPE_ARRAY = new StorageType[0];

    public BlockLocation() {
        this(EMPTY_STR_ARRAY, EMPTY_STR_ARRAY, 0L, 0L);
    }

    public BlockLocation(BlockLocation that) {
        this.hosts = that.hosts;
        this.cachedHosts = that.cachedHosts;
        this.names = that.names;
        this.topologyPaths = that.topologyPaths;
        this.offset = that.offset;
        this.length = that.length;
        this.corrupt = that.corrupt;
        this.storageIds = that.storageIds;
        this.storageTypes = that.storageTypes;
    }

    public BlockLocation(String[] names, String[] hosts, long offset2, long length) {
        this(names, hosts, offset2, length, false);
    }

    public BlockLocation(String[] names, String[] hosts, long offset2, long length, boolean corrupt) {
        this(names, hosts, null, offset2, length, corrupt);
    }

    public BlockLocation(String[] names, String[] hosts, String[] topologyPaths, long offset2, long length) {
        this(names, hosts, topologyPaths, offset2, length, false);
    }

    public BlockLocation(String[] names, String[] hosts, String[] topologyPaths, long offset2, long length, boolean corrupt) {
        this(names, hosts, null, topologyPaths, offset2, length, corrupt);
    }

    public BlockLocation(String[] names, String[] hosts, String[] cachedHosts, String[] topologyPaths, long offset2, long length, boolean corrupt) {
        this(names, hosts, cachedHosts, topologyPaths, null, null, offset2, length, corrupt);
    }

    public BlockLocation(String[] names, String[] hosts, String[] cachedHosts, String[] topologyPaths, String[] storageIds, StorageType[] storageTypes, long offset2, long length, boolean corrupt) {
        this.names = names == null ? EMPTY_STR_ARRAY : StringInterner.internStringsInArray(names);
        this.hosts = hosts == null ? EMPTY_STR_ARRAY : StringInterner.internStringsInArray(hosts);
        this.cachedHosts = cachedHosts == null ? EMPTY_STR_ARRAY : StringInterner.internStringsInArray(cachedHosts);
        this.topologyPaths = topologyPaths == null ? EMPTY_STR_ARRAY : StringInterner.internStringsInArray(topologyPaths);
        this.storageIds = storageIds == null ? EMPTY_STR_ARRAY : StringInterner.internStringsInArray(storageIds);
        this.storageTypes = storageTypes == null ? EMPTY_STORAGE_TYPE_ARRAY : storageTypes;
        this.offset = offset2;
        this.length = length;
        this.corrupt = corrupt;
    }

    public String[] getHosts() throws IOException {
        return this.hosts;
    }

    public String[] getCachedHosts() {
        return this.cachedHosts;
    }

    public String[] getNames() throws IOException {
        return this.names;
    }

    public String[] getTopologyPaths() throws IOException {
        return this.topologyPaths;
    }

    public String[] getStorageIds() {
        return this.storageIds;
    }

    public StorageType[] getStorageTypes() {
        return this.storageTypes;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }

    public boolean isCorrupt() {
        return this.corrupt;
    }

    public void setOffset(long offset2) {
        this.offset = offset2;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setCorrupt(boolean corrupt) {
        this.corrupt = corrupt;
    }

    public void setHosts(String[] hosts) throws IOException {
        this.hosts = hosts == null ? EMPTY_STR_ARRAY : StringInterner.internStringsInArray(hosts);
    }

    public void setCachedHosts(String[] cachedHosts) {
        this.cachedHosts = cachedHosts == null ? EMPTY_STR_ARRAY : StringInterner.internStringsInArray(cachedHosts);
    }

    public void setNames(String[] names) throws IOException {
        this.names = names == null ? EMPTY_STR_ARRAY : StringInterner.internStringsInArray(names);
    }

    public void setTopologyPaths(String[] topologyPaths) throws IOException {
        this.topologyPaths = topologyPaths == null ? EMPTY_STR_ARRAY : StringInterner.internStringsInArray(topologyPaths);
    }

    public void setStorageIds(String[] storageIds) {
        this.storageIds = storageIds == null ? EMPTY_STR_ARRAY : StringInterner.internStringsInArray(storageIds);
    }

    public void setStorageTypes(StorageType[] storageTypes) {
        this.storageTypes = storageTypes == null ? EMPTY_STORAGE_TYPE_ARRAY : storageTypes;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append(this.offset);
        result2.append(',');
        result2.append(this.length);
        if (this.corrupt) {
            result2.append("(corrupt)");
        }
        for (String h : this.hosts) {
            result2.append(',');
            result2.append(h);
        }
        return result2.toString();
    }
}

