/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class WritableFactories {
    private static final Map<Class, WritableFactory> CLASS_TO_FACTORY = new ConcurrentHashMap<Class, WritableFactory>();

    private WritableFactories() {
    }

    public static void setFactory(Class c, WritableFactory factory) {
        CLASS_TO_FACTORY.put(c, factory);
    }

    public static WritableFactory getFactory(Class c) {
        return CLASS_TO_FACTORY.get(c);
    }

    public static Writable newInstance(Class<? extends Writable> c, Configuration conf) {
        WritableFactory factory = WritableFactories.getFactory(c);
        if (factory != null) {
            Writable result2 = factory.newInstance();
            if (result2 instanceof Configurable) {
                ((Configurable)((Object)result2)).setConf(conf);
            }
            return result2;
        }
        return ReflectionUtils.newInstance(c, conf);
    }

    public static Writable newInstance(Class<? extends Writable> c) {
        return WritableFactories.newInstance(c, null);
    }
}

