/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.io.BoundedByteArrayOutputStream;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.file.tfile.BCFile;
import org.apache.hadoop.io.file.tfile.ByteArray;
import org.apache.hadoop.io.file.tfile.Chunk;
import org.apache.hadoop.io.file.tfile.CompareUtils;
import org.apache.hadoop.io.file.tfile.Compression;
import org.apache.hadoop.io.file.tfile.MetaBlockAlreadyExists;
import org.apache.hadoop.io.file.tfile.MetaBlockDoesNotExist;
import org.apache.hadoop.io.file.tfile.RawComparable;
import org.apache.hadoop.io.file.tfile.TFileDumper;
import org.apache.hadoop.io.file.tfile.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TFile {
    static final Logger LOG = LoggerFactory.getLogger(TFile.class);
    private static final String CHUNK_BUF_SIZE_ATTR = "tfile.io.chunk.size";
    private static final String FS_INPUT_BUF_SIZE_ATTR = "tfile.fs.input.buffer.size";
    private static final String FS_OUTPUT_BUF_SIZE_ATTR = "tfile.fs.output.buffer.size";
    private static final int MAX_KEY_SIZE = 65536;
    static final Utils.Version API_VERSION = new Utils.Version(1, 0);
    public static final String COMPRESSION_GZ = "gz";
    public static final String COMPRESSION_LZO = "lzo";
    public static final String COMPRESSION_NONE = "none";
    public static final String COMPARATOR_MEMCMP = "memcmp";
    public static final String COMPARATOR_JCLASS = "jclass:";

    static int getChunkBufferSize(Configuration conf) {
        int ret = conf.getInt(CHUNK_BUF_SIZE_ATTR, 0x100000);
        return ret > 0 ? ret : 0x100000;
    }

    static int getFSInputBufferSize(Configuration conf) {
        return conf.getInt(FS_INPUT_BUF_SIZE_ATTR, 262144);
    }

    static int getFSOutputBufferSize(Configuration conf) {
        return conf.getInt(FS_OUTPUT_BUF_SIZE_ATTR, 262144);
    }

    public static Comparator<RawComparable> makeComparator(String name) {
        return TFileMeta.makeComparator(name);
    }

    private TFile() {
    }

    public static String[] getSupportedCompressionAlgorithms() {
        return Compression.getSupportedAlgorithms();
    }

    public static void main(String[] args) {
        System.out.printf("TFile Dumper (TFile %s, BCFile %s)%n", API_VERSION.toString(), BCFile.API_VERSION.toString());
        if (args.length == 0) {
            System.out.println("Usage: java ... org.apache.hadoop.io.file.tfile.TFile tfile-path [tfile-path ...]");
            System.exit(0);
        }
        Configuration conf = new Configuration();
        for (String file : args) {
            System.out.println("===" + file + "===");
            try {
                TFileDumper.dumpInfo(file, System.out, conf);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    static final class TFileIndexEntry
    implements RawComparable {
        final byte[] key;
        final long kvEntries;

        public TFileIndexEntry(DataInput in) throws IOException {
            int len = Utils.readVInt(in);
            this.key = new byte[len];
            in.readFully(this.key, 0, len);
            this.kvEntries = Utils.readVLong(in);
        }

        public TFileIndexEntry(byte[] newkey, int offset2, int len, long entries) {
            this.key = new byte[len];
            System.arraycopy(newkey, offset2, this.key, 0, len);
            this.kvEntries = entries;
        }

        @Override
        public byte[] buffer() {
            return this.key;
        }

        @Override
        public int offset() {
            return 0;
        }

        @Override
        public int size() {
            return this.key.length;
        }

        long entries() {
            return this.kvEntries;
        }

        public void write(DataOutput out) throws IOException {
            Utils.writeVInt(out, this.key.length);
            out.write(this.key, 0, this.key.length);
            Utils.writeVLong(out, this.kvEntries);
        }
    }

    static class TFileIndex {
        static final String BLOCK_NAME = "TFile.index";
        private ByteArray firstKey;
        private final ArrayList<TFileIndexEntry> index;
        private final ArrayList<Long> recordNumIndex;
        private final CompareUtils.BytesComparator comparator;
        private long sum = 0L;

        public TFileIndex(int entryCount, DataInput in, CompareUtils.BytesComparator comparator) throws IOException {
            this.index = new ArrayList(entryCount);
            this.recordNumIndex = new ArrayList(entryCount);
            int size2 = Utils.readVInt(in);
            if (size2 > 0) {
                byte[] buffer = new byte[size2];
                in.readFully(buffer);
                DataInputStream firstKeyInputStream = new DataInputStream(new ByteArrayInputStream(buffer, 0, size2));
                int firstKeyLength = Utils.readVInt(firstKeyInputStream);
                this.firstKey = new ByteArray(new byte[firstKeyLength]);
                firstKeyInputStream.readFully(this.firstKey.buffer());
                for (int i = 0; i < entryCount; ++i) {
                    size2 = Utils.readVInt(in);
                    if (buffer.length < size2) {
                        buffer = new byte[size2];
                    }
                    in.readFully(buffer, 0, size2);
                    TFileIndexEntry idx = new TFileIndexEntry(new DataInputStream(new ByteArrayInputStream(buffer, 0, size2)));
                    this.index.add(idx);
                    this.sum += idx.entries();
                    this.recordNumIndex.add(this.sum);
                }
            } else if (entryCount != 0) {
                throw new RuntimeException("Internal error");
            }
            this.comparator = comparator;
        }

        public int lowerBound(RawComparable key) {
            if (this.comparator == null) {
                throw new RuntimeException("Cannot search in unsorted TFile");
            }
            if (this.firstKey == null) {
                return -1;
            }
            int ret = Utils.lowerBound(this.index, key, this.comparator);
            if (ret == this.index.size()) {
                return -1;
            }
            return ret;
        }

        public int upperBound(RawComparable key) {
            if (this.comparator == null) {
                throw new RuntimeException("Cannot search in unsorted TFile");
            }
            if (this.firstKey == null) {
                return -1;
            }
            int ret = Utils.upperBound(this.index, key, this.comparator);
            if (ret == this.index.size()) {
                return -1;
            }
            return ret;
        }

        public TFileIndex(CompareUtils.BytesComparator comparator) {
            this.index = new ArrayList();
            this.recordNumIndex = new ArrayList();
            this.comparator = comparator;
        }

        public RawComparable getFirstKey() {
            return this.firstKey;
        }

        public Reader.Location getLocationByRecordNum(long recNum) {
            int idx = Utils.upperBound(this.recordNumIndex, recNum);
            long lastRecNum = idx == 0 ? 0L : this.recordNumIndex.get(idx - 1);
            return new Reader.Location(idx, recNum - lastRecNum);
        }

        public long getRecordNumByLocation(Reader.Location location) {
            int blkIndex = location.getBlockIndex();
            long lastRecNum = blkIndex == 0 ? 0L : this.recordNumIndex.get(blkIndex - 1);
            return lastRecNum + location.getRecordIndex();
        }

        public void setFirstKey(byte[] key, int offset2, int length) {
            this.firstKey = new ByteArray(new byte[length]);
            System.arraycopy(key, offset2, this.firstKey.buffer(), 0, length);
        }

        public RawComparable getLastKey() {
            if (this.index.size() == 0) {
                return null;
            }
            return new ByteArray(this.index.get(this.index.size() - 1).buffer());
        }

        public void addEntry(TFileIndexEntry keyEntry) {
            this.index.add(keyEntry);
            this.sum += keyEntry.entries();
            this.recordNumIndex.add(this.sum);
        }

        public TFileIndexEntry getEntry(int bid) {
            return this.index.get(bid);
        }

        public void write(DataOutput out) throws IOException {
            if (this.firstKey == null) {
                Utils.writeVInt(out, 0);
                return;
            }
            DataOutputBuffer dob = new DataOutputBuffer();
            Utils.writeVInt(dob, this.firstKey.size());
            dob.write(this.firstKey.buffer());
            Utils.writeVInt(out, dob.size());
            out.write(dob.getData(), 0, dob.getLength());
            for (TFileIndexEntry entry2 : this.index) {
                dob.reset();
                entry2.write(dob);
                Utils.writeVInt(out, dob.getLength());
                out.write(dob.getData(), 0, dob.getLength());
            }
        }
    }

    static final class TFileMeta {
        static final String BLOCK_NAME = "TFile.meta";
        final Utils.Version version;
        private long recordCount;
        private final String strComparator;
        private final CompareUtils.BytesComparator comparator;

        public TFileMeta(String comparator) {
            this.version = API_VERSION;
            this.recordCount = 0L;
            this.strComparator = comparator == null ? "" : comparator;
            this.comparator = TFileMeta.makeComparator(this.strComparator);
        }

        public TFileMeta(DataInput in) throws IOException {
            this.version = new Utils.Version(in);
            if (!this.version.compatibleWith(API_VERSION)) {
                throw new RuntimeException("Incompatible TFile fileVersion.");
            }
            this.recordCount = Utils.readVLong(in);
            this.strComparator = Utils.readString(in);
            this.comparator = TFileMeta.makeComparator(this.strComparator);
        }

        static CompareUtils.BytesComparator makeComparator(String comparator) {
            if (comparator.length() == 0) {
                return null;
            }
            if (comparator.equals(TFile.COMPARATOR_MEMCMP)) {
                return new CompareUtils.BytesComparator(new CompareUtils.MemcmpRawComparator());
            }
            if (comparator.startsWith(TFile.COMPARATOR_JCLASS)) {
                String compClassName = comparator.substring(TFile.COMPARATOR_JCLASS.length()).trim();
                try {
                    Class<?> compClass = Class.forName(compClassName);
                    return new CompareUtils.BytesComparator((RawComparator)compClass.newInstance());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to instantiate comparator: " + comparator + "(" + e.toString() + ")");
                }
            }
            throw new IllegalArgumentException("Unsupported comparator: " + comparator);
        }

        public void write(DataOutput out) throws IOException {
            API_VERSION.write(out);
            Utils.writeVLong(out, this.recordCount);
            Utils.writeString(out, this.strComparator);
        }

        public long getRecordCount() {
            return this.recordCount;
        }

        public void incRecordCount() {
            ++this.recordCount;
        }

        public boolean isSorted() {
            return !this.strComparator.isEmpty();
        }

        public String getComparatorString() {
            return this.strComparator;
        }

        public CompareUtils.BytesComparator getComparator() {
            return this.comparator;
        }

        public Utils.Version getVersion() {
            return this.version;
        }
    }

    @InterfaceStability.Evolving
    public static class Reader
    implements Closeable {
        final BCFile.Reader readerBCF;
        TFileIndex tfileIndex = null;
        final TFileMeta tfileMeta;
        final CompareUtils.BytesComparator comparator;
        private final Location begin;
        private final Location end;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Reader(FSDataInputStream fsdis, long fileLength, Configuration conf) throws IOException {
            this.readerBCF = new BCFile.Reader(fsdis, fileLength, conf);
            try (BCFile.Reader.BlockReader brMeta = this.readerBCF.getMetaBlock("TFile.meta");){
                this.tfileMeta = new TFileMeta(brMeta);
            }
            this.comparator = this.tfileMeta.getComparator();
            this.begin = new Location(0, 0L);
            this.end = new Location(this.readerBCF.getBlockCount(), 0L);
        }

        @Override
        public void close() throws IOException {
            this.readerBCF.close();
        }

        Location begin() {
            return this.begin;
        }

        Location end() {
            return this.end;
        }

        public String getComparatorName() {
            return this.tfileMeta.getComparatorString();
        }

        public boolean isSorted() {
            return this.tfileMeta.isSorted();
        }

        public long getEntryCount() {
            return this.tfileMeta.getRecordCount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void checkTFileDataIndex() throws IOException {
            if (this.tfileIndex == null) {
                try (BCFile.Reader.BlockReader brIndex = this.readerBCF.getMetaBlock("TFile.index");){
                    this.tfileIndex = new TFileIndex(this.readerBCF.getBlockCount(), brIndex, this.tfileMeta.getComparator());
                }
            }
        }

        public RawComparable getFirstKey() throws IOException {
            this.checkTFileDataIndex();
            return this.tfileIndex.getFirstKey();
        }

        public RawComparable getLastKey() throws IOException {
            this.checkTFileDataIndex();
            return this.tfileIndex.getLastKey();
        }

        public Comparator<Scanner.Entry> getEntryComparator() {
            if (!this.isSorted()) {
                throw new RuntimeException("Entries are not comparable for unsorted TFiles");
            }
            return new Comparator<Scanner.Entry>(){

                @Override
                public int compare(Scanner.Entry o1, Scanner.Entry o2) {
                    return Reader.this.comparator.compare(o1.getKeyBuffer(), 0, o1.getKeyLength(), o2.getKeyBuffer(), 0, o2.getKeyLength());
                }
            };
        }

        public Comparator<RawComparable> getComparator() {
            return this.comparator;
        }

        public DataInputStream getMetaBlock(String name) throws IOException, MetaBlockDoesNotExist {
            return this.readerBCF.getMetaBlock(name);
        }

        Location getBlockContainsKey(RawComparable key, boolean greater2) throws IOException {
            int blkIndex;
            if (!this.isSorted()) {
                throw new RuntimeException("Seeking in unsorted TFile");
            }
            this.checkTFileDataIndex();
            int n = blkIndex = greater2 ? this.tfileIndex.upperBound(key) : this.tfileIndex.lowerBound(key);
            if (blkIndex < 0) {
                return this.end;
            }
            return new Location(blkIndex, 0L);
        }

        Location getLocationByRecordNum(long recNum) throws IOException {
            this.checkTFileDataIndex();
            return this.tfileIndex.getLocationByRecordNum(recNum);
        }

        long getRecordNumByLocation(Location location) throws IOException {
            this.checkTFileDataIndex();
            return this.tfileIndex.getRecordNumByLocation(location);
        }

        int compareKeys(byte[] a, int o1, int l1, byte[] b, int o2, int l2) {
            if (!this.isSorted()) {
                throw new RuntimeException("Cannot compare keys for unsorted TFiles.");
            }
            return this.comparator.compare(a, o1, l1, b, o2, l2);
        }

        int compareKeys(RawComparable a, RawComparable b) {
            if (!this.isSorted()) {
                throw new RuntimeException("Cannot compare keys for unsorted TFiles.");
            }
            return this.comparator.compare(a, b);
        }

        Location getLocationNear(long offset2) {
            int blockIndex = this.readerBCF.getBlockIndexNear(offset2);
            if (blockIndex == -1) {
                return this.end;
            }
            return new Location(blockIndex, 0L);
        }

        public long getRecordNumNear(long offset2) throws IOException {
            return this.getRecordNumByLocation(this.getLocationNear(offset2));
        }

        public RawComparable getKeyNear(long offset2) throws IOException {
            int blockIndex = this.readerBCF.getBlockIndexNear(offset2);
            if (blockIndex == -1) {
                return null;
            }
            this.checkTFileDataIndex();
            return new ByteArray(this.tfileIndex.getEntry((int)blockIndex).key);
        }

        public Scanner createScanner() throws IOException {
            return new Scanner(this, this.begin, this.end);
        }

        public Scanner createScannerByByteRange(long offset2, long length) throws IOException {
            return new Scanner(this, offset2, offset2 + length);
        }

        @Deprecated
        public Scanner createScanner(byte[] beginKey, byte[] endKey) throws IOException {
            return this.createScannerByKey(beginKey, endKey);
        }

        public Scanner createScannerByKey(byte[] beginKey, byte[] endKey) throws IOException {
            return this.createScannerByKey(beginKey == null ? null : new ByteArray(beginKey, 0, beginKey.length), endKey == null ? null : new ByteArray(endKey, 0, endKey.length));
        }

        @Deprecated
        public Scanner createScanner(RawComparable beginKey, RawComparable endKey) throws IOException {
            return this.createScannerByKey(beginKey, endKey);
        }

        public Scanner createScannerByKey(RawComparable beginKey, RawComparable endKey) throws IOException {
            if (beginKey != null && endKey != null && this.compareKeys(beginKey, endKey) >= 0) {
                return new Scanner(this, beginKey, beginKey);
            }
            return new Scanner(this, beginKey, endKey);
        }

        public Scanner createScannerByRecordNum(long beginRecNum, long endRecNum) throws IOException {
            if (beginRecNum < 0L) {
                beginRecNum = 0L;
            }
            if (endRecNum < 0L || endRecNum > this.getEntryCount()) {
                endRecNum = this.getEntryCount();
            }
            return new Scanner(this, this.getLocationByRecordNum(beginRecNum), this.getLocationByRecordNum(endRecNum));
        }

        long getBlockEntryCount(int curBid) {
            return this.tfileIndex.getEntry(curBid).entries();
        }

        BCFile.Reader.BlockReader getBlockReader(int blockIndex) throws IOException {
            return this.readerBCF.getDataBlock(blockIndex);
        }

        public static class Scanner
        implements Closeable {
            final Reader reader;
            private BCFile.Reader.BlockReader blkReader;
            Location beginLocation;
            Location endLocation;
            Location currentLocation;
            boolean valueChecked = false;
            final byte[] keyBuffer;
            int klen = -1;
            static final int MAX_VAL_TRANSFER_BUF_SIZE = 131072;
            BytesWritable valTransferBuffer;
            DataInputBuffer keyDataInputStream;
            Chunk.ChunkDecoder valueBufferInputStream;
            DataInputStream valueDataInputStream;
            int vlen;

            protected Scanner(Reader reader, long offBegin, long offEnd) throws IOException {
                this(reader, reader.getLocationNear(offBegin), reader.getLocationNear(offEnd));
            }

            Scanner(Reader reader, Location begin, Location end) throws IOException {
                this.reader = reader;
                reader.checkTFileDataIndex();
                this.beginLocation = begin;
                this.endLocation = end;
                this.valTransferBuffer = new BytesWritable();
                this.keyBuffer = new byte[65536];
                this.keyDataInputStream = new DataInputBuffer();
                this.valueBufferInputStream = new Chunk.ChunkDecoder();
                this.valueDataInputStream = new DataInputStream(this.valueBufferInputStream);
                if (this.beginLocation.compareTo(this.endLocation) >= 0) {
                    this.currentLocation = new Location(this.endLocation);
                } else {
                    this.currentLocation = new Location(0, 0L);
                    this.initBlock(this.beginLocation.getBlockIndex());
                    this.inBlockAdvance(this.beginLocation.getRecordIndex());
                }
            }

            protected Scanner(Reader reader, RawComparable beginKey, RawComparable endKey) throws IOException {
                this(reader, beginKey == null ? reader.begin() : reader.getBlockContainsKey(beginKey, false), reader.end());
                if (beginKey != null) {
                    this.inBlockAdvance(beginKey, false);
                    this.beginLocation.set(this.currentLocation);
                }
                if (endKey != null) {
                    this.seekTo(endKey, false);
                    this.endLocation.set(this.currentLocation);
                    this.seekTo(this.beginLocation);
                }
            }

            public boolean seekTo(byte[] key) throws IOException {
                return this.seekTo(key, 0, key.length);
            }

            public boolean seekTo(byte[] key, int keyOffset, int keyLen) throws IOException {
                return this.seekTo(new ByteArray(key, keyOffset, keyLen), false);
            }

            private boolean seekTo(RawComparable key, boolean beyond) throws IOException {
                Location l = this.reader.getBlockContainsKey(key, beyond);
                if (l.compareTo(this.beginLocation) < 0) {
                    l = this.beginLocation;
                } else if (l.compareTo(this.endLocation) >= 0) {
                    this.seekTo(this.endLocation);
                    return false;
                }
                if (this.atEnd() || l.getBlockIndex() != this.currentLocation.getBlockIndex() || this.compareCursorKeyTo(key) >= 0) {
                    this.seekTo(l);
                }
                return this.inBlockAdvance(key, beyond);
            }

            private void seekTo(Location l) throws IOException {
                if (l.compareTo(this.beginLocation) < 0) {
                    throw new IllegalArgumentException("Attempt to seek before the begin location.");
                }
                if (l.compareTo(this.endLocation) > 0) {
                    throw new IllegalArgumentException("Attempt to seek after the end location.");
                }
                if (l.compareTo(this.endLocation) == 0) {
                    this.parkCursorAtEnd();
                    return;
                }
                if (l.getBlockIndex() != this.currentLocation.getBlockIndex()) {
                    this.initBlock(l.getBlockIndex());
                } else {
                    if (this.valueChecked) {
                        this.inBlockAdvance(1L);
                    }
                    if (l.getRecordIndex() < this.currentLocation.getRecordIndex()) {
                        this.initBlock(l.getBlockIndex());
                    }
                }
                this.inBlockAdvance(l.getRecordIndex() - this.currentLocation.getRecordIndex());
            }

            public void rewind() throws IOException {
                this.seekTo(this.beginLocation);
            }

            public void seekToEnd() throws IOException {
                this.parkCursorAtEnd();
            }

            public void lowerBound(byte[] key) throws IOException {
                this.lowerBound(key, 0, key.length);
            }

            public void lowerBound(byte[] key, int keyOffset, int keyLen) throws IOException {
                this.seekTo(new ByteArray(key, keyOffset, keyLen), false);
            }

            public void upperBound(byte[] key) throws IOException {
                this.upperBound(key, 0, key.length);
            }

            public void upperBound(byte[] key, int keyOffset, int keyLen) throws IOException {
                this.seekTo(new ByteArray(key, keyOffset, keyLen), true);
            }

            public boolean advance() throws IOException {
                long entriesInBlock;
                if (this.atEnd()) {
                    return false;
                }
                int curBid = this.currentLocation.getBlockIndex();
                long curRid = this.currentLocation.getRecordIndex();
                if (curRid + 1L >= (entriesInBlock = this.reader.getBlockEntryCount(curBid))) {
                    if (this.endLocation.compareTo(curBid + 1, 0L) <= 0) {
                        this.parkCursorAtEnd();
                    } else {
                        this.initBlock(curBid + 1);
                    }
                } else {
                    this.inBlockAdvance(1L);
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void initBlock(int blockIndex) throws IOException {
                this.klen = -1;
                if (this.blkReader != null) {
                    try {
                        this.blkReader.close();
                    }
                    finally {
                        this.blkReader = null;
                    }
                }
                this.blkReader = this.reader.getBlockReader(blockIndex);
                this.currentLocation.set(blockIndex, 0L);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void parkCursorAtEnd() throws IOException {
                this.klen = -1;
                this.currentLocation.set(this.endLocation);
                if (this.blkReader != null) {
                    try {
                        this.blkReader.close();
                    }
                    finally {
                        this.blkReader = null;
                    }
                }
            }

            @Override
            public void close() throws IOException {
                this.parkCursorAtEnd();
            }

            public boolean atEnd() {
                return this.currentLocation.compareTo(this.endLocation) >= 0;
            }

            void checkKey() throws IOException {
                if (this.klen >= 0) {
                    return;
                }
                if (this.atEnd()) {
                    throw new EOFException("No key-value to read");
                }
                this.klen = -1;
                this.vlen = -1;
                this.valueChecked = false;
                this.klen = Utils.readVInt(this.blkReader);
                this.blkReader.readFully(this.keyBuffer, 0, this.klen);
                this.valueBufferInputStream.reset(this.blkReader);
                if (this.valueBufferInputStream.isLastChunk()) {
                    this.vlen = this.valueBufferInputStream.getRemain();
                }
            }

            public Entry entry() throws IOException {
                this.checkKey();
                return new Entry();
            }

            public long getRecordNum() throws IOException {
                return this.reader.getRecordNumByLocation(this.currentLocation);
            }

            int compareCursorKeyTo(RawComparable other) throws IOException {
                this.checkKey();
                return this.reader.compareKeys(this.keyBuffer, 0, this.klen, other.buffer(), other.offset(), other.size());
            }

            private void inBlockAdvance(long n) throws IOException {
                for (long i = 0L; i < n; ++i) {
                    this.checkKey();
                    if (!this.valueBufferInputStream.isClosed()) {
                        this.valueBufferInputStream.close();
                    }
                    this.klen = -1;
                    this.currentLocation.incRecordIndex();
                }
            }

            private boolean inBlockAdvance(RawComparable key, boolean greater2) throws IOException {
                int curBid = this.currentLocation.getBlockIndex();
                long entryInBlock = this.reader.getBlockEntryCount(curBid);
                if (curBid == this.endLocation.getBlockIndex()) {
                    entryInBlock = this.endLocation.getRecordIndex();
                }
                while (this.currentLocation.getRecordIndex() < entryInBlock) {
                    int cmp = this.compareCursorKeyTo(key);
                    if (cmp > 0) {
                        return false;
                    }
                    if (cmp == 0 && !greater2) {
                        return true;
                    }
                    if (!this.valueBufferInputStream.isClosed()) {
                        this.valueBufferInputStream.close();
                    }
                    this.klen = -1;
                    this.currentLocation.incRecordIndex();
                }
                throw new RuntimeException("Cannot find matching key in block.");
            }

            public class Entry
            implements Comparable<RawComparable> {
                public int getKeyLength() {
                    return Scanner.this.klen;
                }

                byte[] getKeyBuffer() {
                    return Scanner.this.keyBuffer;
                }

                public void get(BytesWritable key, BytesWritable value2) throws IOException {
                    this.getKey(key);
                    this.getValue(value2);
                }

                public int getKey(BytesWritable key) throws IOException {
                    key.setSize(this.getKeyLength());
                    this.getKey(key.getBytes());
                    return key.getLength();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public long getValue(BytesWritable value2) throws IOException {
                    int size2 = 0;
                    try (DataInputStream dis = this.getValueStream();){
                        int remain;
                        while ((remain = Scanner.this.valueBufferInputStream.getRemain()) > 0) {
                            value2.setSize(size2 + remain);
                            dis.readFully(value2.getBytes(), size2, remain);
                            size2 += remain;
                        }
                        long l = value2.getLength();
                        return l;
                    }
                }

                public int writeKey(OutputStream out) throws IOException {
                    out.write(Scanner.this.keyBuffer, 0, Scanner.this.klen);
                    return Scanner.this.klen;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public long writeValue(OutputStream out) throws IOException {
                    long size2 = 0L;
                    try (DataInputStream dis = this.getValueStream();){
                        int chunkSize;
                        while ((chunkSize = Scanner.this.valueBufferInputStream.getRemain()) > 0) {
                            chunkSize = Math.min(chunkSize, 131072);
                            Scanner.this.valTransferBuffer.setSize(chunkSize);
                            dis.readFully(Scanner.this.valTransferBuffer.getBytes(), 0, chunkSize);
                            out.write(Scanner.this.valTransferBuffer.getBytes(), 0, chunkSize);
                            size2 += (long)chunkSize;
                        }
                        long l = size2;
                        return l;
                    }
                }

                public int getKey(byte[] buf) throws IOException {
                    return this.getKey(buf, 0);
                }

                public int getKey(byte[] buf, int offset2) throws IOException {
                    if ((offset2 | buf.length - offset2 - Scanner.this.klen) < 0) {
                        throw new IndexOutOfBoundsException("Buffer not enough to store the key");
                    }
                    System.arraycopy(Scanner.this.keyBuffer, 0, buf, offset2, Scanner.this.klen);
                    return Scanner.this.klen;
                }

                public DataInputStream getKeyStream() {
                    Scanner.this.keyDataInputStream.reset(Scanner.this.keyBuffer, Scanner.this.klen);
                    return Scanner.this.keyDataInputStream;
                }

                public int getValueLength() {
                    if (Scanner.this.vlen >= 0) {
                        return Scanner.this.vlen;
                    }
                    throw new RuntimeException("Value length unknown.");
                }

                public int getValue(byte[] buf) throws IOException {
                    return this.getValue(buf, 0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public int getValue(byte[] buf, int offset2) throws IOException {
                    try (DataInputStream dis = this.getValueStream();){
                        int nextOffset2;
                        int n;
                        if (this.isValueLengthKnown()) {
                            if ((offset2 | buf.length - offset2 - Scanner.this.vlen) < 0) {
                                throw new IndexOutOfBoundsException("Buffer too small to hold value");
                            }
                            dis.readFully(buf, offset2, Scanner.this.vlen);
                            int n2 = Scanner.this.vlen;
                            return n2;
                        }
                        for (nextOffset2 = offset2; nextOffset2 < buf.length && (n = dis.read(buf, nextOffset2, buf.length - nextOffset2)) >= 0; nextOffset2 += n) {
                        }
                        if (dis.read() >= 0) {
                            throw new IndexOutOfBoundsException("Buffer too small to hold value");
                        }
                        int n3 = nextOffset2 - offset2;
                        return n3;
                    }
                }

                public DataInputStream getValueStream() throws IOException {
                    if (Scanner.this.valueChecked) {
                        throw new IllegalStateException("Attempt to examine value multiple times.");
                    }
                    Scanner.this.valueChecked = true;
                    return Scanner.this.valueDataInputStream;
                }

                public boolean isValueLengthKnown() {
                    return Scanner.this.vlen >= 0;
                }

                @Override
                public int compareTo(byte[] buf) {
                    return this.compareTo(buf, 0, buf.length);
                }

                public int compareTo(byte[] buf, int offset2, int length) {
                    return this.compareTo(new ByteArray(buf, offset2, length));
                }

                @Override
                public int compareTo(RawComparable key) {
                    return Scanner.this.reader.compareKeys(Scanner.this.keyBuffer, 0, this.getKeyLength(), key.buffer(), key.offset(), key.size());
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Entry)) {
                        return false;
                    }
                    return ((Entry)other).compareTo(Scanner.this.keyBuffer, 0, this.getKeyLength()) == 0;
                }

                public int hashCode() {
                    return WritableComparator.hashBytes(Scanner.this.keyBuffer, 0, this.getKeyLength());
                }
            }
        }

        static final class Location
        implements Comparable<Location>,
        Cloneable {
            private int blockIndex;
            private long recordIndex;

            Location(int blockIndex, long recordIndex) {
                this.set(blockIndex, recordIndex);
            }

            void incRecordIndex() {
                ++this.recordIndex;
            }

            Location(Location other) {
                this.set(other);
            }

            int getBlockIndex() {
                return this.blockIndex;
            }

            long getRecordIndex() {
                return this.recordIndex;
            }

            void set(int blockIndex, long recordIndex) {
                if (((long)blockIndex | recordIndex) < 0L) {
                    throw new IllegalArgumentException("Illegal parameter for BlockLocation.");
                }
                this.blockIndex = blockIndex;
                this.recordIndex = recordIndex;
            }

            void set(Location other) {
                this.set(other.blockIndex, other.recordIndex);
            }

            @Override
            public int compareTo(Location other) {
                return this.compareTo(other.blockIndex, other.recordIndex);
            }

            int compareTo(int bid, long rid) {
                if (this.blockIndex == bid) {
                    long ret = this.recordIndex - rid;
                    if (ret > 0L) {
                        return 1;
                    }
                    if (ret < 0L) {
                        return -1;
                    }
                    return 0;
                }
                return this.blockIndex - bid;
            }

            protected Location clone() {
                return new Location(this.blockIndex, this.recordIndex);
            }

            public int hashCode() {
                int prime = 31;
                int result2 = 31 + this.blockIndex;
                result2 = (int)((long)(31 * result2) + this.recordIndex);
                return result2;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Location other = (Location)obj;
                if (this.blockIndex != other.blockIndex) {
                    return false;
                }
                return this.recordIndex == other.recordIndex;
            }
        }
    }

    @InterfaceStability.Evolving
    public static class Writer
    implements Closeable {
        private final int sizeMinBlock;
        final TFileIndex tfileIndex;
        final TFileMeta tfileMeta;
        private BCFile.Writer writerBCF;
        BCFile.Writer.BlockAppender blkAppender;
        long blkRecordCount;
        BoundedByteArrayOutputStream currentKeyBufferOS;
        BoundedByteArrayOutputStream lastKeyBufferOS;
        private byte[] valueBuffer;
        State state = State.READY;
        Configuration conf;
        long errorCount = 0L;

        public Writer(FSDataOutputStream fsdos, int minBlockSize, String compressName, String comparator, Configuration conf) throws IOException {
            this.sizeMinBlock = minBlockSize;
            this.tfileMeta = new TFileMeta(comparator);
            this.tfileIndex = new TFileIndex(this.tfileMeta.getComparator());
            this.writerBCF = new BCFile.Writer(fsdos, compressName, conf);
            this.currentKeyBufferOS = new BoundedByteArrayOutputStream(65536);
            this.lastKeyBufferOS = new BoundedByteArrayOutputStream(65536);
            this.conf = conf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            block10: {
                if (this.state == State.CLOSED) {
                    return;
                }
                try {
                    if (this.errorCount != 0L) break block10;
                    if (this.state != State.READY) {
                        throw new IllegalStateException("Cannot close TFile in the middle of key-value insertion.");
                    }
                    this.finishDataBlock(true);
                    try (BCFile.Writer.BlockAppender outMeta = this.writerBCF.prepareMetaBlock("TFile.meta", TFile.COMPRESSION_NONE);){
                        this.tfileMeta.write(outMeta);
                    }
                    try (BCFile.Writer.BlockAppender outIndex = this.writerBCF.prepareMetaBlock("TFile.index");){
                        this.tfileIndex.write(outIndex);
                    }
                    this.writerBCF.close();
                }
                catch (Throwable throwable) {
                    IOUtils.cleanupWithLogger(LOG, this.blkAppender, this.writerBCF);
                    this.blkAppender = null;
                    this.writerBCF = null;
                    this.state = State.CLOSED;
                    throw throwable;
                }
            }
            IOUtils.cleanupWithLogger(LOG, this.blkAppender, this.writerBCF);
            this.blkAppender = null;
            this.writerBCF = null;
            this.state = State.CLOSED;
        }

        public void append(byte[] key, byte[] value2) throws IOException {
            this.append(key, 0, key.length, value2, 0, value2.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void append(byte[] key, int koff, int klen, byte[] value2, int voff, int vlen) throws IOException {
            if ((koff | klen | koff + klen | key.length - (koff + klen)) < 0) {
                throw new IndexOutOfBoundsException("Bad key buffer offset-length combination.");
            }
            if ((voff | vlen | voff + vlen | value2.length - (voff + vlen)) < 0) {
                throw new IndexOutOfBoundsException("Bad value buffer offset-length combination.");
            }
            try {
                try (DataOutputStream dosKey = this.prepareAppendKey(klen);){
                    ++this.errorCount;
                    dosKey.write(key, koff, klen);
                    --this.errorCount;
                }
                try (DataOutputStream dosValue = this.prepareAppendValue(vlen);){
                    ++this.errorCount;
                    dosValue.write(value2, voff, vlen);
                    --this.errorCount;
                }
            }
            finally {
                this.state = State.READY;
            }
        }

        public DataOutputStream prepareAppendKey(int length) throws IOException {
            if (this.state != State.READY) {
                throw new IllegalStateException("Incorrect state to start a new key: " + this.state.name());
            }
            this.initDataBlock();
            KeyRegister ret = new KeyRegister(length);
            this.state = State.IN_KEY;
            return ret;
        }

        public DataOutputStream prepareAppendValue(int length) throws IOException {
            ValueRegister ret;
            if (this.state != State.END_KEY) {
                throw new IllegalStateException("Incorrect state to start a new value: " + this.state.name());
            }
            if (length < 0) {
                if (this.valueBuffer == null) {
                    this.valueBuffer = new byte[TFile.getChunkBufferSize(this.conf)];
                }
                ret = new ValueRegister(new Chunk.ChunkEncoder(this.blkAppender, this.valueBuffer));
            } else {
                ret = new ValueRegister(new Chunk.SingleChunkEncoder(this.blkAppender, length));
            }
            this.state = State.IN_VALUE;
            return ret;
        }

        public DataOutputStream prepareMetaBlock(String name, String compressName) throws IOException, MetaBlockAlreadyExists {
            if (this.state != State.READY) {
                throw new IllegalStateException("Incorrect state to start a Meta Block: " + this.state.name());
            }
            this.finishDataBlock(true);
            BCFile.Writer.BlockAppender outputStream = this.writerBCF.prepareMetaBlock(name, compressName);
            return outputStream;
        }

        public DataOutputStream prepareMetaBlock(String name) throws IOException, MetaBlockAlreadyExists {
            if (this.state != State.READY) {
                throw new IllegalStateException("Incorrect state to start a Meta Block: " + this.state.name());
            }
            this.finishDataBlock(true);
            return this.writerBCF.prepareMetaBlock(name);
        }

        private void initDataBlock() throws IOException {
            if (this.blkAppender == null) {
                this.blkAppender = this.writerBCF.prepareDataBlock();
            }
        }

        void finishDataBlock(boolean bForceFinish) throws IOException {
            if (this.blkAppender == null) {
                return;
            }
            if (bForceFinish || this.blkAppender.getCompressedSize() >= (long)this.sizeMinBlock) {
                TFileIndexEntry keyLast = new TFileIndexEntry(this.lastKeyBufferOS.getBuffer(), 0, this.lastKeyBufferOS.size(), this.blkRecordCount);
                this.tfileIndex.addEntry(keyLast);
                this.blkAppender.close();
                this.blkAppender = null;
                this.blkRecordCount = 0L;
            }
        }

        private class ValueRegister
        extends DataOutputStream {
            private boolean closed;

            public ValueRegister(OutputStream os) {
                super(os);
                this.closed = false;
            }

            @Override
            public void flush() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                try {
                    ++Writer.this.errorCount;
                    super.close();
                    ++Writer.this.blkRecordCount;
                    Writer.this.tfileMeta.incRecordCount();
                    Writer.this.finishDataBlock(false);
                    --Writer.this.errorCount;
                }
                finally {
                    this.closed = true;
                    Writer.this.state = State.READY;
                }
            }
        }

        private class KeyRegister
        extends DataOutputStream {
            private final int expectedLength;
            private boolean closed;

            public KeyRegister(int len) {
                super(Writer.this.currentKeyBufferOS);
                this.closed = false;
                if (len >= 0) {
                    Writer.this.currentKeyBufferOS.reset(len);
                } else {
                    Writer.this.currentKeyBufferOS.reset();
                }
                this.expectedLength = len;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                try {
                    ++Writer.this.errorCount;
                    byte[] key = Writer.this.currentKeyBufferOS.getBuffer();
                    int len = Writer.this.currentKeyBufferOS.size();
                    if (this.expectedLength >= 0 && this.expectedLength != len) {
                        throw new IOException("Incorrect key length: expected=" + this.expectedLength + " actual=" + len);
                    }
                    Utils.writeVInt(Writer.this.blkAppender, len);
                    Writer.this.blkAppender.write(key, 0, len);
                    if (Writer.this.tfileIndex.getFirstKey() == null) {
                        Writer.this.tfileIndex.setFirstKey(key, 0, len);
                    }
                    if (Writer.this.tfileMeta.isSorted() && Writer.this.tfileMeta.getRecordCount() > 0L) {
                        byte[] lastKey = Writer.this.lastKeyBufferOS.getBuffer();
                        int lastLen = Writer.this.lastKeyBufferOS.size();
                        if (Writer.this.tfileMeta.getComparator().compare(key, 0, len, lastKey, 0, lastLen) < 0) {
                            throw new IOException("Keys are not added in sorted order");
                        }
                    }
                    BoundedByteArrayOutputStream tmp = Writer.this.currentKeyBufferOS;
                    Writer.this.currentKeyBufferOS = Writer.this.lastKeyBufferOS;
                    Writer.this.lastKeyBufferOS = tmp;
                    --Writer.this.errorCount;
                }
                finally {
                    this.closed = true;
                    Writer.this.state = State.END_KEY;
                }
            }
        }

        private static enum State {
            READY,
            IN_KEY,
            END_KEY,
            IN_VALUE,
            CLOSED;

        }
    }
}

