/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.jmx;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.http.HttpServer2;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXJsonServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(JMXJsonServlet.class);
    static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final long serialVersionUID = 1L;
    protected transient MBeanServer mBeanServer = null;

    @Override
    public void init() throws ServletException {
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    protected boolean isInstrumentationAccessAllowed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return HttpServer2.isInstrumentationAccessAllowed(this.getServletContext(), request, response);
    }

    @Override
    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        Object jsonpcb = null;
        try (PrintWriter writer = null;){
            ServletContext servletContext = this.getServletContext();
            if (!HttpServer2.isStaticUserAndNoneAuthType(servletContext, request) && !this.isInstrumentationAccessAllowed(request, response)) {
                return;
            }
            JsonGenerator jg = null;
            try {
                writer = response.getWriter();
                response.setContentType("application/json; charset=utf8");
                response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, "GET");
                response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
                JsonFactory jsonFactory = new JsonFactory();
                jg = jsonFactory.createJsonGenerator(writer);
                jg.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
                jg.useDefaultPrettyPrinter();
                jg.writeStartObject();
                if (this.mBeanServer == null) {
                    jg.writeStringField("result", "ERROR");
                    jg.writeStringField("message", "No MBeanServer could be found");
                    jg.close();
                    LOG.error("No MBeanServer could be found.");
                    response.setStatus(404);
                    return;
                }
                String getmethod = request.getParameter("get");
                if (getmethod != null) {
                    String[] splitStrings = getmethod.split("\\:\\:");
                    if (splitStrings.length != 2) {
                        jg.writeStringField("result", "ERROR");
                        jg.writeStringField("message", "query format is not as expected.");
                        jg.close();
                        response.setStatus(400);
                        return;
                    }
                    this.listBeans(jg, new ObjectName(splitStrings[0]), splitStrings[1], response);
                    jg.close();
                    return;
                }
                String qry = request.getParameter("qry");
                if (qry == null) {
                    qry = "*:*";
                }
                this.listBeans(jg, new ObjectName(qry), null, response);
                return;
            }
            finally {
                if (jg != null) {
                    jg.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    private void listBeans(JsonGenerator jg, ObjectName qry, String attribute, HttpServletResponse response) throws IOException {
        LOG.debug("Listing beans for " + qry);
        Set<ObjectName> names = null;
        names = this.mBeanServer.queryNames(qry, null);
        jg.writeArrayFieldStart("beans");
        for (ObjectName oname : names) {
            MBeanInfo minfo;
            String code = "";
            Object attributeinfo = null;
            try {
                minfo = this.mBeanServer.getMBeanInfo(oname);
                code = minfo.getClassName();
                String prs = "";
                try {
                    if ("org.apache.commons.modeler.BaseModelMBean".equals(code)) {
                        prs = "modelerType";
                        code = (String)this.mBeanServer.getAttribute(oname, prs);
                    }
                    if (attribute != null) {
                        prs = attribute;
                        attributeinfo = this.mBeanServer.getAttribute(oname, prs);
                    }
                }
                catch (AttributeNotFoundException e) {
                    LOG.error("getting attribute " + prs + " of " + oname + " threw an exception", e);
                }
                catch (MBeanException e) {
                    LOG.error("getting attribute " + prs + " of " + oname + " threw an exception", e);
                }
                catch (RuntimeException e) {
                    LOG.error("getting attribute " + prs + " of " + oname + " threw an exception", e);
                }
                catch (ReflectionException e) {
                    LOG.error("getting attribute " + prs + " of " + oname + " threw an exception", e);
                }
            }
            catch (InstanceNotFoundException e) {
                continue;
            }
            catch (IntrospectionException e) {
                LOG.error("Problem while trying to process JMX query: " + qry + " with MBean " + oname, e);
                continue;
            }
            catch (ReflectionException e) {
                LOG.error("Problem while trying to process JMX query: " + qry + " with MBean " + oname, e);
                continue;
            }
            jg.writeStartObject();
            jg.writeStringField("name", oname.toString());
            jg.writeStringField("modelerType", code);
            if (attribute != null && attributeinfo == null) {
                jg.writeStringField("result", "ERROR");
                jg.writeStringField("message", "No attribute with name " + attribute + " was found.");
                jg.writeEndObject();
                jg.writeEndArray();
                jg.close();
                response.setStatus(404);
                return;
            }
            if (attribute != null) {
                this.writeAttribute(jg, attribute, attributeinfo);
            } else {
                MBeanAttributeInfo[] attrs = minfo.getAttributes();
                for (int i = 0; i < attrs.length; ++i) {
                    this.writeAttribute(jg, oname, attrs[i]);
                }
            }
            jg.writeEndObject();
        }
        jg.writeEndArray();
    }

    private void writeAttribute(JsonGenerator jg, ObjectName oname, MBeanAttributeInfo attr) throws IOException {
        if (!attr.isReadable()) {
            return;
        }
        String attName = attr.getName();
        if ("modelerType".equals(attName)) {
            return;
        }
        if (attName.indexOf("=") >= 0 || attName.indexOf(":") >= 0 || attName.indexOf(" ") >= 0) {
            return;
        }
        Object value2 = null;
        try {
            value2 = this.mBeanServer.getAttribute(oname, attName);
        }
        catch (RuntimeMBeanException e) {
            if (e.getCause() instanceof UnsupportedOperationException) {
                LOG.debug("getting attribute " + attName + " of " + oname + " threw an exception", e);
            } else {
                LOG.error("getting attribute " + attName + " of " + oname + " threw an exception", e);
            }
            return;
        }
        catch (RuntimeErrorException e) {
            LOG.debug("getting attribute " + attName + " of " + oname + " threw an exception", e);
            return;
        }
        catch (AttributeNotFoundException e) {
            return;
        }
        catch (MBeanException e) {
            LOG.error("getting attribute " + attName + " of " + oname + " threw an exception", e);
            return;
        }
        catch (RuntimeException e) {
            LOG.error("getting attribute " + attName + " of " + oname + " threw an exception", e);
            return;
        }
        catch (ReflectionException e) {
            LOG.error("getting attribute " + attName + " of " + oname + " threw an exception", e);
            return;
        }
        catch (InstanceNotFoundException e) {
            return;
        }
        this.writeAttribute(jg, attName, value2);
    }

    private void writeAttribute(JsonGenerator jg, String attName, Object value2) throws IOException {
        jg.writeFieldName(attName);
        this.writeObject(jg, value2);
    }

    private void writeObject(JsonGenerator jg, Object value2) throws IOException {
        if (value2 == null) {
            jg.writeNull();
        } else {
            Class<?> c = value2.getClass();
            if (c.isArray()) {
                jg.writeStartArray();
                int len = Array.getLength(value2);
                for (int j = 0; j < len; ++j) {
                    Object item = Array.get(value2, j);
                    this.writeObject(jg, item);
                }
                jg.writeEndArray();
            } else if (value2 instanceof Number) {
                Number n = (Number)value2;
                jg.writeNumber(n.toString());
            } else if (value2 instanceof Boolean) {
                Boolean b = (Boolean)value2;
                jg.writeBoolean(b);
            } else if (value2 instanceof CompositeData) {
                CompositeData cds = (CompositeData)value2;
                CompositeType comp = cds.getCompositeType();
                Set<String> keys = comp.keySet();
                jg.writeStartObject();
                for (String key : keys) {
                    this.writeAttribute(jg, key, cds.get(key));
                }
                jg.writeEndObject();
            } else if (value2 instanceof TabularData) {
                TabularData tds = (TabularData)value2;
                jg.writeStartArray();
                for (Object entry2 : tds.values()) {
                    this.writeObject(jg, entry2);
                }
                jg.writeEndArray();
            } else {
                jg.writeString(value2.toString());
            }
        }
    }
}

