/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsTag;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MetricStringBuilder
extends MetricsRecordBuilder {
    private final StringBuilder builder = new StringBuilder(256);
    private final String prefix;
    private final String suffix;
    private final String separator;
    private final MetricsCollector parent;

    public MetricStringBuilder(MetricsCollector parent, String prefix, String separator, String suffix) {
        this.parent = parent;
        this.prefix = prefix;
        this.suffix = suffix;
        this.separator = separator;
    }

    public MetricStringBuilder add(MetricsInfo info, Object value2) {
        return this.tuple(info.name(), value2.toString());
    }

    public MetricStringBuilder tuple(String key, String value2) {
        this.builder.append(this.prefix).append(key).append(this.separator).append(value2).append(this.suffix);
        return this;
    }

    @Override
    public MetricsRecordBuilder tag(MetricsInfo info, String value2) {
        return this.add(info, value2);
    }

    @Override
    public MetricsRecordBuilder add(MetricsTag tag) {
        return this.tuple(tag.name(), tag.value());
    }

    @Override
    public MetricsRecordBuilder add(AbstractMetric metric) {
        this.add(metric.info(), metric.toString());
        return this;
    }

    @Override
    public MetricsRecordBuilder setContext(String value2) {
        return this.tuple("context", value2);
    }

    @Override
    public MetricsRecordBuilder addCounter(MetricsInfo info, int value2) {
        return this.add(info, value2);
    }

    @Override
    public MetricsRecordBuilder addCounter(MetricsInfo info, long value2) {
        return this.add(info, value2);
    }

    @Override
    public MetricsRecordBuilder addGauge(MetricsInfo info, int value2) {
        return this.add(info, value2);
    }

    @Override
    public MetricsRecordBuilder addGauge(MetricsInfo info, long value2) {
        return this.add(info, value2);
    }

    @Override
    public MetricsRecordBuilder addGauge(MetricsInfo info, float value2) {
        return this.add(info, Float.valueOf(value2));
    }

    @Override
    public MetricsRecordBuilder addGauge(MetricsInfo info, double value2) {
        return this.add(info, value2);
    }

    @Override
    public MetricsCollector parent() {
        return this.parent;
    }

    public String toString() {
        return this.builder.toString();
    }
}

