/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableGauge;

public class MutableGaugeFloat
extends MutableGauge {
    private AtomicInteger value = new AtomicInteger();

    MutableGaugeFloat(MetricsInfo info, float initValue) {
        super(info);
        this.value.set(Float.floatToIntBits(initValue));
    }

    public float value() {
        return Float.intBitsToFloat(this.value.get());
    }

    @Override
    public void incr() {
        this.incr(1.0f);
    }

    @Override
    public void decr() {
        this.incr(-1.0f);
    }

    @Override
    public void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            builder.addGauge(this.info(), this.value());
            this.clearChanged();
        }
    }

    public void set(float value2) {
        this.value.set(Float.floatToIntBits(value2));
        this.setChanged();
    }

    private final boolean compareAndSet(float expect, float update2) {
        return this.value.compareAndSet(Float.floatToIntBits(expect), Float.floatToIntBits(update2));
    }

    private void incr(float delta) {
        float next2;
        float current;
        while (!this.compareAndSet(current = (float)this.value.get(), next2 = current + delta)) {
        }
        this.setChanged();
    }
}

