/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;

public class AuthenticationFilterInitializer
extends FilterInitializer {
    static final String PREFIX = "hadoop.http.authentication.";

    @Override
    public void initFilter(FilterContainer container, Configuration conf) {
        Map<String, String> filterConfig = AuthenticationFilterInitializer.getFilterConfigMap(conf, PREFIX);
        container.addFilter("authentication", AuthenticationFilter.class.getName(), filterConfig);
    }

    public static Map<String, String> getFilterConfigMap(Configuration conf, String prefix) {
        HashMap<String, String> filterConfig = new HashMap<String, String>();
        filterConfig.put("cookie.path", "/");
        for (Map.Entry<String, String> entry2 : conf) {
            String name = entry2.getKey();
            if (!name.startsWith(prefix)) continue;
            String value2 = conf.get(name);
            name = name.substring(prefix.length());
            filterConfig.put(name, value2);
        }
        String bindAddress = conf.get("bind.address");
        String principal = (String)filterConfig.get("kerberos.principal");
        if (principal != null) {
            try {
                principal = SecurityUtil.getServerPrincipal(principal, bindAddress);
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not resolve Kerberos principal name: " + ex.toString(), ex);
            }
            filterConfig.put("kerberos.principal", principal);
        }
        return filterConfig;
    }
}

