/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.security.http.CrossOriginFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCrossOriginFilterInitializer
extends FilterInitializer {
    public static final String PREFIX = "hadoop.http.cross-origin.";
    public static final String ENABLED_SUFFIX = "enabled";
    private static final Logger LOG = LoggerFactory.getLogger(HttpCrossOriginFilterInitializer.class);

    @Override
    public void initFilter(FilterContainer container, Configuration conf) {
        String key = this.getEnabledConfigKey();
        boolean enabled = conf.getBoolean(key, false);
        if (enabled) {
            container.addGlobalFilter("Cross Origin Filter", CrossOriginFilter.class.getName(), HttpCrossOriginFilterInitializer.getFilterParameters(conf, this.getPrefix()));
        } else {
            LOG.info("CORS filter not enabled. Please set " + key + " to 'true' to enable it");
        }
    }

    protected static Map<String, String> getFilterParameters(Configuration conf, String prefix) {
        HashMap<String, String> filterParams = new HashMap<String, String>();
        for (Map.Entry<String, String> entry2 : conf.getValByRegex(prefix).entrySet()) {
            String name = entry2.getKey();
            String value2 = entry2.getValue();
            name = name.substring(prefix.length());
            filterParams.put(name, value2);
        }
        return filterParams;
    }

    protected String getPrefix() {
        return PREFIX;
    }

    protected String getEnabledConfigKey() {
        return this.getPrefix() + ENABLED_SUFFIX;
    }
}

