/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.SecureClientLoginConfiguration;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.util.StringUtils;

public class SecureClientLogin {
    private static final Log LOG = LogFactory.getLog(SecureClientLogin.class);
    public static final String HOSTNAME_PATTERN = "_HOST";

    public static synchronized Subject loginUserFromKeytab(String user, String path) throws IOException {
        try {
            Subject subject = new Subject();
            SecureClientLoginConfiguration loginConf = new SecureClientLoginConfiguration(true, user, path);
            LoginContext login = new LoginContext("hadoop-keytab-kerberos", subject, null, loginConf);
            subject.getPrincipals().add(new User(user, UserGroupInformation.AuthenticationMethod.KERBEROS, login));
            login.logout();
            login.login();
            return login.getSubject();
        }
        catch (LoginException le) {
            throw new IOException("Login failure for " + user + " from keytab " + path, le);
        }
    }

    public static synchronized Subject loginUserFromKeytab(String user, String path, String nameRules) throws IOException {
        try {
            Subject subject = new Subject();
            SecureClientLoginConfiguration loginConf = new SecureClientLoginConfiguration(true, user, path);
            LoginContext login = new LoginContext("hadoop-keytab-kerberos", subject, null, loginConf);
            KerberosName.setRules(nameRules);
            subject.getPrincipals().add(new User(user, UserGroupInformation.AuthenticationMethod.KERBEROS, login));
            login.logout();
            login.login();
            return login.getSubject();
        }
        catch (LoginException le) {
            throw new IOException("Login failure for " + user + " from keytab " + path, le);
        }
    }

    public static synchronized Subject loginUserWithPassword(String user, String password) throws IOException {
        try {
            Subject subject = new Subject();
            SecureClientLoginConfiguration loginConf = new SecureClientLoginConfiguration(false, user, password);
            LoginContext login = new LoginContext("hadoop-keytab-kerberos", subject, null, loginConf);
            subject.getPrincipals().add(new User(user, UserGroupInformation.AuthenticationMethod.KERBEROS, login));
            login.logout();
            login.login();
            return login.getSubject();
        }
        catch (LoginException le) {
            throw new IOException("Login failure for " + user + " using password ****", le);
        }
    }

    public static synchronized Subject login(String user) throws IOException {
        Subject subject = new Subject();
        subject.getPrincipals().add(new User(user));
        return subject;
    }

    public static Set<Principal> getUserPrincipals(Subject aSubject) {
        if (aSubject != null) {
            Set<User> list = aSubject.getPrincipals(User.class);
            if (list != null) {
                HashSet<Principal> ret = new HashSet<Principal>();
                ret.addAll(list);
                return ret;
            }
            return null;
        }
        return null;
    }

    public static Principal createUserPrincipal(String aLoginName) {
        return new User(aLoginName);
    }

    public static boolean isKerberosCredentialExists(String principal, String keytabPath) {
        boolean isValid = false;
        if (keytabPath != null && !keytabPath.isEmpty()) {
            File keytabFile = new File(keytabPath);
            if (!keytabFile.exists()) {
                LOG.warn(keytabPath + " doesn't exist.");
            } else if (!keytabFile.canRead()) {
                LOG.warn("Unable to read " + keytabPath + ". Please check the file access permissions for user");
            } else {
                isValid = true;
            }
        } else {
            LOG.warn("Can't find keyTab Path : " + keytabPath);
        }
        if (principal == null || principal.isEmpty() || !isValid) {
            isValid = false;
            LOG.warn("Can't find principal : " + principal);
        }
        return isValid;
    }

    public static String getPrincipal(String principalConfig, String hostName) throws IOException {
        String[] components = SecureClientLogin.getComponents(principalConfig);
        if (components == null || components.length != 3 || !HOSTNAME_PATTERN.equals(components[1])) {
            return principalConfig;
        }
        if (hostName == null) {
            throw new IOException("Can't replace _HOST pattern since client ranger.service.host is null");
        }
        return SecureClientLogin.replacePattern(components, hostName);
    }

    private static String[] getComponents(String principalConfig) {
        if (principalConfig == null) {
            return null;
        }
        return principalConfig.split("[/@]");
    }

    private static String replacePattern(String[] components, String hostname) throws IOException {
        String fqdn = hostname;
        if (fqdn == null || fqdn.isEmpty() || "0.0.0.0".equals(fqdn)) {
            fqdn = InetAddress.getLocalHost().getCanonicalHostName();
        }
        return components[0] + "/" + StringUtils.toLowerCase(fqdn) + "@" + components[2];
    }
}

