/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.alias;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.alias.CredentialProvider;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class CredentialProviderFactory {
    public static final String CREDENTIAL_PROVIDER_PATH = "hadoop.security.credential.provider.path";
    private static final ServiceLoader<CredentialProviderFactory> serviceLoader = ServiceLoader.load(CredentialProviderFactory.class, CredentialProviderFactory.class.getClassLoader());

    public abstract CredentialProvider createProvider(URI var1, Configuration var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CredentialProvider> getProviders(Configuration conf) throws IOException {
        ArrayList<CredentialProvider> result2 = new ArrayList<CredentialProvider>();
        for (String path : conf.getStringCollection(CREDENTIAL_PROVIDER_PATH)) {
            try {
                URI uri = new URI(path);
                boolean found = false;
                ServiceLoader<CredentialProviderFactory> serviceLoader = CredentialProviderFactory.serviceLoader;
                synchronized (serviceLoader) {
                    for (CredentialProviderFactory factory : CredentialProviderFactory.serviceLoader) {
                        CredentialProvider kp = factory.createProvider(uri, conf);
                        if (kp == null) continue;
                        result2.add(kp);
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                throw new IOException("No CredentialProviderFactory for " + uri + " in " + CREDENTIAL_PROVIDER_PATH);
            }
            catch (URISyntaxException error) {
                throw new IOException("Bad configuration of hadoop.security.credential.provider.path at " + path, error);
            }
        }
        return result2;
    }

    static {
        Iterator<CredentialProviderFactory> iterServices = serviceLoader.iterator();
        while (iterServices.hasNext()) {
            iterServices.next();
        }
    }
}

