/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import com.google.protobuf.ByteString;
import java.io.DataInput;
import java.io.IOException;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.protobuf.IpcConnectionContextProtos;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.htrace.core.Span;
import org.apache.htrace.core.Tracer;

public abstract class ProtoUtil {
    public static int readRawVarint32(DataInput in) throws IOException {
        byte tmp = in.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result2 = tmp & 0x7F;
        tmp = in.readByte();
        if (tmp >= 0) {
            result2 |= tmp << 7;
        } else {
            result2 |= (tmp & 0x7F) << 7;
            tmp = in.readByte();
            if (tmp >= 0) {
                result2 |= tmp << 14;
            } else {
                result2 |= (tmp & 0x7F) << 14;
                tmp = in.readByte();
                if (tmp >= 0) {
                    result2 |= tmp << 21;
                } else {
                    result2 |= (tmp & 0x7F) << 21;
                    tmp = in.readByte();
                    result2 |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (in.readByte() < 0) continue;
                            return result2;
                        }
                        throw new IOException("Malformed varint");
                    }
                }
            }
        }
        return result2;
    }

    public static IpcConnectionContextProtos.IpcConnectionContextProto makeIpcConnectionContext(String protocol, UserGroupInformation ugi, SaslRpcServer.AuthMethod authMethod) {
        IpcConnectionContextProtos.IpcConnectionContextProto.Builder result2 = IpcConnectionContextProtos.IpcConnectionContextProto.newBuilder();
        if (protocol != null) {
            result2.setProtocol(protocol);
        }
        IpcConnectionContextProtos.UserInformationProto.Builder ugiProto = IpcConnectionContextProtos.UserInformationProto.newBuilder();
        if (ugi != null) {
            if (authMethod == SaslRpcServer.AuthMethod.KERBEROS) {
                ugiProto.setEffectiveUser(ugi.getUserName());
            } else if (authMethod != SaslRpcServer.AuthMethod.TOKEN) {
                ugiProto.setEffectiveUser(ugi.getUserName());
                if (ugi.getRealUser() != null) {
                    ugiProto.setRealUser(ugi.getRealUser().getUserName());
                }
            }
        }
        result2.setUserInfo(ugiProto);
        return result2.build();
    }

    public static UserGroupInformation getUgi(IpcConnectionContextProtos.IpcConnectionContextProto context) {
        if (context.hasUserInfo()) {
            IpcConnectionContextProtos.UserInformationProto userInfo = context.getUserInfo();
            return ProtoUtil.getUgi(userInfo);
        }
        return null;
    }

    public static UserGroupInformation getUgi(IpcConnectionContextProtos.UserInformationProto userInfo) {
        String realUser;
        UserGroupInformation ugi = null;
        String effectiveUser = userInfo.hasEffectiveUser() ? userInfo.getEffectiveUser() : null;
        String string2 = realUser = userInfo.hasRealUser() ? userInfo.getRealUser() : null;
        if (effectiveUser != null) {
            if (realUser != null) {
                UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser(realUser);
                ugi = UserGroupInformation.createProxyUser(effectiveUser, realUserUgi);
            } else {
                ugi = UserGroupInformation.createRemoteUser(effectiveUser);
            }
        }
        return ugi;
    }

    static RpcHeaderProtos.RpcKindProto convert(RPC.RpcKind kind) {
        switch (kind) {
            case RPC_BUILTIN: {
                return RpcHeaderProtos.RpcKindProto.RPC_BUILTIN;
            }
            case RPC_WRITABLE: {
                return RpcHeaderProtos.RpcKindProto.RPC_WRITABLE;
            }
            case RPC_PROTOCOL_BUFFER: {
                return RpcHeaderProtos.RpcKindProto.RPC_PROTOCOL_BUFFER;
            }
        }
        return null;
    }

    public static RPC.RpcKind convert(RpcHeaderProtos.RpcKindProto kind) {
        switch (kind) {
            case RPC_BUILTIN: {
                return RPC.RpcKind.RPC_BUILTIN;
            }
            case RPC_WRITABLE: {
                return RPC.RpcKind.RPC_WRITABLE;
            }
            case RPC_PROTOCOL_BUFFER: {
                return RPC.RpcKind.RPC_PROTOCOL_BUFFER;
            }
        }
        return null;
    }

    public static RpcHeaderProtos.RpcRequestHeaderProto makeRpcRequestHeader(RPC.RpcKind rpcKind, RpcHeaderProtos.RpcRequestHeaderProto.OperationProto operation, int callId, int retryCount, byte[] uuid) {
        CallerContext callerContext;
        RpcHeaderProtos.RpcRequestHeaderProto.Builder result2 = RpcHeaderProtos.RpcRequestHeaderProto.newBuilder();
        result2.setRpcKind(ProtoUtil.convert(rpcKind)).setRpcOp(operation).setCallId(callId).setRetryCount(retryCount).setClientId(ByteString.copyFrom(uuid));
        Span span2 = Tracer.getCurrentSpan();
        if (span2 != null) {
            result2.setTraceInfo(RpcHeaderProtos.RPCTraceInfoProto.newBuilder().setTraceId(span2.getSpanId().getHigh()).setParentId(span2.getSpanId().getLow()).build());
        }
        if ((callerContext = CallerContext.getCurrent()) != null && callerContext.isContextValid()) {
            RpcHeaderProtos.RPCCallerContextProto.Builder contextBuilder = RpcHeaderProtos.RPCCallerContextProto.newBuilder().setContext(callerContext.getContext());
            if (callerContext.getSignature() != null) {
                contextBuilder.setSignature(ByteString.copyFrom(callerContext.getSignature()));
            }
            result2.setCallerContext(contextBuilder);
        }
        return result2.build();
    }
}

