/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.htrace.core.SpanId;
import org.apache.htrace.core.TimelineAnnotation;
import org.apache.htrace.shaded.fasterxml.jackson.core.JsonGenerator;
import org.apache.htrace.shaded.fasterxml.jackson.databind.JsonSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.SerializerProvider;
import org.apache.htrace.shaded.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonSerialize(using=SpanSerializer.class)
public interface Span {
    public void stop();

    public long getStartTimeMillis();

    public long getStopTimeMillis();

    public long getAccumulatedMillis();

    public boolean isRunning();

    public String getDescription();

    public SpanId getSpanId();

    @Deprecated
    public Span child(String var1);

    public String toString();

    public SpanId[] getParents();

    public void setParents(SpanId[] var1);

    public void addKVAnnotation(String var1, String var2);

    public void addTimelineAnnotation(String var1);

    public Map<String, String> getKVAnnotations();

    public List<TimelineAnnotation> getTimelineAnnotations();

    public String getTracerId();

    public void setTracerId(String var1);

    public String toJson();

    public static class SpanSerializer
    extends JsonSerializer<Span> {
        @Override
        public void serialize(Span span2, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            List<TimelineAnnotation> timelineAnnotations;
            String tracerId;
            jgen.writeStartObject();
            if (span2.getSpanId().isValid()) {
                jgen.writeStringField("a", span2.getSpanId().toString());
            }
            if (span2.getStartTimeMillis() != 0L) {
                jgen.writeNumberField("b", span2.getStartTimeMillis());
            }
            if (span2.getStopTimeMillis() != 0L) {
                jgen.writeNumberField("e", span2.getStopTimeMillis());
            }
            if (!span2.getDescription().isEmpty()) {
                jgen.writeStringField("d", span2.getDescription());
            }
            if (!(tracerId = span2.getTracerId()).isEmpty()) {
                jgen.writeStringField("r", tracerId);
            }
            jgen.writeArrayFieldStart("p");
            for (SpanId parent : span2.getParents()) {
                jgen.writeString(parent.toString());
            }
            jgen.writeEndArray();
            Map<String, String> traceInfoMap = span2.getKVAnnotations();
            if (!traceInfoMap.isEmpty()) {
                jgen.writeObjectFieldStart("n");
                Object[] keys = traceInfoMap.keySet().toArray(new String[traceInfoMap.size()]);
                Arrays.sort(keys);
                for (Object key : keys) {
                    jgen.writeStringField((String)key, traceInfoMap.get(key));
                }
                jgen.writeEndObject();
            }
            if (!(timelineAnnotations = span2.getTimelineAnnotations()).isEmpty()) {
                jgen.writeArrayFieldStart("t");
                for (TimelineAnnotation tl : timelineAnnotations) {
                    jgen.writeStartObject();
                    jgen.writeNumberField("t", tl.getTime());
                    jgen.writeStringField("m", tl.getMessage());
                    jgen.writeEndObject();
                }
                jgen.writeEndArray();
            }
            jgen.writeEndObject();
        }
    }
}

