/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.fasterxml.jackson.databind.deser.impl;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import org.apache.htrace.shaded.fasterxml.jackson.core.JsonParser;
import org.apache.htrace.shaded.fasterxml.jackson.core.JsonProcessingException;
import org.apache.htrace.shaded.fasterxml.jackson.databind.DeserializationContext;
import org.apache.htrace.shaded.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.PropertyName;
import org.apache.htrace.shaded.fasterxml.jackson.databind.deser.SettableBeanProperty;
import org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.AnnotatedMember;
import org.apache.htrace.shaded.fasterxml.jackson.databind.util.Annotations;

public final class ManagedReferenceProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final String _referenceName;
    protected final boolean _isContainer;
    protected final SettableBeanProperty _managedProperty;
    protected final SettableBeanProperty _backProperty;

    public ManagedReferenceProperty(SettableBeanProperty forward, String refName, SettableBeanProperty backward, Annotations contextAnnotations, boolean isContainer) {
        super(forward.getFullName(), forward.getType(), forward.getWrapperName(), forward.getValueTypeDeserializer(), contextAnnotations, forward.getMetadata());
        this._referenceName = refName;
        this._managedProperty = forward;
        this._backProperty = backward;
        this._isContainer = isContainer;
    }

    protected ManagedReferenceProperty(ManagedReferenceProperty src, JsonDeserializer<?> deser) {
        super((SettableBeanProperty)src, deser);
        this._referenceName = src._referenceName;
        this._isContainer = src._isContainer;
        this._managedProperty = src._managedProperty;
        this._backProperty = src._backProperty;
    }

    protected ManagedReferenceProperty(ManagedReferenceProperty src, PropertyName newName) {
        super((SettableBeanProperty)src, newName);
        this._referenceName = src._referenceName;
        this._isContainer = src._isContainer;
        this._managedProperty = src._managedProperty;
        this._backProperty = src._backProperty;
    }

    @Override
    public ManagedReferenceProperty withName(PropertyName newName) {
        return new ManagedReferenceProperty(this, newName);
    }

    @Override
    public ManagedReferenceProperty withValueDeserializer(JsonDeserializer<?> deser) {
        return new ManagedReferenceProperty(this, deser);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._managedProperty.getAnnotation(acls);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._managedProperty.getMember();
    }

    @Override
    public void deserializeAndSet(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException, JsonProcessingException {
        this.set(instance, this._managedProperty.deserialize(jp, ctxt));
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException, JsonProcessingException {
        return this.setAndReturn(instance, this.deserialize(jp, ctxt));
    }

    @Override
    public final void set(Object instance, Object value2) throws IOException {
        this.setAndReturn(instance, value2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object setAndReturn(Object instance, Object value2) throws IOException {
        if (value2 == null) return this._managedProperty.setAndReturn(instance, value2);
        if (this._isContainer) {
            if (value2 instanceof Object[]) {
                for (Object ob : (Object[])value2) {
                    if (ob == null) continue;
                    this._backProperty.set(ob, instance);
                }
                return this._managedProperty.setAndReturn(instance, value2);
            } else if (value2 instanceof Collection) {
                for (Object ob : (Collection)value2) {
                    if (ob == null) continue;
                    this._backProperty.set(ob, instance);
                }
                return this._managedProperty.setAndReturn(instance, value2);
            } else {
                if (!(value2 instanceof Map)) throw new IllegalStateException("Unsupported container type (" + value2.getClass().getName() + ") when resolving reference '" + this._referenceName + "'");
                for (Object ob : ((Map)value2).values()) {
                    if (ob == null) continue;
                    this._backProperty.set(ob, instance);
                }
            }
            return this._managedProperty.setAndReturn(instance, value2);
        } else {
            this._backProperty.set(value2, instance);
        }
        return this._managedProperty.setAndReturn(instance, value2);
    }
}

