/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.fasterxml.jackson.databind.jsontype.impl;

import java.io.IOException;
import org.apache.htrace.shaded.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.htrace.shaded.fasterxml.jackson.core.JsonGenerator;
import org.apache.htrace.shaded.fasterxml.jackson.databind.BeanProperty;
import org.apache.htrace.shaded.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import org.apache.htrace.shaded.fasterxml.jackson.databind.jsontype.impl.TypeSerializerBase;

public class AsWrapperTypeSerializer
extends TypeSerializerBase {
    public AsWrapperTypeSerializer(TypeIdResolver idRes, BeanProperty property) {
        super(idRes, property);
    }

    @Override
    public AsWrapperTypeSerializer forProperty(BeanProperty prop) {
        return this._property == prop ? this : new AsWrapperTypeSerializer(this._idResolver, prop);
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.WRAPPER_OBJECT;
    }

    @Override
    public void writeTypePrefixForObject(Object value2, JsonGenerator jgen) throws IOException {
        String typeId = this.idFromValue(value2);
        if (jgen.canWriteTypeId()) {
            jgen.writeTypeId(typeId);
            jgen.writeStartObject();
        } else {
            jgen.writeStartObject();
            jgen.writeObjectFieldStart(typeId);
        }
    }

    @Override
    public void writeTypePrefixForObject(Object value2, JsonGenerator jgen, Class<?> type) throws IOException {
        String typeId = this.idFromValueAndType(value2, type);
        if (jgen.canWriteTypeId()) {
            jgen.writeTypeId(typeId);
            jgen.writeStartObject();
        } else {
            jgen.writeStartObject();
            jgen.writeObjectFieldStart(typeId);
        }
    }

    @Override
    public void writeTypePrefixForArray(Object value2, JsonGenerator jgen) throws IOException {
        String typeId = this.idFromValue(value2);
        if (jgen.canWriteTypeId()) {
            jgen.writeTypeId(typeId);
            jgen.writeStartObject();
        } else {
            jgen.writeStartObject();
            jgen.writeArrayFieldStart(typeId);
        }
    }

    @Override
    public void writeTypePrefixForArray(Object value2, JsonGenerator jgen, Class<?> type) throws IOException {
        String typeId = this.idFromValueAndType(value2, type);
        if (jgen.canWriteTypeId()) {
            jgen.writeTypeId(typeId);
            jgen.writeStartObject();
        } else {
            jgen.writeStartObject();
            jgen.writeArrayFieldStart(typeId);
        }
    }

    @Override
    public void writeTypePrefixForScalar(Object value2, JsonGenerator jgen) throws IOException {
        String typeId = this.idFromValue(value2);
        if (jgen.canWriteTypeId()) {
            jgen.writeTypeId(typeId);
        } else {
            jgen.writeStartObject();
            jgen.writeFieldName(typeId);
        }
    }

    @Override
    public void writeTypePrefixForScalar(Object value2, JsonGenerator jgen, Class<?> type) throws IOException {
        String typeId = this.idFromValueAndType(value2, type);
        if (jgen.canWriteTypeId()) {
            jgen.writeTypeId(typeId);
        } else {
            jgen.writeStartObject();
            jgen.writeFieldName(typeId);
        }
    }

    @Override
    public void writeTypeSuffixForObject(Object value2, JsonGenerator jgen) throws IOException {
        jgen.writeEndObject();
        if (!jgen.canWriteTypeId()) {
            jgen.writeEndObject();
        }
    }

    @Override
    public void writeTypeSuffixForArray(Object value2, JsonGenerator jgen) throws IOException {
        jgen.writeEndArray();
        if (!jgen.canWriteTypeId()) {
            jgen.writeEndObject();
        }
    }

    @Override
    public void writeTypeSuffixForScalar(Object value2, JsonGenerator jgen) throws IOException {
        if (!jgen.canWriteTypeId()) {
            jgen.writeEndObject();
        }
    }

    @Override
    public void writeCustomTypePrefixForObject(Object value2, JsonGenerator jgen, String typeId) throws IOException {
        if (jgen.canWriteTypeId()) {
            jgen.writeTypeId(typeId);
            jgen.writeStartObject();
        } else {
            jgen.writeStartObject();
            jgen.writeObjectFieldStart(typeId);
        }
    }

    @Override
    public void writeCustomTypePrefixForArray(Object value2, JsonGenerator jgen, String typeId) throws IOException {
        if (jgen.canWriteTypeId()) {
            jgen.writeTypeId(typeId);
            jgen.writeStartArray();
        } else {
            jgen.writeStartObject();
            jgen.writeArrayFieldStart(typeId);
        }
    }

    @Override
    public void writeCustomTypePrefixForScalar(Object value2, JsonGenerator jgen, String typeId) throws IOException {
        if (jgen.canWriteTypeId()) {
            jgen.writeTypeId(typeId);
        } else {
            jgen.writeStartObject();
            jgen.writeFieldName(typeId);
        }
    }

    @Override
    public void writeCustomTypeSuffixForObject(Object value2, JsonGenerator jgen, String typeId) throws IOException {
        if (!jgen.canWriteTypeId()) {
            this.writeTypeSuffixForObject(value2, jgen);
        }
    }

    @Override
    public void writeCustomTypeSuffixForArray(Object value2, JsonGenerator jgen, String typeId) throws IOException {
        if (!jgen.canWriteTypeId()) {
            this.writeTypeSuffixForArray(value2, jgen);
        }
    }

    @Override
    public void writeCustomTypeSuffixForScalar(Object value2, JsonGenerator jgen, String typeId) throws IOException {
        if (!jgen.canWriteTypeId()) {
            this.writeTypeSuffixForScalar(value2, jgen);
        }
    }
}

