/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.fasterxml.jackson.databind.ser.impl;

import java.util.Map;
import org.apache.htrace.shaded.fasterxml.jackson.databind.JsonSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.SerializerCache;

public class JsonSerializerMap {
    private final Bucket[] _buckets;
    private final int _size;

    public JsonSerializerMap(Map<SerializerCache.TypeKey, JsonSerializer<Object>> serializers) {
        int size2;
        this._size = size2 = JsonSerializerMap.findSize(serializers.size());
        int hashMask = size2 - 1;
        Bucket[] buckets = new Bucket[size2];
        for (Map.Entry<SerializerCache.TypeKey, JsonSerializer<Object>> entry2 : serializers.entrySet()) {
            SerializerCache.TypeKey key = entry2.getKey();
            int index = key.hashCode() & hashMask;
            buckets[index] = new Bucket(buckets[index], key, entry2.getValue());
        }
        this._buckets = buckets;
    }

    private static final int findSize(int size2) {
        int result2;
        int needed = size2 <= 64 ? size2 + size2 : size2 + (size2 >> 2);
        for (result2 = 8; result2 < needed; result2 += result2) {
        }
        return result2;
    }

    public int size() {
        return this._size;
    }

    public JsonSerializer<Object> find(SerializerCache.TypeKey key) {
        int index = key.hashCode() & this._buckets.length - 1;
        Bucket bucket = this._buckets[index];
        if (bucket == null) {
            return null;
        }
        if (key.equals(bucket.key)) {
            return bucket.value;
        }
        while ((bucket = bucket.next) != null) {
            if (!key.equals(bucket.key)) continue;
            return bucket.value;
        }
        return null;
    }

    private static final class Bucket {
        public final SerializerCache.TypeKey key;
        public final JsonSerializer<Object> value;
        public final Bucket next;

        public Bucket(Bucket next2, SerializerCache.TypeKey key, JsonSerializer<Object> value2) {
            this.next = next2;
            this.key = key;
            this.value = value2;
        }
    }
}

