/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Map;
import org.apache.htrace.shaded.fasterxml.jackson.core.JsonGenerationException;
import org.apache.htrace.shaded.fasterxml.jackson.core.JsonGenerator;
import org.apache.htrace.shaded.fasterxml.jackson.core.SerializableString;
import org.apache.htrace.shaded.fasterxml.jackson.databind.BeanProperty;
import org.apache.htrace.shaded.fasterxml.jackson.databind.JavaType;
import org.apache.htrace.shaded.fasterxml.jackson.databind.JsonMappingException;
import org.apache.htrace.shaded.fasterxml.jackson.databind.JsonNode;
import org.apache.htrace.shaded.fasterxml.jackson.databind.JsonSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.SerializationFeature;
import org.apache.htrace.shaded.fasterxml.jackson.databind.SerializerProvider;
import org.apache.htrace.shaded.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.AnnotatedMember;
import org.apache.htrace.shaded.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.apache.htrace.shaded.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import org.apache.htrace.shaded.fasterxml.jackson.databind.jsonschema.JsonSchema;
import org.apache.htrace.shaded.fasterxml.jackson.databind.jsonschema.SchemaAware;
import org.apache.htrace.shaded.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.node.JsonNodeFactory;
import org.apache.htrace.shaded.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.ContainerSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.EnumSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.util.EnumValues;

@JacksonStdImpl
public class EnumMapSerializer
extends ContainerSerializer<EnumMap<? extends Enum<?>, ?>>
implements ContextualSerializer {
    protected final boolean _staticTyping;
    protected final BeanProperty _property;
    protected final EnumValues _keyEnums;
    protected final JavaType _valueType;
    protected final JsonSerializer<Object> _valueSerializer;
    protected final TypeSerializer _valueTypeSerializer;

    public EnumMapSerializer(JavaType valueType, boolean staticTyping, EnumValues keyEnums, TypeSerializer vts, JsonSerializer<Object> valueSerializer) {
        super(EnumMap.class, false);
        this._property = null;
        this._staticTyping = staticTyping || valueType != null && valueType.isFinal();
        this._valueType = valueType;
        this._keyEnums = keyEnums;
        this._valueTypeSerializer = vts;
        this._valueSerializer = valueSerializer;
    }

    public EnumMapSerializer(EnumMapSerializer src, BeanProperty property, JsonSerializer<?> ser) {
        super(src);
        this._property = property;
        this._staticTyping = src._staticTyping;
        this._valueType = src._valueType;
        this._keyEnums = src._keyEnums;
        this._valueTypeSerializer = src._valueTypeSerializer;
        this._valueSerializer = ser;
    }

    public EnumMapSerializer _withValueTypeSerializer(TypeSerializer vts) {
        return new EnumMapSerializer(this._valueType, this._staticTyping, this._keyEnums, vts, this._valueSerializer);
    }

    public EnumMapSerializer withValueSerializer(BeanProperty prop, JsonSerializer<?> ser) {
        if (this._property == prop && ser == this._valueSerializer) {
            return this;
        }
        return new EnumMapSerializer(this, prop, ser);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        Object serDef;
        AnnotatedMember m;
        JsonSerializer<Object> ser = null;
        if (property != null && (m = property.getMember()) != null && (serDef = provider.getAnnotationIntrospector().findContentSerializer(m)) != null) {
            ser = provider.serializerInstance(m, serDef);
        }
        if (ser == null) {
            ser = this._valueSerializer;
        }
        if ((ser = this.findConvertingContentSerializer(provider, property, ser)) == null) {
            if (this._staticTyping) {
                return this.withValueSerializer(property, provider.findValueSerializer(this._valueType, property));
            }
        } else {
            ser = provider.handleSecondaryContextualization(ser, property);
        }
        if (ser != this._valueSerializer) {
            return this.withValueSerializer(property, ser);
        }
        return this;
    }

    @Override
    public JavaType getContentType() {
        return this._valueType;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._valueSerializer;
    }

    @Override
    public boolean isEmpty(EnumMap<? extends Enum<?>, ?> value2) {
        return value2 == null || value2.isEmpty();
    }

    @Override
    public boolean hasSingleElement(EnumMap<? extends Enum<?>, ?> value2) {
        return value2.size() == 1;
    }

    @Override
    public void serialize(EnumMap<? extends Enum<?>, ?> value2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartObject();
        if (!value2.isEmpty()) {
            this.serializeContents(value2, jgen, provider);
        }
        jgen.writeEndObject();
    }

    @Override
    public void serializeWithType(EnumMap<? extends Enum<?>, ?> value2, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForObject(value2, jgen);
        if (!value2.isEmpty()) {
            this.serializeContents(value2, jgen, provider);
        }
        typeSer.writeTypeSuffixForObject(value2, jgen);
    }

    protected void serializeContents(EnumMap<? extends Enum<?>, ?> value2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._valueSerializer != null) {
            this.serializeContentsUsing(value2, jgen, provider, this._valueSerializer);
            return;
        }
        JsonSerializer<Object> prevSerializer = null;
        Class<?> prevClass = null;
        EnumValues keyEnums = this._keyEnums;
        boolean skipNulls = !provider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES);
        TypeSerializer vts = this._valueTypeSerializer;
        for (Map.Entry<Enum<?>, ?> entry2 : value2.entrySet()) {
            JsonSerializer<Object> currSerializer;
            Object valueElem = entry2.getValue();
            if (skipNulls && valueElem == null) continue;
            Enum<?> key = entry2.getKey();
            if (keyEnums == null) {
                StdSerializer ser = (StdSerializer)provider.findValueSerializer(key.getDeclaringClass(), this._property);
                keyEnums = ((EnumSerializer)ser).getEnumValues();
            }
            jgen.writeFieldName(keyEnums.serializedValueFor(key));
            if (valueElem == null) {
                provider.defaultSerializeNull(jgen);
                continue;
            }
            Class<?> cc = valueElem.getClass();
            if (cc == prevClass) {
                currSerializer = prevSerializer;
            } else {
                prevSerializer = currSerializer = provider.findValueSerializer(cc, this._property);
                prevClass = cc;
            }
            try {
                if (vts == null) {
                    currSerializer.serialize(valueElem, jgen, provider);
                    continue;
                }
                currSerializer.serializeWithType(valueElem, jgen, provider, vts);
            }
            catch (Exception e) {
                this.wrapAndThrow(provider, (Throwable)e, value2, entry2.getKey().name());
            }
        }
    }

    protected void serializeContentsUsing(EnumMap<? extends Enum<?>, ?> value2, JsonGenerator jgen, SerializerProvider provider, JsonSerializer<Object> valueSer) throws IOException, JsonGenerationException {
        EnumValues keyEnums = this._keyEnums;
        boolean skipNulls = !provider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES);
        TypeSerializer vts = this._valueTypeSerializer;
        for (Map.Entry<Enum<?>, ?> entry2 : value2.entrySet()) {
            Object valueElem = entry2.getValue();
            if (skipNulls && valueElem == null) continue;
            Enum<?> key = entry2.getKey();
            if (keyEnums == null) {
                StdSerializer ser = (StdSerializer)provider.findValueSerializer(key.getDeclaringClass(), this._property);
                keyEnums = ((EnumSerializer)ser).getEnumValues();
            }
            jgen.writeFieldName(keyEnums.serializedValueFor(key));
            if (valueElem == null) {
                provider.defaultSerializeNull(jgen);
                continue;
            }
            try {
                if (vts == null) {
                    valueSer.serialize(valueElem, jgen, provider);
                    continue;
                }
                valueSer.serializeWithType(valueElem, jgen, provider, vts);
            }
            catch (Exception e) {
                this.wrapAndThrow(provider, (Throwable)e, value2, entry2.getKey().name());
            }
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        Type[] typeArgs;
        ObjectNode o = this.createSchemaNode("object", true);
        if (typeHint instanceof ParameterizedType && (typeArgs = ((ParameterizedType)typeHint).getActualTypeArguments()).length == 2) {
            JavaType enumType = provider.constructType(typeArgs[0]);
            JavaType valueType = provider.constructType(typeArgs[1]);
            ObjectNode propsNode = JsonNodeFactory.instance.objectNode();
            Class<?> enumClass = enumType.getRawClass();
            for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                JsonSerializer<Object> ser = provider.findValueSerializer(valueType.getRawClass(), this._property);
                JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, null) : JsonSchema.getDefaultSchemaNode();
                propsNode.put(provider.getConfig().getAnnotationIntrospector().findEnumValue(enumValue), schemaNode);
            }
            o.put("properties", propsNode);
        }
        return o;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        EnumValues keyEnums;
        if (visitor == null) {
            return;
        }
        JsonObjectFormatVisitor objectVisitor = visitor.expectObjectFormat(typeHint);
        if (objectVisitor == null) {
            return;
        }
        JavaType valueType = typeHint.containedType(1);
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser == null && valueType != null) {
            ser = visitor.getProvider().findValueSerializer(valueType, this._property);
        }
        if (valueType == null) {
            valueType = visitor.getProvider().constructType((Type)((Object)Object.class));
        }
        if ((keyEnums = this._keyEnums) == null) {
            JavaType enumType = typeHint.containedType(0);
            if (enumType == null) {
                throw new IllegalStateException("Can not resolve Enum type of EnumMap: " + typeHint);
            }
            JsonSerializer<Object> enumSer = visitor.getProvider().findValueSerializer(enumType, this._property);
            if (!(enumSer instanceof EnumSerializer)) {
                throw new IllegalStateException("Can not resolve Enum type of EnumMap: " + typeHint);
            }
            keyEnums = ((EnumSerializer)enumSer).getEnumValues();
        }
        for (Map.Entry<?, SerializableString> entry2 : keyEnums.internalMap().entrySet()) {
            String name = entry2.getValue().getValue();
            if (ser == null) {
                ser = visitor.getProvider().findValueSerializer(entry2.getKey().getClass(), this._property);
            }
            objectVisitor.property(name, ser, valueType);
        }
    }
}

