/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.htrace.shaded.fasterxml.jackson.core.JsonGenerationException;
import org.apache.htrace.shaded.fasterxml.jackson.core.JsonGenerator;
import org.apache.htrace.shaded.fasterxml.jackson.databind.SerializerProvider;
import org.apache.htrace.shaded.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.StdScalarSerializer;

public class InetSocketAddressSerializer
extends StdScalarSerializer<InetSocketAddress> {
    public InetSocketAddressSerializer() {
        super(InetSocketAddress.class);
    }

    @Override
    public void serialize(InetSocketAddress value2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        InetAddress addr = value2.getAddress();
        String str = addr == null ? value2.getHostName() : addr.toString().trim();
        int ix = str.indexOf(47);
        if (ix >= 0) {
            str = ix == 0 ? (addr instanceof Inet6Address ? "[" + str.substring(1) + "]" : str.substring(1)) : str.substring(0, ix);
        }
        jgen.writeString(str + ":" + value2.getPort());
    }

    @Override
    public void serializeWithType(InetSocketAddress value2, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForScalar(value2, jgen, InetSocketAddress.class);
        this.serialize(value2, jgen, provider);
        typeSer.writeTypeSuffixForScalar(value2, jgen);
    }
}

