/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.protocol.Errors;

@InterfaceStability.Evolving
public class DeleteConsumerGroupOffsetsResult {
    private final KafkaFuture<Map<TopicPartition, Errors>> future;
    private final Set<TopicPartition> partitions;

    DeleteConsumerGroupOffsetsResult(KafkaFuture<Map<TopicPartition, Errors>> future, Set<TopicPartition> partitions) {
        this.future = future;
        this.partitions = partitions;
    }

    public KafkaFuture<Void> partitionResult(TopicPartition partition2) {
        if (!this.partitions.contains(partition2)) {
            throw new IllegalArgumentException("Partition " + partition2 + " was not included in the original request");
        }
        KafkaFutureImpl<Void> result2 = new KafkaFutureImpl<Void>();
        this.future.whenComplete((topicPartitions, throwable) -> {
            if (throwable != null) {
                result2.completeExceptionally((Throwable)throwable);
            } else if (!this.maybeCompleteExceptionally((Map<TopicPartition, Errors>)topicPartitions, partition2, result2)) {
                result2.complete(null);
            }
        });
        return result2;
    }

    public KafkaFuture<Void> all() {
        KafkaFutureImpl<Void> result2 = new KafkaFutureImpl<Void>();
        this.future.whenComplete((topicPartitions, throwable) -> {
            if (throwable != null) {
                result2.completeExceptionally((Throwable)throwable);
            } else {
                for (TopicPartition partition2 : this.partitions) {
                    if (!this.maybeCompleteExceptionally((Map<TopicPartition, Errors>)topicPartitions, partition2, result2)) continue;
                    return;
                }
                result2.complete(null);
            }
        });
        return result2;
    }

    private boolean maybeCompleteExceptionally(Map<TopicPartition, Errors> partitionLevelErrors, TopicPartition partition2, KafkaFutureImpl<Void> result2) {
        Throwable exception = KafkaAdminClient.getSubLevelError(partitionLevelErrors, partition2, "Offset deletion result for partition \"" + partition2 + "\" was not included in the response");
        if (exception != null) {
            result2.completeExceptionally(exception);
            return true;
        }
        return false;
    }
}

