/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPartitionAssignor
implements ConsumerPartitionAssignor {
    private static final Logger log = LoggerFactory.getLogger(AbstractPartitionAssignor.class);

    public abstract Map<String, List<TopicPartition>> assign(Map<String, Integer> var1, Map<String, ConsumerPartitionAssignor.Subscription> var2);

    @Override
    public ConsumerPartitionAssignor.GroupAssignment assign(Cluster metadata, ConsumerPartitionAssignor.GroupSubscription groupSubscription) {
        Map<String, ConsumerPartitionAssignor.Subscription> subscriptions = groupSubscription.groupSubscription();
        HashSet<String> allSubscribedTopics = new HashSet<String>();
        for (Map.Entry<String, ConsumerPartitionAssignor.Subscription> entry2 : subscriptions.entrySet()) {
            allSubscribedTopics.addAll(entry2.getValue().topics());
        }
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        for (String topic : allSubscribedTopics) {
            Integer numPartitions = metadata.partitionCountForTopic(topic);
            if (numPartitions != null && numPartitions > 0) {
                partitionsPerTopic.put(topic, numPartitions);
                continue;
            }
            log.debug("Skipping assignment for topic {} since no metadata is available", (Object)topic);
        }
        Map<String, List<TopicPartition>> map2 = this.assign(partitionsPerTopic, subscriptions);
        HashMap<String, ConsumerPartitionAssignor.Assignment> assignments = new HashMap<String, ConsumerPartitionAssignor.Assignment>();
        for (Map.Entry<String, List<TopicPartition>> assignmentEntry : map2.entrySet()) {
            assignments.put(assignmentEntry.getKey(), new ConsumerPartitionAssignor.Assignment(assignmentEntry.getValue()));
        }
        return new ConsumerPartitionAssignor.GroupAssignment(assignments);
    }

    protected static <K, V> void put(Map<K, List<V>> map2, K key, V value2) {
        List list = map2.computeIfAbsent(key, k -> new ArrayList());
        list.add(value2);
    }

    protected static List<TopicPartition> partitions(String topic, int numPartitions) {
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>(numPartitions);
        for (int i = 0; i < numPartitions; ++i) {
            partitions.add(new TopicPartition(topic, i));
        }
        return partitions;
    }

    public static class MemberInfo
    implements Comparable<MemberInfo> {
        public final String memberId;
        public final Optional<String> groupInstanceId;

        public MemberInfo(String memberId, Optional<String> groupInstanceId) {
            this.memberId = memberId;
            this.groupInstanceId = groupInstanceId;
        }

        @Override
        public int compareTo(MemberInfo otherMemberInfo) {
            if (this.groupInstanceId.isPresent() && otherMemberInfo.groupInstanceId.isPresent()) {
                return this.groupInstanceId.get().compareTo(otherMemberInfo.groupInstanceId.get());
            }
            if (this.groupInstanceId.isPresent()) {
                return -1;
            }
            if (otherMemberInfo.groupInstanceId.isPresent()) {
                return 1;
            }
            return this.memberId.compareTo(otherMemberInfo.memberId);
        }

        public boolean equals(Object o) {
            return o instanceof MemberInfo && this.memberId.equals(((MemberInfo)o).memberId);
        }

        public int hashCode() {
            return this.memberId.hashCode();
        }

        public String toString() {
            return "MemberInfo [member.id: " + this.memberId + ", group.instance.id: " + this.groupInstanceId.orElse("{}") + "]";
        }
    }
}

