/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class CreatePartitionsRequestData
implements ApiMessage {
    private List<CreatePartitionsTopic> topics;
    private int timeoutMs;
    private boolean validateOnly;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public CreatePartitionsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public CreatePartitionsRequestData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public CreatePartitionsRequestData() {
        this.topics = new ArrayList<CreatePartitionsTopic>();
        this.timeoutMs = 0;
        this.validateOnly = false;
    }

    @Override
    public short apiKey() {
        return 37;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        ArrayList<CreatePartitionsTopic> newCollection = new ArrayList<CreatePartitionsTopic>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new CreatePartitionsTopic(_readable, _version));
        }
        this.topics = newCollection;
        this.timeoutMs = _readable.readInt();
        this.validateOnly = _readable.readByte() != 0;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.topics.size());
        for (CreatePartitionsTopic topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version);
        }
        _writable.writeInt(this.timeoutMs);
        _writable.writeByte(this.validateOnly ? (byte)1 : 0);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<CreatePartitionsTopic>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new CreatePartitionsTopic((Struct)nestedObject, _version));
        }
        this.timeoutMs = struct.getInt("timeout_ms");
        this.validateOnly = struct.getBoolean("validate_only");
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        Struct[] _nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (CreatePartitionsTopic element : this.topics) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        struct.set("timeout_ms", (Object)this.timeoutMs);
        struct.set("validate_only", (Object)this.validateOnly);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        int _arraySize = 0;
        _arraySize += 4;
        for (CreatePartitionsTopic topicsElement : this.topics) {
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        _size += 4;
        ++_size;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CreatePartitionsRequestData)) {
            return false;
        }
        CreatePartitionsRequestData other = (CreatePartitionsRequestData)obj;
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        return this.validateOnly == other.validateOnly;
    }

    public int hashCode() {
        int hashCode2 = 0;
        hashCode2 = 31 * hashCode2 + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode2 = 31 * hashCode2 + this.timeoutMs;
        hashCode2 = 31 * hashCode2 + (this.validateOnly ? 1231 : 1237);
        return hashCode2;
    }

    public String toString() {
        return "CreatePartitionsRequestData(topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", timeoutMs=" + this.timeoutMs + ", validateOnly=" + (this.validateOnly ? "true" : "false") + ")";
    }

    public List<CreatePartitionsTopic> topics() {
        return this.topics;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public CreatePartitionsRequestData setTopics(List<CreatePartitionsTopic> v) {
        this.topics = v;
        return this;
    }

    public CreatePartitionsRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public CreatePartitionsRequestData setValidateOnly(boolean v) {
        this.validateOnly = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(CreatePartitionsTopic.SCHEMA_0), "Each topic that we want to create new partitions inside."), new Field("timeout_ms", Type.INT32, "The time in ms to wait for the partitions to be created."), new Field("validate_only", Type.BOOLEAN, "If true, then validate the request, but don't actually increase the number of partitions."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class CreatePartitionsAssignment
    implements Message {
        private List<Integer> brokerIds;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public CreatePartitionsAssignment(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public CreatePartitionsAssignment(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public CreatePartitionsAssignment() {
            this.brokerIds = new ArrayList<Integer>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatePartitionsAssignment");
            }
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field brokerIds was serialized as null");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.brokerIds = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreatePartitionsAssignment");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.brokerIds.size());
            for (Integer brokerIdsElement : this.brokerIds) {
                _writable.writeInt(brokerIdsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatePartitionsAssignment");
            }
            this._unknownTaggedFields = null;
            Object[] _nestedObjects = struct.getArray("broker_ids");
            this.brokerIds = new ArrayList<Integer>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.brokerIds.add((Integer)nestedObject);
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreatePartitionsAssignment");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            Integer[] _nestedObjects = new Integer[this.brokerIds.size()];
            int i = 0;
            for (Integer element : this.brokerIds) {
                _nestedObjects[i++] = element;
            }
            struct.set("broker_ids", (Object)_nestedObjects);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CreatePartitionsAssignment");
            }
            int _arraySize = 0;
            _arraySize += 4;
            _size += (_arraySize += this.brokerIds.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatePartitionsAssignment)) {
                return false;
            }
            CreatePartitionsAssignment other = (CreatePartitionsAssignment)obj;
            return !(this.brokerIds == null ? other.brokerIds != null : !this.brokerIds.equals(other.brokerIds));
        }

        public int hashCode() {
            int hashCode2 = 0;
            hashCode2 = 31 * hashCode2 + (this.brokerIds == null ? 0 : this.brokerIds.hashCode());
            return hashCode2;
        }

        public String toString() {
            return "CreatePartitionsAssignment(brokerIds=" + MessageUtil.deepToString(this.brokerIds.iterator()) + ")";
        }

        public List<Integer> brokerIds() {
            return this.brokerIds;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CreatePartitionsAssignment setBrokerIds(List<Integer> v) {
            this.brokerIds = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("broker_ids", new ArrayOf(Type.INT32), "The assigned broker IDs."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class CreatePartitionsTopic
    implements Message {
        private String name;
        private int count;
        private List<CreatePartitionsAssignment> assignments;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public CreatePartitionsTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public CreatePartitionsTopic(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public CreatePartitionsTopic() {
            this.name = "";
            this.count = 0;
            this.assignments = new ArrayList<CreatePartitionsAssignment>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatePartitionsTopic");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.count = _readable.readInt();
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                this.assignments = null;
            } else {
                ArrayList<CreatePartitionsAssignment> newCollection = new ArrayList<CreatePartitionsAssignment>(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    newCollection.add(new CreatePartitionsAssignment(_readable, _version));
                }
                this.assignments = newCollection;
            }
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreatePartitionsTopic");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.count);
            if (this.assignments == null) {
                _writable.writeInt(-1);
            } else {
                _writable.writeInt(this.assignments.size());
                _stringBytes = this.assignments.iterator();
                while (_stringBytes.hasNext()) {
                    CreatePartitionsAssignment assignmentsElement = (CreatePartitionsAssignment)_stringBytes.next();
                    assignmentsElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatePartitionsTopic");
            }
            this._unknownTaggedFields = null;
            this.name = struct.getString("name");
            this.count = struct.getInt("count");
            Object[] _nestedObjects = struct.getArray("assignments");
            if (_nestedObjects == null) {
                this.assignments = null;
            } else {
                this.assignments = new ArrayList<CreatePartitionsAssignment>(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.assignments.add(new CreatePartitionsAssignment((Struct)nestedObject, _version));
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreatePartitionsTopic");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            struct.set("count", (Object)this.count);
            if (this.assignments == null) {
                struct.set("assignments", null);
            } else {
                Struct[] _nestedObjects = new Struct[this.assignments.size()];
                int i = 0;
                for (CreatePartitionsAssignment element : this.assignments) {
                    _nestedObjects[i++] = element.toStruct(_version);
                }
                struct.set("assignments", (Object)_nestedObjects);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CreatePartitionsTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size += _stringBytes.length + 2;
            _size += 4;
            if (this.assignments == null) {
                _size += 4;
            } else {
                int _arraySize = 0;
                _arraySize += 4;
                for (CreatePartitionsAssignment assignmentsElement : this.assignments) {
                    _arraySize += assignmentsElement.size(_cache, _version);
                }
                _size += _arraySize;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatePartitionsTopic)) {
                return false;
            }
            CreatePartitionsTopic other = (CreatePartitionsTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.count != other.count) {
                return false;
            }
            return !(this.assignments == null ? other.assignments != null : !this.assignments.equals(other.assignments));
        }

        public int hashCode() {
            int hashCode2 = 0;
            hashCode2 = 31 * hashCode2 + (this.name == null ? 0 : this.name.hashCode());
            hashCode2 = 31 * hashCode2 + this.count;
            hashCode2 = 31 * hashCode2 + (this.assignments == null ? 0 : this.assignments.hashCode());
            return hashCode2;
        }

        public String toString() {
            return "CreatePartitionsTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", count=" + this.count + ", assignments=" + (this.assignments == null ? "null" : MessageUtil.deepToString(this.assignments.iterator())) + ")";
        }

        public String name() {
            return this.name;
        }

        public int count() {
            return this.count;
        }

        public List<CreatePartitionsAssignment> assignments() {
            return this.assignments;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CreatePartitionsTopic setName(String v) {
            this.name = v;
            return this;
        }

        public CreatePartitionsTopic setCount(int v) {
            this.count = v;
            return this;
        }

        public CreatePartitionsTopic setAssignments(List<CreatePartitionsAssignment> v) {
            this.assignments = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("count", Type.INT32, "The new partition count."), new Field("assignments", ArrayOf.nullable(CreatePartitionsAssignment.SCHEMA_0), "The new partition assignments."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

