/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeAclsRequestData
implements ApiMessage {
    private byte resourceType;
    private String resourceNameFilter;
    private byte resourcePatternType;
    private String principalFilter;
    private String hostFilter;
    private byte operation;
    private byte permissionType;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("resource_type", Type.INT8, "The resource type."), new Field("resource_name_filter", Type.NULLABLE_STRING, "The resource name, or null to match any resource name."), new Field("principal_filter", Type.NULLABLE_STRING, "The principal to match, or null to match any principal."), new Field("host_filter", Type.NULLABLE_STRING, "The host to match, or null to match any host."), new Field("operation", Type.INT8, "The operation to match."), new Field("permission_type", Type.INT8, "The permission type to match."));
    public static final Schema SCHEMA_1 = new Schema(new Field("resource_type", Type.INT8, "The resource type."), new Field("resource_name_filter", Type.NULLABLE_STRING, "The resource name, or null to match any resource name."), new Field("resource_pattern_type", Type.INT8, "The resource pattern to match."), new Field("principal_filter", Type.NULLABLE_STRING, "The principal to match, or null to match any principal."), new Field("host_filter", Type.NULLABLE_STRING, "The host to match, or null to match any host."), new Field("operation", Type.INT8, "The operation to match."), new Field("permission_type", Type.INT8, "The permission type to match."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};

    public DescribeAclsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeAclsRequestData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public DescribeAclsRequestData() {
        this.resourceType = 0;
        this.resourceNameFilter = "";
        this.resourcePatternType = (byte)3;
        this.principalFilter = "";
        this.hostFilter = "";
        this.operation = 0;
        this.permissionType = 0;
    }

    @Override
    public short apiKey() {
        return 29;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.resourceType = _readable.readByte();
        short length = _readable.readShort();
        if (length < 0) {
            this.resourceNameFilter = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field resourceNameFilter had invalid length " + length);
            }
            this.resourceNameFilter = _readable.readString(length);
        }
        this.resourcePatternType = _version >= 1 ? _readable.readByte() : (byte)3;
        length = _readable.readShort();
        if (length < 0) {
            this.principalFilter = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field principalFilter had invalid length " + length);
            }
            this.principalFilter = _readable.readString(length);
        }
        length = _readable.readShort();
        if (length < 0) {
            this.hostFilter = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field hostFilter had invalid length " + length);
            }
            this.hostFilter = _readable.readString(length);
        }
        this.operation = _readable.readByte();
        this.permissionType = _readable.readByte();
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeByte(this.resourceType);
        if (this.resourceNameFilter == null) {
            _writable.writeShort((short)-1);
        } else {
            _stringBytes = _cache.getSerializedValue(this.resourceNameFilter);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
        }
        if (_version >= 1) {
            _writable.writeByte(this.resourcePatternType);
        } else if (this.resourcePatternType != 3) {
            throw new UnsupportedVersionException("Attempted to write a non-default resourcePatternType at version " + _version);
        }
        if (this.principalFilter == null) {
            _writable.writeShort((short)-1);
        } else {
            _stringBytes = _cache.getSerializedValue(this.principalFilter);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
        }
        if (this.hostFilter == null) {
            _writable.writeShort((short)-1);
        } else {
            _stringBytes = _cache.getSerializedValue(this.hostFilter);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeByte(this.operation);
        _writable.writeByte(this.permissionType);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.resourceType = struct.getByte("resource_type");
        this.resourceNameFilter = struct.getString("resource_name_filter");
        this.resourcePatternType = _version >= 1 ? struct.getByte("resource_pattern_type") : (byte)3;
        this.principalFilter = struct.getString("principal_filter");
        this.hostFilter = struct.getString("host_filter");
        this.operation = struct.getByte("operation");
        this.permissionType = struct.getByte("permission_type");
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("resource_type", (Object)this.resourceType);
        struct.set("resource_name_filter", (Object)this.resourceNameFilter);
        if (_version >= 1) {
            struct.set("resource_pattern_type", (Object)this.resourcePatternType);
        }
        struct.set("principal_filter", (Object)this.principalFilter);
        struct.set("host_filter", (Object)this.hostFilter);
        struct.set("operation", (Object)this.operation);
        struct.set("permission_type", (Object)this.permissionType);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        byte[] _stringBytes;
        int _size = 0;
        int _numTaggedFields = 0;
        ++_size;
        if (this.resourceNameFilter == null) {
            _size += 2;
        } else {
            _stringBytes = this.resourceNameFilter.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'resourceNameFilter' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.resourceNameFilter, _stringBytes);
            _size += _stringBytes.length + 2;
        }
        if (_version >= 1) {
            ++_size;
        }
        if (this.principalFilter == null) {
            _size += 2;
        } else {
            _stringBytes = this.principalFilter.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'principalFilter' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.principalFilter, _stringBytes);
            _size += _stringBytes.length + 2;
        }
        if (this.hostFilter == null) {
            _size += 2;
        } else {
            _stringBytes = this.hostFilter.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'hostFilter' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.hostFilter, _stringBytes);
            _size += _stringBytes.length + 2;
        }
        ++_size;
        ++_size;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeAclsRequestData)) {
            return false;
        }
        DescribeAclsRequestData other = (DescribeAclsRequestData)obj;
        if (this.resourceType != other.resourceType) {
            return false;
        }
        if (this.resourceNameFilter == null ? other.resourceNameFilter != null : !this.resourceNameFilter.equals(other.resourceNameFilter)) {
            return false;
        }
        if (this.resourcePatternType != other.resourcePatternType) {
            return false;
        }
        if (this.principalFilter == null ? other.principalFilter != null : !this.principalFilter.equals(other.principalFilter)) {
            return false;
        }
        if (this.hostFilter == null ? other.hostFilter != null : !this.hostFilter.equals(other.hostFilter)) {
            return false;
        }
        if (this.operation != other.operation) {
            return false;
        }
        return this.permissionType == other.permissionType;
    }

    public int hashCode() {
        int hashCode2 = 0;
        hashCode2 = 31 * hashCode2 + this.resourceType;
        hashCode2 = 31 * hashCode2 + (this.resourceNameFilter == null ? 0 : this.resourceNameFilter.hashCode());
        hashCode2 = 31 * hashCode2 + this.resourcePatternType;
        hashCode2 = 31 * hashCode2 + (this.principalFilter == null ? 0 : this.principalFilter.hashCode());
        hashCode2 = 31 * hashCode2 + (this.hostFilter == null ? 0 : this.hostFilter.hashCode());
        hashCode2 = 31 * hashCode2 + this.operation;
        hashCode2 = 31 * hashCode2 + this.permissionType;
        return hashCode2;
    }

    public String toString() {
        return "DescribeAclsRequestData(resourceType=" + this.resourceType + ", resourceNameFilter=" + (this.resourceNameFilter == null ? "null" : "'" + this.resourceNameFilter.toString() + "'") + ", resourcePatternType=" + this.resourcePatternType + ", principalFilter=" + (this.principalFilter == null ? "null" : "'" + this.principalFilter.toString() + "'") + ", hostFilter=" + (this.hostFilter == null ? "null" : "'" + this.hostFilter.toString() + "'") + ", operation=" + this.operation + ", permissionType=" + this.permissionType + ")";
    }

    public byte resourceType() {
        return this.resourceType;
    }

    public String resourceNameFilter() {
        return this.resourceNameFilter;
    }

    public byte resourcePatternType() {
        return this.resourcePatternType;
    }

    public String principalFilter() {
        return this.principalFilter;
    }

    public String hostFilter() {
        return this.hostFilter;
    }

    public byte operation() {
        return this.operation;
    }

    public byte permissionType() {
        return this.permissionType;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeAclsRequestData setResourceType(byte v) {
        this.resourceType = v;
        return this;
    }

    public DescribeAclsRequestData setResourceNameFilter(String v) {
        this.resourceNameFilter = v;
        return this;
    }

    public DescribeAclsRequestData setResourcePatternType(byte v) {
        this.resourcePatternType = v;
        return this;
    }

    public DescribeAclsRequestData setPrincipalFilter(String v) {
        this.principalFilter = v;
        return this;
    }

    public DescribeAclsRequestData setHostFilter(String v) {
        this.hostFilter = v;
        return this;
    }

    public DescribeAclsRequestData setOperation(byte v) {
        this.operation = v;
        return this;
    }

    public DescribeAclsRequestData setPermissionType(byte v) {
        this.permissionType = v;
        return this;
    }
}

