/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.kafka.common.protocol.types.RawTaggedField;

public interface Readable {
    public byte readByte();

    public short readShort();

    public int readInt();

    public long readLong();

    public void readArray(byte[] var1);

    public int readUnsignedVarint();

    default public String readString(int length) {
        byte[] arr = new byte[length];
        this.readArray(arr);
        return new String(arr, StandardCharsets.UTF_8);
    }

    default public List<RawTaggedField> readUnknownTaggedField(List<RawTaggedField> unknowns, int tag, int size2) {
        if (unknowns == null) {
            unknowns = new ArrayList<RawTaggedField>();
        }
        byte[] data = new byte[size2];
        this.readArray(data);
        unknowns.add(new RawTaggedField(tag, data));
        return unknowns;
    }

    default public UUID readUUID() {
        return new UUID(this.readLong(), this.readLong());
    }
}

