/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

public enum RecordVersion {
    V0(0),
    V1(1),
    V2(2);

    private static final RecordVersion[] VALUES;
    public final byte value;

    private RecordVersion(int value2) {
        this.value = (byte)value2;
    }

    public boolean precedes(RecordVersion other) {
        return this.value < other.value;
    }

    public static RecordVersion lookup(byte value2) {
        if (value2 < 0 || value2 >= VALUES.length) {
            throw new IllegalArgumentException("Unknown record version: " + value2);
        }
        return VALUES[value2];
    }

    public static RecordVersion current() {
        return V2;
    }

    static {
        VALUES = RecordVersion.values();
    }
}

