/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.nio.ByteBuffer;
import java.util.zip.Checksum;

public final class Checksums {
    private Checksums() {
    }

    public static void update(Checksum checksum, ByteBuffer buffer, int length) {
        Checksums.update(checksum, buffer, 0, length);
    }

    public static void update(Checksum checksum, ByteBuffer buffer, int offset2, int length) {
        if (buffer.hasArray()) {
            checksum.update(buffer.array(), buffer.position() + buffer.arrayOffset() + offset2, length);
        } else {
            int start;
            for (int i = start = buffer.position() + offset2; i < start + length; ++i) {
                checksum.update(buffer.get(i));
            }
        }
    }

    public static void updateInt(Checksum checksum, int input2) {
        checksum.update((byte)(input2 >> 24));
        checksum.update((byte)(input2 >> 16));
        checksum.update((byte)(input2 >> 8));
        checksum.update((byte)input2);
    }

    public static void updateLong(Checksum checksum, long input2) {
        checksum.update((byte)(input2 >> 56));
        checksum.update((byte)(input2 >> 48));
        checksum.update((byte)(input2 >> 40));
        checksum.update((byte)(input2 >> 32));
        checksum.update((byte)(input2 >> 24));
        checksum.update((byte)(input2 >> 16));
        checksum.update((byte)(input2 >> 8));
        checksum.update((byte)input2);
    }
}

