/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.admin.client.datatype;

import com.sun.jersey.api.client.ClientResponse;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.ranger.authorization.utils.StringUtil;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RESTResponse {
    private static final Logger LOG = Logger.getLogger(RESTResponse.class);
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_ERROR = 1;
    public static final int STATUS_VALIDATION = 2;
    public static final int STATUS_WARN = 3;
    public static final int STATUS_INFO = 4;
    public static final int STATUS_PARTIAL_SUCCESS = 5;
    public static final int ResponseStatus_MAX = 5;
    private int httpStatusCode;
    private int statusCode;
    private String msgDesc;
    private List<Message> messageList;

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public void setHttpStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getMsgDesc() {
        return this.msgDesc;
    }

    public void setMsgDesc(String msgDesc) {
        this.msgDesc = msgDesc;
    }

    public List<Message> getMessageList() {
        return this.messageList;
    }

    public void setMessageList(List<Message> messageList) {
        this.messageList = messageList;
    }

    public String getMessage() {
        return StringUtil.isEmpty(this.msgDesc) ? "HTTP " + this.httpStatusCode : this.msgDesc;
    }

    public static RESTResponse fromClientResponse(ClientResponse response) {
        int httpStatus;
        RESTResponse ret = null;
        String jsonString = response == null ? null : response.getEntity(String.class);
        int n = httpStatus = response == null ? 0 : response.getStatus();
        if (!StringUtil.isEmpty(jsonString)) {
            ret = RESTResponse.fromJson(jsonString);
        }
        if (ret == null) {
            ret = new RESTResponse();
        }
        ret.setHttpStatusCode(httpStatus);
        return ret;
    }

    public String toJson() {
        try {
            ObjectMapper om = new ObjectMapper();
            return om.writeValueAsString(this);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("toJson() failed", e);
            }
            return "";
        }
    }

    public static RESTResponse fromJson(String jsonString) {
        try {
            ObjectMapper om = new ObjectMapper();
            return om.readValue(jsonString, RESTResponse.class);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("fromJson('" + jsonString + "') failed", e);
            }
            return null;
        }
    }

    public String toString() {
        return this.toJson();
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Message {
        private String name;
        private String rbKey;
        private String message;
        private Long objectId;
        private String fieldName;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRbKey() {
            return this.rbKey;
        }

        public void setRbKey(String rbKey) {
            this.rbKey = rbKey;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Long getObjectId() {
            return this.objectId;
        }

        public void setObjectId(Long objectId) {
            this.objectId = objectId;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String toJson() {
            try {
                ObjectMapper om = new ObjectMapper();
                return om.writeValueAsString(this);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("toJson() failed", e);
                }
                return "";
            }
        }

        public static RESTResponse fromJson(String jsonString) {
            try {
                ObjectMapper om = new ObjectMapper();
                return om.readValue(jsonString, RESTResponse.class);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("fromJson('" + jsonString + "') failed", e);
                }
                return null;
            }
        }

        public String toString() {
            return this.toJson();
        }
    }
}

