/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.destination;

import java.util.Collection;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.audit.destination.AuditDestination;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.provider.MiscUtil;

public class Log4JAuditDestination
extends AuditDestination {
    private static final Log logger = LogFactory.getLog(Log4JAuditDestination.class);
    private static Log auditLogger = null;
    public static final String PROP_LOG4J_LOGGER = "logger";
    public static final String DEFAULT_LOGGER_PREFIX = "ranger.audit";
    private String loggerName = null;

    public Log4JAuditDestination() {
        logger.info("Log4JAuditDestination() called.");
    }

    @Override
    public void init(Properties prop, String propPrefix) {
        super.init(prop, propPrefix);
        this.loggerName = MiscUtil.getStringProperty(this.props, propPrefix + "." + PROP_LOG4J_LOGGER);
        if (this.loggerName == null || this.loggerName.isEmpty()) {
            this.loggerName = "ranger.audit." + this.getName();
            logger.info("Logger property " + propPrefix + "." + PROP_LOG4J_LOGGER + " was not set. Constructing default=" + this.loggerName);
        }
        logger.info("Logger name for " + this.getName() + " is " + this.loggerName);
        auditLogger = LogFactory.getLog(this.loggerName);
        logger.info("Done initializing logger for audit. name=" + this.getName() + ", loggerName=" + this.loggerName);
    }

    @Override
    public void stop() {
        super.stop();
        this.logStatus();
    }

    @Override
    public boolean log(AuditEventBase event) {
        if (!auditLogger.isInfoEnabled()) {
            this.logStatusIfRequired();
            this.addTotalCount(1);
            return true;
        }
        if (event != null) {
            String eventStr = MiscUtil.stringify(event);
            this.logJSON(eventStr);
        }
        return true;
    }

    @Override
    public boolean log(Collection<AuditEventBase> events2) {
        if (!auditLogger.isInfoEnabled()) {
            this.logStatusIfRequired();
            this.addTotalCount(events2.size());
            return true;
        }
        for (AuditEventBase event : events2) {
            this.log(event);
        }
        return true;
    }

    @Override
    public boolean logJSON(String event) {
        this.logStatusIfRequired();
        this.addTotalCount(1);
        if (!auditLogger.isInfoEnabled()) {
            return true;
        }
        if (event != null) {
            auditLogger.info(event);
            this.addSuccessCount(1);
        }
        return true;
    }

    @Override
    public boolean logJSON(Collection<String> events2) {
        if (!auditLogger.isInfoEnabled()) {
            this.logStatusIfRequired();
            this.addTotalCount(events2.size());
            return true;
        }
        for (String event : events2) {
            this.logJSON(event);
        }
        return false;
    }
}

