/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider;

import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.MiscUtil;

public abstract class BaseAuditHandler
implements AuditHandler {
    private static final Log LOG = LogFactory.getLog(BaseAuditHandler.class);
    static final String AUDIT_LOG_FAILURE_REPORT_MIN_INTERVAL_PROP = "xasecure.audit.log.failure.report.min.interval.ms";
    protected static final String AUDIT_DB_CREDENTIAL_PROVIDER_FILE = "xasecure.audit.credential.provider.file";
    public static final String PROP_CONFIG = "config";
    private int mLogFailureReportMinIntervalInMs = 60000;
    private AtomicLong mFailedLogLastReportTime = new AtomicLong(0L);
    private AtomicLong mFailedLogCountSinceLastReport = new AtomicLong(0L);
    private AtomicLong mFailedLogCountLifeTime = new AtomicLong(0L);
    public static final String PROP_NAME = "name";
    public static final String PROP_CLASS_NAME = "classname";
    public static final String PROP_DEFAULT_PREFIX = "xasecure.audit.provider";
    protected String propPrefix = "xasecure.audit.provider";
    protected String providerName = null;
    protected String parentPath = null;
    protected int failedRetryTimes = 3;
    protected int failedRetrySleep = 3000;
    int errorLogIntervalMS = 30000;
    long lastErrorLogMS = 0L;
    long totalCount = 0L;
    long totalSuccessCount = 0L;
    long totalFailedCount = 0L;
    long totalStashedCount = 0L;
    long totalDeferredCount = 0L;
    long lastIntervalCount = 0L;
    long lastIntervalSuccessCount = 0L;
    long lastIntervalFailedCount = 0L;
    long lastStashedCount = 0L;
    long lastDeferredCount = 0L;
    long lastStatusLogTime = System.currentTimeMillis();
    long statusLogIntervalMS = 60000L;
    protected Properties props = null;
    protected Map<String, String> configProps = new HashMap<String, String>();

    @Override
    public void init(Properties props) {
        this.init(props, null);
    }

    @Override
    public void init(Properties props, String basePropertyName) {
        List<String> tokens;
        LOG.info("BaseAuditProvider.init()");
        this.props = props;
        if (basePropertyName != null) {
            this.propPrefix = basePropertyName;
        }
        LOG.info("propPrefix=" + this.propPrefix);
        String name = MiscUtil.getStringProperty(props, basePropertyName + "." + PROP_NAME);
        if (name != null && !name.isEmpty()) {
            this.setName(name);
        }
        if (this.providerName == null && !(tokens = MiscUtil.toArray(this.propPrefix, ".")).isEmpty()) {
            String finalToken = tokens.get(tokens.size() - 1);
            this.setName(finalToken);
            LOG.info("Using providerName from property prefix. providerName=" + this.getName());
        }
        LOG.info("providerName=" + this.getName());
        try {
            new GsonBuilder().setDateFormat("yyyyMMdd-HH:mm:ss.SSS-Z").create();
        }
        catch (Throwable excp) {
            LOG.warn("Log4jAuditProvider.init(): failed to create GsonBuilder object. events will be formated using toString(), instead of Json", excp);
        }
        this.mLogFailureReportMinIntervalInMs = MiscUtil.getIntProperty(props, AUDIT_LOG_FAILURE_REPORT_MIN_INTERVAL_PROP, 60000);
        String configPropsNamePrefix = this.propPrefix + "." + PROP_CONFIG + ".";
        for (Object propNameObj : props.keySet()) {
            String propName = propNameObj.toString();
            if (!propName.startsWith(configPropsNamePrefix)) continue;
            String configName = propName.substring(configPropsNamePrefix.length());
            String configValue = props.getProperty(propName);
            this.configProps.put(configName, configValue);
            LOG.info("Found Config property: " + configName + " => " + configValue);
        }
    }

    @Override
    public boolean log(AuditEventBase event) {
        return this.log(Collections.singletonList(event));
    }

    @Override
    public boolean logJSON(String event) {
        AuditEventBase eventObj = MiscUtil.fromJson(event, AuthzAuditEvent.class);
        return this.log(eventObj);
    }

    @Override
    public boolean logJSON(Collection<String> events2) {
        ArrayList<AuditEventBase> eventList = new ArrayList<AuditEventBase>(events2.size());
        for (String event : events2) {
            eventList.add(MiscUtil.fromJson(event, AuthzAuditEvent.class));
        }
        return this.log(eventList);
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public String getFinalPath() {
        return this.getName();
    }

    public void setName(String name) {
        this.providerName = name;
    }

    @Override
    public String getName() {
        if (this.parentPath != null) {
            return this.parentPath + "." + this.providerName;
        }
        return this.providerName;
    }

    public long addTotalCount(int count2) {
        this.totalCount += (long)count2;
        return this.totalCount;
    }

    public long addSuccessCount(int count2) {
        this.totalSuccessCount += (long)count2;
        return this.totalSuccessCount;
    }

    public long addFailedCount(int count2) {
        this.totalFailedCount += (long)count2;
        return this.totalFailedCount;
    }

    public long addStashedCount(int count2) {
        this.totalStashedCount += (long)count2;
        return this.totalStashedCount;
    }

    public long addDeferredCount(int count2) {
        this.totalDeferredCount += (long)count2;
        return this.totalDeferredCount;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public long getTotalSuccessCount() {
        return this.totalSuccessCount;
    }

    public long getTotalFailedCount() {
        return this.totalFailedCount;
    }

    public long getTotalStashedCount() {
        return this.totalStashedCount;
    }

    public long getLastStashedCount() {
        return this.lastStashedCount;
    }

    public long getTotalDeferredCount() {
        return this.totalDeferredCount;
    }

    public long getLastDeferredCount() {
        return this.lastDeferredCount;
    }

    public void logStatusIfRequired() {
        long currTime = System.currentTimeMillis();
        if (currTime - this.lastStatusLogTime > this.statusLogIntervalMS) {
            this.logStatus();
        }
    }

    public void logStatus() {
        try {
            long currTime = System.currentTimeMillis();
            long diffTime = currTime - this.lastStatusLogTime;
            this.lastStatusLogTime = currTime;
            long diffCount = this.totalCount - this.lastIntervalCount;
            long diffSuccess = this.totalSuccessCount - this.lastIntervalSuccessCount;
            long diffFailed = this.totalFailedCount - this.lastIntervalFailedCount;
            long diffStashed = this.totalStashedCount - this.lastStashedCount;
            long diffDeferred = this.totalDeferredCount - this.lastDeferredCount;
            if (diffCount == 0L && diffSuccess == 0L && diffFailed == 0L && diffStashed == 0L && diffDeferred == 0L) {
                return;
            }
            this.lastIntervalCount = this.totalCount;
            this.lastIntervalSuccessCount = this.totalSuccessCount;
            this.lastIntervalFailedCount = this.totalFailedCount;
            this.lastStashedCount = this.totalStashedCount;
            this.lastDeferredCount = this.totalDeferredCount;
            String finalPath = "";
            String tFinalPath = this.getFinalPath();
            if (!this.getName().equals(tFinalPath)) {
                finalPath = ", finalDestination=" + tFinalPath;
            }
            String msg = "Audit Status Log: name=" + this.getName() + finalPath + ", interval=" + this.formatIntervalForLog(diffTime) + ", events=" + diffCount + (diffSuccess > 0L ? ", succcessCount=" + diffSuccess : "") + (diffFailed > 0L ? ", failedCount=" + diffFailed : "") + (diffStashed > 0L ? ", stashedCount=" + diffStashed : "") + (diffDeferred > 0L ? ", deferredCount=" + diffDeferred : "") + ", totalEvents=" + this.totalCount + (this.totalSuccessCount > 0L ? ", totalSuccessCount=" + this.totalSuccessCount : "") + (this.totalFailedCount > 0L ? ", totalFailedCount=" + this.totalFailedCount : "") + (this.totalStashedCount > 0L ? ", totalStashedCount=" + this.totalStashedCount : "") + (this.totalDeferredCount > 0L ? ", totalDeferredCount=" + this.totalDeferredCount : "");
            LOG.info(msg);
        }
        catch (Throwable t) {
            LOG.error("Error while printing stats. auditProvider=" + this.getName());
        }
    }

    public void logError(String msg) {
        long currTimeMS = System.currentTimeMillis();
        if (currTimeMS - this.lastErrorLogMS > (long)this.errorLogIntervalMS) {
            LOG.error(msg);
            this.lastErrorLogMS = currTimeMS;
        }
    }

    public void logError(String msg, Throwable ex) {
        long currTimeMS = System.currentTimeMillis();
        if (currTimeMS - this.lastErrorLogMS > (long)this.errorLogIntervalMS) {
            LOG.error(msg, ex);
            this.lastErrorLogMS = currTimeMS;
        }
    }

    public String getTimeDiffStr(long time1, long time2) {
        long timeInMs = Math.abs(time1 - time2);
        return this.formatIntervalForLog(timeInMs);
    }

    public String formatIntervalForLog(long timeInMs) {
        long hours = timeInMs / 3600000L;
        long minutes = timeInMs / 60000L % 60L;
        long seconds = timeInMs % 60000L / 1000L;
        long mSeconds = timeInMs % 1000L;
        if (hours > 0L) {
            return String.format("%02d:%02d:%02d.%03d hours", hours, minutes, seconds, mSeconds);
        }
        if (minutes > 0L) {
            return String.format("%02d:%02d.%03d minutes", minutes, seconds, mSeconds);
        }
        if (seconds > 0L) {
            return String.format("%02d.%03d seconds", seconds, mSeconds);
        }
        return String.format("%03d milli-seconds", mSeconds);
    }

    public void logFailedEvent(AuditEventBase event) {
        this.logFailedEvent(event, "");
    }

    public void logFailedEvent(AuditEventBase event, Throwable excp) {
        long now = System.currentTimeMillis();
        long timeSinceLastReport = now - this.mFailedLogLastReportTime.get();
        long countSinceLastReport = this.mFailedLogCountSinceLastReport.incrementAndGet();
        long countLifeTime = this.mFailedLogCountLifeTime.incrementAndGet();
        if (timeSinceLastReport >= (long)this.mLogFailureReportMinIntervalInMs) {
            this.mFailedLogLastReportTime.set(now);
            this.mFailedLogCountSinceLastReport.set(0L);
            if (excp != null) {
                LOG.warn("failed to log audit event: " + MiscUtil.stringify(event), excp);
            } else {
                LOG.warn("failed to log audit event: " + MiscUtil.stringify(event));
            }
            if (countLifeTime > 1L) {
                LOG.warn("Log failure count: " + countSinceLastReport + " in past " + this.formatIntervalForLog(timeSinceLastReport) + "; " + countLifeTime + " during process lifetime");
            }
        }
    }

    public void logFailedEvent(Collection<AuditEventBase> events2) {
        this.logFailedEvent(events2, "");
    }

    public void logFailedEvent(Collection<AuditEventBase> events2, Throwable excp) {
        for (AuditEventBase event : events2) {
            this.logFailedEvent(event, excp);
        }
    }

    public void logFailedEvent(AuditEventBase event, String message) {
        long now = System.currentTimeMillis();
        long timeSinceLastReport = now - this.mFailedLogLastReportTime.get();
        long countSinceLastReport = this.mFailedLogCountSinceLastReport.incrementAndGet();
        long countLifeTime = this.mFailedLogCountLifeTime.incrementAndGet();
        if (timeSinceLastReport >= (long)this.mLogFailureReportMinIntervalInMs) {
            this.mFailedLogLastReportTime.set(now);
            this.mFailedLogCountSinceLastReport.set(0L);
            LOG.warn("failed to log audit event: " + MiscUtil.stringify(event) + ", errorMessage=" + message);
            if (countLifeTime > 1L) {
                LOG.warn("Log failure count: " + countSinceLastReport + " in past " + this.formatIntervalForLog(timeSinceLastReport) + "; " + countLifeTime + " during process lifetime");
            }
        }
    }

    public void logFailedEvent(Collection<AuditEventBase> events2, String errorMessage) {
        for (AuditEventBase event : events2) {
            this.logFailedEvent(event, errorMessage);
        }
    }

    public void logFailedEventJSON(String event, Throwable excp) {
        long now = System.currentTimeMillis();
        long timeSinceLastReport = now - this.mFailedLogLastReportTime.get();
        long countSinceLastReport = this.mFailedLogCountSinceLastReport.incrementAndGet();
        long countLifeTime = this.mFailedLogCountLifeTime.incrementAndGet();
        if (timeSinceLastReport >= (long)this.mLogFailureReportMinIntervalInMs) {
            this.mFailedLogLastReportTime.set(now);
            this.mFailedLogCountSinceLastReport.set(0L);
            if (excp != null) {
                LOG.warn("failed to log audit event: " + event, excp);
            } else {
                LOG.warn("failed to log audit event: " + event);
            }
            if (countLifeTime > 1L) {
                LOG.warn("Log failure count: " + countSinceLastReport + " in past " + this.formatIntervalForLog(timeSinceLastReport) + "; " + countLifeTime + " during process lifetime");
            }
        }
    }

    public void logFailedEventJSON(Collection<String> events2, Throwable excp) {
        for (String event : events2) {
            this.logFailedEventJSON(event, excp);
        }
    }
}

