/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop.utils;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;

public final class RangerCredentialProvider {
    private static final Log LOG = LogFactory.getLog(RangerCredentialProvider.class);
    private static final RangerCredentialProvider CRED_PROVIDER = new RangerCredentialProvider();

    protected RangerCredentialProvider() {
    }

    public static RangerCredentialProvider getInstance() {
        return CRED_PROVIDER;
    }

    public char[] getCredentialString(String url, String alias) {
        List<CredentialProvider> providers = this.getCredentialProviders(url);
        if (providers != null) {
            for (CredentialProvider provider : providers) {
                try {
                    CredentialProvider.CredentialEntry credEntry = provider.getCredentialEntry(alias);
                    if (credEntry == null) continue;
                    return credEntry.getCredential();
                }
                catch (Exception ie) {
                    LOG.error("Unable to get the Credential Provider from the Configuration", ie);
                }
            }
        }
        return null;
    }

    List<CredentialProvider> getCredentialProviders(String url) {
        try {
            Configuration conf = new Configuration();
            conf.set("hadoop.security.credential.provider.path", url);
            return CredentialProviderFactory.getProviders(conf);
        }
        catch (Exception ie) {
            LOG.error("Unable to get the Credential Provider from the Configuration", ie);
            return null;
        }
    }
}

