/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.geo;

import org.apache.ranger.plugin.geo.RangeChecker;
import org.apache.ranger.plugin.geo.ValueProcessor;

public class BinarySearchTree<T extends Comparable<T> & RangeChecker<V>, V> {
    private Node<T> root = null;
    private int size;

    public void insert(T value2) {
        Node<T> parent;
        Node<T> node = new Node<T>(value2);
        if (this.root == null) {
            this.root = node;
            return;
        }
        Node<T> focusNode = this.root;
        while (true) {
            parent = focusNode;
            int comparison = ((Comparable)focusNode.getValue()).compareTo(value2);
            if (comparison == 0) {
                return;
            }
            if (comparison < 0) {
                if ((focusNode = focusNode.getRight()) != null) continue;
                parent.setRight(node);
                return;
            }
            if ((focusNode = focusNode.getLeft()) == null) break;
        }
        parent.setLeft(node);
    }

    public T find(V value2) {
        int rangeCheck;
        Node<T> focusNode = this.root;
        while (focusNode != null && (rangeCheck = ((RangeChecker)((Object)((Comparable)focusNode.getValue()))).compareToRange(value2)) != 0) {
            if (rangeCheck < 0) {
                focusNode = focusNode.getRight();
                continue;
            }
            focusNode = focusNode.getLeft();
        }
        return (T)(focusNode == null ? null : (Comparable)focusNode.getValue());
    }

    public final void preOrderTraverseTree(ValueProcessor<T> processor) {
        this.preOrderTraverseTree(this.getRoot(), processor);
    }

    public final void inOrderTraverseTree(ValueProcessor<T> processor) {
        this.inOrderTraverseTree(this.getRoot(), processor);
    }

    Node<T> getRoot() {
        return this.root;
    }

    void setRoot(Node<T> newRoot) {
        this.root = newRoot;
    }

    void rebalance() {
        Node<Object> dummy = new Node<Object>(null);
        dummy.setRight(this.root);
        this.setRoot(dummy);
        this.degenerate();
        this.reconstruct();
        this.setRoot(this.getRoot().getRight());
    }

    final void inOrderTraverseTree(Node<T> focusNode, ValueProcessor<T> processor) {
        if (focusNode != null) {
            this.inOrderTraverseTree(focusNode.getLeft(), processor);
            processor.process(focusNode.getValue());
            this.inOrderTraverseTree(focusNode.getRight(), processor);
        }
    }

    final void preOrderTraverseTree(Node<T> focusNode, ValueProcessor<T> processor) {
        if (focusNode != null) {
            processor.process(focusNode.getValue());
            this.preOrderTraverseTree(focusNode.getLeft(), processor);
            this.preOrderTraverseTree(focusNode.getRight(), processor);
        }
    }

    private void degenerate() {
        Node<T> sentinel = this.getRoot();
        Node<T> remainder = sentinel.getRight();
        this.size = 0;
        while (remainder != null) {
            if (remainder.getLeft() == null) {
                sentinel = remainder;
                remainder = remainder.getRight();
                ++this.size;
                continue;
            }
            Node<T> temp = remainder.getLeft();
            remainder.setLeft(temp.getRight());
            temp.setRight(remainder);
            remainder = temp;
            sentinel.setRight(temp);
        }
    }

    private void reconstruct() {
        int sz = this.size;
        Node<T> node = this.getRoot();
        int fullCount = this.fullSize(sz);
        this.rotateLeft(node, sz - fullCount);
        for (sz = fullCount; sz > 1; sz /= 2) {
            this.rotateLeft(node, sz / 2);
        }
    }

    private void rotateLeft(Node<T> root, int count2) {
        if (root == null) {
            return;
        }
        Node<T> scanner = root;
        for (int i = 0; i < count2; ++i) {
            Node<T> child = scanner.getRight();
            scanner.setRight(child.getRight());
            scanner = child.getRight();
            child.setRight(scanner.getLeft());
            scanner.setLeft(child);
        }
    }

    private int fullSize(int size2) {
        int ret = 1;
        while (ret <= size2) {
            ret = 2 * ret + 1;
        }
        return ret / 2;
    }

    static class Node<T> {
        private T value;
        private Node<T> left;
        private Node<T> right;

        public Node(T value2) {
            this.value = value2;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value2) {
            this.value = value2;
        }

        public Node<T> getLeft() {
            return this.left;
        }

        public void setLeft(Node<T> left) {
            this.left = left;
        }

        public Node<T> getRight() {
            return this.right;
        }

        public void setRight(Node<T> right) {
            this.right = right;
        }
    }
}

