/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.geo;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.geo.ValueProcessor;

class ValuePrinter<T>
implements ValueProcessor<T> {
    private static final Log LOG = LogFactory.getLog(ValuePrinter.class);
    private Writer writer;
    private String fileName;

    ValuePrinter(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public T process(T value2) {
        if (value2 != null) {
            if (this.writer == null) {
                LOG.error("ValuePrinter.process() -" + value2);
            } else {
                try {
                    this.writer.write(value2.toString());
                    this.writer.write(10);
                }
                catch (IOException exception) {
                    LOG.error("ValuePrinter.process() - Cannot write '" + value2 + "' to " + this.fileName);
                }
            }
        }
        return value2;
    }

    public void print(String str) {
        if (this.writer == null) {
            LOG.error("ValuePrinter.print() -" + str);
        } else {
            try {
                this.writer.write(str);
                this.writer.write(10);
            }
            catch (IOException exception) {
                LOG.error("ValuePrinter.print() - Cannot write '" + str + "' to " + this.fileName);
            }
        }
    }

    void build() {
        try {
            if (StringUtils.isNotBlank(this.fileName)) {
                this.writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.fileName)));
            }
        }
        catch (IOException exception) {
            LOG.error("ValuePrinter.build() - Cannot open " + this.fileName + " for writing");
        }
    }

    void close() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException exception) {
            LOG.error("ValuePrinter.close() - Cannot close " + this.fileName);
        }
    }
}

