/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.errors.ValidationErrorCode;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.ValidationFailureDetails;
import org.apache.ranger.plugin.model.validation.ValidationFailureDetailsBuilder;
import org.apache.ranger.plugin.store.ServiceStore;
import org.apache.ranger.plugin.util.RangerObjectFactory;

public abstract class RangerValidator {
    private static final Log LOG = LogFactory.getLog(RangerValidator.class);
    ServiceStore _store;
    RangerObjectFactory _factory = new RangerObjectFactory();

    protected RangerValidator(ServiceStore store) {
        if (store == null) {
            throw new IllegalArgumentException("ServiceValidator(): store is null!");
        }
        this._store = store;
    }

    public void validate(Long id, Action action) throws Exception {
        ArrayList<ValidationFailureDetails> failures;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.validate(" + id + ")");
        }
        if (this.isValid(id, action, failures = new ArrayList<ValidationFailureDetails>())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerValidator.validate(" + id + "): valid");
            }
        } else {
            String message = RangerValidator.serializeFailures(failures);
            LOG.debug("<== RangerValidator.validate(" + id + "): invalid, reason[" + message + "]");
            throw new Exception(message);
        }
    }

    boolean isValid(Long id, Action action, List<ValidationFailureDetails> failures) {
        failures.add(new ValidationFailureDetailsBuilder().isAnInternalError().becauseOf("unimplemented method called").build());
        return false;
    }

    public static String serializeFailures(List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getFailureMessage()");
        }
        String message = null;
        if (CollectionUtils.isEmpty(failures)) {
            LOG.warn("serializeFailures: called while list of failures is null/empty!");
        } else {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < failures.size(); ++i) {
                builder.append(String.format("(%d)", i));
                builder.append(failures.get(i));
                builder.append(" ");
            }
            message = builder.toString();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.serializeFailures(): " + message);
        }
        return message;
    }

    Set<String> getServiceConfigParameters(RangerService service) {
        if (service == null || service.getConfigs() == null) {
            return new HashSet<String>();
        }
        return service.getConfigs().keySet();
    }

    Set<String> getRequiredParameters(RangerServiceDef serviceDef) {
        Set<String> result2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getRequiredParameters(" + serviceDef + ")");
        }
        if (serviceDef == null) {
            result2 = Collections.emptySet();
        } else {
            List<RangerServiceDef.RangerServiceConfigDef> configs = serviceDef.getConfigs();
            if (CollectionUtils.isEmpty(configs)) {
                result2 = Collections.emptySet();
            } else {
                result2 = new HashSet<String>(configs.size());
                for (RangerServiceDef.RangerServiceConfigDef configDef : configs) {
                    if (!configDef.getMandatory().booleanValue()) continue;
                    result2.add(configDef.getName());
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getRequiredParameters(" + serviceDef + "): " + result2);
        }
        return result2;
    }

    RangerServiceDef getServiceDef(Long id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getServiceDef(" + id + ")");
        }
        RangerServiceDef result2 = null;
        try {
            result2 = this._store.getServiceDef(id);
        }
        catch (Exception e) {
            LOG.debug("Encountred exception while retrieving service def from service store!", e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getServiceDef(" + id + "): " + result2);
        }
        return result2;
    }

    RangerServiceDef getServiceDef(String type) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getServiceDef(" + type + ")");
        }
        RangerServiceDef result2 = null;
        try {
            result2 = this._store.getServiceDefByName(type);
        }
        catch (Exception e) {
            LOG.debug("Encountred exception while retrieving service definition from service store!", e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getServiceDef(" + type + "): " + result2);
        }
        return result2;
    }

    RangerService getService(Long id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getService(" + id + ")");
        }
        RangerService result2 = null;
        try {
            result2 = this._store.getService(id);
        }
        catch (Exception e) {
            LOG.debug("Encountred exception while retrieving service from service store!", e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getService(" + id + "): " + result2);
        }
        return result2;
    }

    RangerService getService(String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getService(" + name + ")");
        }
        RangerService result2 = null;
        try {
            result2 = this._store.getServiceByName(name);
        }
        catch (Exception e) {
            LOG.debug("Encountred exception while retrieving service from service store!", e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getService(" + name + "): " + result2);
        }
        return result2;
    }

    RangerPolicy getPolicy(Long id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getPolicy(" + id + ")");
        }
        RangerPolicy result2 = null;
        try {
            result2 = this._store.getPolicy(id);
        }
        catch (Exception e) {
            LOG.debug("Encountred exception while retrieving policy from service store!", e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getPolicy(" + id + "): " + result2);
        }
        return result2;
    }

    Long getPolicyId(Long serviceId, String policyName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getPolicyId(" + serviceId + ", " + policyName + ")");
        }
        Long policyId = null;
        try {
            policyId = this._store.getPolicyId(serviceId, policyName);
        }
        catch (Exception e) {
            LOG.debug("Encountred exception while retrieving service from service store!", e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getPolicyId(" + serviceId + ", " + policyName + "): policy-id[" + policyId + "]");
        }
        return policyId;
    }

    List<RangerPolicy> getPoliciesForResourceSignature(String serviceName, String policySignature) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("==> RangerValidator.getPoliciesForResourceSignature(%s, %s)", serviceName, policySignature));
        }
        List<RangerPolicy> policies = null;
        try {
            policies = this._store.getPoliciesByResourceSignature(serviceName, policySignature, true);
        }
        catch (Exception e) {
            LOG.debug("Encountred exception while retrieving policies from service store!", e);
        }
        if (LOG.isDebugEnabled()) {
            int count2 = policies == null ? 0 : policies.size();
            LOG.debug(String.format("<== RangerValidator.getPoliciesForResourceSignature(%s, %s): count[%d], %s", serviceName, policySignature, count2, policies));
        }
        return policies;
    }

    Set<String> getAccessTypes(RangerServiceDef serviceDef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getAccessTypes(" + serviceDef + ")");
        }
        HashSet<String> accessTypes = new HashSet<String>();
        if (serviceDef == null) {
            LOG.warn("serviceDef passed in was null!");
        } else if (CollectionUtils.isEmpty(serviceDef.getAccessTypes())) {
            LOG.warn("AccessTypeDef collection on serviceDef was null!");
        } else {
            for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : serviceDef.getAccessTypes()) {
                if (accessTypeDef == null) {
                    LOG.warn("Access type def was null!");
                    continue;
                }
                String accessType = accessTypeDef.getName();
                if (StringUtils.isBlank(accessType)) {
                    LOG.warn("Access type def name was null/empty/blank!");
                    continue;
                }
                accessTypes.add(accessType.toLowerCase());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getAccessTypes(" + serviceDef + "): " + accessTypes);
        }
        return accessTypes;
    }

    boolean getIsAuditEnabled(RangerPolicy policy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getIsAuditEnabled(" + policy + ")");
        }
        boolean isEnabled = false;
        if (policy == null) {
            LOG.warn("policy was null!");
        } else {
            isEnabled = policy.getIsAuditEnabled() == null ? true : policy.getIsAuditEnabled();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getIsAuditEnabled(" + policy + "): " + isEnabled);
        }
        return isEnabled;
    }

    Set<String> getMandatoryResourceNames(RangerServiceDef serviceDef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getMandatoryResourceNames(" + serviceDef + ")");
        }
        HashSet<String> resourceNames = new HashSet<String>();
        if (serviceDef == null) {
            LOG.warn("serviceDef passed in was null!");
        } else if (CollectionUtils.isEmpty(serviceDef.getResources())) {
            LOG.warn("ResourceDef collection on serviceDef was null!");
        } else {
            for (RangerServiceDef.RangerResourceDef resourceTypeDef : serviceDef.getResources()) {
                if (resourceTypeDef == null) {
                    LOG.warn("resource type def was null!");
                    continue;
                }
                Boolean mandatory = resourceTypeDef.getMandatory();
                if (mandatory == null || !mandatory.booleanValue()) continue;
                String resourceName = resourceTypeDef.getName();
                if (StringUtils.isBlank(resourceName)) {
                    LOG.warn("Resource def name was null/empty/blank!");
                    continue;
                }
                resourceNames.add(resourceName.toLowerCase());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getMandatoryResourceNames(" + serviceDef + "): " + resourceNames);
        }
        return resourceNames;
    }

    Set<String> getAllResourceNames(RangerServiceDef serviceDef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getAllResourceNames(" + serviceDef + ")");
        }
        HashSet<String> resourceNames = new HashSet<String>();
        if (serviceDef == null) {
            LOG.warn("serviceDef passed in was null!");
        } else if (CollectionUtils.isEmpty(serviceDef.getResources())) {
            LOG.warn("ResourceDef collection on serviceDef was null!");
        } else {
            for (RangerServiceDef.RangerResourceDef resourceTypeDef : serviceDef.getResources()) {
                if (resourceTypeDef == null) {
                    LOG.warn("resource type def was null!");
                    continue;
                }
                String resourceName = resourceTypeDef.getName();
                if (StringUtils.isBlank(resourceName)) {
                    LOG.warn("Resource def name was null/empty/blank!");
                    continue;
                }
                resourceNames.add(resourceName.toLowerCase());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getAllResourceNames(" + serviceDef + "): " + resourceNames);
        }
        return resourceNames;
    }

    Set<String> getPolicyResources(RangerPolicy policy) {
        if (policy == null || policy.getResources() == null || policy.getResources().isEmpty()) {
            return new HashSet<String>();
        }
        HashSet<String> result2 = new HashSet<String>();
        for (String name : policy.getResources().keySet()) {
            result2.add(name.toLowerCase());
        }
        return result2;
    }

    Map<String, String> getValidationRegExes(RangerServiceDef serviceDef) {
        if (serviceDef == null || CollectionUtils.isEmpty(serviceDef.getResources())) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        for (RangerServiceDef.RangerResourceDef resourceDef : serviceDef.getResources()) {
            if (resourceDef == null) {
                LOG.warn("A resource def in resource def collection is null");
                continue;
            }
            String name = resourceDef.getName();
            String regEx = resourceDef.getValidationRegEx();
            if (StringUtils.isBlank(name)) {
                LOG.warn("resource name is null/empty/blank");
                continue;
            }
            if (StringUtils.isBlank(regEx)) {
                LOG.debug("validation regex is null/empty/blank");
                continue;
            }
            result2.put(name, regEx);
        }
        return result2;
    }

    int getEnumDefaultIndex(RangerServiceDef.RangerEnumDef enumDef) {
        int index = enumDef == null ? -1 : (enumDef.getDefaultIndex() == null ? 0 : enumDef.getDefaultIndex());
        return index;
    }

    Collection<String> getImpliedGrants(RangerServiceDef.RangerAccessTypeDef def) {
        if (def == null) {
            return null;
        }
        if (CollectionUtils.isEmpty(def.getImpliedGrants())) {
            return new ArrayList<String>();
        }
        ArrayList<String> result2 = new ArrayList<String>(def.getImpliedGrants().size());
        for (String name : def.getImpliedGrants()) {
            if (StringUtils.isBlank(name)) {
                result2.add(name);
                continue;
            }
            result2.add(name.toLowerCase());
        }
        return result2;
    }

    Map<String, RangerPolicy.RangerPolicyResource> getPolicyResourceWithLowerCaseKeys(Map<String, RangerPolicy.RangerPolicyResource> input2) {
        if (input2 == null) {
            return null;
        }
        HashMap<String, RangerPolicy.RangerPolicyResource> output = new HashMap<String, RangerPolicy.RangerPolicyResource>(input2.size());
        for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry2 : input2.entrySet()) {
            output.put(entry2.getKey().toLowerCase(), entry2.getValue());
        }
        return output;
    }

    boolean isUnique(Long value2, Set<Long> alreadySeen, String valueName, String collectionName, List<ValidationFailureDetails> failures) {
        return this.isUnique(value2, null, alreadySeen, valueName, collectionName, failures);
    }

    boolean isUnique(Long value2, String valueContext, Set<Long> alreadySeen, String valueName, String collectionName, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("==> RangerServiceDefValidator.isValueUnique(%s, %s, %s, %s, %s)", value2, alreadySeen, valueName, collectionName, failures));
        }
        boolean valid = true;
        if (value2 == null) {
            failures.add(new ValidationFailureDetailsBuilder().field(valueName).subField(valueContext).isMissing().becauseOf(String.format("%s[%s] is null/empty", valueName, value2)).build());
            valid = false;
        } else if (alreadySeen.contains(value2)) {
            failures.add(new ValidationFailureDetailsBuilder().field(valueName).subField(value2.toString()).isSemanticallyIncorrect().becauseOf(String.format("duplicate %s[%s] in %s", valueName, value2, collectionName)).build());
            valid = false;
        } else {
            alreadySeen.add(value2);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("==> RangerServiceDefValidator.isValueUnique(%s, %s, %s, %s, %s): %s", value2, alreadySeen, valueName, collectionName, failures, valid));
        }
        return valid;
    }

    boolean isUnique(Integer value2, Set<Integer> alreadySeen, String valueName, String collectionName, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("==> RangerServiceDefValidator.isValueUnique(%s, %s, %s, %s, %s)", value2, alreadySeen, valueName, collectionName, failures));
        }
        boolean valid = true;
        if (value2 == null) {
            failures.add(new ValidationFailureDetailsBuilder().field(valueName).isMissing().becauseOf(String.format("%s[%s] is null/empty", valueName, value2)).build());
            valid = false;
        } else if (alreadySeen.contains(value2)) {
            failures.add(new ValidationFailureDetailsBuilder().field(valueName).subField(value2.toString()).isSemanticallyIncorrect().becauseOf(String.format("duplicate %s[%s] in %s", valueName, value2, collectionName)).build());
            valid = false;
        } else {
            alreadySeen.add(value2);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("==> RangerServiceDefValidator.isValueUnique(%s, %s, %s, %s, %s): %s", value2, alreadySeen, valueName, collectionName, failures, valid));
        }
        return valid;
    }

    boolean isValidResourceName(String value2, String valueContext, List<ValidationFailureDetails> failures) {
        boolean ret = true;
        if (value2 != null && !StringUtils.isEmpty(value2)) {
            int sz = value2.length();
            for (int i = 0; i < sz; ++i) {
                char c = value2.charAt(i);
                if (Character.isLowerCase(c) || c == '-' || c == '_') continue;
                ret = false;
                break;
            }
        } else {
            ret = false;
        }
        if (!ret) {
            ValidationErrorCode errorCode = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_NOT_LOWERCASE_NAME;
            failures.add(new ValidationFailureDetailsBuilder().errorCode(errorCode.getErrorCode()).field(value2).becauseOf(errorCode.getMessage(valueContext, value2)).build());
        }
        return ret;
    }

    boolean isUnique(String value2, Set<String> alreadySeen, String valueName, String collectionName, List<ValidationFailureDetails> failures) {
        return this.isUnique(value2, null, alreadySeen, valueName, collectionName, failures);
    }

    boolean isUnique(String value2, String valueContext, Set<String> alreadySeen, String valueName, String collectionName, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("==> RangerServiceDefValidator.isValueUnique(%s, %s, %s, %s, %s)", value2, alreadySeen, valueName, collectionName, failures));
        }
        boolean valid = true;
        if (StringUtils.isBlank(value2)) {
            failures.add(new ValidationFailureDetailsBuilder().field(valueName).subField(valueContext).isMissing().becauseOf(String.format("%s[%s] is null/empty", valueName, value2)).build());
            valid = false;
        } else if (alreadySeen.contains(value2.toLowerCase())) {
            failures.add(new ValidationFailureDetailsBuilder().field(valueName).subField(value2).isSemanticallyIncorrect().becauseOf(String.format("duplicate %s[%s] in %s", valueName, value2, collectionName)).build());
            valid = false;
        } else {
            alreadySeen.add(value2.toLowerCase());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("==> RangerServiceDefValidator.isValueUnique(%s, %s, %s, %s, %s): %s", value2, alreadySeen, valueName, collectionName, failures, valid));
        }
        return valid;
    }

    Map<String, RangerServiceDef.RangerEnumDef> getEnumDefMap(List<RangerServiceDef.RangerEnumDef> enumDefs) {
        HashMap<String, RangerServiceDef.RangerEnumDef> result2 = new HashMap<String, RangerServiceDef.RangerEnumDef>();
        if (enumDefs != null) {
            for (RangerServiceDef.RangerEnumDef enumDef : enumDefs) {
                result2.put(enumDef.getName(), enumDef);
            }
        }
        return result2;
    }

    Set<String> getEnumValues(RangerServiceDef.RangerEnumDef enumDef) {
        HashSet<String> result2 = new HashSet<String>();
        if (enumDef != null) {
            for (RangerServiceDef.RangerEnumElementDef element : enumDef.getElements()) {
                result2.add(element.getName());
            }
        }
        return result2;
    }

    static Map<Integer, Integer> createMap(int[][] data) {
        HashMap<Integer, Integer> result2 = new HashMap<Integer, Integer>();
        if (data != null) {
            for (int[] row : data) {
                Integer key = row[0];
                Integer value2 = row[1];
                if (result2.containsKey(key)) {
                    LOG.warn("createMap: Internal error: duplicate key: multiple rows found for [" + key + "]. Skipped");
                    continue;
                }
                result2.put(key, value2);
            }
        }
        return result2;
    }

    static Map<Integer, String> createMap(Object[][] data) {
        HashMap<Integer, String> result2 = new HashMap<Integer, String>();
        if (data != null) {
            for (Object[] row : data) {
                Integer key = (Integer)row[0];
                String value2 = (String)row[1];
                if (key == null) {
                    LOG.warn("createMap: error converting key[" + row[0] + "] to Integer! Sipped!");
                    continue;
                }
                if (StringUtils.isEmpty(value2)) {
                    LOG.warn("createMap: empty/null value.  Skipped!");
                    continue;
                }
                if (result2.containsKey(key)) {
                    LOG.warn("createMap: Internal error: duplicate key.  Multiple rows found for [" + key + "]. Skipped");
                    continue;
                }
                result2.put(key, value2);
            }
        }
        return result2;
    }

    public static enum Action {
        CREATE,
        UPDATE,
        DELETE;

    }
}

