/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class RangerResourceACLs {
    private final Map<String, Map<String, AccessResult>> userACLs = new HashMap<String, Map<String, AccessResult>>();
    private final Map<String, Map<String, AccessResult>> groupACLs = new HashMap<String, Map<String, AccessResult>>();

    public Map<String, Map<String, AccessResult>> getUserACLs() {
        return this.userACLs;
    }

    public Map<String, Map<String, AccessResult>> getGroupACLs() {
        return this.groupACLs;
    }

    public void finalizeAcls() {
        Map<String, AccessResult> publicGroupAccessInfo = this.groupACLs.get("public");
        if (publicGroupAccessInfo != null) {
            for (Map.Entry<String, AccessResult> entry2 : publicGroupAccessInfo.entrySet()) {
                AccessResult savedAccessResult;
                Map<String, AccessResult> mapValue;
                String accessType = entry2.getKey();
                AccessResult accessResult = entry2.getValue();
                int access = accessResult.getResult();
                if (access != RangerPolicyEvaluator.ACCESS_DENIED && access != RangerPolicyEvaluator.ACCESS_ALLOWED) continue;
                for (Map.Entry<String, Map<String, AccessResult>> mapEntry : this.userACLs.entrySet()) {
                    mapValue = mapEntry.getValue();
                    savedAccessResult = mapValue.get(accessType);
                    if (savedAccessResult == null || savedAccessResult.getIsFinal()) continue;
                    mapValue.remove(accessType);
                }
                for (Map.Entry<String, Map<String, AccessResult>> mapEntry : this.groupACLs.entrySet()) {
                    if (StringUtils.equals(mapEntry.getKey(), "public") || (savedAccessResult = (mapValue = mapEntry.getValue()).get(accessType)) == null || savedAccessResult.getIsFinal()) continue;
                    mapValue.remove(accessType);
                }
            }
        }
        this.finalizeAcls(this.userACLs);
        this.finalizeAcls(this.groupACLs);
    }

    public void setUserAccessInfo(String userName, String accessType, Integer access) {
        AccessResult accessResult;
        Map<String, AccessResult> userAccessInfo = this.userACLs.get(userName);
        if (userAccessInfo == null) {
            userAccessInfo = new HashMap<String, AccessResult>();
            this.userACLs.put(userName, userAccessInfo);
        }
        if ((accessResult = userAccessInfo.get(accessType)) == null) {
            accessResult = new AccessResult(access);
            userAccessInfo.put(accessType, accessResult);
        } else {
            accessResult.setResult(access);
        }
    }

    public void setGroupAccessInfo(String groupName, String accessType, Integer access) {
        AccessResult accessResult;
        Map<String, AccessResult> groupAccessInfo = this.groupACLs.get(groupName);
        if (groupAccessInfo == null) {
            groupAccessInfo = new HashMap<String, AccessResult>();
            this.groupACLs.put(groupName, groupAccessInfo);
        }
        if ((accessResult = groupAccessInfo.get(accessType)) == null) {
            accessResult = new AccessResult(access);
            groupAccessInfo.put(accessType, accessResult);
        } else {
            accessResult.setResult(access);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("UserACLs={");
        for (Map.Entry<String, Map<String, AccessResult>> entry2 : this.userACLs.entrySet()) {
            sb.append("user=").append(entry2.getKey()).append(":");
            sb.append("permissions={");
            for (Map.Entry<String, AccessResult> permission : entry2.getValue().entrySet()) {
                sb.append("{Permission=").append(permission.getKey()).append(", value=").append(permission.getValue()).append("},");
            }
            sb.append("},");
        }
        sb.append("}");
        sb.append(", GroupACLs={");
        for (Map.Entry<String, Map<String, AccessResult>> entry2 : this.groupACLs.entrySet()) {
            sb.append("group=").append(entry2.getKey()).append(":");
            sb.append("permissions={");
            for (Map.Entry<String, AccessResult> permission : entry2.getValue().entrySet()) {
                sb.append("{Permission=").append(permission.getKey()).append(", value=").append(permission.getValue()).append("}, ");
            }
            sb.append("},");
        }
        sb.append("}");
        sb.append("}");
        return sb.toString();
    }

    private void finalizeAcls(Map<String, Map<String, AccessResult>> acls) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (Map.Entry<String, Map<String, AccessResult>> entry2 : acls.entrySet()) {
            if (entry2.getValue().isEmpty()) {
                keysToRemove.add(entry2.getKey());
                continue;
            }
            for (Map.Entry<String, AccessResult> permission : entry2.getValue().entrySet()) {
                permission.getValue().setIsFinal(true);
            }
        }
        for (String keyToRemove : keysToRemove) {
            acls.remove(keyToRemove);
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class AccessResult {
        private int result;
        private boolean isFinal;

        public AccessResult() {
            this(-1);
        }

        public AccessResult(int result2) {
            this(result2, false);
        }

        public AccessResult(int result2, boolean isFinal) {
            this.setIsFinal(isFinal);
            this.setResult(result2);
        }

        public int getResult() {
            return this.result;
        }

        public void setResult(int result2) {
            if (!this.isFinal) {
                this.result = result2;
                if (this.result == RangerPolicyEvaluator.ACCESS_DENIED) {
                    this.isFinal = true;
                }
            }
        }

        public boolean getIsFinal() {
            return this.isFinal;
        }

        public void setIsFinal(boolean isFinal) {
            this.isFinal = isFinal;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other instanceof AccessResult) {
                AccessResult otherObject = (AccessResult)other;
                return this.result == otherObject.result && this.isFinal == otherObject.isFinal;
            }
            return false;
        }

        public String toString() {
            if (this.result == RangerPolicyEvaluator.ACCESS_ALLOWED) {
                return "ALLOWED, final=" + this.isFinal;
            }
            if (this.result == RangerPolicyEvaluator.ACCESS_DENIED) {
                return "NOT_ALLOWED, final=" + this.isFinal;
            }
            return "CONDITIONAL_ALLOWED, final=" + this.isFinal;
        }
    }
}

