/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.conditionevaluator.RangerConditionEvaluator;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyevaluator.RangerAbstractPolicyItemEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.util.RangerPerfTracer;

public class RangerDefaultPolicyItemEvaluator
extends RangerAbstractPolicyItemEvaluator {
    private static final Log LOG = LogFactory.getLog(RangerDefaultPolicyItemEvaluator.class);
    private static final Log PERF_POLICYITEM_INIT_LOG = RangerPerfTracer.getPerfLogger("policyitem.init");
    private static final Log PERF_POLICYITEM_REQUEST_LOG = RangerPerfTracer.getPerfLogger("policyitem.request");
    private static final Log PERF_POLICYCONDITION_INIT_LOG = RangerPerfTracer.getPerfLogger("policycondition.init");
    private static final Log PERF_POLICYCONDITION_REQUEST_LOG = RangerPerfTracer.getPerfLogger("policycondition.request");
    private boolean hasCurrentUser;
    private boolean hasResourceOwner;
    private boolean hasAllPerms;

    public RangerDefaultPolicyItemEvaluator(RangerServiceDef serviceDef, RangerPolicy policy, RangerPolicy.RangerPolicyItem policyItem, int policyItemType, int policyItemIndex, RangerPolicyEngineOptions options) {
        super(serviceDef, policy, policyItem, policyItemType, policyItemIndex, options);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init() {
        List<String> list;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyItemEvaluator(policyId=" + this.policyId + ", policyItem=" + this.policyItem + ", serviceType=" + this.getServiceType() + ", conditionsDisabled=" + this.getConditionsDisabledOption() + ")");
        }
        HashSet<String> accessPerms = new HashSet<String>();
        List<RangerPolicy.RangerPolicyItemAccess> policyItemAccesses = this.policyItem.getAccesses();
        for (RangerPolicy.RangerPolicyItemAccess rangerPolicyItemAccess : policyItemAccesses) {
            if (!rangerPolicyItemAccess.getIsAllowed().booleanValue()) continue;
            accessPerms.add(rangerPolicyItemAccess.getType());
        }
        this.hasAllPerms = true;
        List<RangerServiceDef.RangerAccessTypeDef> serviceAccessTypes = this.serviceDef.getAccessTypes();
        for (RangerServiceDef.RangerAccessTypeDef serviceAccessType : serviceAccessTypes) {
            String serviceAccessTypeName = serviceAccessType.getName();
            if (accessPerms.contains(serviceAccessTypeName)) continue;
            this.hasAllPerms = false;
            break;
        }
        if (!this.getConditionsDisabledOption() && CollectionUtils.isNotEmpty(this.policyItem.getConditions())) {
            void var4_8;
            this.conditionEvaluators = new ArrayList();
            Object var4_6 = null;
            if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYITEM_INIT_LOG)) {
                RangerPerfTracer rangerPerfTracer = RangerPerfTracer.getPerfTracer(PERF_POLICYITEM_INIT_LOG, "RangerPolicyItemEvaluator.init(policyId=" + this.policyId + ",policyItemIndex=" + this.getPolicyItemIndex() + ")");
            }
            for (RangerPolicy.RangerPolicyItemCondition condition : this.policyItem.getConditions()) {
                RangerServiceDef.RangerPolicyConditionDef conditionDef = this.getConditionDef(condition.getType());
                if (conditionDef == null) {
                    LOG.error("RangerDefaultPolicyItemEvaluator(policyId=" + this.policyId + "): conditionDef '" + condition.getType() + "' not found. Ignoring the condition");
                    continue;
                }
                RangerConditionEvaluator conditionEvaluator = this.newConditionEvaluator(conditionDef.getEvaluator());
                if (conditionEvaluator != null) {
                    conditionEvaluator.setServiceDef(this.serviceDef);
                    conditionEvaluator.setConditionDef(conditionDef);
                    conditionEvaluator.setPolicyItemCondition(condition);
                    RangerPerfTracer perfConditionInit = null;
                    if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYCONDITION_INIT_LOG)) {
                        perfConditionInit = RangerPerfTracer.getPerfTracer(PERF_POLICYCONDITION_INIT_LOG, "RangerConditionEvaluator.init(policyId=" + this.policyId + ",policyItemIndex=" + this.getPolicyItemIndex() + ",policyConditionType=" + condition.getType() + ")");
                    }
                    conditionEvaluator.init();
                    RangerPerfTracer.log(perfConditionInit);
                    this.conditionEvaluators.add(conditionEvaluator);
                    continue;
                }
                LOG.error("RangerDefaultPolicyItemEvaluator(policyId=" + this.policyId + "): failed to instantiate condition evaluator '" + condition.getType() + "'; evaluatorClassName='" + conditionDef.getEvaluator() + "'");
            }
            RangerPerfTracer.log((RangerPerfTracer)var4_8);
        }
        this.hasCurrentUser = CollectionUtils.isNotEmpty(list = this.policyItem.getUsers()) && list.contains("{USER}");
        boolean bl = this.hasResourceOwner = CollectionUtils.isNotEmpty(list) && list.contains("{OWNER}");
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyItemEvaluator(policyId=" + this.policyId + ", conditionsCount=" + this.getConditionEvaluators().size() + ")");
        }
    }

    @Override
    public boolean isMatch(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyItemEvaluator.isMatch(" + request + ")");
        }
        boolean ret = false;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYITEM_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYITEM_REQUEST_LOG, "RangerPolicyItemEvaluator.isMatch(resource=" + request.getResource().getAsString() + ")");
        }
        if (this.policyItem != null && this.matchUserGroupAndOwner(request)) {
            if (request.isAccessTypeDelegatedAdmin()) {
                if (this.policyItem.getDelegateAdmin().booleanValue()) {
                    ret = true;
                }
            } else if (CollectionUtils.isNotEmpty(this.policyItem.getAccesses())) {
                boolean isAccessTypeMatched = false;
                if (request.isAccessTypeAny()) {
                    if (this.getPolicyItemType() == 1 || this.getPolicyItemType() == 3) {
                        if (this.hasAllPerms) {
                            isAccessTypeMatched = true;
                        }
                    } else {
                        for (RangerPolicy.RangerPolicyItemAccess access : this.policyItem.getAccesses()) {
                            if (!access.getIsAllowed().booleanValue()) continue;
                            isAccessTypeMatched = true;
                            break;
                        }
                    }
                } else {
                    for (RangerPolicy.RangerPolicyItemAccess access : this.policyItem.getAccesses()) {
                        if (!access.getIsAllowed().booleanValue() || !StringUtils.equalsIgnoreCase(access.getType(), request.getAccessType())) continue;
                        isAccessTypeMatched = true;
                        break;
                    }
                }
                if (isAccessTypeMatched && this.matchCustomConditions(request)) {
                    ret = true;
                }
            }
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyItemEvaluator.isMatch(" + request + "): " + ret);
        }
        return ret;
    }

    @Override
    public boolean matchUserGroup(String user, Set<String> userGroups) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyItemEvaluator.matchUserGroup(" + this.policyItem + ", " + user + ", " + userGroups + ")");
        }
        boolean ret = false;
        if (this.policyItem != null) {
            if (!ret && user != null && this.policyItem.getUsers() != null) {
                boolean bl = ret = this.hasCurrentUser || this.policyItem.getUsers().contains(user);
            }
            if (!ret && userGroups != null && this.policyItem.getGroups() != null) {
                boolean bl = ret = this.policyItem.getGroups().contains("public") || !Collections.disjoint(this.policyItem.getGroups(), userGroups);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyItemEvaluator.matchUserGroup(" + this.policyItem + ", " + user + ", " + userGroups + "): " + ret);
        }
        return ret;
    }

    private boolean matchUserGroupAndOwner(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyItemEvaluator.matchUserGroupAndOwner(" + request + ")");
        }
        boolean ret = false;
        String user = request.getUser();
        Set<String> userGroups = request.getUserGroups();
        if (this.hasResourceOwner) {
            String resourceOwner;
            RangerAccessResource accessedResource = request.getResource();
            String string2 = resourceOwner = accessedResource != null ? accessedResource.getOwnerUser() : null;
            if (user != null && resourceOwner != null && user.equals(resourceOwner)) {
                ret = true;
            }
        }
        if (!ret) {
            ret = this.matchUserGroup(user, userGroups);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyItemEvaluator.matchUserGroupAndOwner(" + request + "): " + ret);
        }
        return ret;
    }

    @Override
    public boolean matchAccessType(String accessType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyItemEvaluator.matchAccessType(" + accessType + ")");
        }
        boolean ret = false;
        if (this.policyItem != null) {
            boolean isAdminAccess = StringUtils.equals(accessType, "_admin");
            if (isAdminAccess) {
                ret = this.policyItem.getDelegateAdmin();
            } else if (CollectionUtils.isNotEmpty(this.policyItem.getAccesses())) {
                boolean isAnyAccess = StringUtils.equals(accessType, "_any");
                for (RangerPolicy.RangerPolicyItemAccess itemAccess : this.policyItem.getAccesses()) {
                    if (!itemAccess.getIsAllowed().booleanValue()) continue;
                    if (isAnyAccess) {
                        ret = true;
                        break;
                    }
                    if (!StringUtils.equalsIgnoreCase(itemAccess.getType(), accessType)) continue;
                    ret = true;
                    break;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyItemEvaluator.matchAccessType(" + accessType + "): " + ret);
        }
        return ret;
    }

    @Override
    public boolean matchCustomConditions(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyItemEvaluator.matchCustomConditions(" + request + ")");
        }
        boolean ret = true;
        if (CollectionUtils.isNotEmpty(this.conditionEvaluators)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("RangerDefaultPolicyItemEvaluator.matchCustomConditions(): conditionCount=" + this.conditionEvaluators.size());
            }
            for (RangerConditionEvaluator conditionEvaluator : this.conditionEvaluators) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("evaluating condition: " + conditionEvaluator);
                }
                RangerPerfTracer perf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYCONDITION_REQUEST_LOG)) {
                    String conditionType = null;
                    if (conditionEvaluator instanceof RangerAbstractConditionEvaluator) {
                        conditionType = ((RangerAbstractConditionEvaluator)conditionEvaluator).getPolicyItemCondition().getType();
                    }
                    perf = RangerPerfTracer.getPerfTracer(PERF_POLICYCONDITION_REQUEST_LOG, "RangerConditionEvaluator.matchCondition(policyId=" + this.policyId + ",policyItemIndex=" + this.getPolicyItemIndex() + ",policyConditionType=" + conditionType + ")");
                }
                boolean conditionEvalResult = conditionEvaluator.isMatched(request);
                RangerPerfTracer.log(perf);
                if (conditionEvalResult) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(conditionEvaluator + " returned false");
                }
                ret = false;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyItemEvaluator.matchCustomConditions(" + request + "): " + ret);
        }
        return ret;
    }

    @Override
    public void updateAccessResult(RangerPolicyEvaluator policyEvaluator, RangerAccessResult result2, RangerPolicyResourceMatcher.MatchType matchType) {
        policyEvaluator.updateAccessResult(result2, matchType, this.getPolicyItemType() != 1, this.getComments());
    }

    RangerServiceDef.RangerPolicyConditionDef getConditionDef(String conditionName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyItemEvaluator.getConditionDef(" + conditionName + ")");
        }
        RangerServiceDef.RangerPolicyConditionDef ret = null;
        if (this.serviceDef != null && CollectionUtils.isNotEmpty(this.serviceDef.getPolicyConditions())) {
            for (RangerServiceDef.RangerPolicyConditionDef conditionDef : this.serviceDef.getPolicyConditions()) {
                if (!StringUtils.equals(conditionName, conditionDef.getName())) continue;
                ret = conditionDef;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyItemEvaluator.getConditionDef(" + conditionName + "): " + ret);
        }
        return ret;
    }

    RangerConditionEvaluator newConditionEvaluator(String className) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyItemEvaluator.newConditionEvaluator(" + className + ")");
        }
        RangerConditionEvaluator evaluator = null;
        try {
            Class<?> matcherClass = Class.forName(className);
            evaluator = (RangerConditionEvaluator)matcherClass.newInstance();
        }
        catch (Throwable t) {
            LOG.error("RangerDefaultPolicyItemEvaluator.newConditionEvaluator(" + className + "): error instantiating evaluator", t);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyItemEvaluator.newConditionEvaluator(" + className + "): " + evaluator);
        }
        return evaluator;
    }
}

