/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.resourcematcher.CaseInsensitiveRecursiveMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseInsensitiveRecursiveWildcardMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseInsensitiveStringMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseSensitiveRecursiveMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseSensitiveRecursiveWildcardMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerDefaultResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.ResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.ResourceMatcherWrapper;
import org.apache.ranger.plugin.util.ServiceDefUtil;

public class RangerPathResourceMatcher
extends RangerDefaultResourceMatcher {
    private static final Log LOG = LogFactory.getLog(RangerPathResourceMatcher.class);
    public static final String OPTION_PATH_SEPARATOR = "pathSeparatorChar";
    public static final char DEFAULT_PATH_SEPARATOR_CHAR = '/';
    private boolean policyIsRecursive;
    private char pathSeparatorChar = (char)47;

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPathResourceMatcher.init()");
        }
        Map<String, String> options = this.resourceDef == null ? null : this.resourceDef.getMatcherOptions();
        this.policyIsRecursive = this.policyResource != null && this.policyResource.getIsRecursive() != false;
        this.pathSeparatorChar = ServiceDefUtil.getCharOption(options, OPTION_PATH_SEPARATOR, '/');
        super.init();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPathResourceMatcher.init()");
        }
    }

    @Override
    protected ResourceMatcherWrapper buildResourceMatchers() {
        ArrayList<ResourceMatcher> resourceMatchers = new ArrayList<ResourceMatcher>();
        boolean needsDynamicEval = false;
        for (String policyValue : this.policyValues) {
            ResourceMatcher matcher;
            if (this.optWildCard && this.policyIsRecursive && policyValue.charAt(policyValue.length() - 1) == this.pathSeparatorChar) {
                policyValue = policyValue + "*";
            }
            if ((matcher = this.getMatcher(policyValue)) == null) continue;
            if (matcher.isMatchAny()) {
                resourceMatchers.clear();
                break;
            }
            if (!needsDynamicEval && matcher.getNeedsDynamicEval()) {
                needsDynamicEval = true;
            }
            resourceMatchers.add(matcher);
        }
        Collections.sort(resourceMatchers, new ResourceMatcher.PriorityComparator());
        return CollectionUtils.isNotEmpty(resourceMatchers) ? new ResourceMatcherWrapper(needsDynamicEval, resourceMatchers) : null;
    }

    @Override
    ResourceMatcher getMatcher(String policyValue) {
        ResourceMatcher ret;
        int len;
        if (!this.policyIsRecursive) {
            return super.getMatcher(policyValue);
        }
        int n = len = policyValue != null ? policyValue.length() : 0;
        if (len == 0) {
            return null;
        }
        if (this.optWildCard && "*".equals(policyValue)) {
            return new CaseInsensitiveStringMatcher("");
        }
        boolean isWildcardPresent = false;
        if (this.optWildCard) {
            for (int i = 0; i < len; ++i) {
                char c = policyValue.charAt(i);
                if (c != '?' && c != '*') continue;
                isWildcardPresent = true;
                break;
            }
        }
        if (isWildcardPresent) {
            ret = this.optIgnoreCase ? new CaseInsensitiveRecursiveWildcardMatcher(policyValue, this.pathSeparatorChar) : new CaseSensitiveRecursiveWildcardMatcher(policyValue, this.pathSeparatorChar);
        } else {
            ResourceMatcher resourceMatcher = ret = this.optIgnoreCase ? new CaseInsensitiveRecursiveMatcher(policyValue, this.pathSeparatorChar) : new CaseSensitiveRecursiveMatcher(policyValue, this.pathSeparatorChar);
        }
        if (this.optReplaceTokens) {
            ret.setDelimiters(this.startDelimiterChar, this.endDelimiterChar, this.escapeChar, this.tokenPrefix);
        }
        return ret;
    }

    static boolean isRecursiveWildCardMatch(String pathToCheck, String wildcardPath, char pathSeparatorChar, IOCase caseSensitivity) {
        boolean ret = false;
        if (!StringUtils.isEmpty(pathToCheck)) {
            Object[] pathElements = StringUtils.split(pathToCheck, pathSeparatorChar);
            if (!ArrayUtils.isEmpty(pathElements)) {
                StringBuilder sb = new StringBuilder();
                if (pathToCheck.charAt(0) == pathSeparatorChar) {
                    sb.append(pathSeparatorChar);
                }
                for (Object p : pathElements) {
                    sb.append((String)p);
                    ret = FilenameUtils.wildcardMatch(sb.toString(), wildcardPath, caseSensitivity);
                    if (ret) break;
                    sb.append(pathSeparatorChar);
                }
                sb = null;
            } else {
                ret = FilenameUtils.wildcardMatch(pathToCheck, wildcardPath, caseSensitivity);
            }
        }
        return ret;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerPathResourceMatcher={");
        super.toString(sb);
        sb.append("policyIsRecursive={").append(this.policyIsRecursive).append("} ");
        sb.append("}");
        return sb;
    }
}

