/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.util.SearchFilter;

public class AbstractPredicateUtil {
    private static Map<String, Comparator<RangerBaseModelObject>> sorterMap = new HashMap<String, Comparator<RangerBaseModelObject>>();
    public static final Comparator<RangerBaseModelObject> idComparator = new Comparator<RangerBaseModelObject>(){

        @Override
        public int compare(RangerBaseModelObject o1, RangerBaseModelObject o2) {
            Long val1 = o1 != null ? o1.getId() : null;
            Long val2 = o2 != null ? o2.getId() : null;
            return ObjectUtils.compare(val1, val2);
        }
    };
    protected static final Comparator<RangerBaseModelObject> createTimeComparator = new Comparator<RangerBaseModelObject>(){

        @Override
        public int compare(RangerBaseModelObject o1, RangerBaseModelObject o2) {
            Date val1 = o1 != null ? o1.getCreateTime() : null;
            Date val2 = o2 != null ? o2.getCreateTime() : null;
            return ObjectUtils.compare(val1, val2);
        }
    };
    protected static final Comparator<RangerBaseModelObject> updateTimeComparator = new Comparator<RangerBaseModelObject>(){

        @Override
        public int compare(RangerBaseModelObject o1, RangerBaseModelObject o2) {
            Date val1 = o1 != null ? o1.getUpdateTime() : null;
            Date val2 = o2 != null ? o2.getUpdateTime() : null;
            return ObjectUtils.compare(val1, val2);
        }
    };
    protected static final Comparator<RangerBaseModelObject> serviceDefNameComparator = new Comparator<RangerBaseModelObject>(){

        @Override
        public int compare(RangerBaseModelObject o1, RangerBaseModelObject o2) {
            String val1 = null;
            String val2 = null;
            if (o1 != null) {
                if (o1 instanceof RangerServiceDef) {
                    val1 = ((RangerServiceDef)o1).getName();
                } else if (o1 instanceof RangerService) {
                    val1 = ((RangerService)o1).getType();
                }
            }
            if (o2 != null) {
                if (o2 instanceof RangerServiceDef) {
                    val2 = ((RangerServiceDef)o2).getName();
                } else if (o2 instanceof RangerService) {
                    val2 = ((RangerService)o2).getType();
                }
            }
            return ObjectUtils.compare(val1, val2);
        }
    };
    protected static final Comparator<RangerBaseModelObject> serviceNameComparator = new Comparator<RangerBaseModelObject>(){

        @Override
        public int compare(RangerBaseModelObject o1, RangerBaseModelObject o2) {
            String val1 = null;
            String val2 = null;
            if (o1 != null) {
                if (o1 instanceof RangerPolicy) {
                    val1 = ((RangerPolicy)o1).getService();
                } else if (o1 instanceof RangerService) {
                    val1 = ((RangerService)o1).getType();
                }
            }
            if (o2 != null) {
                if (o2 instanceof RangerPolicy) {
                    val2 = ((RangerPolicy)o2).getService();
                } else if (o2 instanceof RangerService) {
                    val2 = ((RangerService)o2).getType();
                }
            }
            return ObjectUtils.compare(val1, val2);
        }
    };
    protected static final Comparator<RangerBaseModelObject> policyNameComparator = new Comparator<RangerBaseModelObject>(){

        @Override
        public int compare(RangerBaseModelObject o1, RangerBaseModelObject o2) {
            String val1 = o1 instanceof RangerPolicy ? ((RangerPolicy)o1).getName() : null;
            String val2 = o2 instanceof RangerPolicy ? ((RangerPolicy)o2).getName() : null;
            return ObjectUtils.compare((Comparable)((Object)val1), (Comparable)((Object)val2));
        }
    };
    public static final Comparator<RangerServiceDef.RangerResourceDef> resourceLevelComparator = new Comparator<RangerServiceDef.RangerResourceDef>(){

        @Override
        public int compare(RangerServiceDef.RangerResourceDef o1, RangerServiceDef.RangerResourceDef o2) {
            Integer val1 = o1 != null ? o1.getLevel() : null;
            Integer val2 = o2 != null ? o2.getLevel() : null;
            return ObjectUtils.compare(val1, val2);
        }
    };

    public void applyFilter(List<? extends RangerBaseModelObject> objList, SearchFilter filter2) {
        Comparator<RangerBaseModelObject> sorter;
        if (CollectionUtils.isEmpty(objList)) {
            return;
        }
        Predicate pred = this.getPredicate(filter2);
        if (pred != null) {
            CollectionUtils.filter(objList, pred);
        }
        if ((sorter = this.getSorter(filter2)) != null) {
            Collections.sort(objList, sorter);
        }
    }

    public Predicate getPredicate(SearchFilter filter2) {
        if (filter2 == null || filter2.isEmpty()) {
            return null;
        }
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.addPredicates(filter2, predicates);
        Predicate ret = CollectionUtils.isEmpty(predicates) ? null : PredicateUtils.allPredicate(predicates);
        return ret;
    }

    public void addPredicates(SearchFilter filter2, List<Predicate> predicates) {
        this.addPredicateForServiceType(filter2.getParam("serviceType"), predicates);
        this.addPredicateForServiceTypeId(filter2.getParam("serviceTypeId"), predicates);
        this.addPredicateForServiceName(filter2.getParam("serviceName"), predicates);
        this.addPredicateForPolicyName(filter2.getParam("policyName"), predicates);
        this.addPredicateForPolicyId(filter2.getParam("policyId"), predicates);
        this.addPredicateForIsEnabled(filter2.getParam("isEnabled"), predicates);
        this.addPredicateForIsRecursive(filter2.getParam("isRecursive"), predicates);
        this.addPredicateForTagServiceName(filter2.getParam("tagServiceName"), predicates);
        this.addPredicateForUserName(filter2.getParam("user"), predicates);
        this.addPredicateForGroupName(filter2.getParam("group"), predicates);
        this.addPredicateForResources(filter2.getParamsWithPrefix("resource:", true), predicates);
        this.addPredicateForPolicyResource(filter2.getParam("polResource"), predicates);
        this.addPredicateForPartialPolicyName(filter2.getParam("policyNamePartial"), predicates);
        this.addPredicateForResourceSignature(filter2.getParam("resourceSignature:"), predicates);
        this.addPredicateForPolicyType(filter2.getParam("policyType"), predicates);
        this.addPredicateForPolicyPriority(filter2.getParam("policyPriority"), predicates);
        this.addPredicateForPartialPolicyLabels(filter2.getParam("policyLabelsPartial"), predicates);
    }

    public Comparator<RangerBaseModelObject> getSorter(SearchFilter filter2) {
        String sortBy2;
        String string2 = sortBy2 = filter2 == null ? null : filter2.getParam("sortBy");
        if (StringUtils.isEmpty(sortBy2)) {
            return null;
        }
        Comparator<RangerBaseModelObject> ret = sorterMap.get(sortBy2);
        return ret;
    }

    private Predicate addPredicateForServiceType(final String serviceType, List<Predicate> predicates) {
        if (StringUtils.isEmpty(serviceType)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerServiceDef) {
                    RangerServiceDef serviceDef = (RangerServiceDef)object;
                    String svcType = serviceDef.getName();
                    ret = StringUtils.equals(svcType, serviceType);
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForServiceTypeId(final String serviceTypeId, List<Predicate> predicates) {
        if (StringUtils.isEmpty(serviceTypeId)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerServiceDef) {
                    RangerServiceDef serviceDef = (RangerServiceDef)object;
                    Long svcDefId = serviceDef.getId();
                    if (svcDefId != null) {
                        ret = StringUtils.equals(serviceTypeId, svcDefId.toString());
                    }
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForServiceName(final String serviceName, List<Predicate> predicates) {
        if (StringUtils.isEmpty(serviceName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerPolicy) {
                    RangerPolicy policy = (RangerPolicy)object;
                    ret = StringUtils.equals(serviceName, policy.getService());
                } else if (object instanceof RangerService) {
                    RangerService service = (RangerService)object;
                    ret = StringUtils.equals(serviceName, service.getName());
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (ret != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPolicyName(final String policyName, List<Predicate> predicates) {
        if (StringUtils.isEmpty(policyName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerPolicy) {
                    RangerPolicy policy = (RangerPolicy)object;
                    ret = StringUtils.equals(policyName, policy.getName());
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPartialPolicyName(final String policyName, List<Predicate> predicates) {
        if (StringUtils.isEmpty(policyName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerPolicy) {
                    RangerPolicy policy = (RangerPolicy)object;
                    ret = StringUtils.containsIgnoreCase(policy.getName(), policyName);
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPolicyId(final String policyId, List<Predicate> predicates) {
        if (StringUtils.isEmpty(policyId)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerPolicy) {
                    RangerPolicy policy = (RangerPolicy)object;
                    if (policy.getId() != null) {
                        ret = StringUtils.equals(policyId, policy.getId().toString());
                    }
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForUserName(final String userName, List<Predicate> predicates) {
        if (StringUtils.isEmpty(userName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerPolicy) {
                    List[] policyItemsList;
                    RangerPolicy policy = (RangerPolicy)object;
                    List[] listArray = policyItemsList = new List[]{policy.getPolicyItems(), policy.getDenyPolicyItems(), policy.getAllowExceptions(), policy.getDenyExceptions(), policy.getDataMaskPolicyItems(), policy.getRowFilterPolicyItems()};
                    int n = listArray.length;
                    for (int i = 0; i < n; ++i) {
                        List policyItemsObj;
                        List policyItems = policyItemsObj = listArray[i];
                        block1: for (RangerPolicy.RangerPolicyItem policyItem : policyItems) {
                            if (policyItem.getUsers().isEmpty()) continue;
                            for (String user : policyItem.getUsers()) {
                                if (!StringUtils.containsIgnoreCase(user, userName)) continue;
                                ret = true;
                                continue block1;
                            }
                        }
                        if (!ret) {
                            continue;
                        }
                        break;
                    }
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForGroupName(final String groupName, List<Predicate> predicates) {
        if (StringUtils.isEmpty(groupName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerPolicy) {
                    List[] policyItemsList;
                    RangerPolicy policy = (RangerPolicy)object;
                    List[] listArray = policyItemsList = new List[]{policy.getPolicyItems(), policy.getDenyPolicyItems(), policy.getAllowExceptions(), policy.getDenyExceptions(), policy.getDataMaskPolicyItems(), policy.getRowFilterPolicyItems()};
                    int n = listArray.length;
                    for (int i = 0; i < n; ++i) {
                        List policyItemsObj;
                        List policyItems = policyItemsObj = listArray[i];
                        block1: for (RangerPolicy.RangerPolicyItem policyItem : policyItems) {
                            if (policyItem.getGroups().isEmpty()) continue;
                            for (String group : policyItem.getGroups()) {
                                if (!StringUtils.containsIgnoreCase(group, groupName)) continue;
                                ret = true;
                                continue block1;
                            }
                        }
                        if (!ret) {
                            continue;
                        }
                        break;
                    }
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForIsEnabled(final String status, List<Predicate> predicates) {
        if (StringUtils.isEmpty(status)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerBaseModelObject) {
                    RangerBaseModelObject obj = (RangerBaseModelObject)object;
                    ret = Boolean.parseBoolean(status) ? obj.getIsEnabled() : obj.getIsEnabled() == false;
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForResources(final Map<String, String> resources, List<Predicate> predicates) {
        if (MapUtils.isEmpty(resources)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerPolicy) {
                    RangerPolicy policy = (RangerPolicy)object;
                    if (!MapUtils.isEmpty(policy.getResources())) {
                        int numFound = 0;
                        for (String name : resources.keySet()) {
                            boolean isMatch = false;
                            RangerPolicy.RangerPolicyResource policyResource = policy.getResources().get(name);
                            if (policyResource != null && !CollectionUtils.isEmpty(policyResource.getValues())) {
                                String val = (String)resources.get(name);
                                if (policyResource.getValues().contains(val)) {
                                    isMatch = true;
                                } else {
                                    for (String policyResourceValue : policyResource.getValues()) {
                                        if (!FilenameUtils.wildcardMatch(val, policyResourceValue)) continue;
                                        isMatch = true;
                                        break;
                                    }
                                }
                            }
                            if (!isMatch) break;
                            ++numFound;
                        }
                        ret = numFound == resources.size();
                    }
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPolicyResource(final String resourceValue, List<Predicate> predicates) {
        if (StringUtils.isEmpty(resourceValue)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerPolicy) {
                    RangerPolicy policy = (RangerPolicy)object;
                    Map<String, RangerPolicy.RangerPolicyResource> policyResources = policy.getResources();
                    if (MapUtils.isNotEmpty(policyResources)) {
                        block0: for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry2 : policyResources.entrySet()) {
                            RangerPolicy.RangerPolicyResource policyResource = entry2.getValue();
                            if (policyResource == null || !CollectionUtils.isNotEmpty(policyResource.getValues())) continue;
                            for (String policyResoureValue : policyResource.getValues()) {
                                if (!StringUtils.containsIgnoreCase(policyResoureValue, resourceValue)) continue;
                                ret = true;
                                continue block0;
                            }
                        }
                    }
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForIsRecursive(String isRecursiveStr, List<Predicate> predicates) {
        if (StringUtils.isEmpty(isRecursiveStr)) {
            return null;
        }
        final boolean isRecursive = Boolean.parseBoolean(isRecursiveStr);
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                RangerPolicy policy;
                if (object == null) {
                    return false;
                }
                boolean ret = true;
                if (object instanceof RangerPolicy && !MapUtils.isEmpty((policy = (RangerPolicy)object).getResources())) {
                    for (Map.Entry<String, RangerPolicy.RangerPolicyResource> e : policy.getResources().entrySet()) {
                        RangerPolicy.RangerPolicyResource resValue = e.getValue();
                        if (resValue.getIsRecursive() == null) {
                            ret = !isRecursive;
                        } else {
                            boolean bl = ret = resValue.getIsRecursive() == isRecursive;
                        }
                        if (!ret) continue;
                        break;
                    }
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagServiceName(final String tagServiceName, List<Predicate> predicates) {
        if (StringUtils.isEmpty(tagServiceName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerService) {
                    RangerService service = (RangerService)object;
                    ret = StringUtils.equals(tagServiceName, service.getTagService());
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (ret != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForResourceSignature(String signature, List<Predicate> predicates) {
        Predicate ret = this.createPredicateForResourceSignature(signature);
        if (predicates != null && ret != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPolicyType(final String policyType, List<Predicate> predicates) {
        if (StringUtils.isEmpty(policyType)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                RangerPolicy policy;
                if (object == null) {
                    return false;
                }
                boolean ret = true;
                if (object instanceof RangerPolicy && (policy = (RangerPolicy)object).getPolicyType() != null) {
                    ret = StringUtils.equalsIgnoreCase(policyType, policy.getPolicyType().toString());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPartialPolicyLabels(final String policyLabels, List<Predicate> predicates) {
        if (StringUtils.isEmpty(policyLabels)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerPolicy) {
                    RangerPolicy policy = (RangerPolicy)object;
                    for (String label : policy.getPolicyLabels()) {
                        ret = StringUtils.containsIgnoreCase(label, policyLabels);
                        if (!ret) continue;
                        return ret;
                    }
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPolicyPriority(final String policyPriority, List<Predicate> predicates) {
        if (StringUtils.isEmpty(policyPriority)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = true;
                if (object instanceof RangerPolicy) {
                    RangerPolicy policy = (RangerPolicy)object;
                    Integer priority = policy.getPolicyPriority() != null ? policy.getPolicyPriority() : 0;
                    ret = priority == 0 ? StringUtils.equalsIgnoreCase(policyPriority, "NORMAL") || StringUtils.equalsIgnoreCase(policyPriority, priority.toString()) : (priority == 1 ? StringUtils.equalsIgnoreCase(policyPriority, "OVERRIDE") || StringUtils.equalsIgnoreCase(policyPriority, priority.toString()) : false);
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    public Predicate createPredicateForResourceSignature(final String policySignature) {
        if (StringUtils.isEmpty(policySignature)) {
            return null;
        }
        return new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerPolicy) {
                    RangerPolicy policy = (RangerPolicy)object;
                    ret = StringUtils.equals(policy.getResourceSignature(), policySignature);
                } else {
                    ret = true;
                }
                return ret;
            }
        };
    }

    static {
        sorterMap.put("serviceType", serviceDefNameComparator);
        sorterMap.put("serviceTypeId", idComparator);
        sorterMap.put("serviceName", serviceNameComparator);
        sorterMap.put("serviceTypeId", idComparator);
        sorterMap.put("policyName", policyNameComparator);
        sorterMap.put("policyId", idComparator);
        sorterMap.put("createTime", createTimeComparator);
        sorterMap.put("updateTime", updateTimeComparator);
    }
}

