/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceResource;

public class RangerServiceResourceSignature {
    private final String _string;
    private final String _hash;

    public RangerServiceResourceSignature(RangerServiceResource serviceResource) {
        this._string = ServiceResourceSerializer.toString(serviceResource);
        this._hash = DigestUtils.sha256Hex(this._string);
    }

    String asString() {
        return this._string;
    }

    public String getSignature() {
        return this._hash;
    }

    static class ServiceResourceSerializer {
        static final int _SignatureVersion = 1;

        ServiceResourceSerializer() {
        }

        public static String toString(RangerServiceResource serviceResource) {
            Map<String, RangerPolicy.RangerPolicyResource> resource = serviceResource.getResourceElements();
            TreeMap<String, ResourceSerializer> resources = new TreeMap<String, ResourceSerializer>();
            for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry2 : resource.entrySet()) {
                String resourceName = entry2.getKey();
                ResourceSerializer resourceView = new ResourceSerializer(entry2.getValue());
                resources.put(resourceName, resourceView);
            }
            String resourcesAsString = ((Object)resources).toString();
            return String.format("{version=%d,service=%s,resource=%s}", 1, serviceResource.getServiceName(), resourcesAsString);
        }

        static class ResourceSerializer {
            final RangerPolicy.RangerPolicyResource _policyResource;

            ResourceSerializer(RangerPolicy.RangerPolicyResource policyResource) {
                this._policyResource = policyResource;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("{");
                if (this._policyResource != null) {
                    builder.append("values=");
                    if (this._policyResource.getValues() != null) {
                        ArrayList<String> values = new ArrayList<String>(this._policyResource.getValues());
                        Collections.sort(values);
                        builder.append(values);
                    }
                    builder.append(",excludes=");
                    if (this._policyResource.getIsExcludes() == null) {
                        builder.append(Boolean.FALSE);
                    } else {
                        builder.append(this._policyResource.getIsExcludes());
                    }
                    builder.append(",recursive=");
                    if (this._policyResource.getIsRecursive() == null) {
                        builder.append(Boolean.FALSE);
                    } else {
                        builder.append(this._policyResource.getIsRecursive());
                    }
                }
                builder.append("}");
                return builder.toString();
            }
        }
    }
}

