/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.util.RangerPerfTracerFactory;

public class RangerPerfTracer {
    protected final Log logger;
    protected final String tag;
    protected final String data;
    private final long startTimeMs;
    private static long reportingThresholdMs;
    private static final String tagEndMarker = "(";

    public static Log getPerfLogger(String name) {
        return LogFactory.getLog("org.apache.ranger.perf." + name);
    }

    public static Log getPerfLogger(Class<?> cls) {
        return RangerPerfTracer.getPerfLogger(cls.getName());
    }

    public static boolean isPerfTraceEnabled(Log logger) {
        return logger.isDebugEnabled();
    }

    public static RangerPerfTracer getPerfTracer(Log logger, String tag) {
        String data = "";
        String realTag = "";
        if (tag != null) {
            int indexOfTagEndMarker = StringUtils.indexOf(tag, tagEndMarker);
            if (indexOfTagEndMarker != -1) {
                realTag = StringUtils.substring(tag, 0, indexOfTagEndMarker);
                data = StringUtils.substring(tag, indexOfTagEndMarker);
            } else {
                realTag = tag;
            }
        }
        return RangerPerfTracerFactory.getPerfTracer(logger, realTag, data);
    }

    public static RangerPerfTracer getPerfTracer(Log logger, String tag, String data) {
        return RangerPerfTracerFactory.getPerfTracer(logger, tag, data);
    }

    public static void log(RangerPerfTracer tracer) {
        if (tracer != null) {
            tracer.log();
        }
    }

    public static void logAlways(RangerPerfTracer tracer) {
        if (tracer != null) {
            tracer.logAlways();
        }
    }

    public RangerPerfTracer(Log logger, String tag, String data) {
        this.logger = logger;
        this.tag = tag;
        this.data = data;
        this.startTimeMs = System.currentTimeMillis();
    }

    public final String getTag() {
        return this.tag;
    }

    public final long getStartTime() {
        return this.startTimeMs;
    }

    public final long getElapsedTime() {
        return System.currentTimeMillis() - this.startTimeMs;
    }

    public void log() {
        long elapsedTime = this.getElapsedTime();
        if (elapsedTime > reportingThresholdMs) {
            this.logger.debug("[PERF] " + this.tag + this.data + ": " + elapsedTime);
        }
    }

    public void logAlways() {
        long elapsedTime = this.getElapsedTime();
        this.logger.debug("[PERF] " + this.tag + this.data + ": " + elapsedTime);
    }
}

