/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.ExpressibleComparator;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.stream.CloudSolrStream;
import org.apache.solr.client.solrj.io.stream.ExpressibleStream;
import org.apache.solr.client.solrj.io.stream.SolrStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.Base64;

public class ParallelStream
extends CloudSolrStream
implements ExpressibleStream {
    private TupleStream tupleStream;
    private int workers;
    private boolean objectSerialize = true;
    private transient StreamFactory streamFactory;

    public ParallelStream(String zkHost, String collection, TupleStream tupleStream, int workers, Comparator<Tuple> comp) throws IOException {
        this.init(zkHost, collection, tupleStream, workers, comp);
    }

    public ParallelStream(String zkHost, String collection, String expressionString, int workers, Comparator<Tuple> comp) throws IOException {
        this.objectSerialize = false;
        TupleStream tStream = this.streamFactory.constructStream(expressionString);
        this.init(zkHost, collection, tStream, workers, comp);
    }

    public ParallelStream(StreamExpression expression, StreamFactory factory) throws IOException {
        this.objectSerialize = false;
        String collectionName = factory.getValueOperand(expression, 0);
        StreamExpressionNamedParameter workersParam = factory.getNamedOperand(expression, "workers");
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, ExpressibleStream.class, TupleStream.class);
        StreamExpressionNamedParameter sortExpression = factory.getNamedOperand(expression, "sort");
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (expression.getParameters().size() != streamExpressions.size() + 3 + (null != zkHostExpression ? 1 : 0)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        if (null == workersParam || null == workersParam.getParameter() || !(workersParam.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single 'workersParam' parameter of type positive integer but didn't find one", expression));
        }
        String workersStr = ((StreamExpressionValue)workersParam.getParameter()).getValue();
        int workersInt = 0;
        try {
            workersInt = Integer.parseInt(workersStr);
            if (workersInt <= 0) {
                throw new IOException(String.format(Locale.ROOT, "invalid expression %s - workers '%s' must be greater than 0.", expression, workersStr));
            }
        }
        catch (NumberFormatException e) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - workers '%s' is not a valid integer.", expression, workersStr));
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        if (null == sortExpression || !(sortExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'sort' parameter telling us how to join the parallel streams but didn't find one", expression));
        }
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (null == zkHost) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        TupleStream stream = factory.constructStream(streamExpressions.get(0));
        Comparator<Tuple> comp = factory.constructComparator(((StreamExpressionValue)sortExpression.getParameter()).getValue(), FieldComparator.class);
        this.streamFactory = factory;
        this.init(zkHost, collectionName, stream, workersInt, comp);
    }

    private void init(String zkHost, String collection, TupleStream tupleStream, int workers, Comparator<Tuple> comp) throws IOException {
        this.zkHost = zkHost;
        this.collection = collection;
        this.workers = workers;
        this.comp = comp;
        this.tupleStream = tupleStream;
        if (!this.objectSerialize && !(tupleStream instanceof ExpressibleStream)) {
            throw new IOException("Unable to create ParallelStream with a non-expressible TupleStream.");
        }
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.collection);
        expression.addParameter(new StreamExpressionNamedParameter("workers", Integer.toString(this.workers)));
        if (!(this.tupleStream instanceof ExpressibleStream)) {
            throw new IOException("This ParallelStream contains a non-expressible TupleStream - it cannot be converted to an expression");
        }
        expression.addParameter(((ExpressibleStream)((Object)this.tupleStream)).toExpression(factory));
        if (!(this.comp instanceof ExpressibleComparator)) {
            throw new IOException("This ParallelStream contains a non-expressible comparator - it cannot be converted to an expression");
        }
        expression.addParameter(new StreamExpressionNamedParameter("sort", ((ExpressibleComparator)((Object)this.comp)).toExpression(factory)));
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        return expression;
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.tupleStream);
        return l;
    }

    @Override
    public Tuple read() throws IOException {
        Tuple tuple = this._read();
        if (tuple.EOF) {
            HashMap<String, Boolean> m = new HashMap<String, Boolean>();
            m.put("EOF", true);
            Tuple t = new Tuple(m);
            HashMap<String, Map> metrics = new HashMap<String, Map>();
            for (Map.Entry entry2 : this.eofTuples.entrySet()) {
                metrics.put((String)entry2.getKey(), ((Tuple)entry2.getValue()).fields);
            }
            t.setMetrics(metrics);
            return t;
        }
        return tuple;
    }

    @Override
    public void setStreamContext(StreamContext streamContext) {
        this.streamContext = streamContext;
        if (this.streamFactory == null) {
            this.streamFactory = streamContext.getStreamFactory();
        }
        this.tupleStream.setStreamContext(streamContext);
    }

    @Override
    protected void constructStreams() throws IOException {
        try {
            Object pushStream = null;
            if (this.objectSerialize) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bout);
                out.writeObject(this.tupleStream);
                byte[] bytes = bout.toByteArray();
                String encoded = Base64.byteArrayToBase64(bytes, 0, bytes.length);
                pushStream = URLEncoder.encode(encoded, "UTF-8");
            } else {
                pushStream = ((ExpressibleStream)((Object)this.tupleStream)).toExpression(this.streamFactory);
            }
            ZkStateReader zkStateReader = this.cloudSolrClient.getZkStateReader();
            ClusterState clusterState = zkStateReader.getClusterState();
            Collection<Slice> slices = clusterState.getActiveSlices(this.collection);
            ArrayList<Replica> shuffler = new ArrayList<Replica>();
            for (Slice slice2 : slices) {
                Collection<Replica> replicas = slice2.getReplicas();
                for (Replica replica : replicas) {
                    shuffler.add(replica);
                }
            }
            if (this.workers > shuffler.size()) {
                throw new IOException("Number of workers exceeds nodes in the worker collection");
            }
            Collections.shuffle(shuffler, new Random());
            for (int w = 0; w < this.workers; ++w) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("distrib", "false");
                params.put("numWorkers", this.workers);
                params.put("workerID", w);
                params.put("stream", pushStream);
                params.put("qt", "/stream");
                params.put("objectSerialize", this.objectSerialize);
                Replica rep = (Replica)shuffler.get(w);
                ZkCoreNodeProps zkProps = new ZkCoreNodeProps(rep);
                String url = zkProps.getCoreUrl();
                SolrStream solrStream = new SolrStream(url, params);
                this.solrStreams.add(solrStream);
            }
            assert (this.solrStreams.size() == this.workers);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void setObjectSerialize(boolean objectSerialize) {
        this.objectSerialize = objectSerialize;
    }

    public boolean getObjectSerialize() {
        return this.objectSerialize;
    }
}

