/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.common.luke.FieldFlag;
import org.apache.solr.common.util.NamedList;

public class LukeResponse
extends SolrResponseBase {
    private NamedList<Object> indexInfo;
    private Map<String, FieldInfo> fieldInfo;
    private Map<String, FieldTypeInfo> fieldTypeInfo;

    @Override
    public void setResponse(NamedList<Object> res) {
        NamedList fldTypes;
        super.setResponse(res);
        this.indexInfo = (NamedList)res.get("index");
        NamedList schema = (NamedList)res.get("schema");
        NamedList flds = (NamedList)res.get("fields");
        if (flds == null && schema != null) {
            flds = (NamedList)schema.get("fields");
        }
        if (flds != null) {
            this.fieldInfo = new HashMap<String, FieldInfo>();
            for (Map.Entry field2 : flds) {
                FieldInfo f = new FieldInfo(field2.getKey());
                f.read((NamedList)field2.getValue());
                this.fieldInfo.put(field2.getKey(), f);
            }
        }
        if (schema != null && (fldTypes = (NamedList)schema.get("types")) != null) {
            this.fieldTypeInfo = new HashMap<String, FieldTypeInfo>();
            for (Map.Entry fieldType : fldTypes) {
                FieldTypeInfo ft = new FieldTypeInfo(fieldType.getKey());
                ft.read((NamedList)fieldType.getValue());
                this.fieldTypeInfo.put(fieldType.getKey(), ft);
            }
        }
    }

    public String getIndexDirectory() {
        if (this.indexInfo == null) {
            return null;
        }
        return (String)this.indexInfo.get("directory");
    }

    public Integer getNumDocs() {
        if (this.indexInfo == null) {
            return null;
        }
        return (Integer)this.indexInfo.get("numDocs");
    }

    public Integer getMaxDoc() {
        if (this.indexInfo == null) {
            return null;
        }
        return (Integer)this.indexInfo.get("maxDoc");
    }

    public Integer getNumTerms() {
        if (this.indexInfo == null) {
            return null;
        }
        return (Integer)this.indexInfo.get("numTerms");
    }

    public Map<String, FieldTypeInfo> getFieldTypeInfo() {
        return this.fieldTypeInfo;
    }

    public FieldTypeInfo getFieldTypeInfo(String name) {
        return this.fieldTypeInfo.get(name);
    }

    public NamedList<Object> getIndexInfo() {
        return this.indexInfo;
    }

    public Map<String, FieldInfo> getFieldInfo() {
        return this.fieldInfo;
    }

    public FieldInfo getFieldInfo(String f) {
        return this.fieldInfo.get(f);
    }

    public static class FieldInfo
    implements Serializable {
        String name;
        String type;
        String schema;
        int docs;
        int distinct;
        EnumSet<FieldFlag> flags;
        boolean cacheableFaceting;
        NamedList<Integer> topTerms;

        public FieldInfo(String n) {
            this.name = n;
        }

        public void read(NamedList<Object> nl) {
            for (Map.Entry<String, Object> entry2 : nl) {
                if ("type".equals(entry2.getKey())) {
                    this.type = (String)entry2.getValue();
                }
                if ("flags".equals(entry2.getKey())) {
                    this.flags = FieldInfo.parseFlags((String)entry2.getValue());
                    continue;
                }
                if ("schema".equals(entry2.getKey())) {
                    this.schema = (String)entry2.getValue();
                    continue;
                }
                if ("docs".equals(entry2.getKey())) {
                    this.docs = (Integer)entry2.getValue();
                    continue;
                }
                if ("distinct".equals(entry2.getKey())) {
                    this.distinct = (Integer)entry2.getValue();
                    continue;
                }
                if ("cacheableFaceting".equals(entry2.getKey())) {
                    this.cacheableFaceting = (Boolean)entry2.getValue();
                    continue;
                }
                if (!"topTerms".equals(entry2.getKey())) continue;
                this.topTerms = (NamedList)entry2.getValue();
            }
        }

        public static EnumSet<FieldFlag> parseFlags(String flagStr) {
            EnumSet<FieldFlag> result2 = EnumSet.noneOf(FieldFlag.class);
            char[] chars = flagStr.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == '-') continue;
                FieldFlag flag = FieldFlag.getFlag(chars[i]);
                result2.add(flag);
            }
            return result2;
        }

        public EnumSet<FieldFlag> getFlags() {
            return this.flags;
        }

        public boolean isCacheableFaceting() {
            return this.cacheableFaceting;
        }

        public String getType() {
            return this.type;
        }

        public int getDistinct() {
            return this.distinct;
        }

        public int getDocs() {
            return this.docs;
        }

        public String getName() {
            return this.name;
        }

        public String getSchema() {
            return this.schema;
        }

        public NamedList<Integer> getTopTerms() {
            return this.topTerms;
        }
    }

    public static class FieldTypeInfo
    implements Serializable {
        String name;
        String className;
        boolean tokenized;
        String analyzer;
        List<String> fields;

        public FieldTypeInfo(String name) {
            this.name = name;
            this.fields = Collections.emptyList();
        }

        public String getAnalyzer() {
            return this.analyzer;
        }

        public String getClassName() {
            return this.className;
        }

        public List<String> getFields() {
            return this.fields;
        }

        public String getName() {
            return this.name;
        }

        public boolean isTokenized() {
            return this.tokenized;
        }

        public void read(NamedList<Object> nl) {
            for (Map.Entry<String, Object> entry2 : nl) {
                String key = entry2.getKey();
                if ("fields".equals(key) && entry2.getValue() != null) {
                    List theFields = (List)entry2.getValue();
                    this.fields = new ArrayList<String>(theFields);
                    continue;
                }
                if ("tokenized".equals(key)) {
                    this.tokenized = Boolean.parseBoolean(entry2.getValue().toString());
                    continue;
                }
                if ("analyzer".equals(key)) {
                    this.analyzer = entry2.getValue().toString();
                    continue;
                }
                if (!"className".equals(key)) continue;
                this.className = entry2.getValue().toString();
            }
        }
    }
}

